/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.DlgGenEdmn;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.EdmnImporteurWorker;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.ProgressFrame;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.DefaultImporter;
import java.awt.Dialog;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EdmnImporter
extends DefaultImporter {
    private static final Logger logger = Logger.getLogger(EdmnImporter.class);
    private static String TABLE_INDEX = EdmnImporteurWorker.TABLE_INDEX;
    private static String TABLE_BUDGETS = EdmnImporteurWorker.TABLE_BUDGETS;
    private static String TABLE_ORDOS = EdmnImporteurWorker.TABLE_ORDOS;
    private static String TABLE_COMPTABLES = EdmnImporteurWorker.TABLE_COMPTABLES;
    private static String TABLE_MINISTERES = EdmnImporteurWorker.TABLE_MINISTERES;
    private static ProgressFrame progress;
    private DlgGenEdmn dlg;

    public EdmnImporter() {
        super(new XemeliosUser(){

            public String getId() {
                return "edmn importer user";
            }

            public String getDisplayName() {
                return this.getId();
            }

            public boolean hasRole(String role) {
                return true;
            }

            public boolean hasDocument(String document) {
                return true;
            }

            public boolean hasCollectivite(String collectivite, DocumentModel dm) {
                return true;
            }
        });
    }

    public EdmnImporter(DlgGenEdmn dlg) {
        this();
        this.dlg = dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(File f, File index, File budgets, File ordos, File comptas, File output) throws Exception {
        Connection con = null;
        try {
            con = PoolManager.getInstance().getConnection();
            this.createDataBase(con);
            this.createDataBaseBudgets(con);
            this.createDataBaseOrdos(con);
            this.createDataBaseComptables(con);
            EdmnImporteurWorker eiw = new EdmnImporteurWorker(con, budgets, ordos, comptas, output, this.dlg);
            File[] tabF = new File[]{f, index, budgets, ordos, comptas};
            progress = new ProgressFrame(this.dlg, eiw, tabF);
            progress.setDisplayFeedback(true);
            eiw.setProgressDlg(progress);
            eiw.setFilesToTreat(tabF);
            eiw.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"doImport", (Throwable)ex);
            new DisplayExceptionDlg((Dialog)this.dlg, (Throwable)ex);
        }
        finally {
            if (progress != null && EdmnImporter.progress.pg != null) {
                EdmnImporter.progress.pg.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBase(Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder();
        Statement ps = null;
        try {
            sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_INDEX + " ( ");
            sb.append("ANNEE VARCHAR(2) NOT NULL, ");
            sb.append("TRIMESTRE VARCHAR(1) NOT NULL, ");
            sb.append("COMPTABLE VARCHAR(6) NOT NULL, ");
            sb.append("MINISTERE VARCHAR(3) NOT NULL, ");
            sb.append("LOCALE VARCHAR(4) NOT NULL, ");
            sb.append("GESTION VARCHAR(3) NOT NULL, ");
            sb.append("SECTION VARCHAR(3) NOT NULL, ");
            sb.append("NATIONALE VARCHAR(6) NOT NULL, ");
            sb.append("INDEX toto (ANNEE,TRIMESTRE,COMPTABLE,MINISTERE,LOCALE)");
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            ps.execute();
            sb = new StringBuilder();
            sb.append("TRUNCATE TABLE " + TABLE_INDEX);
            ps = con.prepareStatement(sb.toString());
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseBudgets(Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder();
        Statement ps = null;
        try {
            sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_BUDGETS + " ( ");
            sb.append("CODE VARCHAR(16) NOT NULL, ");
            sb.append("LIBELLE VARCHAR(250) NOT NULL, ");
            sb.append("INDEX budgets (CODE)");
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_BUDGETS);
            ps.execute();
            sb = new StringBuilder();
            sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_MINISTERES + " ( ");
            sb.append("CODE VARCHAR(2) NOT NULL, ");
            sb.append("LIBELLE VARCHAR(250) NOT NULL, ");
            sb.append("INDEX ministere (CODE)");
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_MINISTERES);
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseOrdos(Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder();
        Statement ps = null;
        try {
            sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_ORDOS + " ( ");
            sb.append("CODE VARCHAR(10) NOT NULL, ");
            sb.append("LIBELLE VARCHAR(250) NOT NULL, ");
            sb.append("INDEX ordos (CODE)");
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            ps.execute();
            sb = new StringBuilder();
            sb.append("TRUNCATE TABLE " + TABLE_ORDOS);
            ps = con.prepareStatement(sb.toString());
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseComptables(Connection con) throws SQLException {
        StringBuilder sb = new StringBuilder();
        Statement ps = null;
        try {
            sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_COMPTABLES + " ( ");
            sb.append("CODE VARCHAR(6) NOT NULL, ");
            sb.append("LIBELLE VARCHAR(75) NOT NULL, ");
            sb.append("INDEX comptas (CODE)");
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            ps.execute();
            sb = new StringBuilder();
            sb.append("TRUNCATE TABLE " + TABLE_COMPTABLES);
            ps = con.prepareStatement(sb.toString());
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

