/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.DlgGenEdmn;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.EdmnImporteurWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProgressFrame {
    private static final long serialVersionUID = 3977304325938558517L;
    private static Logger logger = Logger.getLogger(ProgressFrame.class);
    private DlgGenEdmn owner = null;
    private static final boolean SHOW_CANCEL_BUTTON = true;
    protected ProgressDlg pg;
    private EdmnImporteurWorker eiw;
    private boolean displayFeedback = true;
    public int[] nbLines = new int[]{0, 0, 0, 0, 0};

    public ProgressFrame(DlgGenEdmn owner, EdmnImporteurWorker eiw, File[] tabFiles) {
        this.owner = owner;
        this.eiw = eiw;
        for (int i = 0; i < tabFiles.length; ++i) {
            try {
                this.nbLines[i] = this.getLinesFile(tabFiles[i]);
                continue;
            }
            catch (Exception e) {
                this.nbLines[i] = 0;
            }
        }
    }

    public void hide() {
        this.pg.setVisible(false);
    }

    public void displayProgress() {
        Runnable code = new Runnable(){

            public void run() {
                logger.debug((Object)this.getClass().getName());
                ProgressFrame.this.pg = new ProgressDlg(ProgressFrame.this.owner, ProgressFrame.this.eiw);
                ProgressFrame.this.eiw.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        String propName = evt.getPropertyName();
                        if ("FILE_NAME".equals(propName)) {
                            ProgressFrame.this.pg.setCurrentFile((String)evt.getNewValue());
                        } else if ("initialize".equals(propName)) {
                            Integer initialize = (Integer)evt.getNewValue();
                            ProgressFrame.this.pg.setMaximumProgress(initialize);
                        } else if ("progress".equals(propName)) {
                            Integer progress = (Integer)evt.getNewValue();
                            ProgressFrame.this.pg.pushCurrentProgress(progress);
                        } else if ("currentTerminated".equals(propName)) {
                            int max = ProgressFrame.this.pg.currentProgress.getMaximum();
                            int oldProgress = ProgressFrame.this.pg.currentProgress.getValue();
                            ProgressFrame.this.pg.currentProgress.setValue(max);
                            ProgressFrame.this.pg.globalProgress.setValue(ProgressFrame.this.pg.globalProgress.getValue() - oldProgress + max);
                            ProgressFrame.this.pg.repaintImmediatly();
                        } else if ("terminated".equals(propName)) {
                            ProgressFrame.this.pg.globalProgress.setValue(ProgressFrame.this.pg.globalProgress.getMaximum());
                            ProgressFrame.this.pg.repaintImmediatly();
                            ProgressFrame.this.owner.setFile_edmn("");
                            ProgressFrame.this.owner.setFile_index("");
                            ProgressFrame.this.owner.setBrowseIndexEnabled(false);
                            ProgressFrame.this.owner.setValidBouttonEnabled(false);
                            ProgressFrame.this.pg.setDefaultCloseOperation(2);
                            ProgressFrame.this.pg.setVisible(false);
                        }
                    }
                });
                ProgressFrame.this.pg.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(code);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void pushCurrentProgress(int progress) {
        this.pg.pushCurrentProgress(progress);
    }

    public void displayMessage(String msg, int msgType) {
        if (this.shouldDisplayFeedback()) {
            JOptionPane.showMessageDialog(this.owner, msg, "G\u00e9n\u00e9ration", msgType == 1 ? 1 : 0);
        }
    }

    public void displayException(Throwable t) {
        new DisplayExceptionDlg((Dialog)this.owner, t);
    }

    public void startLongWait() {
        this.pg.setUnknownEndded(true);
    }

    public void endLongWait() {
        this.pg.setUnknownEndded(false);
    }

    public void setDisplayFeedback(boolean display) {
        this.displayFeedback = display;
    }

    public boolean shouldDisplayFeedback() {
        return this.displayFeedback;
    }

    public int getLinesFile(File f) throws Exception {
        BufferedReader br = null;
        int nbLignes = 0;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            while (line != null) {
                ++nbLignes;
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (br != null) {
            br.close();
        }
        return nbLignes;
    }

    public final class ProgressDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        public static final String DEFAULT_TEXT = "Traitement de #FILE# en cours : ";
        private boolean shouldContinue;
        private EdmnImporteurWorker eiw;
        private int nbFilesToImport;
        private int nbFilesImported;
        PaintableProgress globalProgress;
        PaintableProgress currentProgress;
        JTextField currentFileName;

        public ProgressDlg(DlgGenEdmn owner, EdmnImporteurWorker eiw) {
            super((Dialog)owner, "G\u00e9n\u00e9ration en cours...");
            this.shouldContinue = true;
            this.eiw = null;
            this.nbFilesImported = -1;
            this.eiw = eiw;
            this.initComponents();
        }

        protected void initComponents() {
            IhmFactory iF = IhmFactory.newInstance();
            FormLayout fl = null;
            fl = new FormLayout("3dlu,pref,3dlu", "3dlu,pref,1dlu,pref,5dlu,pref,1dlu,pref,3dlu,pref,3dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl);
            this.currentFileName = new JTextField(30);
            this.currentFileName.setBackground(this.getBackground());
            this.currentFileName.setBorder(BorderFactory.createEmptyBorder());
            this.currentFileName.setEditable(false);
            this.currentFileName.setText(DEFAULT_TEXT);
            pb.add((Component)this.currentFileName, cc.xy(2, 6));
            this.currentProgress = new PaintableProgress(0, 100);
            this.currentProgress.setStringPainted(true);
            pb.add((Component)this.currentProgress, cc.xy(2, 8));
            JButton pbCancel = new JButton("Annuler");
            pbCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ProgressDlg.this.eiw.cancel(true);
                }
            });
            pb.add((Component)pbCancel, cc.xy(2, 10));
            pb.add((Component)iF.newLabel("Progression Globale", "normal"), cc.xy(2, 2));
            this.globalProgress = new PaintableProgress(0, 100);
            this.globalProgress.setStringPainted(true);
            int nbLignes = 0;
            for (int i : ProgressFrame.this.nbLines) {
                nbLignes += i;
            }
            this.globalProgress.setMaximum(nbLignes);
            pb.add((Component)this.globalProgress, cc.xy(2, 4));
            this.setContentPane(pb.getPanel());
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
            Graphics g = this.getGraphics();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            this.paint(g);
            this.setGlassPane((Component)new InfiniteGlassPane());
        }

        public boolean setCurrentFile(String fileName) {
            ++this.nbFilesImported;
            this.currentFileName.setText(DEFAULT_TEXT.replace("#FILE#", fileName));
            this.repaintImmediatly();
            return this.shouldContinue;
        }

        public boolean setMaximumProgress(int max) {
            this.currentProgress.setValue(0);
            this.currentProgress.setMaximum(max);
            this.repaintImmediatly();
            return this.shouldContinue;
        }

        public boolean pushCurrentProgress(int value) {
            this.currentProgress.setValue(this.currentProgress.getValue() + value);
            this.globalProgress.setValue(this.globalProgress.getValue() + value);
            this.repaintImmediatly();
            return this.shouldContinue;
        }

        public void repaintImmediatly() {
            this.currentProgress.paintImmediatly();
            this.globalProgress.paintImmediatly();
            Graphics g = this.getGraphics();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            if (this.isLightweight()) {
                this.paint(g);
            } else {
                this.update(g);
            }
        }

        public void setUnknownEndded(boolean start) {
            this.getGlassPane().setVisible(start);
        }
    }

    public static class PaintableProgress
    extends JProgressBar
    implements ImmediatlyPaintable {
        private static final long serialVersionUID = 1L;

        public PaintableProgress() {
        }

        public PaintableProgress(int orient) {
            super(orient);
        }

        public PaintableProgress(int min, int max) {
            super(min, max);
        }

        public PaintableProgress(int orient, int min, int max) {
            super(orient, min, max);
        }

        public PaintableProgress(BoundedRangeModel newModel) {
            super(newModel);
        }

        public void paintImmediatly() {
            Runnable code = new Runnable(){

                public void run() {
                    PaintableProgress.this.paintImmediately(0, 0, PaintableProgress.this.getWidth(), PaintableProgress.this.getHeight());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(code);
                }
                catch (Exception ex) {
                    logger.error((Object)"tu sais ou", (Throwable)ex);
                }
            }
        }
    }

    public static interface ImmediatlyPaintable {
        public void paintImmediatly();
    }
}

