/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import java.util.Enumeration;
import java.util.Hashtable;

public class FileInfo {
    private Hashtable<String, Long> elementsCount = new Hashtable();
    private long globalCount = 0L;

    public void merge(FileInfo other) {
        if (other == null) {
            return;
        }
        Enumeration<String> enumer = other.elementsCount.keys();
        while (enumer.hasMoreElements()) {
            String etat = enumer.nextElement();
            Long otherCount = other.elementsCount.get(etat);
            Long thisCount = this.elementsCount.get(etat);
            if (thisCount != null) {
                otherCount = new Long(otherCount + thisCount);
            }
            this.elementsCount.put(etat, otherCount);
            other.elementsCount.remove(etat);
        }
        if (!other.elementsCount.isEmpty()) {
            this.elementsCount.putAll(other.elementsCount);
        }
        this.globalCount += other.getGlobalCount();
    }

    public void incElement(String etat) {
        Long ret = this.elementsCount.get(etat);
        if (ret == null) {
            ret = new Long(0L);
        }
        this.elementsCount.put(etat, new Long(ret + 1L));
        ++this.globalCount;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Enumeration<String> enumer = this.elementsCount.keys();
        while (enumer.hasMoreElements()) {
            String etat = enumer.nextElement();
            ret.append("   ").append(etat).append("\t-> ").append(this.elementsCount.get(etat)).append(" \u00e9l\u00e9ments import\u00e9s\n");
        }
        ret.append("\n");
        return ret.toString();
    }

    public long getGlobalCount() {
        return this.globalCount;
    }
}

