/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import fr.gouv.finances.cp.utils.xml.marshal.CharacterEscaper;
import fr.gouv.finances.cp.utils.xml.marshal.escapers.DefaultCharacterEscaper;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.DlgGenEdmn;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.ProgressFrame;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdmnImporteurWorker
extends SwingWorker<String, String> {
    private static Logger logger = Logger.getLogger(EdmnImporteurWorker.class);
    private static final boolean DEBUG = false;
    public static final transient String NOT_AVAILABLE = "Non disponible";
    public static final int MAX_SIZE_FILE = 5000;
    protected File[] filesToTreat;
    protected Exception inProcessException = null;
    protected long start;
    public final int MSG_TYPE_INFORMATION = 1;
    public final int MSG_TYPE_ERROR = 2;
    public static String TABLE_INDEX = "EDMN_INDEX_NUM_LIASSE";
    public static String TABLE_BUDGETS = "EDMN_BUDGS";
    public static String TABLE_ORDOS = "EDMN_ORDOS";
    public static String TABLE_COMPTABLES = "EDMN_COMPTAS";
    public static final transient String ENCODING = "ISO-8859-1";
    public static final String EDMN_NS_URI = "http://projets.admisource.gouv.fr/xemelios/namespaces#edmn";
    private ProgressFrame progress;
    private int progressShowing = 0;
    private String fireName = "";
    private Object fireValue;
    private File dirEDMN = null;
    private File budgets = null;
    private File ordos = null;
    private File comptables = null;
    private File output = null;
    private static final int BUFFER_SIZE = 8192;
    private DlgGenEdmn dlg;
    private Connection con = null;
    final CharacterEscaper escaper = new DefaultCharacterEscaper();
    private EdmnWriter writer;
    private File patchIndex;
    DecimalFormat df = new DecimalFormat("##0.00");
    private static long ministereError = 0L;
    private static long programmeError = 0L;
    private static long actionError = 0L;
    private static long cpceError = 0L;
    private String AnneeGestionCourante;

    public EdmnImporteurWorker(Connection con, File budgets, File ordos, File comptables, File output, String anneeGestion, DlgGenEdmn dlg) {
        this.con = con;
        this.budgets = budgets;
        this.ordos = ordos;
        this.comptables = comptables;
        this.output = output;
        this.dlg = dlg;
        this.AnneeGestionCourante = anneeGestion.length() == 2 ? anneeGestion : anneeGestion.substring(anneeGestion.length() - 2);
        DecimalFormatSymbols dfs = this.df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doInBackground() {
        FileInfo fileInfo = new FileInfo();
        this.start = System.currentTimeMillis();
        this.getProgressDlg().displayProgress();
        this.filesToTreat[2] = this.budgets;
        this.filesToTreat[3] = this.ordos;
        this.filesToTreat[4] = this.comptables;
        try {
            String fName;
            File f;
            try {
                f = this.filesToTreat[1];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[1]);
                this.saveIndex(f, this.getProgressDlg().nbLines[1]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[2];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[2]);
                this.saveBudgets(f, this.getProgressDlg().nbLines[2]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[3];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[3]);
                this.saveOrdos(f, this.getProgressDlg().nbLines[3]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[4];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[4]);
                this.saveComptas(f, this.getProgressDlg().nbLines[4]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[0];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[0]);
                this.importFile(f, this.getProgressDlg().nbLines[0]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            this.inProcessException = ex;
            ex.printStackTrace();
        }
        finally {
            if (this.con != null) {
                try {
                    PoolManager.getInstance().releaseConnection(this.con);
                }
                catch (Exception sqlEx) {}
            }
        }
        StringBuffer msg = new StringBuffer();
        if (!this.isCancelled()) {
            long ms = System.currentTimeMillis() - this.start;
            int s = Integer.parseInt(String.valueOf(ms / 1000L));
            int m = Integer.parseInt(String.valueOf(s / 60));
            int h = Integer.parseInt(String.valueOf(m / 60));
            StringBuffer sb = new StringBuffer("La g\u00e9n\u00e9ration a dur\u00e9 : ");
            if (Integer.parseInt(String.valueOf(h)) != 0) {
                sb.append(h + "h ");
            }
            if (Integer.parseInt(String.valueOf(m)) != 0) {
                sb.append((h != 0 ? " et " : "") + (m - h * 60) + "mins ");
            }
            if (Integer.parseInt(String.valueOf(s)) != 0) {
                sb.append((h != 0 || m != 0 ? " et " : "") + (s - m * 60) + "s ");
            }
            if (Integer.parseInt(String.valueOf(ms)) != 0) {
                sb.append((h != 0 || m != 0 || s != 0 ? " et " : "") + (ms - (long)(s * 1000)) + "ms ");
            }
            msg.append("La g\u00e9n\u00e9ration du fichier est termin\u00e9.\n");
            try {
                msg.append(fileInfo.toString(Loader.getDocumentsInfos(null)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            msg.append("");
        } else {
            msg.append("La g\u00e9n\u00e9ration du fichier EDMN a \u00e9t\u00e9 interrompue.");
        }
        logger.info((Object)("\n" + msg));
        return msg.toString();
    }

    private void fireProperty(final String name, final Object value) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange(name, null, value);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EdmnImporteurWorker.this.firePropertyChange(name, null, value);
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)"in fire:", t);
        }
    }

    protected void done() {
        super.done();
        if (this.inProcessException != null) {
            this.getProgressDlg().displayException(this.inProcessException);
        }
        String msg = "";
        try {
            msg = (String)this.get();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
        }
        catch (ExecutionException eEx) {
            eEx.printStackTrace();
        }
        catch (CancellationException cEx) {
            msg = "G\u00e9n\u00e9ration annul\u00e9e";
        }
        if (this.inProcessException == null) {
            if (this.generateArchive()) {
                this.cleanTempFile();
            }
            JOptionPane.showMessageDialog(this.dlg, "G\u00e9n\u00e9ration correctement termin\u00e9e.");
            this.dlg.enableGenerateButton();
        } else {
            this.getProgressDlg().displayMessage(msg, 1);
        }
        this.getProgressDlg().hide();
    }

    public void setFilesToTreat(File[] fichiers) throws Exception {
        this.filesToTreat = fichiers;
    }

    public ProgressFrame getProgressDlg() {
        return this.progress;
    }

    public void setProgressDlg(ProgressFrame prog) {
        this.progress = prog;
    }

    protected void saveIndex(File index, int nbLignes) throws Exception {
        Statement ps = null;
        StringBuffer sb = new StringBuffer();
        File fSQL = new File(System.getProperty("user.home"), "insert_index.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(index));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++i;
                ++total;
                if (line.length() > 15) {
                    if (total == nbLignes) {
                        sb.append(line.substring(0, 2) + "," + line.substring(2, 3) + "," + line.substring(3, 9) + "," + line.substring(9, 12) + "," + line.substring(17, 21) + "," + line.substring(21, 24) + "," + line.substring(24, 26) + "," + line.substring(31, 37));
                    } else {
                        sb.append(line.substring(0, 2) + "," + line.substring(2, 3) + "," + line.substring(3, 9) + "," + line.substring(9, 12) + "," + line.substring(17, 21) + "," + line.substring(21, 24) + "," + line.substring(24, 26) + "," + line.substring(31, 37) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.write(sb.toString());
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_INDEX + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion de l'index = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier d'index n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + index.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveBudgets(File budgets, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_budgets.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(budgets));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++i;
                ++total;
                if (line.length() > 15) {
                    String annee = line.substring(0, 4);
                    String typeEnregistrement = line.substring(4, 6);
                    String ministere = line.substring(6, 8);
                    String programme = line.substring(8, 12);
                    String action = line.substring(12, 14);
                    String articleRegroup = line.substring(14, 16);
                    String libelle = EdmnImporteurWorker.upperize(line.substring(16, line.length() - 1).trim());
                    fw.write(annee + "|" + typeEnregistrement + "|" + ministere + "|" + programme + "|" + action + "|" + articleRegroup + "|" + libelle);
                    if (total != nbLignes) {
                        fw.write("\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_BUDGETS + " FIELDS TERMINATED BY '|'");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion budgets = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier des budgets n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + budgets.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveOrdos(File ordos, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_ordos.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 50;
        try {
            BufferedReader br = new BufferedReader(new FileReader(ordos));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++total;
                if (line.length() > 15) {
                    String RCCST_compteSpeTresor = line.substring(0, 5);
                    String IMSB_section = line.substring(5, 7);
                    String ORNO3_codeOrdo = line.substring(7, 10);
                    String LIORDO_libelle = EdmnImporteurWorker.upperize(line.substring(10).trim());
                    fw.write(ORNO3_codeOrdo + ",");
                    fw.write(RCCST_compteSpeTresor + ",");
                    fw.write(IMSB_section + ",");
                    fw.write(LIORDO_libelle + ",");
                    fw.write("0,20");
                    fw.write(this.AnneeGestionCourante);
                    if (total != nbLignes) {
                        fw.write("\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_ORDOS + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion ordos = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier d'ordos n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + ordos.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveComptas(File comptas, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_comptas.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(comptas));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Date datedeb = new Date();
            while (line != null) {
                ++total;
                if (line.length() > 15) {
                    if (total == nbLignes) {
                        fw.write(line.substring(0, 6) + "," + EdmnImporteurWorker.upperize(line.substring(6, line.length() - 1)));
                    } else {
                        fw.write(line.substring(0, 6) + "," + EdmnImporteurWorker.upperize(line.substring(6, line.length() - 1)) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_COMPTABLES + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            long tempsTotalTraitement = datefin.getTime() - datedeb.getTime();
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion comptas = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier des comptas n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + comptas.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected FileInfo importFile(File f, int nbLignes) throws Exception {
        FileInfo ret = new FileInfo();
        this.dirEDMN = File.createTempFile("tmp", "edmn", f.getParentFile());
        this.dirEDMN.delete();
        this.dirEDMN.mkdir();
        if (this.dirEDMN != null && this.dirEDMN.listFiles().length > 0) {
            for (File fToDelete : this.dirEDMN.listFiles()) {
                fToDelete.delete();
            }
        }
        this.generateXmlFileText(f, this.dirEDMN, nbLignes);
        return ret;
    }

    protected static String fmtNumLiasse(int i) {
        String v = Integer.toString(i);
        while (v.length() < 4) {
            v = "0".concat(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleMinistere(String ministere, String annee, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT BUD_LIBELLE FROM " + TABLE_BUDGETS + " WHERE BUD_TYPE_ENREGISTREMENT='02' " + "AND BUD_MINISTERE=? " + "AND BUD_ANNEE=? ");
            ps.setString(1, ministere);
            ps.setString(2, annee);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
            if (rs.next()) {
                // empty if block
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleProgramme(String ministere, String annee, String programme, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT BUD_LIBELLE FROM " + TABLE_BUDGETS + " WHERE BUD_TYPE_ENREGISTREMENT='06' " + "AND BUD_MINISTERE=? " + "AND BUD_ANNEE=? " + "AND BUD_PROGRAMME=? " + "AND BUD_ACTION='00' " + "AND BUD_ARTICLE='00'");
            ps.setString(1, ministere);
            ps.setString(2, annee);
            ps.setString(3, programme);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
            if (rs.next()) {
                // empty if block
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleAction(String ministere, String annee, String programme, String action, String artRegr, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT BUD_LIBELLE FROM " + TABLE_BUDGETS + " WHERE BUD_TYPE_ENREGISTREMENT='10' " + "AND BUD_MINISTERE=? " + "AND BUD_ANNEE=? " + "AND BUD_PROGRAMME=? " + "AND BUD_ACTION=? " + "AND BUD_ARTICLE=?");
            ps.setString(1, ministere);
            ps.setString(2, annee);
            ps.setString(3, programme);
            ps.setString(4, action);
            ps.setString(5, artRegr);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
            if (rs.next()) {
                // empty if block
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleCPCE(String ministere, String annee, String programme, String action, String artRegr, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT BUD_LIBELLE FROM " + TABLE_BUDGETS + " WHERE BUD_TYPE_ENREGISTREMENT='15' " + "AND BUD_MINISTERE=? " + "AND BUD_ANNEE=? " + "AND BUD_PROGRAMME=? " + "AND BUD_ACTION=? " + "AND BUD_ARTICLE=?");
            ps.setString(1, ministere);
            ps.setString(2, annee);
            ps.setString(3, programme);
            ps.setString(4, action);
            ps.setString(5, artRegr);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
            if (rs.next()) {
                // empty if block
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleOrdo(String orno3, String rccst, String imsb, String annee, String trimestre, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT ORD_LIORDO FROM " + TABLE_ORDOS + " WHERE ORD_ORNO3=? " + "AND ORD_RCCST=? " + "AND ORD_IMSB=? " + "AND ORD_ANNEE=? ");
            ps.setString(1, orno3);
            ps.setString(2, rccst);
            ps.setString(3, imsb);
            ps.setString(4, annee);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
                if (rs.next()) {
                    // empty if block
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleCompta(String code, Connection con) {
        Statement ps = null;
        String ret = NOT_AVAILABLE;
        try {
            ps = con.prepareStatement("SELECT CMP_LIBELLE FROM " + TABLE_COMPTABLES + " WHERE CMP_CODE=?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNumLiasseNationale(String annee, String trimestre, String comptable, String ministere, String numLiasseLocaleDeb, String numLiasseLocaleFin, Connection con) {
        Statement ps = null;
        StringBuffer ret = new StringBuffer();
        StringBuffer numLiasses = new StringBuffer();
        int first = 0;
        int last = 0;
        try {
            first = Integer.parseInt(numLiasseLocaleDeb);
        }
        catch (NumberFormatException nfEx) {
            // empty catch block
        }
        try {
            last = Integer.parseInt(numLiasseLocaleFin);
        }
        catch (NumberFormatException nfEx) {
            // empty catch block
        }
        numLiasses.append("(");
        for (int i = first; i < last; ++i) {
            numLiasses.append("'").append(EdmnImporteurWorker.fmtNumLiasse(i)).append("',");
        }
        numLiasses.append("'").append(EdmnImporteurWorker.fmtNumLiasse(last)).append("')");
        try {
            String sql = "SELECT IND_NATIONALE FROM " + TABLE_INDEX + " WHERE IND_ANNEE=? AND IND_TRIMESTRE=? AND IND_COMPTABLE=? AND IND_MINISTERE=? AND IND_LOCALE IN " + numLiasses.toString() + " ORDER BY 1";
            ps = con.prepareStatement(sql);
            ps.setString(1, annee);
            ps.setString(2, trimestre);
            ps.setString(3, comptable);
            ps.setString(4, ministere);
            ResultSet rs = ps.executeQuery();
            boolean alreadyNexted = false;
            while (rs.next()) {
                ret.append("<Liasse V=\"").append(EdmnImporteurWorker.escape(rs.getString(1))).append("\"/>");
                alreadyNexted = true;
            }
            if (!alreadyNexted) {
                // empty if block
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret.toString();
    }

    protected void generateXmlFileText(File source, File dirDest, int nbLignes) throws IOException, SAXException, SQLException {
        this.progressShowing = 500;
        dirDest.mkdir();
        BufferedReader br = new BufferedReader(new FileReader(source));
        String line = br.readLine();
        this.writer = new EdmnWriter(this.dirEDMN, source.getName());
        boolean lineCount = false;
        boolean roundCount = false;
        br.close();
        BufferedOutputStream bos = this.writer.prepareRepository();
        this.createRepositorys(bos, this.budgets, this.ordos, this.comptables);
        this.writer.flush();
        this.patchIndex = this.generatePatchIndex(this.writer.getMainTrimestre(), this.con);
    }

    private File generatePatchIndex(TrimestreMarker tm, Connection con) throws SQLException, IOException {
        File f = this.writer.getTargetFile();
        String name = "INDEX-" + this.writer.getMainTrimestre().toString();
        File ret = new File(f.getParentFile(), name);
        FileWriter fw = new FileWriter(ret);
        String sql = "SELECT IND_ANNEE, IND_TRIMESTRE, IND_COMPTABLE, IND_MINISTERE, IND_LOCALE, IND_NATIONALE FROM EDMN_INDEX_NUM_LIASSE WHERE IND_ANNEE<>? OR IND_TRIMESTRE<>?";
        PreparedStatement ps = con.prepareStatement(sql);
        ps.setString(1, tm.getAnnee());
        ps.setString(2, tm.getTrimestre());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            fw.write(rs.getString(1));
            fw.write(";");
            fw.write(rs.getString(2));
            fw.write(";");
            fw.write(rs.getString(3));
            fw.write(";");
            fw.write(rs.getString(4));
            fw.write(";");
            fw.write(rs.getString(5));
            fw.write(";");
            fw.write(rs.getString(6));
            fw.write("\n");
        }
        fw.flush();
        fw.close();
        ps.close();
        return ret;
    }

    private void createRepositorys(BufferedOutputStream writer, File budgets, File ordonateurs, File comptables) throws IOException {
        this.createBudgetRepository(writer, budgets);
        this.createOrdoRepository(writer, ordonateurs);
        this.createComptaRepository(writer, comptables);
    }

    private void createBudgetRepository(BufferedOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureBudgets>\n".getBytes());
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT BUD_ANNEE,BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE,BUD_PROGRAMME,BUD_ACTION,BUD_ARTICLE,BUD_LIBELLE FROM " + TABLE_BUDGETS);
            while (rs.next()) {
                String typeEnregistrement = rs.getString(2);
                String datatype = null;
                if ("02".equals(typeEnregistrement)) {
                    datatype = "MINISTERE";
                } else if ("06".equals(typeEnregistrement)) {
                    datatype = "PROGRAMME";
                } else if ("10".equals(typeEnregistrement)) {
                    datatype = "ACTION";
                } else if ("15".equals(typeEnregistrement)) {
                    datatype = "CPCE";
                }
                writer.write(("<Budget><Annee V=\"" + rs.getString(1) + "\"/><Libelle V=\"" + EdmnImporteurWorker.escape(rs.getString(7)) + "\"/><Data V=\"" + datatype + "\"/><Ministere V=\"" + rs.getString(3) + "\"/>").getBytes());
                if (!"MINISTERE".equals(datatype) && rs.getString(4) != null) {
                    writer.write(("<Programme V=\"" + rs.getString(4) + "\"/>").getBytes());
                    if (!"PROGRAMME".equals(datatype) && rs.getString(5) != null) {
                        writer.write(("<Action V=\"" + rs.getString(5) + "\"/>").getBytes());
                        if ("ACTION".equals(datatype) && rs.getString(6) != null) {
                            writer.write(("<ArticleRegroupt V=\"" + rs.getString(6) + "\"/>").getBytes());
                        }
                    }
                }
                writer.write("</Budget>\n".getBytes());
            }
            writer.write("</NomenclatureBudgets>\n".getBytes());
            rs.close();
            st.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature budget !");
            e.printStackTrace();
        }
    }

    private void createOrdoRepository(BufferedOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureOrdonnateurs>\n".getBytes());
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT ORD_ORNO3, ORD_RCCST, ORD_IMSB, ORD_LIORDO, ORD_TRIMESTRE, ORD_ANNEE FROM " + TABLE_ORDOS);
            while (rs.next()) {
                writer.write(("<Ordonnateur><CodeOrdo V=\"" + rs.getString(1).trim() + "\"/><CompteSpeTresor V=\"" + rs.getString(2) + "\"/><CodeMinistere V=\"" + rs.getString(3) + "\"/><Trimestre V=\"" + rs.getString(5) + "\"/><Annee V=\"" + rs.getString(6) + "\"/><Libelle V=\"" + EdmnImporteurWorker.escape(rs.getString(4).trim()) + "\"/></Ordonnateur>\n").getBytes());
            }
            writer.write("</NomenclatureOrdonnateurs>\n".getBytes());
            rs.close();
            st.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature ordonnateurs !");
            e.printStackTrace();
        }
    }

    private void createComptaRepository(BufferedOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureComptables>\n".getBytes());
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT CMP_CODE,CMP_LIBELLE FROM " + TABLE_COMPTABLES);
            while (rs.next()) {
                writer.write(("<Comptable><Annee V=\"20" + this.AnneeGestionCourante + "\"/><Code V=\"" + rs.getString(1) + "\"/><Libelle V=\"" + EdmnImporteurWorker.escape(rs.getString(2)) + "\"/></Comptable>\n").getBytes());
            }
            writer.write("</NomenclatureComptables>\n".getBytes());
            rs.close();
            st.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature comptables !");
            e.printStackTrace();
        }
    }

    public String getAdditionalMessage() {
        return "";
    }

    private String getLine(char[] tab, int deb, int fin) {
        String s = "";
        for (int i = deb; i < fin; ++i) {
            s = s + String.valueOf(tab[i]);
        }
        return this.escaper.escapeString(s.trim());
    }

    private String getCodeReferenceNomenclature(String annee, String trimestre) {
        return annee + "-" + trimestre;
    }

    private String getLibelleReferenceNomenclature(String annee, String trimestre) {
        return "Ann\u00e9e " + annee + " - Trimestre " + trimestre;
    }

    protected void writeNode(String nodeName, String value, DefaultHandler h) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "V", "V", "String", value);
        h.startElement(EDMN_NS_URI, nodeName, "n:" + nodeName, attr);
        h.endElement(EDMN_NS_URI, nodeName, "n:" + nodeName);
    }

    private LineInfo createLineText(char[] line, Connection con, int lineCount) throws SAXException {
        String comptable = this.getLine(line, 0, 6);
        String imin = this.getLine(line, 6, 9);
        String imsb = imin.substring(1);
        String imputation = imin.substring(0, 1);
        String ordo = this.getLine(line, 9, 15);
        String typeEvent = this.getLine(line, 15, 18);
        String anneeGestion = this.getLine(line, 18, 20);
        String noMdt = this.getLine(line, 20, 26);
        String cpteSpecTres = this.getLine(line, 26, 31);
        String noOpeInv = this.getLine(line, 31, 39);
        String anneeEngag = this.getLine(line, 39, 41);
        String noEngag = this.getLine(line, 41, 47);
        String programme = this.getLine(line, 47, 51);
        String action = this.getLine(line, 51, 53);
        String PCE = this.getLine(line, 53, 55);
        String mtPj = this.getLine(line, 55, 68);
        String signeMtPj = this.getLine(line, 68, 69);
        String trimestre = this.getLine(line, 69, 70);
        String mois = this.getLine(line, 70, 72);
        String dateCrea8 = this.getLine(line, 72, 80);
        String anneeCrea = this.getLine(line, 72, 76);
        String moisCrea = this.getLine(line, 76, 78);
        String jourCrea = this.getLine(line, 78, 80);
        String chapClassPJ = this.getLine(line, 80, 84);
        String typePaiement = this.getLine(line, 84, 87);
        String artBudgPrev = this.getLine(line, 87, 89);
        String dateValidCompt = this.getLine(line, 89, 97);
        String filler16 = this.getLine(line, 97, 113);
        String numLiasseDeb = this.getLine(line, 113, 117);
        String numLiasseFin = this.getLine(line, 117, 121);
        String typeSuiviEco1 = this.getLine(line, 121, 123);
        String typeSuiviEco2 = this.getLine(line, 123, 125);
        String typeSuiviEco3 = this.getLine(line, 125, 127);
        String codeCorr = this.getLine(line, 127, 131);
        String serviceExec = this.getLine(line, 138, 148);
        String cleChorus = this.getLine(line, 148, 169);
        String chorusExerc = this.getLine(line, 148, 152);
        String chorusSoc = this.getLine(line, 152, 156);
        String chorusPiece = this.getLine(line, 156, 166);
        String chorusPoste = this.getLine(line, 166, 169);
        String anneeCourte = anneeCrea.substring(2);
        String ctordo = this.getLine(line, 12, 15);
        String dateCreation = anneeCrea + "-" + moisCrea + "-" + jourCrea;
        String annee = "20" + anneeGestion;
        StringBuilder sb = new StringBuilder("<LigneEdmn numLigne=\"" + lineCount + "\">");
        sb.append("<Comptable V=\"").append(comptable).append("\"/><LibelleComptable V=\"").append(anneeGestion.equals(this.AnneeGestionCourante) ? this.getLibelleCompta(comptable, con) : NOT_AVAILABLE);
        sb.append("\"/><Imputation V=\"").append(imputation).append("\"/><Ministere V=\"").append(imin).append("\" LibelleMinistere=\"");
        sb.append(this.getLibelleMinistere(imsb, annee, con)).append("\"/><Ordo V=\"").append(ordo).append("\"/><LibelleOrdonnateur V=\"");
        sb.append(this.getLibelleOrdo(ctordo, cpteSpecTres, imsb, annee, trimestre, con));
        sb.append("\"/><TypeEvt V=\"").append(typeEvent).append("\"/><AnneeBudget V=\"20").append(anneeGestion);
        sb.append("\"/><NumMandat V=\"").append(noMdt).append("\"/><CompteSpeTresor V=\"").append(cpteSpecTres);
        sb.append("\"/><NumOpeInvest V=\"").append(noOpeInv).append("\"/><AnneeEngag V=\"").append("20" + anneeEngag);
        sb.append("\"/><NumEngag V=\"").append(noEngag).append("\"/><ChapBudg V=\"").append(programme);
        sb.append("\"/><ArtBudgExec V=\"").append(action).append("\"/><ParagBudgExec V=\"").append(PCE).append("\"/><LibelleBudget V=\"").append(this.getLibelleCPCE(imsb, annee, programme, action, PCE, con)).append("\"/>");
        sb.append("<LibelleProgramme V=\"").append(this.getLibelleProgramme(imsb, annee, programme, con)).append("\"/><LibelleAction V=\"").append(this.getLibelleAction(imsb, annee, programme, action, artBudgPrev, con)).append("\"/>");
        String mtedm = mtPj;
        while (mtedm.startsWith("0")) {
            mtedm = mtedm.substring(1);
        }
        if (mtedm.length() == 0) {
            mtedm = "0";
        }
        if (signeMtPj.trim().equals("-")) {
            mtedm = "-" + mtedm;
        }
        try {
            long mt = Long.parseLong(mtedm);
            mtedm = this.df.format((double)mt / 100.0);
        }
        catch (Exception ex) {
            logger.error((Object)"while dividing mt", (Throwable)ex);
        }
        sb.append("<MtPJ V=\"").append(mtedm).append("\"/><Trimestre V=\"").append(trimestre).append("\"/><Mois V=\"");
        sb.append(mois).append("\"/><AnneeCrea V=\"").append(anneeCrea).append("\"/><MoisCrea V=\"");
        sb.append(moisCrea).append("\"/><JourCrea V=\"").append(jourCrea).append("\"/><DateCreation V=\"").append(dateCreation).append("\"/><ChapClassPJ V=\"");
        sb.append(chapClassPJ).append("\"/><TypePaiement V=\"").append(typePaiement).append("\"/><ArtBudgPrev V=\"");
        sb.append(artBudgPrev).append("\"/><NumLiasseDeb V=\"");
        sb.append(numLiasseDeb).append("\"/><NumLiasseFin V=\"").append(numLiasseFin).append("\"/><TypeSuiviEco1 V=\"").append(typeSuiviEco1);
        sb.append("\"/><TypeSuiviEco2 V=\"").append(typeSuiviEco2).append("\"/><TypeSuiviEco3 V=\"").append(typeSuiviEco3);
        sb.append("\"/><CodeCorrection V=\"").append(codeCorr).append("\"/><NumLiasseNationale>");
        sb.append(this.getNumLiasseNationale(anneeCourte, trimestre, comptable, imin, numLiasseDeb, numLiasseFin, con)).append("</NumLiasseNationale>");
        sb.append("<CodeManip V=\"").append(this.getLine(line, 137, 138)).append("\"/><Zone32 V=\"").append(this.getLine(line, 138, 170));
        sb.append("\"/>");
        sb.append("<CodeOperExc V=\"").append(this.getLine(line, 137, 138)).append("\"/>");
        if (Integer.parseInt(anneeGestion) < 2009) {
            sb.append("<NumPieceCompta V=\"").append(this.getLine(line, 148, 169)).append("\"/>");
        } else {
            sb.append("<ServiceExecutant V=\"").append(serviceExec).append("\"/>");
            sb.append("<ExerComptaChorus V=\"").append(chorusExerc).append("\"/>");
            sb.append("<SocieteChorus V=\"").append(chorusSoc).append("\"/>");
            sb.append("<NumPceChorus V=\"").append(chorusPiece).append("\"/>");
            sb.append("<NumPosteChorus V=\"").append(chorusPoste).append("\"/>");
        }
        sb.append("</LigneEdmn>\n");
        return new LineInfo(sb.toString(), anneeGestion, trimestre);
    }

    private boolean generateArchive() {
        boolean bRet = false;
        File target = this.output;
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));
            ArrayList<File> generatedFiles = this.writer.getGeneratedFiles();
            for (File f : generatedFiles) {
                ZipEntry ze = new ZipEntry("data/" + f.getName());
                zos.putNextEntry(ze);
                byte[] buffer = new byte[2048];
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                int read = bis.read(buffer);
                while (read > 0) {
                    zos.write(buffer, 0, read);
                    read = bis.read(buffer);
                }
                bis.close();
            }
            if (this.patchIndex != null) {
                ZipEntry ze = new ZipEntry("patches/" + this.patchIndex.getName());
                zos.putNextEntry(ze);
                byte[] buffer = new byte[2048];
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.patchIndex));
                int read = bis.read(buffer);
                while (read > 0) {
                    zos.write(buffer, 0, read);
                    read = bis.read(buffer);
                }
                bis.close();
            }
            ZipEntry manifestEntry = new ZipEntry("manifeste_XeMeLios.xml");
            zos.putNextEntry(manifestEntry);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<manifeste cgIdCol=\"000000000000\" cgLibelle=\"ETAT\">\n");
            sb.append("\t<volumes>\n");
            sb.append("\t\t<volume fichier=\"").append(target.getName()).append("\" num=\"1\" dateProduction=\"").append(EdmnImporteurWorker.getFormattedCurrentDateTime()).append("\"/>\n");
            sb.append("\t</volumes>\n");
            sb.append("\t<documents>\n");
            for (File f : generatedFiles) {
                sb.append("\t\t<document volume=\"1\" path=\"data/").append(f.getName()).append("\" type=\"edmn\" buIdCol=\"000000000000\" buLibelle=\"ETAT\" buCode=\"0000\" libBudget=\"LFI\"/>\n");
            }
            sb.append("\t</documents>\n");
            if (this.patchIndex != null) {
                sb.append("\t<actions>\n");
                sb.append("\t\t<action class=\"fr.gouv.finances.dgfip.xemelios.edmn.patchers.NumLiassePatcher\">\n");
                sb.append("\t\t\t<parameter type=\"java.io.File\" name=\"index.file\">patches/").append(this.patchIndex.getName()).append("</parameter>\n");
                sb.append("\t\t</action>\n");
                sb.append("\t</actions>\n");
            }
            sb.append("\t</manifeste>\n");
            zos.write(sb.toString().getBytes("UTF-8"));
            zos.flush();
            zos.close();
            bRet = true;
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return bRet;
    }

    private void cleanTempFile() {
        File[] files;
        logger.info((Object)"removing temp files");
        for (File f : files = this.dirEDMN.listFiles()) {
            f.delete();
        }
        this.dirEDMN.delete();
    }

    private static String getFormattedCurrentDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeZip() throws IOException {
        File fout = new File(this.dirEDMN.getParent(), "EDMN.xml.zip");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fout);
            CheckedOutputStream checksum = new CheckedOutputStream(fos, new Adler32());
            try {
                BufferedOutputStream bos = new BufferedOutputStream(checksum, 8192);
                try {
                    ZipOutputStream zos = new ZipOutputStream(bos);
                    try {
                        try {
                            zos.setMethod(8);
                            zos.setLevel(9);
                        }
                        catch (Exception ignor) {
                            // empty catch block
                        }
                        EdmnImporteurWorker.zipDir(this.dirEDMN.getAbsolutePath(), null, zos);
                    }
                    finally {
                        zos.close();
                    }
                }
                finally {
                    bos.close();
                }
            }
            finally {
                checksum.close();
            }
        }
        finally {
            fos.close();
        }
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDir(String basedir, String currentdir, ZipOutputStream zos) throws FileNotFoundException, IOException {
        ZipEntry anEntry;
        String currentdir2;
        File zipDir = currentdir != null ? new File(basedir, currentdir) : new File(basedir);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        String string = currentdir2 = currentdir != null ? currentdir + "/" : "";
        if (currentdir2.length() > 0) {
            anEntry = new ZipEntry(currentdir2);
            zos.putNextEntry(anEntry);
            zos.closeEntry();
        }
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                EdmnImporteurWorker.zipDir(basedir, currentdir2 + dirList[i], zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                BufferedInputStream bis = new BufferedInputStream(fis, 8192);
                try {
                    anEntry = new ZipEntry(currentdir2 + dirList[i]);
                    anEntry.setTime(f.lastModified());
                    zos.putNextEntry(anEntry);
                    while ((bytesIn = bis.read(readBuffer, 0, 8192)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                    zos.closeEntry();
                    continue;
                }
                finally {
                    bis.close();
                }
            }
            finally {
                fis.close();
            }
        }
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        block7: for (char c : s.trim().toCharArray()) {
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    protected static String upperize(String s) {
        StringBuilder sb = new StringBuilder();
        block9: for (char c : s.toCharArray()) {
            switch (c) {
                case '\u00e0': 
                case '\u00e2': 
                case '\u00e4': {
                    sb.append("A");
                    continue block9;
                }
                case '\u00e7': {
                    sb.append("C");
                    continue block9;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    sb.append("E");
                    continue block9;
                }
                case '\u00ee': 
                case '\u00ef': {
                    sb.append("I");
                    continue block9;
                }
                case '\u00f4': 
                case '\u00f6': {
                    sb.append("O");
                    continue block9;
                }
                case '\u00f9': 
                case '\u00fb': 
                case '\u00fc': {
                    sb.append("U");
                    continue block9;
                }
                case '?': 
                case '\u00ff': {
                    sb.append("Y");
                    continue block9;
                }
                default: {
                    sb.append(String.valueOf(c).toUpperCase());
                }
            }
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineWriter {
        private EdmnWriter writerController;
        private File currentFile;
        private File repository;
        private BufferedOutputStream bos;
        private int writedLines = 0;
        private TrimestreMarker marker;
        ArrayList<File> generatedFiles;

        public LineWriter(EdmnWriter writerController, TrimestreMarker marker) {
            this.writerController = writerController;
            this.marker = marker;
            this.generatedFiles = new ArrayList();
        }

        public void writeLine(LineInfo line) throws IOException {
            if (this.currentFile == null) {
                this.initializeNewFile();
            }
            byte[] data = line.getXmlData().getBytes(EdmnImporteurWorker.ENCODING);
            this.bos.write(data, 0, data.length);
            ++this.writedLines;
            if (this.writedLines == 5000) {
                this.closeFile();
            }
        }

        protected void initializeNewFile() throws IOException {
            this.currentFile = this.writerController.getTargetFile();
            this.generatedFiles.add(this.currentFile);
            this.bos = new BufferedOutputStream(new FileOutputStream(this.currentFile));
            this.writedLines = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"").append(EdmnImporteurWorker.ENCODING).append("\"?>\n<Edmn xmlns=\"").append(EdmnImporteurWorker.EDMN_NS_URI).append("\" xmlns:n=\"").append(EdmnImporteurWorker.EDMN_NS_URI).append("\">\n");
            sb.append("<ReferenceNomenclature>\n<Code V=\"").append(EdmnImporteurWorker.this.getCodeReferenceNomenclature(this.marker.getAnnee(), this.marker.getTrimestre())).append("\"/>\n<Libelle V=\"").append(EdmnImporteurWorker.this.getLibelleReferenceNomenclature(this.marker.getAnnee(), this.marker.getTrimestre())).append("\"/>\n</ReferenceNomenclature>\n");
            sb.append("<Budget><Code V=\"0000\"/><Libelle V=\"LFI\"/></Budget>\n");
            sb.append("<Collectivite><Code V=\"000000000000\"/><Libelle V=\"ETAT\"/></Collectivite>\n");
            sb.append("<EtatEdmn>\n");
            byte[] b = sb.toString().getBytes(EdmnImporteurWorker.ENCODING);
            this.bos.write(b);
        }

        protected void closeFile() throws IOException {
            if (this.currentFile != null) {
                StringBuilder sb = new StringBuilder();
                if (this.currentFile != this.repository) {
                    sb.append("</EtatEdmn>\n");
                }
                sb.append("</Edmn>\n");
                this.bos.write(sb.toString().getBytes(EdmnImporteurWorker.ENCODING));
                this.bos.flush();
                this.bos.close();
                this.bos = null;
                this.currentFile = null;
            }
        }

        public BufferedOutputStream prepareRepository() throws IOException {
            this.closeFile();
            this.initializeNewFile();
            this.repository = this.currentFile;
            this.bos.write("</EtatEdmn>\n".getBytes(EdmnImporteurWorker.ENCODING));
            return this.bos;
        }

        public File getRepositoryFile() {
            return this.repository;
        }

        public ArrayList<File> getGeneratedFiles() {
            return this.generatedFiles;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdmnWriter {
        private File destDir;
        private String baseName;
        private int fileCount = 0;
        private Hashtable<TrimestreMarker, LineWriter> writers;

        public EdmnWriter(File destDir, String baseName) {
            this.destDir = destDir;
            this.baseName = baseName;
            this.writers = new Hashtable();
        }

        public void writeLine(LineInfo line) throws IOException {
            LineWriter writer = this.writers.get(line.getMarker());
            if (writer == null) {
                writer = new LineWriter(this, line.getMarker());
                this.writers.put(line.getMarker(), writer);
            }
            writer.writeLine(line);
        }

        public TrimestreMarker getMainTrimestre() {
            TrimestreMarker m = null;
            for (TrimestreMarker tm : this.writers.keySet()) {
                if (tm.compareTo(m) <= 0) continue;
                m = tm;
            }
            if (m == null) {
                m = new TrimestreMarker(EdmnImporteurWorker.this.AnneeGestionCourante, "1");
            }
            return m;
        }

        public BufferedOutputStream prepareRepository() throws IOException {
            TrimestreMarker tm = this.getMainTrimestre();
            LineWriter writer = this.writers.get(tm);
            if (writer == null) {
                writer = new LineWriter(this, tm);
                this.writers.put(tm, writer);
            }
            return writer.prepareRepository();
        }

        protected File getTargetFile() {
            return new File(this.destDir, this.baseName + "-" + Integer.toString(++this.fileCount) + ".xml");
        }

        public void flush() throws IOException {
            for (LineWriter writer : this.writers.values()) {
                writer.closeFile();
            }
        }

        public ArrayList<File> getGeneratedFiles() {
            ArrayList<File> ret = new ArrayList<File>();
            File repository = null;
            for (LineWriter writer : this.writers.values()) {
                ret.addAll(writer.getGeneratedFiles());
                if (writer.getRepositoryFile() == null) continue;
                repository = writer.getRepositoryFile();
            }
            if (repository != null) {
                ArrayList<File> tmp = new ArrayList<File>();
                tmp.add(repository);
                for (File f : ret) {
                    if (f.equals(repository)) continue;
                    tmp.add(f);
                }
                ret = tmp;
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TrimestreMarker
    implements Comparable<TrimestreMarker> {
        private int data;
        private String annee;
        private String trimestre;

        public TrimestreMarker(String annee, String trimestre) {
            this.annee = annee;
            this.trimestre = trimestre;
            int a = Integer.parseInt(annee) * 100;
            int t = Integer.parseInt(trimestre);
            this.data = 100 * a + t;
        }

        public long getMarker() {
            return this.data;
        }

        public int hashCode() {
            return this.data;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return true;
            }
            if (obj instanceof TrimestreMarker) {
                TrimestreMarker t = (TrimestreMarker)obj;
                return (long)this.data == t.getMarker();
            }
            return false;
        }

        @Override
        public int compareTo(TrimestreMarker o) {
            if (o == null) {
                return 1;
            }
            return (int)((long)this.data - o.getMarker());
        }

        public String getAnnee() {
            return this.annee;
        }

        public String getTrimestre() {
            return this.trimestre;
        }

        public String toString() {
            return this.annee + "-" + this.trimestre;
        }
    }

    private class LineInfo {
        private String xmlData;
        private TrimestreMarker trimestreMarker;

        public LineInfo(String xml, String annee, String trimestre) {
            this.xmlData = xml;
            this.trimestreMarker = new TrimestreMarker(annee, trimestre);
        }

        public String getXmlData() {
            return this.xmlData;
        }

        public TrimestreMarker getMarker() {
            return this.trimestreMarker;
        }
    }
}

