/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.DlgGenEdmn;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.EdmnImporteurWorker;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.ProgressFrame;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import java.awt.Dialog;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class EdmnImporter {
    private static final Logger logger = Logger.getLogger(EdmnImporter.class);
    private static final String TABLE_INDEX = EdmnImporteurWorker.TABLE_INDEX;
    private static final String TABLE_BUDGETS = EdmnImporteurWorker.TABLE_BUDGETS;
    private static final String TABLE_ORDOS = EdmnImporteurWorker.TABLE_ORDOS;
    private static final String TABLE_COMPTABLES = EdmnImporteurWorker.TABLE_COMPTABLES;
    private static final String SCRIPT_BUDGET = "CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_BUDGETS + " (\n" + "BUD_ANNEE VARCHAR(4) not null,\n" + "BUD_TYPE_ENREGISTREMENT VARCHAR(2) not null,\n" + "BUD_MINISTERE VARCHAR(2) not null,\n" + "BUD_PROGRAMME VARCHAR(4) not null,\n" + "BUD_ACTION VARCHAR(2) not null,\n" + "BUD_ARTICLE VARCHAR(2) not null,\n" + "BUD_LIBELLE VARCHAR(500),\n" + "INDEX IX_BUDGETS_1 (BUD_TYPE_ENREGISTREMENT),\n" + "INDEX IX_BUDGETS_2 (BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE),\n" + "INDEX IX_BUDGETS_3 (BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE,BUD_ANNEE),\n" + "INDEX IX_BUDGETS_5 (BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE,BUD_ANNEE,BUD_PROGRAMME),\n" + "INDEX IX_BUDGETS_6 (BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE,BUD_ANNEE,BUD_PROGRAMME,BUD_ACTION),\n" + "INDEX IX_BUDGETS_7 (BUD_TYPE_ENREGISTREMENT,BUD_MINISTERE,BUD_ANNEE,BUD_PROGRAMME,BUD_ACTION,BUD_ARTICLE)\n" + ")";
    private static final String SCRIPT_ORDOS = "CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_ORDOS + " (\n" + "ORD_ORNO3 VARCHAR(3) not null,\n" + "ORD_RCCST VARCHAR(5),\n" + "ORD_IMSB VARCHAR(2),\n" + "ORD_LIORDO VARCHAR(500),\n" + "ORD_TRIMESTRE VARCHAR(1) not null,\n" + "ORD_ANNEE VARCHAR(4) not null,\n" + "INDEX IX_ORDOS (ORD_ORNO3,ORD_RCCST,ORD_IMSB, ORD_TRIMESTRE, ORD_ANNEE)\n" + ")";
    private static final String SCRIPTS_COMPTABLES = "CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_COMPTABLES + " (\n" + "CMP_CODE VARCHAR(6) not null,\n" + "CMP_LIBELLE VARCHAR(75),\n" + "INDEX IX_COMPTA (CMP_CODE)\n" + ")";
    private static final String SCRIPT_INDEX = "CREATE TEMPORARY TABLE IF NOT EXISTS " + TABLE_INDEX + " (\n" + "IND_ANNEE VARCHAR(4) not null,\n" + "IND_TRIMESTRE VARCHAR(1) not null,\n" + "IND_COMPTABLE VARCHAR(6) not null,\n" + "IND_MINISTERE VARCHAR(3) not null,\n" + "IND_LOCALE VARCHAR(4) not null,\n" + "IND_GESTION VARCHAR(3),\n" + "IND_SECTION VARCHAR(3),\n" + "IND_NATIONALE VARCHAR(6),\n" + "INDEX IX_INDEX (IND_ANNEE,IND_TRIMESTRE,IND_COMPTABLE,IND_MINISTERE,IND_LOCALE)\n" + ")";
    private static ProgressFrame progress;
    private DlgGenEdmn dlg;

    public EdmnImporter() {
    }

    public EdmnImporter(DlgGenEdmn dlg) {
        this();
        this.dlg = dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(File f, File index, File budgets, File ordos, File comptas, File output, String anneeGestion) throws Exception {
        Connection con = null;
        try {
            con = PoolManager.getInstance().getConnection();
            this.createDataBase(con);
            this.createDataBaseBudgets(con);
            this.createDataBaseOrdos(con);
            this.createDataBaseComptables(con);
            EdmnImporteurWorker eiw = new EdmnImporteurWorker(con, budgets, ordos, comptas, output, anneeGestion, this.dlg);
            File[] tabF = new File[]{f, index, budgets, ordos, comptas};
            progress = new ProgressFrame(this.dlg, eiw, tabF);
            progress.setDisplayFeedback(true);
            eiw.setProgressDlg(progress);
            eiw.setFilesToTreat(tabF);
            eiw.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"doImport", (Throwable)ex);
            new DisplayExceptionDlg((Dialog)this.dlg, (Throwable)ex);
        }
        finally {
            if (progress != null && EdmnImporter.progress.pg != null) {
                EdmnImporter.progress.pg.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBase(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SCRIPT_INDEX);
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_INDEX);
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseBudgets(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SCRIPT_BUDGET);
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_BUDGETS);
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseOrdos(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SCRIPT_ORDOS);
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_ORDOS);
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataBaseComptables(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(SCRIPTS_COMPTABLES);
            ps.execute();
            ps = con.prepareStatement("TRUNCATE TABLE " + TABLE_COMPTABLES);
            ps.execute();
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

