/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.EdmnImporter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;

public class DlgGenEdmn
extends JDialog {
    private static final long serialVersionUID = 3977304325945658517L;
    String lastDiredtory = "";
    private JButton browse_edmn;
    private JButton browse_index;
    private JButton cancel_button;
    private JTextField dfAnneeGestion;
    private JTextField dfBudgets;
    private JTextField dfComptables;
    private JTextField dfOrdos;
    private JTextField dfOutput;
    private JTextField file_edmn;
    private JTextField file_index;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JButton pbChooseBudgets;
    private JButton pbChooseComptables;
    private JButton pbChooseOrdos;
    private JButton pbChooseOutput;
    private JButton valid_button;

    public DlgGenEdmn(Frame parent, boolean modal) {
        super(parent, "G\u00e9n\u00e9rateur de flux EDMN", modal);
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        InfiniteGlassPane glassPane = new InfiniteGlassPane();
        this.setGlassPane((Component)glassPane);
        if (System.getProperty("xemelios.mysql.config.filename") == null) {
            this.browse_edmn.setVisible(false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.file_edmn = new JTextField();
        this.browse_edmn = new JButton();
        this.jLabel2 = new JLabel();
        this.file_index = new JTextField();
        this.browse_index = new JButton();
        this.cancel_button = new JButton();
        this.valid_button = new JButton();
        this.jLabel3 = new JLabel();
        this.dfBudgets = new JTextField();
        this.pbChooseBudgets = new JButton();
        this.jLabel4 = new JLabel();
        this.dfOrdos = new JTextField();
        this.pbChooseOrdos = new JButton();
        this.jLabel5 = new JLabel();
        this.dfComptables = new JTextField();
        this.pbChooseComptables = new JButton();
        this.jLabel6 = new JLabel();
        this.dfOutput = new JTextField();
        this.pbChooseOutput = new JButton();
        this.dfAnneeGestion = new JTextField();
        this.jLabel7 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Fichier EDMN");
        this.browse_edmn.setText("...");
        this.browse_edmn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.browse_edmnActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Fichier Index");
        this.browse_index.setText("...");
        this.browse_index.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.browse_indexActionPerformed(evt);
            }
        });
        this.cancel_button.setIcon(new ImageIcon(this.getClass().getResource("/fr/gouv/finances/cp/xemelios/ui/resources/deleteRow.png")));
        this.cancel_button.setText("Fermer");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.cancel_buttonActionPerformed(evt);
            }
        });
        this.valid_button.setIcon(new ImageIcon(this.getClass().getResource("/fr/gouv/finances/cp/xemelios/plugin/generatorEdmn/busy-icon0.png")));
        this.valid_button.setText("G\u00e9n\u00e9rer");
        this.valid_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.valid_buttonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Fichier Budgets");
        this.pbChooseBudgets.setText("...");
        this.pbChooseBudgets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.pbChooseBudgetsActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Fichier Ordonnateurs");
        this.pbChooseOrdos.setText("...");
        this.pbChooseOrdos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.pbChooseOrdosActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Fichier Comptables");
        this.pbChooseComptables.setText("...");
        this.pbChooseComptables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.pbChooseComptablesActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Fichier de sortie");
        this.pbChooseOutput.setText("...");
        this.pbChooseOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenEdmn.this.pbChooseOutputActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Ann\u00e9e de Gestion");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jLabel1)).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.jLabel5).add((Component)this.jLabel6).add((Component)this.jLabel7)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dfOutput, -1, 422, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pbChooseOutput)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dfComptables, -1, 422, Short.MAX_VALUE).add((Component)this.dfOrdos, -1, 422, Short.MAX_VALUE).add((Component)this.dfBudgets, -1, 422, Short.MAX_VALUE).add(2, (Component)this.file_index, -1, 422, Short.MAX_VALUE).add((Component)this.file_edmn, -1, 422, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.browse_edmn).add(2, (Component)this.browse_index)).add((Component)this.pbChooseBudgets).add((Component)this.pbChooseOrdos).add((Component)this.pbChooseComptables))).add((Component)this.dfAnneeGestion, -2, 49, -2))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cancel_button).addPreferredGap(0).add((Component)this.valid_button))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.browse_edmn).add((Component)this.file_edmn, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.browse_index).add((Component)this.jLabel2).add((Component)this.file_index, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.dfBudgets, -2, -1, -2).add((Component)this.pbChooseBudgets)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.dfOrdos, -2, -1, -2).add((Component)this.pbChooseOrdos)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.dfComptables, -2, -1, -2).add((Component)this.pbChooseComptables)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pbChooseOutput).add((Component)this.dfOutput, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dfAnneeGestion, -2, -1, -2).add((Component)this.jLabel7)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3, false).add((Component)this.valid_button).add((Component)this.cancel_button)).addContainerGap()));
        this.pack();
    }

    private void pbChooseBudgetsActionPerformed(ActionEvent evt) {
        this.chooseFile(evt, this.dfBudgets);
    }

    private void pbChooseOrdosActionPerformed(ActionEvent evt) {
        this.chooseFile(evt, this.dfOrdos);
    }

    private void pbChooseComptablesActionPerformed(ActionEvent evt) {
        this.chooseFile(evt, this.dfComptables);
    }

    private void pbChooseOutputActionPerformed(ActionEvent evt) {
        JFileChooser fc = this.lastDiredtory.length() > 0 ? new JFileChooser(this.lastDiredtory) : (System.getProperty("xemelios.edmn.directory") != null ? new JFileChooser(System.getProperty("edmn.directory")) : new JFileChooser());
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("XAR");
            }

            public String getDescription() {
                return "Archives Xemelios (.xar)";
            }
        });
        int reponse = fc.showSaveDialog(this);
        if (reponse == 0) {
            this.dfOutput.setText(fc.getSelectedFile().getAbsolutePath());
            this.lastDiredtory = fc.getSelectedFile().getParent();
        }
    }

    private void browse_edmnActionPerformed(ActionEvent evt) {
        this.chooseFile(evt, this.file_edmn);
    }

    private void chooseFile(ActionEvent evt, JTextField target) {
        JFileChooser fc = this.lastDiredtory.length() > 0 ? new JFileChooser(this.lastDiredtory) : (System.getProperty("xemelios.edmn.directory") != null ? new JFileChooser(System.getProperty("edmn.directory")) : new JFileChooser());
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("TXT");
            }

            public String getDescription() {
                return "Fichiers texte (.txt)";
            }
        });
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("DAT");
            }

            public String getDescription() {
                return "Fichiers dat (.dat)";
            }
        });
        int reponse = fc.showOpenDialog(this);
        if (reponse == 0) {
            target.setText(fc.getSelectedFile().getAbsolutePath());
            this.lastDiredtory = fc.getSelectedFile().getParent();
        }
    }

    private void browse_indexActionPerformed(ActionEvent evt) {
        this.chooseFile(evt, this.file_index);
    }

    private void cancel_buttonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void valid_buttonActionPerformed(ActionEvent evt) {
        if (!this.checkSaisie()) {
            return;
        }
        EdmnImporter edmni = new EdmnImporter(this);
        try {
            this.startVentilateur();
            edmni.importFile(new File(this.file_edmn.getText()), new File(this.file_index.getText()), new File(this.dfBudgets.getText()), new File(this.dfOrdos.getText()), new File(this.dfComptables.getText()), new File(this.dfOutput.getText()), this.dfAnneeGestion.getText());
            this.stopVentilateur();
        }
        catch (Exception e) {
            this.stopVentilateur();
            e.printStackTrace();
        }
    }

    private boolean checkSaisie() {
        ComponentError err = null;
        if (err == null) {
            err = this.checkFile(this.file_edmn, "EDMN");
        }
        if (err == null) {
            err = this.checkFile(this.file_index, "INDEX");
        }
        if (err == null) {
            err = this.checkFile(this.dfBudgets, "des budgets");
        }
        if (err == null) {
            err = this.checkFile(this.dfOrdos, "des ordonnateurs");
        }
        if (err == null) {
            err = this.checkFile(this.dfComptables, "des comptables");
        }
        if (err == null && (this.dfOutput.getText() == null || this.dfOutput.getText().length() == 0)) {
            err = new ComponentError(this.dfOutput, "Le fihchier de sortie est obligatoire");
        }
        if (err == null && (this.dfAnneeGestion.getText() == null || this.dfAnneeGestion.getText().length() < 4)) {
            err = new ComponentError(this.dfAnneeGestion, "L'ann\u00e9e de gestion est obligatoire");
        }
        if (err == null) {
            try {
                Integer.parseInt(this.dfAnneeGestion.getText());
            }
            catch (NumberFormatException nfEx) {
                err = new ComponentError(this.dfAnneeGestion, this.dfAnneeGestion.getText() + " n'est pas une ann\u00e9e valide");
            }
        }
        if (err != null) {
            JOptionPane.showMessageDialog(this, err.msg, "Erreur de saisie", 0);
            err.comp.requestFocus();
            return false;
        }
        return true;
    }

    private ComponentError checkFile(JTextField fld, String name) {
        if (fld.getText() == null || fld.getText().length() == 0) {
            return new ComponentError(fld, "Le fichier " + name + " ne peut pas \u00eatre vide");
        }
        if (!new File(fld.getText()).exists()) {
            return new ComponentError(fld, "Le fichier EDMN n'existe pas");
        }
        return null;
    }

    public void enableGenerateButton() {
        this.valid_button.setEnabled(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DlgGenEdmn dialog = new DlgGenEdmn((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void stopVentilateur() {
        this.getGlassPane().setVisible(false);
    }

    public void startVentilateur() {
        this.getGlassPane().setVisible(true);
    }

    public void run() {
        this.setVisible(true);
    }

    public void setFile_edmn(String text) {
        this.file_edmn.setText(text);
    }

    public void setFile_index(String text) {
        this.file_index.setText(text);
    }

    public void setBrowseIndexEnabled(boolean b) {
        this.browse_index.setEnabled(b);
    }

    public void setValidBouttonEnabled(boolean b) {
        this.valid_button.setEnabled(b);
    }

    private class ComponentError {
        JComponent comp;
        String msg;

        public ComponentError(JComponent comp, String msg) {
            this.comp = comp;
            this.msg = msg;
        }
    }
}

