/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIE07
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(TIE07.class);
    public static final transient String CTRL_ID = "TIE07";
    private Vector<Anomalie> anos = null;
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String ligne_nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "Piece";
    private static final String ADRESSE = "Adresse";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String tiers_CP = "";
    private String tiers_codRes = "";
    private String tiers_codPays = "";
    private String tiers_ville = "";
    private String tiers_CP_NodeId = "";
    private String tiers_ville_NodeId = "";
    private String tiers_nom = "";
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String MSG_TIERS_NOM = "#TIERS_NOM#";
    private static final String MSG_ERREUR = "#ERREUR#";
    private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
    private static final String RECETTE = "PES_RecetteAller";
    private static final String DEPENSE = "PES_DepenseAller";
    private boolean depense = false;
    private static String CHEMIN_BLOCPIECE = "";
    private static String CHEMIN_BLOCPIECE_IDPCE = "";
    private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static String CHEMIN_INFOLIGNEPIECE = "";
    private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
    private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
    private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
    private static final String CHEMIN_TIERS_NOM = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Nom/";
    private static final String CHEMIN_ADRESSE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/";
    private static final String CHEMIN_ADRESSE_CP = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CP/";
    private static final String CHEMIN_ADRESSE_CODRES = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CodRes/";
    private static final String CHEMIN_ADRESSE_CODPAYS = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CodPays/";
    private static final String CHEMIN_ADRESSE_VILLE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/Ville/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In TIE07");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.indexOf(DEPENSE) != -1) {
            this.depense = true;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.indexOf(RECETTE) != -1) {
            this.depense = false;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
            this.ligne_IdLigne = "";
            this.ligne_nodeId = "";
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
            this.ligne_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_TIERS_NOM)) {
            this.tiers_nom = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE)) {
            this.tiers_ville = "";
            this.tiers_codRes = "";
            this.tiers_codPays = "";
            this.tiers_CP = "";
            this.tiers_CP_NodeId = "";
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_CP)) {
            this.tiers_CP = atts.getValue("V");
            this.tiers_CP_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_CODPAYS)) {
            this.tiers_codPays = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_CODRES)) {
            this.tiers_codRes = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ADRESSE_VILLE)) {
            this.tiers_ville = atts.getValue("V");
            this.tiers_ville_NodeId = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (ON_RETURN_ANOMALIES.equals(localName)) {
            return this.anos;
        }
        if (ADRESSE.equals(localName)) {
            boolean err = false;
            if ("0".equals(this.tiers_codRes)) {
                err = this.tiers_CP.startsWith("02A") || this.tiers_CP.startsWith("02B") ? true : this.tiers_CP.length() != 5;
            } else if ("1".equals(this.tiers_codRes)) {
                boolean bl = err = this.tiers_codPays.equals("") || !this.tiers_codPays.matches("^[0-9]{3}$") || !this.tiers_CP.equals("99999") || this.tiers_ville.equals("");
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                msg = msg.replaceAll(MSG_TIERS_NOM, this.tiers_nom);
                msg = this.depense ? msg.replaceAll("#MT#", "Mandat") : msg.replaceAll("#MT#", "Titre");
                if ("0".equals(this.tiers_codRes)) {
                    msg = this.tiers_CP.startsWith("02A") || this.tiers_CP.startsWith("02B") ? msg.replaceAll(MSG_ERREUR, "Le code postal r\u00e9el 02AXX ou 02BXX doit \u00eatre renseign\u00e9 dans le champs Ville et le code postal doit \u00eatre valoris\u00e9 \u00e0 99999") : msg.replaceAll(MSG_ERREUR, "Code postal invalide");
                } else if ("1".equals(this.tiers_codRes)) {
                    msg = this.tiers_codPays.equals("") || !this.tiers_codPays.matches("^[0-9]{3}$") ? msg.replaceAll(MSG_ERREUR, "Code pays [NON RENSEIGNE] ou invalide") : msg.replaceAll(MSG_ERREUR, "Il faut valoriser le code postal \u00e0 99999 et renseigner le v\u00e9ritable code postal (de format \u00e9tranger) dans le champs Ville");
                }
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], this.depense ? "BordereauDepense" : "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                if ("0".equals(this.tiers_codRes)) {
                    ano.addNode(new Node(this.tiers_CP_NodeId));
                } else {
                    if (this.tiers_codPays.equals("") || this.tiers_ville.equals("") || !this.tiers_codPays.matches("^[0-9]{3}$")) {
                        ano.addNode(new Node(this.ligne_nodeId));
                    }
                    if (!this.tiers_CP.equals("99999")) {
                        ano.addNode(new Node(this.tiers_CP_NodeId));
                        ano.addNode(new Node(this.tiers_ville_NodeId));
                    }
                }
                this.anos.add(ano);
            }
            this.tiers_nom = "";
            this.tiers_ville = "";
            this.tiers_codRes = "";
            this.tiers_codPays = "";
            this.tiers_CP = "";
            this.tiers_ville_NodeId = "";
            this.tiers_CP_NodeId = "";
            return null;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

