/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N TIE06
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		Les rfrences bancaires : cl RIB, code banque, code guichet et cadrage du numro de compte 
 * 		doivent tre cohrents et valides. (Pas valoriss  " 0 ").
 *
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V. 
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V.
 * 			- on stocke BlocPiece/IdPce/@V.
 * 		3- Lorsqu'on lit un lment InfoLignePiece :
 * 			- on vide InfoLignePiece/IdLigne/@V.
 * 			- on stocke InfoLignePiece/IdLigne/@V.
 * 		4- Lorsqu'on lit un lment CpteBancaire/ :
 * 			- on vide CpteBancaire/CleRib/@V, CpteBancaire/CodeGuic/@V, CpteBancaire/CodeEtab/@V, CpteBancaire/IdCpte/@V, CpteBancaire/IdBancInt/@V
 * 			- on stocke CpteBancaire/CleRib/@V, CpteBancaire/CodeGuic/@V, CpteBancaire/CodeEtab/@V, CpteBancaire/IdCpte/@V, CpteBancaire/IdBancInt/@V
 * 		5- Lorsqu'on lit la fin de l'lement CpteBancaire/ :
 * 			- on vrifie que CodeGuic, CodeEtab, IdCpte et IdBancInt sont renseigns et ne valent pas que des 0 ou des 9.
 * 			- on vrifie que la CleRib est correcte.
 */
public class TIE06 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(TIE06.class);
	public static final transient String CTRL_ID = "TIE06";
	private Vector<Anomalie> anos = null;
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	
	private String nodeId = null;
	
	private static final String ON_RETURN_ANOMALIES = "Piece";
	
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String idBancInt = "";
	private String idCpte = "";
	private String codeEtab = "";
	private String codeGuic = "";
	private String cleRib = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	private static final String MSG_CPTE_IDBANCINT = "#CPTE_IDBANCINT#";
	private static final String MSG_CPTE_IDCPTE = "#CPTE_IDCPTE#";
	private static final String MSG_CPTE_CODEETAB = "#CPTE_CODEETAB#";
	private static final String MSG_CPTE_CODEGUIC = "#CPTE_CODEGUIC#";
	private static final String MSG_CPTE_CLERIB = "#CPTE_CLERIB#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses et les Recettes
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
	
	/**
	 * Selon que l'on est en RECETTE ou DEPENSE, le xpath est diffrent
	 */
	private static final String RECETTE = "PES_RecetteAller";
	private static final String DEPENSE = "PES_DepenseAller";
	private boolean depense = false;

	private static String CHEMIN_BLOCPIECE = "";
	private static String CHEMIN_BLOCPIECE_IDPCE = "";
	private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	
	private static String CHEMIN_INFOLIGNEPIECE = "";
	private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
	private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
	private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";

	private static final String CHEMIN_COMPTE = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/";
	private static final String CHEMIN_COMPTE_IDBANCINT = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/IdBancInt/";
	private static final String CHEMIN_COMPTE_IDCPTE = 	  "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/IdCpte/";
	private static final String CHEMIN_COMPTE_CODEETAB = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CodeEtab/";
	private static final String CHEMIN_COMPTE_CODEGUIC = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CodeGuic/";
	private static final String CHEMIN_COMPTE_CLERIB = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CleRib/";
	
	/**
	 * La fin de l'lment COMPTEBANCAIRE
	 */
	private static final String FIN_CPTE = "CpteBancaire";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 0
		// RECETTE ou DEPENSE
		if (xpath.indexOf(DEPENSE)!=-1) {
			depense = true;
			CHEMIN_BLOCPIECE = D_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		if (xpath.indexOf(RECETTE)!=-1) {
			depense = false;
			CHEMIN_BLOCPIECE = R_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		
		// 4
		if (xpath.endsWith(CHEMIN_COMPTE)) {
			idBancInt = idCpte = codeEtab = codeGuic = cleRib = "";
			nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_COMPTE_IDBANCINT)) {
			idBancInt = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_COMPTE_IDCPTE)) {
			idCpte = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_COMPTE_CODEETAB)) {
			codeEtab = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_COMPTE_CODEGUIC)) {
			codeGuic = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_COMPTE_CLERIB)) {
			cleRib = atts.getValue("V");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(ON_RETURN_ANOMALIES.equals(localName)){
			return anos;
		} else if (FIN_CPTE.equals(localName)) {
		// 5
			boolean err = false;
			String search0 = "^[0][0]*$";
			String search9 = "^[9][9]*$";
			StringBuffer sb = new StringBuffer();
			
			if (idBancInt!=null) {
				sb.append (idBancInt);
			}
			if (idCpte!=null) {
				sb.append (idCpte);
			}
			if (codeEtab!=null) {
				sb.append (codeEtab);
			}
			if (codeGuic!=null) {
				sb.append (codeGuic);
			}
			if (sb.toString().matches(search0) || sb.toString().matches(search9)) {
				err = true;
			}
			// vrification de la cohrence de la cle rib
			if (!err) {
				try { err = !validateRib (codeEtab, codeGuic, idCpte, cleRib); }
				catch (Exception e) {err = true; }
			}

			if (err) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				msg = msg.replaceAll(MSG_CPTE_IDBANCINT, idBancInt);
				msg = msg.replaceAll(MSG_CPTE_IDCPTE, idCpte);
				msg = msg.replaceAll(MSG_CPTE_CODEETAB, codeEtab);
				msg = msg.replaceAll(MSG_CPTE_CODEGUIC, codeGuic);
				msg = msg.replaceAll(MSG_CPTE_CLERIB, cleRib);
				if (depense) {
					msg = msg.replaceAll("#MT#", "Mandat");
				} else {
					msg = msg.replaceAll("#MT#", "Titre");
				}
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        (depense?BORDEREAU_DEPENSE:BORDEREAU_RECETTE), // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg,
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path,
                                        xslParams);
				ano.addNode(new Node(nodeId));
				anos.add(ano);
			}
			return null;
		} else {
			return null;
		}
	}
	
	public boolean validateRib (String codeEtab, String codeGuich, String idCpte, String cleRib) {
		boolean ret = false;
		
		// conversion du numro de compte en chiffres
		String tabPossibles = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		char []tabTranscrit = "123456789123456789234567890123456789".toCharArray();
		
		String compte = "";
		idCpte = idCpte.toUpperCase();
		for (int i=0; i<idCpte.length(); i++) {
			compte += tabTranscrit[tabPossibles.indexOf(idCpte.charAt(i))];
		}
		
		// calcul de la celf rib du compte
		double bqe = Double.parseDouble(codeEtab);
		double gui = Double.parseDouble(codeGuich);
		double cp  = Double.parseDouble(compte);
		double a=bqe%97;
		a=a*100000+gui;
		a=a%97;
		a=a*Math.pow(10, 11) + cp;
		a=a%97;
		a=a*100;
		a=a%97;
		a=97-a;
		
		// la clef est elle la mme que celle passe ?
		double cr = Double.parseDouble(cleRib);
		ret = (cr == a);
		
		return ret;
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
	
/*	public static void main (String[] args) {
		TIE06 t = new TIE06();
		boolean ret = t.validateRib("20041", "01012", "4742224G033", "35");
	}
*/	
}
