/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N TIE04
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		La catgorie juridique du tiers, doit tre cohrente avec la nature juridique du tiers.
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V. 
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V.
 * 			- on stocke BlocPiece/IdPce/@V.
 * 		3- Lorsqu'on lit un lment InfoLignePiece :
 * 			- on vide InfoLignePiece/IdLigne/@V.
 * 			- on stocke InfoLignePiece/IdLigne/@V.
 * 		4- Lorsqu'on lit un lment InfoTiers/ :
 * 			- on lit InfoTiers/CatTiers/@V et InfoTiers/NatJur/@V.
 * 		5- Lorsqu'on lit une fin d'lement InfoTiers : 
 * 			- on vrifie la cohrence CatTiers / NatJur parmis la liste des couples autoriss.
 */
public class TIE04 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(TIE04.class);
    public static final transient String CTRL_ID = "TIE04";
	private Vector<Anomalie> anos = null;
	private Hashtable<String,Object> hParams;
	
	/**
	 * la liste des couple CatTiers/NatJur valides
	 */
	private static Vector<String> listeValide = new Vector<String>();
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;
	
	/**
	 * La chaine cible
	 */
	private static final String ON_RETURN_ANOMALIES = "Piece";
	private static final String INFO_TIERS = "InfoTiers";
	
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String tiers_cattiers = "";
	private String tiers_natjur = "";
	private String node_id_tiers_cattiers = "";
	private String node_id_tiers_natjur = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	private static final String MSG_TIERS_CATTIERS = "#TIERS_CATTIERS#";
	private static final String MSG_TIERS_NATJUR = "#TIERS_NATJUR#";
	
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses et les Recettes
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
	
	/**
	 * Selon que l'on est en RECETTE ou DEPENSE, le xpath est diffrent
	 */
	private static final String RECETTE = "PES_RecetteAller";
	private static final String DEPENSE = "PES_DepenseAller";
	private boolean depense = false;
	
	private static final String CHEMIN_PIECE = "/Bordereau/Piece/";
	private static String CHEMIN_BLOCPIECE = "";
	private static String CHEMIN_BLOCPIECE_IDPCE = "";
	private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	
	private static String CHEMIN_INFOLIGNEPIECE = "";
	private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
	private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
	private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
	
	private static final String CHEMIN_INFOTIERS = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/";
	private static final String CHEMIN_INFOTIERS_CATTIERS = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/CatTiers/";
	private static final String CHEMIN_INFOTIERS_NATJUR = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/NatJur/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
		
		// constitution de la liste des couples CatTiers/NatJur valides
		listeValide.add(new String("01/01"));listeValide.add(new String("01/02"));
		listeValide.add(new String("20/07"));listeValide.add(new String("20/08"));
		listeValide.add(new String("21/09"));
		listeValide.add(new String("22/09"));
		listeValide.add(new String("23/09"));
		listeValide.add(new String("24/09"));
		listeValide.add(new String("25/09"));
		listeValide.add(new String("26/09"));
		listeValide.add(new String("27/09"));
		listeValide.add(new String("28/08"));
		listeValide.add(new String("29/10"));
		listeValide.add(new String("74/04"));
		listeValide.add(new String("50/03"));listeValide.add(new String("50/06"));
		listeValide.add(new String("60/04"));
		listeValide.add(new String("61/04"));
		listeValide.add(new String("62/04"));
		listeValide.add(new String("63/04"));listeValide.add(new String("63/11"));
		listeValide.add(new String("64/04"));
		listeValide.add(new String("65/04"));listeValide.add(new String("65/05"));
		listeValide.add(new String("70/05"));
		listeValide.add(new String("71/05"));
		listeValide.add(new String("72/04"));
		listeValide.add(new String("73/05"));
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 0
		// RECETTE ou DEPENSE
		if (xpath.indexOf(DEPENSE)!=-1) {
			depense = true;
			CHEMIN_BLOCPIECE = D_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		if (xpath.indexOf(RECETTE)!=-1) {
			depense = false;
			CHEMIN_BLOCPIECE = R_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		
		// 4
		if (xpath.endsWith(CHEMIN_INFOTIERS)) {
			tiers_cattiers = tiers_natjur = "";
			nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_CATTIERS)) {
			tiers_cattiers = atts.getValue("V");
			node_id_tiers_cattiers = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_NATJUR)) {
			tiers_natjur = atts.getValue("V");
			node_id_tiers_natjur = atts.getValue("ano:node-id");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(ON_RETURN_ANOMALIES.equals(localName)){
			return anos;
		} else if (INFO_TIERS.equals(localName)) {
			// 5
				boolean err = !listeValide.contains(tiers_cattiers+"/"+tiers_natjur);

				if (err) {
					String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
					msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
					msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
					msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
					msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
					msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
					msg = msg.replaceAll(MSG_TIERS_NATJUR, tiers_natjur);
					msg = msg.replaceAll(MSG_TIERS_CATTIERS, tiers_cattiers);
					if (depense) {
						msg = msg.replaceAll("#MT#", "Mandat");
					} else {
						msg = msg.replaceAll("#MT#", "Titre");
					}
					String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId", "");
					xslParams.put("mandatId", piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
                                                getDocumentModel().getControlById(CTRL_ID).getId(),
                                                getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                getDocumentModel().getDocumentId(),
                                                xpath.split("/")[1],
                                                (depense?BORDEREAU_DEPENSE:BORDEREAU_RECETTE), // lment importable
                                                bord_IdBord, // id lment importable
                                                localName,
                                                libelleLien,
                                                msg,
                                                getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                path,
                                                xslParams);
					ano.addNode(new Node(node_id_tiers_cattiers));
					ano.addNode(new Node(node_id_tiers_natjur));
					anos.add(ano);
				}
				return null;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
