/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC17
 *
 * Contrle de la collectivit sur la TVA
 * 
 * Le montant de la TVA ne doit tre indiqu que si le budget collectivit et / ou le service grent la TVA. 
 * Si la TVA est mentionne alors que la TVA est gre par un service, le service doit tre indiqu.
 * 
 * Pour chaque titre tel que TypPce est diffrent de 03, 04 et 14, et  NatPce diffrent de 04 :
 * Si Piece/BlocPiece/CodServ est renseign :
 * 1) Si PAR2 contient CodServ, il faut que les MtTVA de toutes ses lignes soient renseigns.
 * 2) Si PAR2 ne contient pas CodServ, il faut que les MtTVA de toutes ses lignes ne soient pas renseigns.
 * Si Piece/BlocPiece/CodServ n'est pas renseign :
 * Erreur NON BLOQUANT.
 * 3) Si PAR1=oui (collectivit assujettie  TVA), il faut que les MtTVA de toutes ses lignes soient renseigns.
 * 4) Si PAR1=non (collectivit assujettie  TVA), il faut que les MtTVA de toutes ses lignes ne soient pas renseigns.
 * 
 */
public class REC17 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC17.class);
    public static final transient String CTRL_ID="REC17";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * Liste des nodes des lignes ayant une TVA 
	 */
	private Vector<Node> nodesHasTVA = new Vector<Node>();
	/**
	 * Liste des nodes des lignes n'ayant pas de TVA 
	 */
	private Vector<Node> nodesHasNoTVA = new Vector<Node>();
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String piece_nodeId = null;
	
	/**
	 * Severit
	 */
	private static final String BLOQUANT = "BLOQUANT";
	private static final String NON_BLOQUANT = "NON BLOQUANT";

	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
	private static final String ON_RETURN_ANOMALIES = FIN_BORDEREAU;
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String FIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String FIN_INFO_LIGNE_PIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String piece_CodServ = "";
	private String piece_typPce = "";
	private String piece_natPce = "";
	private boolean allLinesHasTVAFilled = true;
	private boolean lineHasTVA = false;
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_CODSERV = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/CodServ/";
	private static final String CHEMIN_BLOCPIECE_TYPPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	private static final String CHEMIN_BLOCPIECE_NATPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
														 
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = piece_CodServ = piece_natPce = piece_typPce = "";
			lineHasTVA = false;
			allLinesHasTVAFilled = true;
			nodesHasNoTVA.clear();
			nodesHasTVA.clear();
			piece_nodeId = atts.getValue("ano:node-id");
			anos.clear();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_CODSERV)) {
			piece_CodServ = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPCE)) {
			piece_natPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPCE)) {
			piece_typPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTTVA)) {
			String ligne_Mttva = atts.getValue("V");
			if (ligne_Mttva != null && !"".equals(ligne_Mttva)) {
			{
				lineHasTVA = true;
				nodesHasTVA.add(new Node(atts.getValue("ano:node-id")));
			}
			} else {
				lineHasTVA = false;
				nodesHasNoTVA.add(new Node(atts.getValue("ano:node-id")));
			}
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if (xpath.endsWith(FIN_INFO_LIGNE_PIECE)){
			allLinesHasTVAFilled &= lineHasTVA;
			return null;
		} else if (xpath.endsWith(FIN_PIECE)){
			
			if ("03".equals(piece_typPce) || "04".equals(piece_typPce) || "14".equals(piece_typPce) || "04".equals(piece_natPce)) {
				return null;
			}
			
			String severity = BLOQUANT;
			boolean err = false;
			Vector<Node> anonodes = new Vector<Node>();
			try {
				String[]servTVA = (String[])hParams.get("servTVA");
				boolean coltva = ((Boolean)hParams.get("coltva")).booleanValue();
				if (piece_CodServ!=null && !"".equals(piece_CodServ)) {
					severity = BLOQUANT;
					if (contains (servTVA, piece_CodServ)) {
						err = !allLinesHasTVAFilled;
						anonodes = nodesHasNoTVA;
					}
					else {
						err = allLinesHasTVAFilled;
						anonodes = nodesHasTVA;
					}
				} else {
					severity = NON_BLOQUANT;
					if (coltva) {
						err = !allLinesHasTVAFilled;
						anonodes = nodesHasNoTVA;
					}
					else {
						err = allLinesHasTVAFilled;
						anonodes = nodesHasTVA;
					}					
				}
			} catch (Exception e) { err = true; }
			
			if (err) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);

				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                                getDocumentModel().getControlById(CTRL_ID).getId(),
                                                getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                getDocumentModel().getDocumentId(),
                                                xpath.split("/")[1],
                                                BORDEREAU_RECETTE, // lment importable
                                                bord_IdBord, // id lment importable
                                                localName,
                                                libelleLien,
                                                msg,
                                                getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                severity,
                                                path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addAll(anonodes);
				anos.add(ano);
				return anos;
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	
	private boolean contains (String[]tab, String val) {
		for (String el:tab) {
			if (el.equals(val)) return true;
		}
		return false;
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
