/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC09
 * 
 * Contrle de l'existence de l'objet de la recette
 * 
 * L'objet de la recette devrait tre renseign
 * 
 * Piece/ BlocPiece/ ObjPce[@V] doit tre valoris (non null et non gal  "")
 * 
 */
public class REC09 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC09.class);
    public static final transient String CTRL_ID="REC09";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;

	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String FIN_INFOPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;
	

	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_Objet = "";
	private String piece_NodeIdPce = "";
	private String obj_nodeId = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";

	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_OBJET = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/ObjPce/";


	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_ExerBord = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		if (xpath.endsWith(CHEMIN_PIECE)) {
			anos = new Vector<Anomalie>();
			piece_IdPce = piece_Objet = piece_NodeIdPce = "";
			piece_NodeIdPce = atts.getValue("ano:node-id");
			obj_nodeId = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_OBJET)) {
			piece_Objet = atts.getValue("V");
			obj_nodeId = atts.getValue("ano:node-id");
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			Vector<Node> anonodes = new Vector<Node>();
			boolean err = false;
			if (piece_Objet==null || "".equals(piece_Objet)) {
				err = true;
				if (obj_nodeId!=null && !"".equals(obj_nodeId)) {
					anonodes.add (new Node(obj_nodeId));
				} else {
					anonodes.add (new Node(piece_NodeIdPce));
				}
			}
			if (err) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addAll(anonodes);
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
