/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC04
 * 
 * Contrle du cumul des montants du bordereau
 * 
 * Le montant total, HT et TVA, du bordereau de mandats doit tre gal  la somme des montants des mandats, HT et TVA.
 * 
 * Pour chaque bordereau vrifier que BlocBordereau/MtBordHt[@V] = somme des Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT[@V]
 * 
 * Pour chaque bordereau vrifier que BlocBordereau/MtBordTVA[@V] = somme des Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA[@V] 
 * 
 */
public class REC04 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC04.class);
	public static final transient String CTRL_ID = "REC04";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private ArrayList<Node> nodesId = new ArrayList<Node>();

	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
	private static final String ON_RETURN_ANOMALIES = FIN_BORDEREAU;
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_ExerBord = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String bord_MtBordHT = "";
	private String bord_MtBordHT_nodeid = "";
	private String bord_MtBordTVA = "";
	private String bord_MtBordTVA_nodeid = "";
	private String pieces_TotalHT = "";
	private String pieces_TotalTVA = "";
	private Vector<String> pieces_TotalHT_nodesid = new Vector<String>();
	private Vector<String> pieces_TotalTVA_nodesid = new Vector<String>();

	private static DecimalFormat df = new DecimalFormat("############0.##");
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPEBORD = "#BORD_TYPBORD#";
	private static final String MSG_BORD_MNT = "#MT_BORD#";
	private static final String MSG_PIECE_TOTAL = "#MT_LIGNES#";
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCBORDEREAU_MTHTBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/MtBordHt/";
	private static final String CHEMIN_PIECE_MTHT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT/";
	private static final String CHEMIN_BLOCBORDEREAU_MTTVABORD = "/PES_RecetteAller/Bordereau/BlocBordereau/MtBordTVA/";
	private static final String CHEMIN_PIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";

	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_ExerBord = bord_IdBord = bord_MtBordHT = bord_MtBordHT_nodeid = bord_MtBordTVA = bord_MtBordTVA_nodeid = bord_TypBord = pieces_TotalHT = pieces_TotalTVA = "";
			anos = new Vector<Anomalie>();
			pieces_TotalHT_nodesid = new Vector<String>();
			pieces_TotalTVA_nodesid = new Vector<String>();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTBORD)) {
			bord_MtBordHT = atts.getValue("V");
			bord_MtBordHT_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVABORD)) {
			bord_MtBordTVA = atts.getValue("V");
			bord_MtBordTVA_nodeid = atts.getValue("ano:node-id");
		}
		
		if (xpath.endsWith(CHEMIN_PIECE_MTHT)) {
			pieces_TotalHT_nodesid.add(atts.getValue("ano:node-id"));
			try {
				BigDecimal tmp = new BigDecimal ((pieces_TotalHT.equals("")?"0.0":pieces_TotalHT));
				tmp = tmp.add(new BigDecimal (atts.getValue("V")));
				pieces_TotalHT = tmp.toString();
			} catch (Exception e) {
				
			}
		}
		if (xpath.endsWith(CHEMIN_PIECE_MTTVA)) {
			pieces_TotalTVA_nodesid.add(atts.getValue("ano:node-id"));
			try {
				BigDecimal tmp = new BigDecimal ((pieces_TotalTVA.equals("")?"0.0":pieces_TotalTVA));
				tmp = tmp.add(new BigDecimal (atts.getValue("V")));
				pieces_TotalTVA = tmp.toString();
			} catch (Exception e) {
				
			}
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			/**
			 * HT
			 */
			try {
				if (bord_MtBordHT!=null && !"".equals(bord_MtBordHT)) {
					BigDecimal totalBordHT = new BigDecimal ((bord_MtBordHT.equals("")?"0.0":bord_MtBordHT));
					BigDecimal totalPieceHT = new BigDecimal ((pieces_TotalHT.equals("")?"0.0":pieces_TotalHT));
					if (totalBordHT.compareTo(totalPieceHT)!=0) {
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
						msg = msg.replaceAll(MSG_BORD_TYPEBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_BORD_MNT, " - MtBordHT= "+df.format(totalBordHT));
						msg = msg.replaceAll(MSG_PIECE_TOTAL, " - MtHT= "+df.format(totalPieceHT));
						String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "Bordereau");
						xslParams.put("mandatId", "");
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
                                                            getDocumentModel().getControlById(CTRL_ID).getId(),
                                                            getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                            getDocumentModel().getDocumentId(),
                                                            xpath.split("/")[1],
                                                            BORDEREAU_RECETTE, // lment importable
                                                            bord_IdBord, // id lment importable
                                                            localName,
                                                            libelleLien,
                                                            msg,
                                                            getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                            getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                            path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                            xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addNode(new Node(bord_MtBordHT_nodeid));
						for (String node:pieces_TotalHT_nodesid) {
							ano.addNode(new Node(node));
						}
						anos.add(ano);					
					}
				}
			} catch (Exception e) {
				
			}
			/**
			 * TVA
			 */
			try {
				if (bord_MtBordTVA != null && !"".equals(bord_MtBordTVA)) {
					BigDecimal totalBordTVA = new BigDecimal ((bord_MtBordTVA.equals("")?"0.0":bord_MtBordTVA));
					BigDecimal totalPieceTVA = new BigDecimal ((pieces_TotalTVA.equals("")?"0.0":pieces_TotalTVA));
					if (totalBordTVA.compareTo(totalPieceTVA)!=0) {
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
						msg = msg.replaceAll(MSG_BORD_TYPEBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_BORD_MNT, " - MtBordTVA= "+df.format(totalBordTVA));
						msg = msg.replaceAll(MSG_PIECE_TOTAL, " - MtTVA= "+df.format(totalPieceTVA));
						String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "Bordereau");
						xslParams.put("mandatId", "");
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
                                                            getDocumentModel().getControlById(CTRL_ID).getId(),
                                                            getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                            getDocumentModel().getDocumentId(),
                                                            xpath.split("/")[1],
                                                            BORDEREAU_RECETTE, // lment importable
                                                            bord_IdBord, // id lment importable
                                                            localName,
                                                            libelleLien,
                                                            msg,
                                                            getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                            getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                            path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                            xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addNode(new Node(bord_MtBordTVA_nodeid));
						for (String node:pieces_TotalTVA_nodesid) {
							ano.addNode(new Node(node));
						}
						anos.add(ano);					
					}
				}
			} catch (Exception e) {
				
			}
			
			
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
