/*
 * Copyright
 *   2007 axYus - www.axyus.com
 *   2007 JP.Tessier - jean-philippe.tessier@axyus.com
 *
 * This file is part of XEMELIOS.
 *
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.utils.Luhn;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/*
 * Implmente le contrle N DEP22
 * 
 * Contrle sur la prsence de la balise IdColl
 * 
 */
public class DEP22 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP22.class);
    public static final transient String CTRL_ID = "DEP22";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
		
	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_DepenseAller/";
	private static final String ON_RETURN_ANOMALIES = FIN_BORDEREAU;
	
	
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	
	private String IdColl = "";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_PESDEPENSEALLER = "/PES_DepenseAller/";
	private static final String CHEMIN_IDCOLL = "/EnTetePES/IdColl/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_PESDEPENSEALLER)) {
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_IDCOLL)) {
			IdColl = atts.getValue("V");
			logger.debug(CTRL_ID+" : IdColl="+IdColl);
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			if(!(hParams.get("nomencl").equals("M21")) && !Luhn.testLuhnString(IdColl)) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent().replaceAll("#ID_COLL#","n'est pas bon. "+IdColl!=null?"Il ne correspond pas un un SIRET/SIREN valide":"Il n'existe pas dans le flux analys"+".");
				String anoId = IdGenerator.nextId();
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    null, // lment importable
                                    null, // id lment importable
                                    null,
                                    null,
                                    msg,
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    null, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    null); // paramtres supplmentaires pour accder  l'lment en anomalie
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
	
}
