/*
 * Implmente le contrle N DEP20
 * 
 * Contrles spcifiques aux HLM
 * 
 * L'information TVA HLM est obligatoire
 * 
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

public class DEP20 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP20.class);
	public static final transient String CTRL_ID = "DEP20";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;

	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_DepenseAller/Bordereau/Piece/";
	private static final String LIGNEPCE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;


	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_TypPce = "";
	private String piece_NodeIdPce = "";
	private String lignepiece_Id = "";
	private String lignepiece_TypPce_NodeId = "";
	private String lignepiece_InfoTVAHLM  = "";
	private String lignepiece_InfoTVAHLM_NodeId = "";

	private Vector<String> vLigneId = new Vector<String>();

	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNEPIECE_ID = "#LIGNE_IDLIGNE#";
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_PIECE = "/PES_DepenseAller/Bordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
	private static final String CHEMIN_BLOCLIGNEPIECE_ID = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
	private static final String CHEMIN_BLOCLIGNEPIECE_CATTIERS  = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/CatTiers/";
	private static final String CHEMIN_BLOCLIGNEPIECE_NATJUR  = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/NatJur/";
	private static final String CHEMIN_BLOCLIGNEPIECE_INFOTVAHLM  = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoTVAHLM/";

	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)){
			piece_IdPce = atts.getValue("V");
			anos.clear();
			vLigneId.clear();
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_INFOTVAHLM)){
			lignepiece_InfoTVAHLM= "OK";
			lignepiece_InfoTVAHLM_NodeId = atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)){
			piece_TypPce = atts.getValue("V");
			lignepiece_TypPce_NodeId = atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_ID)){
			lignepiece_Id = atts.getValue("V");
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(LIGNEPCE)){
			if(lignepiece_InfoTVAHLM.equals("") && hParams.get("nomencl").equals("M31")){
				vLigneId.add(lignepiece_Id);
			}
			lignepiece_InfoTVAHLM = "";
			return null;
		}else if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			for(String ligneId:vLigneId){		
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNEPIECE_ID, ligneId);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId",piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_DEPENSE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}

	private class Triplet{
		private String lignePceId;private String severity;
		private Vector<String> v = new Vector<String>();
		private Triplet (String idligne,String sev,Vector<String> nodes){
			this.lignePceId = idligne;
			this.severity = sev;
			this.v = nodes;
		}
	}
}
