/*
 * Implmente le contrle N DEP10
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		Les informations DGP doivent tre valides: date de dpart, dure et  date de fin du dlai.
 *		La dure ne peut tre suprieure au dlai fix par la rglementation (PAR1 jours).
 *		La date de fin du dlai doit tre suprieure ou gale  la date de dbut augmente de la dure du dlai. 
 *
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V.
 * 			- on stocke BlocPiece/IdPce/@V.
 * 		3- Lorsqu'on lit un lment DGP :
 * 			- on vide DGP/DteDebDgp/@V, DGP/DteFinDgp/@V, DGP/DureeDgp/@V.
 * 			- on stocke DGP/DteDebDgp/@V, DGP/DteFinDgp/@V, DGP/DureeDgp/@V.
 * 		4- Lorsqu'on lit une fin d'lment DGP :
 * 			- on vrifie que DGP/DureeDgp/@V <= 45.
 * 			- on vrifie que DGP/DteDebDgp/@V + DGP/DureeDgp/@V <= DGP/DteFinDgp/@V.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

public class DEP10 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP10.class);
	public static final transient String CTRL_ID = "DEP10";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String ligne_nodeId = null;
	
	/**
	 * La chaine cible
	 */
	private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/Piece/";
	private static final String FIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private boolean dgp_present = false;
	private String dgp_DteDeb = "";
	private String dgp_DteFin = "";
	private String dgp_Duree = "";
	private String dgp_DteDeb_nodeid = "";
	private String dgp_DteFin_nodeid = "";
	private String dgp_Duree_nodeid = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_DGP_DEB = "#DGP_DEB#";
	private static final String MSG_DGP_FIN = "#DGP_FIN#";
	private static final String MSG_DGP_DUREE = "#DGP_DUREE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
														 
	private static final String CHEMIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
	private static final String CHEMIN_DGP_DTEDEB = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DteDebDgp/";
	private static final String CHEMIN_DGP_DTEFIN = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DteFinDgp/";
	private static final String CHEMIN_DGP_DUREE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DureeDgp/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			dgp_present = false;
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_DGP)) {
			dgp_DteDeb = dgp_DteFin = dgp_Duree = "";
			ligne_nodeId = atts.getValue("ano:node-id");
			dgp_present = true;
		}
		if (xpath.endsWith(CHEMIN_DGP_DTEDEB)) {
			dgp_DteDeb = atts.getValue("V");
			dgp_DteDeb_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_DGP_DTEFIN)) {
			dgp_DteFin = atts.getValue("V");
			dgp_DteFin_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_DGP_DUREE)) {
			dgp_Duree = atts.getValue("V");
			dgp_Duree_nodeid = atts.getValue("ano:node-id");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			return anos;
		} else if (xpath.endsWith(FIN_DGP)){
			if (dgp_present) {
				boolean err = false;
				Vector<Node> anonodes = new Vector<Node>();
				int dureeMax = 45;
				if (hParams.get("dureedgp")!=null) 
					dureeMax = ((Integer)hParams.get("dureedgp")).intValue();
				int duree = 0;
				Date dateDeb = null, dateFin = null;
				if (dgp_Duree!=null && !"".equals(dgp_Duree)) {
					duree = Integer.parseInt(dgp_Duree);
				}
				if (duree > dureeMax) {err = true; anonodes.add(new Node(dgp_Duree_nodeid));}
				
				if (dgp_DteDeb!=null && !"".equals(dgp_DteDeb)) {
					try { dateDeb = sdf.parse(dgp_DteDeb); } catch (Exception e) { dateDeb = null; err = true; anonodes.add(new Node(dgp_DteDeb_nodeid));}
				}
				if (dgp_DteFin!=null && !"".equals(dgp_DteFin)) {
					try { dateFin = sdf.parse(dgp_DteFin); } catch (Exception e) { dateFin = null; err = true; anonodes.add(new Node(dgp_DteFin_nodeid));}
				}
				
				Calendar c = Calendar.getInstance();
				c.setTime(dateDeb);
				c.add(Calendar.DATE, duree);
				
				if (dateFin.getTime()<c.getTime().getTime()) {
					err = true;
					anonodes.add(new Node(dgp_DteDeb_nodeid));
					anonodes.add(new Node(dgp_DteFin_nodeid));
				}
				
				if (err) {
					String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(); 
					msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
					msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
					msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
					msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
					msg = msg.replaceAll(MSG_DGP_DEB, dgp_DteDeb);
					msg = msg.replaceAll(MSG_DGP_FIN, dgp_DteFin);
					msg = msg.replaceAll(MSG_DGP_DUREE, dgp_Duree);
					
					String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId","");
					xslParams.put("mandatId", piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
												getDocumentModel().getControlById(CTRL_ID).getId(),
												getDocumentModel().getControlById(CTRL_ID).getLibelle(),
												getDocumentModel().getDocumentId(),
												xpath.split("/")[1],
												BORDEREAU_DEPENSE, // lment importable
												bord_IdBord, // id lment importable
												localName,
												libelleLien,
												msg,
												getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent().replaceAll("#NB_JOURS#",hParams.get("dureedgp").toString()),
												getDocumentModel().getControlById(CTRL_ID).getSeverity(),
												path, // xpath vers le bordereau sous lequel se trouve l'anomalie
												xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
					ano.addAll(anonodes);
					anos.add(ano);
				}
			}
			return null;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
