/*
 * Implmente le contrle N DEP06
 * 
 * Contrle de cohrence entre le type de bordereau et les couples (type, nature)
 * 
 * Le triplet Type de bordereau / Nature du mandat / Type du mandat doit tre cohrent
 * 
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

public class DEP06 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP06.class);
	public static final transient String CTRL_ID = "DEP06";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;

	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
	private static final String FIN_INFOPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/";
	private static final String ON_RETURN_ANOMALIES = FIN_BORDEREAU;


	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_NatPce = "";
	private String piece_TypPce = "";
	private String piece_NodeIdPce = "";
	
	private String piece_NodeIdNatPce = "";
	private String piece_NodeIdTypPce = "";
	private String bord_NodeIdTypBord = "";
	
	private Vector<Node> vNodeId = new Vector<Node>();

	private Vector<String> listePossible = new Vector<String>();

	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_PIECE_TYP = "#PIECE_TYPPCE#";
	private static final String MSG_PIECE_NAT = "#PIECE_NATPCE#";

	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
	private static final String CHEMIN_BLOCBORDEREAU_NATPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/NatPce/";

	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);

		// 59 cls possibles
		//listePossible.add( NaturePce , TypePce , TypeBoredereau );
		// 01
		listePossible.add("01/01/01");listePossible.add("01/03/01");listePossible.add("01/04/01");listePossible.add("01/05/01");
		listePossible.add("01/06/01");listePossible.add("01/07/01");listePossible.add("01/08/01");listePossible.add("01/09/01");
		listePossible.add("01/10/01");listePossible.add("01/11/03");listePossible.add("01/13/01");
		// 02
		listePossible.add("02/01/01");listePossible.add("02/03/01");listePossible.add("02/04/01");listePossible.add("02/05/01");
		listePossible.add("02/08/01");listePossible.add("02/09/01");listePossible.add("02/10/01");listePossible.add("02/11/03");
		// 03
		listePossible.add("03/01/01");listePossible.add("03/03/01");listePossible.add("03/04/01");listePossible.add("03/05/01");
		listePossible.add("03/10/01");
		// 04
		listePossible.add("04/01/01");listePossible.add("01/03/01");listePossible.add("04/04/01");listePossible.add("04/05/01");
		listePossible.add("04/06/01");listePossible.add("01/10/01");
		// 05
		listePossible.add("05/01/01");listePossible.add("05/05/01");listePossible.add("05/10/01");
		// 06
		listePossible.add("06/02/02");listePossible.add("06/04/02");listePossible.add("06/13/02");
		// 07
		listePossible.add("07/02/01");listePossible.add("07/05/01");
		// 08
		listePossible.add("08/02/01");
		// 09
		listePossible.add("09/02/01");
		// 10
		listePossible.add("10/02/02");
		// 11
		listePossible.add("11/01/01");listePossible.add("11/08/01");listePossible.add("11/10/01");
		// 12
		listePossible.add("12/09/01");
		// 13
		listePossible.add("13/09/01");
		// 18
		listePossible.add("18/03/01");
		// 14
		listePossible.add("14/09/01");listePossible.add("14/11/03");
		// 15
//FA 68 - on supprime les NatPce=15
//		listePossible.add("15/01/01");listePossible.add("15/03/01");listePossible.add("15/04/01");listePossible.add("15/05/01");
//		listePossible.add("15/06/01");listePossible.add("15/07/01");listePossible.add("15/08/01");listePossible.add("15/09/01");
//		listePossible.add("15/10/01");listePossible.add("15/11/03");
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			//anos = new Vector<Anomalie>();
			anos.clear();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
			bord_NodeIdTypBord = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
			piece_IdPce = atts.getValue("V");
			piece_NodeIdPce = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPPCE)) {
			piece_TypPce = atts.getValue("V");
			piece_NodeIdTypPce = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_NATPCE)) {
			piece_NatPce = atts.getValue("V");
			piece_NodeIdNatPce = atts.getValue("ano:node-id");
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(FIN_INFOPCE)){
			if(!(listePossible.contains(piece_NatPce+"/"+piece_TypPce+"/"+bord_TypBord))){
						
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_PIECE_TYP, piece_TypPce);
				msg = msg.replaceAll(MSG_PIECE_NAT, piece_NatPce);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","Bordereau");
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_DEPENSE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_NodeIdNatPce));
				ano.addNode(new Node(piece_NodeIdTypPce));
				ano.addNode(new Node(bord_NodeIdTypBord));
				anos.add(ano);
			}
			return null;
		}else if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
