/*
 * Copyright
 *   2007 axYus - www.axyus.com
 *   2007 JP.Tessier - jean-philippe.tessier@axyus.com
 *
 * This file is part of XEMELIOS.
 *
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/*
 * Implmente le contrle N DEP01
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		Contrle de lexercice du bordereau.
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment Pes_DepenseAller/BlocBordereau :
 * 			- on vrifie que BlocBordereau/Exer/@V vaut N ou N-1
 */
public class DEP01 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP01.class);
    public static final transient String CTRL_ID = "DEP01";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;
	
	/**
	 * La chaine cible
	 */
	private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/";
	private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
	
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = "";
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
			nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			boolean err = false;
			try {
				int annee = Integer.parseInt(bord_Exer);
				GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
				if (annee == gc.get(GregorianCalendar.YEAR) || annee==(gc.get(GregorianCalendar.YEAR)-1)) err = false;
				else err = true;
			} catch (Exception e) { err = true; }
			
			if (err) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "Bordereau");
				xslParams.put("mandatId", "");
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
											getDocumentModel().getControlById(CTRL_ID).getId(),
											getDocumentModel().getControlById(CTRL_ID).getLibelle(),
											getDocumentModel().getDocumentId(),
											xpath.split("/")[1],
											BORDEREAU_DEPENSE, // lment importable
											bord_IdBord, // id lment importable
											localName,
											libelleLien,
											msg,
											getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
											getDocumentModel().getControlById(CTRL_ID).getSeverity(),
											path, // xpath vers le bordereau sous lequel se trouve l'anomalie
											xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(nodeId));
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
