/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC21
 * 
 * Contrles spcifiques aux Hpitaux
 * 
 * Le Finess juridique, les compte de TVA, les Codes Produits et les Informations Assurs peuvent tre renseigns.
 * 
 * Si PAR1=M21, alors vrifier que 
 * -	1) dans l'entte l'information EnTetePES/ FinJur est prsente 
 * -	2) pour toutes les pices Piece/ BlocPiece/ CodProd[@V] est valoris
 * -	3) pour toutes les lignes LigneDePiece / BlocLignePiece/ InfoLignePce/ CpteTva[@V] est renseign
 * -	4) pour toutes les lignes si le bloc InfoAssure est renseign 
 * 		et la balise Piece/ LigneDePiece/ BlocLignePiece/ InfoAssure/ CodAssDeb[@V] est valorise  2
 * 		alors il existe un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 01
 * 		ET un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 07
 * 		5) pour toutes les lignes si la balise Piece/ LigneDePiece/ BlocLignePiece/ InfoAssure/ CodAssDeb[@V] est valorise  1
 * 		alors il ne peut exister de bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 07
 * 		6) pour toutes les lignes si il existe un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 06
 * 		alors la balise Tiers/ InfoTiers/ DteMalade[@V] est de prfrence renseigne
 * 		7) pour toutes les lignes si il existe un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 06 ou 07
 * 		et si la balise Tiers/ InfoTiers/ IdTiers[@V] est valorise 
 * 		alors Tiers/ InfoTiers/ NatIdTiers[@V] doit tre valoris  04
 * 		8) pour toutes les lignes il doit exister un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 06
 * 		9) pour chaque pice si la balise Piece/CodProd[@V] est valorise 
 * 		alors la balise LigneDePiece / BlocLignePiece/ InfoLignePce/ CodProdLoc[@V] doit tre valorise  300
 * 		10) pour toutes les lignes la balise Piece/ LigneDePiece/ BlocLignePiece/ InfoAssure/ CodAssDeb[@V] doit tre valorise
 * 		11) pour toutes les lignes il doit exister un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 01
 * 		12) pour toutes les lignes il doit exister un bloc Tiers tel que Tiers/ InfoTiers/ TypTiers[@V] = 07 
 * 		SINON la balise Piece/ LigneDePiece/ BlocLignePiece/ InfoAssure/ CodAssDeb[@V] doit tre valorise  3.
 * 
 */
public class REC21 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC21.class);
    public static final transient String CTRL_ID="REC21";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Vector<String> vTypTiers = new Vector<String>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String ligne_nodeId = null;
	
	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String FIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String piece_CodProd = "";
	private String ligne_CodProdLoc = "";
	private String ligne_CodProdLoc_nodeid = "";
	
	private String entetepes_nodeid = "";
	private String piece_nodeid = "";
	
	private String infoAss_CodAssDeb = "";
	private String infoTiers_TypTiers_nodeid = "";
	private String infoTiers_DteMalade = "";
	private String infoTiers_IdTiers = "";
	private String infoTiers_NatIdTiers = "";
	private String infoTiers_NatIdTiers_nodeid = "";
	
	private boolean finJur_present = false;
	private boolean codProd_present = false;
	private boolean cpteTva_present = false;
	private boolean infoAss_present = false;
	private boolean blocTiers_present = false;
	private boolean param = false;
	
	
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_ENTETEPES = "/EnTetePES/";
	private static final String CHEMIN_ENTETEPES_FINJUR = "/EnTetePES/FinJur/";
	
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_CODPROD = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/CodProd/";
	
	private static final String CHEMIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_LIGNE_TIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/";
	private static final String CHEMIN_INFOTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/";
	private static final String CHEMIN_INFOTIERS_TYPTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/TypTiers/";
	private static final String CHEMIN_INFOTIERS_DTEMALADE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/DteMalade/";
	private static final String CHEMIN_INFOTIERS_IDTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/IdTiers/";
	private static final String CHEMIN_INFOTIERS_NATIDTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/NatIdTiers/";
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_CPTETVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CpteTva/";
	private static final String CHEMIN_INFOLIGNEPIECE_CODPRODLOC = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CodProdLoc/";
	
	private static final String CHEMIN_INFOASSURE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoAssure/";
	private static final String CHEMIN_INFOASSURE_CODASSDEB = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoAssure/CodAssDeb/";
	
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		if (xpath.endsWith(CHEMIN_ENTETEPES)) {
			finJur_present = false;
			entetepes_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_ENTETEPES_FINJUR)) {
			finJur_present = true;
		}

		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			codProd_present = false;
			piece_CodProd = "";
			infoAss_CodAssDeb = "";
			piece_nodeid = atts.getValue("ano:node-id");
			if(anos!=null)
				anos = new Vector<Anomalie>();
			if(anos.size()>0)
				anos.clear(); // vidage des anos de la piece prcdente
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_CODPROD)) {
			codProd_present = true;
			piece_CodProd = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_LIGNE)) {
			infoAss_CodAssDeb = "";
			blocTiers_present = false;
			if (!vTypTiers.isEmpty())
				vTypTiers.clear();
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_LIGNE_TIERS)) {
			blocTiers_present = true;
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS)) {			
			infoTiers_TypTiers_nodeid = "";
			infoTiers_DteMalade = "";
			infoTiers_IdTiers = "";
			infoTiers_NatIdTiers = infoTiers_NatIdTiers_nodeid = "";
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_TYPTIERS)) {
			vTypTiers.add(atts.getValue("V"));
			infoTiers_TypTiers_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_DTEMALADE)) {
			infoTiers_DteMalade = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_IDTIERS)) {
			infoTiers_IdTiers = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOTIERS_NATIDTIERS)) {
			infoTiers_NatIdTiers = atts.getValue("V");
			infoTiers_NatIdTiers_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = "";
			ligne_CodProdLoc = ligne_CodProdLoc_nodeid = "";
			cpteTva_present = infoAss_present = false;
			ligne_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_CPTETVA)) {
			cpteTva_present = true;
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_CODPRODLOC)) {
			ligne_CodProdLoc = atts.getValue("V");
			ligne_CodProdLoc_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOASSURE)) {
			infoAss_present = true;
		}
		if (xpath.endsWith(CHEMIN_INFOASSURE_CODASSDEB)) {
			infoAss_CodAssDeb = atts.getValue("V");			
		}

	}

	
	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		param = "M21".equals((String)hParams.get("nomencl"));
		
		if (param && xpath.endsWith(FIN_BORDEREAU)){
			//1
			if (!finJur_present) {
				Vector<Anomalie> ano1 = new Vector<Anomalie>();
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "Bordereau");
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                                getDocumentModel().getControlById(CTRL_ID).getId(),
                                                getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                getDocumentModel().getDocumentId(),
                                                xpath.split("/")[1],
                                                BORDEREAU_RECETTE, // lment importable
                                                bord_IdBord, // id lment importable
                                                localName,
                                                libelleLien,
                                                msg,
                                                getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(bord_IdBord));
				ano1.add(ano);
				return ano1;
			} else {
				return null;
			}			
		} else if (param && xpath.endsWith(FIN_PIECE)) {
			//2
			if (!codProd_present || piece_CodProd.equals("")) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        BORDEREAU_RECETTE, // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg + " - Le code produit doit tre renseign.",
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                        xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			
			return anos;
		} else if (param && xpath.endsWith(FIN_LIGNE)) {
			//3
			if (!cpteTva_present) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - CpteTva doit tre renseign.",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}	
			//4
			if (infoAss_present && infoAss_CodAssDeb.equals("2") && (!vTypTiers.contains("01") || !vTypTiers.contains("07"))) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - Le dbiteur et l'assur doivent tre indiqus.",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			//5
			if (infoAss_present && infoAss_CodAssDeb.equals("1") && vTypTiers.contains("07")) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - L'assur et le dbiteur sont la mme personne.",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(infoTiers_TypTiers_nodeid));
				anos.add(ano);
			}
			//6
			if (blocTiers_present && vTypTiers.contains("06") && infoTiers_DteMalade.equals("")) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - La date de naissance du malde doit tre de prfrence valorise (NON BLOQUANT)",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			//7
			if ( (vTypTiers.contains("06") || vTypTiers.contains("07")) && !infoTiers_IdTiers.equals("") && !infoTiers_NatIdTiers.equals("04") ) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - Seul le numro de scurit sociale doit tre indiqu.",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				//ano.addNode(new Node(infoTiers_NatIdTiers_nodeid));
				anos.add(ano);
			}
			//8
			if (blocTiers_present && !vTypTiers.contains("06")) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                    getDocumentModel().getDocumentId(),
                                    xpath.split("/")[1],
                                    BORDEREAU_RECETTE, // lment importable
                                    bord_IdBord, // id lment importable
                                    localName,
                                    libelleLien,
                                    msg + " - Un malade est de prfrence renseign (NON BLOQUANT)",
                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			//9
			if (codProd_present && !piece_CodProd.equals("") && !ligne_CodProdLoc.equals("300")) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        BORDEREAU_RECETTE, // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg,
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                        xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				ano.addNode(new Node(ligne_CodProdLoc_nodeid));
				anos.add(ano);
			}
			//10
			if (infoAss_CodAssDeb.equals("")){
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        BORDEREAU_RECETTE, // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg + " - La balise codAsDeb doit tre valorise",
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                        xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			//11
			if (blocTiers_present && !vTypTiers.contains("01")){
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        BORDEREAU_RECETTE, // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg + " - Un dbiteur doit tre renseign.",
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                        xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
			//12
			if (blocTiers_present && !vTypTiers.contains("07") && !infoAss_CodAssDeb.equals("3")){
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                        getDocumentModel().getControlById(CTRL_ID).getId(),
                                        getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                        getDocumentModel().getDocumentId(),
                                        xpath.split("/")[1],
                                        BORDEREAU_RECETTE, // lment importable
                                        bord_IdBord, // id lment importable
                                        localName,
                                        libelleLien,
                                        msg + " - Si aucun assur n'est renseign, la balise CodAsDeb doit tre valoris  3.",
                                        getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                        getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                        path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                        xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_nodeid));
				anos.add(ano);
			}
		}
		return null;
	}
	
//	private boolean haveToTest () {
//		String tmp = (String)hParams.get("nomencl");
//		return ("M21".equals(tmp) || "M22".equals(tmp));
//	}

	
	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
