/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC20
 * 
 * Contrle sur l'existence du Type de tiers
 * 
 * Chaque dbiteur doit avoir un type qui permettra de dterminer si c'est une personne de droit public ou priv. 
 * Le type du dbiteur est essentiel pour le recouvrement des titres.
 * 
 * Pour chaque ligne de titre, vrifier qu'il y a au moins un tiers dbiteur principal ( Tiers/ InfoTiers/ TypTiers[@V]=01) 
 * ou un assur (Tiers/ InfoTiers/ TypTiers[@V]=07 et LigneDePiece/ BlocLignePiece/ InfoAssure/ CodAssDeb[@V]=1)
 * 
 */
public class REC20 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC20.class);
    public static final transient String CTRL_ID="REC20";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String ligne_nodeId = null;
	
	private Vector<Node> anonodes = new Vector<Node>();
	
	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;
	private static final String FIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String typTiers_nodeid = "";
	private Vector<Couple> typTiers = new Vector<Couple>();
	private String codAssDeb = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
														 
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	
	private static final String CHEMIN_TIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/";
	private static final String CHEMIN_TIERS_TYPTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/TypTiers/";

	private static final String CHEMIN_INFOASSURE_CODASSDEB = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoAssure/CodAssDeb/";	
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			anos = new Vector<Anomalie>();
			anonodes = new Vector<Node>();
			piece_IdPce = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = codAssDeb = "";
			typTiers = new Vector<Couple>();
			ligne_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		
		if (xpath.endsWith(CHEMIN_TIERS)) {
			typTiers_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_TIERS_TYPTIERS)) {
			typTiers.add (new Couple (atts.getValue("V"), typTiers_nodeid));
		}
		if (xpath.endsWith(CHEMIN_INFOASSURE_CODASSDEB)) {
			codAssDeb = atts.getValue("V");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if (xpath.endsWith(FIN_LIGNE)){
			Vector<Node>tmp = new Vector<Node>();
			boolean err = true;
			for (Couple c:typTiers) {
				if ("01".equals(c.getTypTiers()) || ("07".equals(c.getTypTiers()) && "1".equals(codAssDeb))) {
					err = false;
				} else {
					tmp.add(new Node(c.getTypTiers_nodeid()));
				}
			}
			if (err)
				anonodes.addAll(tmp);
			return null;
		} else if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
			if (anonodes.size()>0) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                                    getDocumentModel().getControlById(CTRL_ID).getId(),
                                                    getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                    getDocumentModel().getDocumentId(),
                                                    xpath.split("/")[1],
                                                    BORDEREAU_RECETTE, // lment importable
                                                    bord_IdBord, // id lment importable
                                                    localName,
                                                    libelleLien,
                                                    msg,
                                                    getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                    getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                    path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                    xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addAll(anonodes);
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}
	
	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
	
	private class Couple {
		String typTiers = "";
		String typTiers_nodeid = "";

		public Couple (String tt, String ttni) {
			typTiers = tt;
			typTiers_nodeid = ttni;
		}

		public String getTypTiers() {
			return typTiers;
		}

		public void setTypTiers(
				String typTiers) {
			this.typTiers = typTiers;
		}

		public String getTypTiers_nodeid() {
			return typTiers_nodeid;
		}

		public void setTypTiers_nodeid(
				String typTiers_nodeid) {
			this.typTiers_nodeid = typTiers_nodeid;
		}
	}
}
