/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC15
 * 
 * Contrle du seuil d'mission des titres
 * 
 * Les montants des titres doivent avoir un montant suprieur au seuil de mise en recouvrement.
 * Il n'y a pas de contrle sur le seuil de recouvrement lorsqu'il s'agit d'une annulation de titre.
 * Pour toutes les lignes de titre, BlocLignePiece/ InfoLignePiece/ MtHT[@V] > PAR1
 * 
 */
public class REC15 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC15.class);
	public static final transient String CTRL_ID = "REC15";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;



	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String lignepiece_MTHT = "";
	private String lignepiece_NodeIdMTHT = "";
	private String piece_TypPiece = "";
	private String piece_NatPiece = "";
	

	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNEPIECE_MTHT = "#LIGNE_PIECE_MTHT#";
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Recettes uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_PIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	private static final String CHEMIN_PIECE_NATPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
	private static final String CHEMIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_BLOCLIGNEPIECE_MTHT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT/";


	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}


	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_PIECE)) {
			piece_IdPce = "";
			piece_TypPiece = piece_NatPiece = "";
			
			if (anos.isEmpty())
				anos = new Vector<Anomalie>();
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)){
			piece_IdPce=atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_PIECE_TYPPIECE)){
			piece_TypPiece=atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_PIECE_NATPIECE)){
			piece_NatPiece=atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_INFOLIGNEPIECE)){
			lignepiece_MTHT = "";
			lignepiece_NodeIdMTHT = "";
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_MTHT)){
			lignepiece_MTHT=atts.getValue("V");
			lignepiece_NodeIdMTHT=atts.getValue("ano:node-id");
		}
	}


	
	
	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(CHEMIN_LIGNE)){
			boolean err = false;
			BigDecimal par1 = (BigDecimal)hParams.get("seuilEmission");
			try {
				BigDecimal tmp = new BigDecimal (lignepiece_MTHT);
				err = (!isAnnulation() && tmp.compareTo(par1)<=0 );
			} catch (Exception e) {
				err = false;
			}
				
			
			if (err){				
				
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNEPIECE_MTHT, lignepiece_MTHT);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId",piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);							
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				
				ano.addNode(new Node (lignepiece_NodeIdMTHT));				
				anos.add(ano);
								
			}
			return null;
			
		} 
		else if (xpath.endsWith(CHEMIN_PIECE)) {
			return anos;
		}
		else return null;

	}

	

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
	
	public boolean isAnnulation (){
		if ( ( bord_TypBord.equals("02") && piece_TypPiece.equals("02") && piece_NatPiece.equals("06") )
			|| ( bord_TypBord.equals("01") && piece_TypPiece.equals("02") && piece_NatPiece.equals("09") ) ){
			return true;
		}
		else return false;
	}
}
