/*
 * Implmente le contrle N DEP21
 * 
 * Contrles spcifiques aux Hpitaux
 * 
 * Le Finess juridique, les compte de TVA, les Codes Produits et les Informations Assurs doivent tre renseigns.
 * 
 * Si PAR1=M21 ou M22, alors vrifier que 
 * -	1) dans l'entte l'information EnTetePES/FinJur est prsente 
 * -	2) 2)	pour toutes les lignes LigneDePiece / BlocLignePiece/ InfoLignePce/ CpteTva est renseign.
 * 
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

public class DEP21 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP21.class);
    public static final transient String CTRL_ID="DEP21";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String ligne_nodeId = "";
	
	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
	private static final String FIN_PIECE = "/PES_DepenseAller/Bordereau/Piece/";
	private static final String FIN_LIGNE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	
	private String entetepes_nodeid = "";
	private String piece_nodeid = "";
	private String finjur_nodeid = "";
	
	private boolean finJur_present = false;
	private boolean codProd_present = false;
	private boolean cpteTva_present = false;
	private boolean infoAss_present = false;
	
	private Vector<String> nodesId = new Vector<String>();
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_ENTETEPES = "/EnTetePES/";
	private static final String CHEMIN_ENTETEPES_FINJUR = "/EnTetePES/FinJur/";
	
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
														 
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_CPTETVA = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/CpteTVA/";

	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		if (xpath.endsWith(CHEMIN_ENTETEPES)) {
			finJur_present = false;
			entetepes_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_ENTETEPES_FINJUR)) {
			finJur_present = true;
			finjur_nodeid = atts.getValue("ano:node-id");
		}

		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			codProd_present = false;
			piece_nodeid = atts.getValue("ano:node-id");
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = ligne_nodeId = "";
			cpteTva_present = infoAss_present = false;
			
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
			ligne_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_CPTETVA)) {
			cpteTva_present = true;
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if (haveToTest () && xpath.endsWith(FIN_LIGNE)){
			if (!finJur_present) {
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("browser-destination", "internal");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
											getDocumentModel().getControlById(CTRL_ID).getId(),
											getDocumentModel().getControlById(CTRL_ID).getLibelle(),
											getDocumentModel().getDocumentId(),
											xpath.split("/")[1],
											BORDEREAU_DEPENSE, // lment importable
											bord_IdBord, // id lment importable
											localName,
											libelleLien,
											msg,
											getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
											getDocumentModel().getControlById(CTRL_ID).getSeverity(),
											path, // xpath vers le bordereau sous lequel se trouve l'anomalie
											xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				//ano.addNode(new Node(ligne_nodeId));
				anos.add(ano);
			} else if (!cpteTva_present) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                            getDocumentModel().getControlById(CTRL_ID).getId(),
                                            getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                            getDocumentModel().getDocumentId(),
                                            xpath.split("/")[1],
                                            BORDEREAU_DEPENSE, // lment importable
                                            bord_IdBord, // id lment importable
                                            localName,
                                            libelleLien,
                                            msg,
                                            getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                            getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                            path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                            xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				//ano.addNode(new Node(ligne_nodeId));
				anos.add(ano);
			}
			return null;
			
		} else if(xpath.endsWith(FIN_PIECE)){
			return anos;
		}
		return null;
	}
	
	private boolean haveToTest () {
		String tmp = (String)hParams.get("nomencl");
		return ("M21".equals(tmp) || "M22".equals(tmp));
	}
	
	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
