/*
 * Copyright
 *   2007 axYus - www.axyus.com
 *   2007 JP.Tessier - jean-philippe.tessier@axyus.com
 *
 * This file is part of XEMELIOS.
 *
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/*
 * Implmente le contrle N DEP12
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		Le montant de la TVA ne doit tre indiqu que si le budget collectivit et / ou le service grent la TVA. 
 *		Si la TVA est mentionne alors que la TVA est gre par un service, le service doit tre indiqu.
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V, BlocPiece/CodServ/@V.
 * 			- on stocke BlocPiece/IdPce/@V, BlocPiece/CodServ/@V.
 * 		3- Lorsqu'on lit un lment InfoLignePiece :
 * 			- on vide InfoLignePiece/IdLigne/@V, InfoLignePiece/MtTVA/@V.
 * 			- on stocke InfoLignePiece/IdLigne/@V, InfoLignePiece/MtTVA/@V.
 * 		4- Lorsqu'on lit une fin d'lment BlocPiece :
 * 			-  Si BlocPiece/CodServ/@V est renseign
 * 				Si le paramtre "servTVA" contient BlocPiece/CodServ/@V
 * 				  Il faut que toutes les lignes de pice aient un montant TVA renseign.
 * 				Sinon
 * 				  Il faut que toutes les lignes de pice aient un montant TVA non renseign.
 * 			   Sinon
 * 				Si le paramtre "coltva" vaut "true"
 * 				  Il faut que toutes les lignes de pice aient un montant TVA renseign.
 *				Sinon
 *				  Il faut que toutes les lignes de pice aient un montant TVA non renseign.
 */
public class DEP12 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(DEP12.class);
	public static final transient String CTRL_ID="DEP12";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * Liste des nodes des lignes ayant une TVA 
	 */
	private Vector<Node> nodesHasTVA = new Vector<Node>();
	/**
	 * Liste des nodes des lignes n'ayant pas de TVA 
	 */
	private Vector<Node> nodesHasNoTVA = new Vector<Node>();

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String piece_nodeId = null;

	/**
	 * Severit
	 */
	private static final String BLOQUANT = "BLOQUANT";
	private static final String NON_BLOQUANT = "NON BLOQUANT";

	/**
	 * La chaine cible
	 */
	private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
	private static final String ON_RETURN_ANOMALIES = FIN_BORDEREAU;
	private static final String FIN_PIECE = "/PES_DepenseAller/Bordereau/Piece/";
	private static final String FIN_LIGNEPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/";
	private static final String FIN_INFO_LIGNE_PIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";

	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String piece_CodServ = "";
	private boolean allLinesHasTVAFilled = true;
	private boolean lineHasTVA = false;

	private Vector<Node> anonodes;
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";

	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";

	private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	private static final String CHEMIN_BLOCPIECE_CODSERV = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/CodServ/";

	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_MTTVA = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/MtTVA/";

	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}

		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = piece_CodServ = "";
			piece_nodeId = atts.getValue("ano:node-id");
			anos = new Vector<Anomalie>();
			anos.clear();
			if(anonodes != null) anonodes.clear();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_CODSERV)) {
			piece_CodServ = atts.getValue("V");
		}

		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			lineHasTVA = false;
			ligne_IdLigne = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTTVA)) {
			nodesHasNoTVA.clear();
			nodesHasTVA.clear();
			String ligne_Mttva = atts.getValue("V");
			if (ligne_Mttva != null && !"".equals(ligne_Mttva)) {
				{
					lineHasTVA = true;
					nodesHasTVA.add(new Node(atts.getValue("ano:node-id")));
				}
			} else {
				lineHasTVA = false;
				nodesHasNoTVA.add(new Node(atts.getValue("ano:node-id")));
			}
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if (xpath.endsWith(FIN_INFO_LIGNE_PIECE)){
			allLinesHasTVAFilled &= lineHasTVA;

			boolean err = false;
			anonodes = new Vector<Node>();
			String severity = BLOQUANT;
			String[]servTVA = (String[])hParams.get("servTVA");
			boolean coltva = ((Boolean)hParams.get("coltva")).booleanValue();

			if (piece_CodServ!=null && !"".equals(piece_CodServ)) {
				severity = BLOQUANT;
				if (contains (servTVA, piece_CodServ)) {
					if(!lineHasTVA){
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
						msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
						msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
						String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "");
						xslParams.put("mandatId", piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_DEPENSE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								severity,
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(nodesHasNoTVA);
						anos.add(ano);
					}
				}else{
					if(lineHasTVA){
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
						msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
						msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
						String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "");
						xslParams.put("mandatId", piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_DEPENSE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								severity,
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(nodesHasTVA);
						anos.add(ano);
					}
				}
			} else {
				severity = NON_BLOQUANT;
				if (coltva) {
					if(!lineHasTVA){
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
						msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
						msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
						String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "");
						xslParams.put("mandatId", piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_DEPENSE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								severity,
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(nodesHasNoTVA);
						anos.add(ano);
					}
				}
				else {
					if(lineHasTVA){
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
						msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
						msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
						String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId", "");
						xslParams.put("mandatId", piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_DEPENSE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								severity,
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(nodesHasTVA);
						anos.add(ano);
					}
				}					
			}

			return null;
		} else if (xpath.endsWith(FIN_PIECE)){
			return anos;
		} else {
			return null;
		}
	}

	private boolean contains (String[]tab, String val) {
		for (String el:tab) {
			if (el.equals(val)) return true;
		}
		return false;
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
