/*
 * Implmente le contrle N DEP09
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		Contrle de la cohrence gnrale des informations DGP.
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V.
 * 			- on rinitialise le flag  faux.
 * 			- on stocke BlocPiece/IdPce/@V.
 * 		3- Lorsqu'on lit un lment DGP :
 * 			- on positionne un flag indiquant que le DGP est renseign.
 * 		4- Lorsqu'on lit une fin d'lment BlocPiece :
 * 			- on vrifie le flag positionn ci-dessus.
 * 
 * Exceptions :
 * 	- pas de contrle sur la paie, triplets (01,01,11) et (01,08,11)
 * 	- pas de contrle pour les emprunts (NatPce=04)
 * 	- pas de contrle pour les mandats d'admission en non valeur (TypPce=07)
 * 	- pas de contrle pour les mandats mis aprs paiement (TypPce=05)
 * 	- pas de contrle pour les bordereaux correctifs (TypPce=02)
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

public class DEP09 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private static Logger logger = Logger.getLogger(DEP09.class);
	public static final transient String CTRL_ID = "DEP09";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String piece_nodeId = null;
	
	/**
	 * Severit
	 */
	private static final String BLOQUANT = "BLOQUANT";
	private static final String NON_BLOQUANT = "NON BLOQUANT";
	
	/**
	 * La chaine cible
	 */
	private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/Piece/";
	private static final String FIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_TypPce = "";
	private String piece_NatPce = "";
	private String lignePiece_Nature = "";
	private boolean dgp_Present = false;
	
	private Vector<String> vTypPceNatPceEligible = new Vector<String>();
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/TypPce/";
	private static final String CHEMIN_BLOCPIECE_NATPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/NatPce/";
	
	private static final String CHEMIN_LIGNEDEPIECE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_LIGNEDEPIECE_NATURE = "/PES_DepenseAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/Nature/";
	
	private static final String CHEMIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
		vTypPceNatPceEligible.add("0101");vTypPceNatPceEligible.add("0102");vTypPceNatPceEligible.add("0103");
		// vTypPceNatPceEligible.add("0104");vTypPceNatPceEligible.add("0207");vTypPceNatPceEligible.add("0208");
		// pas de contrle sur la paie :
		// vTypPceNatPceEligible.add("0811");vTypPceNatPceEligible.add("0111"); 
		vTypPceNatPceEligible.add("0105");vTypPceNatPceEligible.add("0115");	
		vTypPceNatPceEligible.add("0801");vTypPceNatPceEligible.add("0802");vTypPceNatPceEligible.add("0815");
		vTypPceNatPceEligible.add("0901");vTypPceNatPceEligible.add("0902");vTypPceNatPceEligible.add("0913");vTypPceNatPceEligible.add("0914");
		vTypPceNatPceEligible.add("0915");
		vTypPceNatPceEligible.add("1101");vTypPceNatPceEligible.add("1102");vTypPceNatPceEligible.add("1114");vTypPceNatPceEligible.add("1115");
	}
	
	public void setDocId(String docID) {
		this.docId = docID;
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
			piece_TypPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPIECE)) {
			piece_NatPce = atts.getValue("V");
		}
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";
			dgp_Present = false;
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
			piece_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_LIGNEDEPIECE)) {
			lignePiece_Nature = "";
		}
		if (xpath.endsWith(CHEMIN_LIGNEDEPIECE_NATURE)) {
			lignePiece_Nature = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_DGP)) {
			dgp_Present = true;
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			return anos;
		} else if (xpath.endsWith(FIN_BLOCPIECE)){
			String typnat = piece_TypPce+piece_NatPce;
			if (vTypPceNatPceEligible.contains(typnat) && !dgp_Present) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(); 
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
				
				String severity = BLOQUANT;
				if (hParams.get("suivdgp")==null) logger.error("pas de param suividgp !");
				else {
					boolean suiviDGP = ((Boolean)hParams.get("suivdgp")).booleanValue();
					if (!suiviDGP) severity = NON_BLOQUANT;

					String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId", "");
					xslParams.put("mandatId", piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
												getDocumentModel().getControlById(CTRL_ID).getId(),
												getDocumentModel().getControlById(CTRL_ID).getLibelle(),
												getDocumentModel().getDocumentId(),
												xpath.split("/")[1],
												BORDEREAU_DEPENSE, // lment importable
												bord_IdBord, // id lment importable
												localName,
												libelleLien,
												msg,
												getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
												severity,
												path, // xpath vers le bordereau sous lequel se trouve l'anomalie
												xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
					ano.addNode(new Node(piece_nodeId));
					anos.add(ano);
				}
			}
			return null;
		} else {
			return null;
		}
	}

//	public boolean isPaie() {
//		if (lignePiece_Nature.matches("64.*") || lignePiece_Nature.matches("621.*") || lignePiece_Nature.matches("631.*") || lignePiece_Nature.matches("633.*"))
//			return true;
//		else 
//			return false;
//	}
	
	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
