/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N TIE07
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * 		La catgorie juridique du tiers, doit tre cohrente avec la nature juridique du tiers.
 * Il est fait ainsi :
 * 		1- 	Lorsqu'on lit un lment BlocBordereau :
 * 			- on vide BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V.
 * 			- on stocke BlocBordereau/Exer/@V, BlocBordereau/IdBord/@V, BlocBordereau/Typbord/@V. 
 * 		2- 	Lorsqu'on lit un lment BlocPiece :
 * 			- on vide BlocPiece/IdPce/@V.
 * 			- on stocke BlocPiece/IdPce/@V.
 * 		3- Lorsqu'on lit un lment InfoLignePiece :
 * 			- on vide InfoLignePiece/IdLigne/@V.
 * 			- on stocke InfoLignePiece/IdLigne/@V.
 * 		4- Lorsqu'on lit un lment Adresse/ :
 * 			- on lit Adresse/CP/@V, Adresse/CodRes/@V et Adresse/CodPays/@V.
 * 		5- Lorsqu'on lit une fin d'lement Adresse : 
 * 			- on vrifie que si CodRes = 0
 * 					si CP commence par "02A" ou "02B" 
 * 						alors erreur --> CP doit tre valoris  99999
 * 					sinon CP a une longueur de 5 caractres.
 * 			- on vrifie que si CodRes = 1
 * 					CodPays comporte 3 chiffres.
 * 					CP est valoris  99999 et le vritable code postal est renseign dans la balise Tiers/Adresse/Ville[@V]
 */

public class TIE07 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(TIE07.class);
    public static final transient String CTRL_ID = "TIE07";
	private Vector<Anomalie> anos = null;
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String ligne_nodeId = null;
	
	/**
	 * La chaine cible
	 */
	private static final String ON_RETURN_ANOMALIES = "Piece";
	private static final String ADRESSE = "Adresse";
	
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String tiers_CP = "";
	private String tiers_codRes = "";
	private String tiers_codPays = "";
	private String tiers_ville = "";
	private String tiers_CP_NodeId = "";
	private String tiers_ville_NodeId = "";
	private String tiers_nom = "";
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	private static final String MSG_TIERS_NOM = "#TIERS_NOM#";
	private static final String MSG_ERREUR = "#ERREUR#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses et les Recettes
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
	
	/**
	 * Selon que l'on est en RECETTE ou DEPENSE, le xpath est diffrent
	 */
	private static final String RECETTE = "PES_RecetteAller";
	private static final String DEPENSE = "PES_DepenseAller";
	private boolean depense = false;
	
	private static String CHEMIN_BLOCPIECE = "";
	private static String CHEMIN_BLOCPIECE_IDPCE = "";
	private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
	private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
	
	private static String CHEMIN_INFOLIGNEPIECE = "";
	private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
	private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
	private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
	
	private static final String CHEMIN_TIERS_NOM = "/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Nom/";
	private static final String CHEMIN_ADRESSE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/";
	private static final String CHEMIN_ADRESSE_CP = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CP/";
	private static final String CHEMIN_ADRESSE_CODRES = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CodRes/";
	private static final String CHEMIN_ADRESSE_CODPAYS = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/CodPays/";
	private static final String CHEMIN_ADRESSE_VILLE = "/Bordereau/Piece/LigneDePiece/Tiers/Adresse/Ville/";
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 0
		// RECETTE ou DEPENSE
		if (xpath.indexOf(DEPENSE)!=-1) {
			depense = true;
			CHEMIN_BLOCPIECE = D_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		if (xpath.indexOf(RECETTE)!=-1) {
			depense = false;
			CHEMIN_BLOCPIECE = R_CHEMIN_BLOCPIECE;
			CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
			CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
			CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
		}
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = "";			
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = "";
			ligne_nodeId = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");	
			ligne_nodeId = atts.getValue("ano:node-id");

		}
		
		// 4		
		if (xpath.endsWith(CHEMIN_TIERS_NOM)) {
			tiers_nom = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_ADRESSE)) {
			tiers_CP = tiers_codPays = tiers_codRes = tiers_ville = "";
			tiers_CP_NodeId = "";
		}
		if (xpath.endsWith(CHEMIN_ADRESSE_CP)) {
			tiers_CP = atts.getValue("V");
			tiers_CP_NodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_ADRESSE_CODPAYS)) {
			tiers_codPays = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_ADRESSE_CODRES)) {
			tiers_codRes = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_ADRESSE_VILLE)) {
			tiers_ville = atts.getValue("V");
			tiers_ville_NodeId = atts.getValue("ano:node-id");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(ON_RETURN_ANOMALIES.equals(localName)){
			return anos;
			
		} else if (ADRESSE.equals(localName)) {
			// 5
				boolean err = false;
				
				if ("0".equals(tiers_codRes)) {
					if (tiers_CP.startsWith("02A") || tiers_CP.startsWith("02B"))
						err = true;			
					else err = tiers_CP.length()!=5;					
				}else if ("1".equals(tiers_codRes)) {
					err = (tiers_codPays.equals("") || !tiers_codPays.matches("^[0-9]{3}$") || !tiers_CP.equals("99999") || tiers_ville.equals("")) ;
				}

				
				if (err) {
					String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
					msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
					msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
					msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
					msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
					msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
					msg = msg.replaceAll(MSG_TIERS_NOM, tiers_nom);
					
					// RECETTE OU DEPENSE
					if (depense)
						msg = msg.replaceAll("#MT#", "Mandat");
					else
						msg = msg.replaceAll("#MT#", "Titre");

					// MESSAGE D ERREUR
					if ("0".equals(tiers_codRes)){
						if (tiers_CP.startsWith("02A") || tiers_CP.startsWith("02B"))
							msg = msg.replaceAll(MSG_ERREUR, "Le code postal rel 02AXX ou 02BXX doit tre renseign dans le champs Ville et le code postal doit tre valoris  99999");					
						else
							msg = msg.replaceAll(MSG_ERREUR, "Code postal invalide");		
					}
					else if ("1".equals(tiers_codRes)){
						if (tiers_codPays.equals("") || !tiers_codPays.matches("^[0-9]{3}$"))
							msg = msg.replaceAll(MSG_ERREUR, "Code pays [NON RENSEIGNE] ou invalide");	
						else
							msg = msg.replaceAll(MSG_ERREUR, "Il faut valoriser le code postal  99999 et renseigner le vritable code postal (de format tranger) dans le champs Ville");
					}
					
					
					String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId", "");
					xslParams.put("mandatId", piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
                                                getDocumentModel().getControlById(CTRL_ID).getId(),
                                                getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                getDocumentModel().getDocumentId(),
                                                xpath.split("/")[1],
                                                (depense?BORDEREAU_DEPENSE:BORDEREAU_RECETTE), // lment importable
                                                bord_IdBord, // id lment importable
                                                localName,
                                                libelleLien,
                                                msg,
                                                getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                getDocumentModel().getControlById(CTRL_ID).getSeverity(),
                                                path,
                                                xslParams);
					if ("0".equals(tiers_codRes))
							ano.addNode(new Node(tiers_CP_NodeId));										
					else {
						if (tiers_codPays.equals("") || tiers_ville.equals("") || !tiers_codPays.matches("^[0-9]{3}$"))
							ano.addNode(new Node (ligne_nodeId));
						if (!tiers_CP.equals("99999")){
							ano.addNode(new Node(tiers_CP_NodeId));
							ano.addNode(new Node(tiers_ville_NodeId));
						}
					}
											
					anos.add(ano);
										
				}
				tiers_CP = tiers_codPays = tiers_codRes = tiers_ville = tiers_nom = "";
				tiers_CP_NodeId = tiers_ville_NodeId = "";
				
				return null;
				
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
