/*
 * Copyright 
 *   2009 axYus - www.axyus.com
 *   2009 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;


/**
 * Implmente le contrle N REC30
 * 
 * Il consiste  vrifier la rgle fonctionnelle suivante :
 * Les contrles sur la balise opration doivent tre correctement renseigns
 * 
 */


public class REC30 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(REC30.class);
	public static final transient String CTRL_ID = "REC30";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	
	private String docId = null;
	private String nodeId = null;

	/**
	 * La chaine cible
	 */
	
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String LIGNEPCE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;

	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_TypPce = "";	
	private String piece_NatPce = "";	
	private String ligne_IdLigne = "";
	private String ligne_Fonction = "";
	private String ligne_Operation = "";
		
	private String ligne_Fonction_NodeId = "";
	private String ligne_Operation_NodeId = "";
	
	
	
	/**
	 * Variables devant tre remplaces dans le message-echec
	 */
	
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
	private static final String MSG_LIGNE_OPERATION = "#LIGNE_OPERATION#";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCPIECE_NATPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	private static final String CHEMIN_BLOCLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_FONCTION = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/Fonction/";
	private static final String CHEMIN_INFOLIGNEPIECE_OPERATION = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/Operation/";

	
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	
	public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
		
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_ExerBord = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_PIECE)) {
			if (anos != null)
				anos = new Vector<Anomalie>();			
			piece_IdPce = piece_TypPce = piece_NatPce = "";			
		}		
		if(xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)){
			piece_IdPce = atts.getValue("V");
			anos.clear();
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)){
			piece_TypPce = atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_NATPIECE)){
			piece_NatPce = atts.getValue("V");
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE)){
			ligne_IdLigne = "";			
		}
		if(xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)){
			ligne_IdLigne = atts.getValue("V");
			ligne_Fonction = ligne_Operation = "";
			ligne_Fonction_NodeId = ligne_Operation_NodeId = "";
		}
		if(xpath.endsWith(CHEMIN_INFOLIGNEPIECE_FONCTION)){
			ligne_Fonction = atts.getValue("V");
			ligne_Fonction_NodeId = atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_INFOLIGNEPIECE_OPERATION)){
			ligne_Operation = atts.getValue("V");
			ligne_Operation_NodeId = atts.getValue("ano:node-id");
		}
		
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		String PAR1 = (String)hParams.get("nomencl");
		String PAR2 = (String)hParams.get("typnomencl");
		Vector<Node> anonodes = new Vector<Node>();
		boolean err = false;
		
		if(xpath.endsWith(LIGNEPCE)){
			
			// toutes nomenclatures sauf M52 et M71
			if ( !PAR1.equals("M52") && !PAR1.equals("M71") && (piece_TypPce.equals("03")||piece_TypPce.equals("04")) ){
				if ( PAR2.equals("Nature") || PAR2.equals("Nature-ref-fonct") ){
					if ( piece_NatPce.equals("01") ){
						if ( !ligne_Operation.equals("6") && !ligne_Operation.equals("042") && !ligne_Operation.equals("7") && !ligne_Operation.equals("043") ){
							
							err = true;
							anonodes.add(new Node (ligne_Operation_NodeId));
							
						}						
					}
					if ( piece_NatPce.equals("02") ){
						if ( !ligne_Operation.equals("4") && !ligne_Operation.equals("040") && !ligne_Operation.equals("5") && !ligne_Operation.equals("041") ){
							
							err = true;
							anonodes.add(new Node (ligne_Operation_NodeId));
							
						}
					}
				}
				if ( PAR2.equals("Fonction") ){
					if ( piece_NatPce.equals("01") ){
						if ( ((!ligne_Operation.equals("6") && !ligne_Operation.equals("042")) || !ligne_Fonction.equals("934"))
							  && ((!ligne_Operation.equals("7") && !ligne_Operation.equals("043")) || !ligne_Fonction.equals("935")) ){
							
								err = true;
								anonodes.add(new Node (ligne_Operation_NodeId));
								anonodes.add(new Node (ligne_Fonction_NodeId));
							
						}
					}
					if ( piece_NatPce.equals("02") ){
						if ( ((!ligne_Operation.equals("4") && !ligne_Operation.equals("040")) || !ligne_Fonction.equals("914"))
							  && ((!ligne_Operation.equals("5") && !ligne_Operation.equals("041")) || !ligne_Fonction.equals("910")) ){
								
								err = true;					
								anonodes.add(new Node (ligne_Operation_NodeId));
								anonodes.add(new Node (ligne_Fonction_NodeId));
																
						}
					}
						
				}
			}
			
			// nomenclature M71
			if ( PAR1.equals("M71") && (piece_TypPce.equals("03")||piece_TypPce.equals("04")) ){
				if ( PAR2.equals("Nature") || PAR2.equals("Nature-ref-fonct") ){
					if ( piece_NatPce.equals("01") ){
						if ( !ligne_Operation.equals("6") && !ligne_Operation.equals("042") && !ligne_Operation.equals("7") && !ligne_Operation.equals("043") ){
							
							err = true;							
							anonodes.add(new Node (ligne_Operation_NodeId));
							
						}						
					}
					if ( piece_NatPce.equals("02") ){
						if ( !ligne_Operation.equals("4") && !ligne_Operation.equals("040") && !ligne_Operation.equals("5") && !ligne_Operation.equals("041") ){
							
							err = true;							
							anonodes.add(new Node (ligne_Operation_NodeId));
							
						}
					}
				}
				if ( PAR2.equals("Fonction") ){
					if ( piece_NatPce.equals("01") ){
						if ( (!ligne_Operation.equals("7") && !ligne_Operation.equals("043")) || !ligne_Fonction.equals("935") ){
							
							err = true;
							if (!ligne_Fonction.equals("935"))
								anonodes.add(new Node (ligne_Fonction_NodeId));
							if (!ligne_Operation.equals("7") && !ligne_Operation.equals("043"))
								anonodes.add(new Node (ligne_Operation_NodeId));
								
						}
					}
					if ( piece_NatPce.equals("02") ){
						if ( ((!ligne_Operation.equals("4") && !ligne_Operation.equals("040")) || !ligne_Fonction.equals("914"))
							  && ((!ligne_Operation.equals("5") && !ligne_Operation.equals("041")) || !ligne_Fonction.equals("910")) ){
								
								err = true;
								anonodes.add(new Node (ligne_Operation_NodeId));
								anonodes.add(new Node (ligne_Fonction_NodeId));								
								
						}
					}
						
				}
			}
			
			
			// nomenclature M52
			if ( PAR1.equals("M52") ){
				if ( (PAR2.equals("Nature") || PAR2.equals("Nature-ref-fonct")) && piece_NatPce.equals("01") ){
						if ( !ligne_Operation.equals("1") && !ligne_Operation.equals("010") && !ligne_Operation.equals("2") && !ligne_Operation.equals("015") &&
							 !ligne_Operation.equals("3") && !ligne_Operation.equals("016")	){
							
							err = true;
							anonodes.add(new Node (ligne_Operation_NodeId));
							
						}											
				}
				if ( PAR2.equals("Fonction") ){
					if ( piece_NatPce.equals("01") ){
						if ( (!ligne_Operation.equals("4") || !ligne_Fonction.equals("905"))
						  && (!ligne_Operation.equals("4") || !ligne_Fonction.equals("935"))
						  && (!ligne_Operation.equals("5") || !ligne_Fonction.equals("935")) ){
							
								err = true;
								anonodes.add(new Node (ligne_Operation_NodeId));
								anonodes.add(new Node (ligne_Fonction_NodeId));								
							
						}
					}
											
				}
			}
					 					 
			if (err){	
				
					String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
					msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
					msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
					msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
					msg = msg.replaceAll(MSG_LIGNE_OPERATION, ligne_Operation);	
					String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId","");
					xslParams.put("mandatId",piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
							getDocumentModel().getControlById(CTRL_ID).getId(),
							getDocumentModel().getControlById(CTRL_ID).getLibelle(),
							getDocumentModel().getDocumentId(),
							xpath.split("/")[1],
							BORDEREAU_RECETTE, // lment importable
							bord_IdBord, // id lment importable
							localName,
							libelleLien,
							msg,
							getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
							getDocumentModel().getControlById(CTRL_ID).getSeverity(),
							path, // xpath vers le bordereau sous lequel se trouve l'anomalie
							xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
					
					
					
					ano.addAll(anonodes);
					anos.add(ano);
				
			}
			
			return null;		
		}
		else if (xpath.endsWith(ON_RETURN_ANOMALIES)){
						
			return anos;
			
		} else {
			return null;
		}
	}
	
	
	
	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
	
}
