/*
 * Copyright
 *   2008 axYus - www.axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 *
 * This file is part of XEMELIOS.
 *
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;


/**
 * Implmente le contrle N REC25
 * 
 * Contrles lis aux titres d'ordre
 * 
 */

public class REC25 extends AbstractUnitControl implements ConstantsControlsPESv2{
	private final static Logger logger = Logger.getLogger(REC25.class);
    public static final transient String CTRL_ID = "REC25";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
		
	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String LIGNEPCE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;


	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_TypPce = "";
	private String lignepiece_Id = "";
	private String lignepiece_CatTiers = "";
	private String lignepiece_NatJur = "";
	private String lignepiece_Tiers_Nom = "";
	
	private String lignepiece_CpteBancaire_NodeId = "";
	private String lignepiece_NodeId = "";

	private Vector<String> vCatTiersNatJur = new Vector<String>();

	private boolean cpteBancaireExist = false;
	
	int compteurTiers = 0;
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNEPIECE_ID = "#LIGNE_IDLIGNE#";
	
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	private static final String CHEMIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_LIGNEPIECE_ID = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_LIGNEPIECE_TIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/";
	private static final String CHEMIN_TIERS_CPTEBANCAIRE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/";
	private static final String CHEMIN_TIERS_CATTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/CatTiers/";
	private static final String CHEMIN_TIERS_NATJUR = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/NatJur/";
	private static final String CHEMIN_TIERS_TYPTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/TypTiers/";
	private static final String CHEMIN_TIERS_NOM = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Nom/";

	
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {

		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			if (!anos.isEmpty())
			anos = new Vector<Anomalie>();
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_PIECE)) {
			anos.clear();
			piece_IdPce = piece_TypPce = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
			piece_TypPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_LIGNEPIECE)) {
			vCatTiersNatJur.clear();
			lignepiece_Id = "";			
			lignepiece_NodeId = "";	
			compteurTiers = 0;
		}
		if (xpath.endsWith(CHEMIN_LIGNEPIECE_ID)) {
			lignepiece_Id = atts.getValue("V");
			lignepiece_NodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_LIGNEPIECE_TIERS)) {	
			compteurTiers++;
			cpteBancaireExist = false;
			lignepiece_CatTiers = lignepiece_NatJur = lignepiece_Tiers_Nom = "";
			lignepiece_CpteBancaire_NodeId = "";			
		}
		if (xpath.endsWith(CHEMIN_TIERS_CPTEBANCAIRE)) {
			cpteBancaireExist = true;
			lignepiece_CpteBancaire_NodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_TIERS_CATTIERS)) {
			lignepiece_CatTiers = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_TIERS_NATJUR)) {
			lignepiece_NatJur = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_TIERS_TYPTIERS)) {
			vCatTiersNatJur.add(lignepiece_CatTiers + lignepiece_NatJur);
		}
		if (xpath.endsWith(CHEMIN_TIERS_NOM)) {
			lignepiece_Tiers_Nom = atts.getValue("V");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
						
		String severity = getDocumentModel().getControlById(CTRL_ID).getSeverity();
		
		if(xpath.endsWith(CHEMIN_LIGNEPIECE_TIERS)){
								
			if(piece_TypPce.equals("03") || piece_TypPce.equals("04")){
				
				if(cpteBancaireExist){
					severity="BLOQUANT";
																					
					String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
					msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
					msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
					msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
					msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
					msg = msg.replaceAll(MSG_LIGNEPIECE_ID, lignepiece_Id);
					String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
					String anoId = IdGenerator.nextId();
					String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
					Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
					xslParams.put("elementId","");
					xslParams.put("mandatId",piece_IdPce);
					xslParams.put("browser-destination", "internal");
					xslParams.put("anoId", anoId);
					Anomalie ano = new Anomalie(anoId,
							getDocumentModel().getControlById(CTRL_ID).getId(),
							getDocumentModel().getControlById(CTRL_ID).getLibelle(),
							getDocumentModel().getDocumentId(),
							xpath.split("/")[1],
							BORDEREAU_RECETTE, // lment importable
							bord_IdBord, // id lment importable
							localName,
							libelleLien,
							msg + " - Tiers : " + lignepiece_Tiers_Nom,
							getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
							severity,
							path, // xpath vers le bordereau sous lequel se trouve l'anomalie
							xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie

					if(compteurTiers==1)
						ano.addNode(new Node(lignepiece_CpteBancaire_NodeId));
					else 
						ano.addNode(new Node(lignepiece_NodeId));
					
					anos.add(ano);
					
				}
				
			} return null;
			
		} else if(xpath.endsWith(LIGNEPCE)){
			
				if(piece_TypPce.equals("03") || piece_TypPce.equals("04")){
					
					if(!vCatTiersNatJur.contains("2007")){
						
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
						msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
						msg = msg.replaceAll(MSG_LIGNEPIECE_ID, lignepiece_Id);
						String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId","");
						xslParams.put("mandatId",piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_RECETTE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg + " (NON BLOQUANT)",
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								severity,
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
	
						ano.addNode(new Node(lignepiece_NodeId));
						anos.add(ano);
						
					}
				} return null;

		} else if(xpath.endsWith(ON_RETURN_ANOMALIES)){
								
			return anos;
			
		} else {
			return null;
		}		
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
	
}
