/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC19
 * 
 * Contrle sur le montant la TVA
 * 
 * Pour les collectivits ou services assujettis  la TVA, le montant du titre doit tre gal au montant budgtaire augment de la TVA. 
 * Le montant de la TVA est crdite au compte de la TVA et le montant hors taxe est crdite au compte budgtaire.
 * 
 * Pour toutes les lignes ayant un MtTVA :
 * Si TxTVA est renseign vrifier que :
 * -	1) TxTVA est contenu dans PAR1
 * -	2) MtTVA/MtHT = TxTVA 
 * Si TxTVA n'est pas renseign vrifier que :
 * -	3) Le rapport MtTVA/MtHT appartienne  PAR1.
 */
public class REC19 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC19.class);
    public static final transient String CTRL_ID="REC19";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String bord_nodeId = null;
	private String ligne_nodeId = null;
	
	private Vector<Node> anonodes = new Vector<Node>();
	
	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;
	private static final String FIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
		
	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */
	private String bord_Exer = "";
	private String bord_IdBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String ligne_IdLigne = "";
	private String ligne_Mtht = "";
	private String ligne_Mttva = "";
	private String ligne_Txtva = "";
	private String ligne_Mtht_nodeid = "";
	private String ligne_Mttva_nodeid = "";
	private String ligne_Txtva_nodeid = "";
	private StringBuffer buff = null;
	private boolean bloquant = false;
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
//	private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
//	private static final String MSG_LIGNE_MTHT = "#LIGNE_MTHT#";
//	private static final String MSG_LIGNE_MTTVA = "#LIGNE_MTTVA#";
//	private static final String MSG_LIGNE_TXTVA = "#LIGNE_TXTVA#";
        private static final String MSG_PIECE_DETAIL = "##DETAIL_MSG##";
	
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
														 
	private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_INFOLIGNEPIECE_MTHT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT/";
	private static final String CHEMIN_INFOLIGNEPIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";
	private static final String CHEMIN_INFOLIGNEPIECE_TXTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/TxTva/";	
	
	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}
	
	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		// 1
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_Exer = bord_IdBord = bord_TypBord = "";
			bord_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_Exer = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		// 2
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			anos = new Vector<Anomalie>();
			anonodes = new Vector<Node>();
			piece_IdPce = "";
            buff = new StringBuffer();
            bloquant = false;
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
			piece_IdPce = atts.getValue("V");
		}
		
		// 3
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
			ligne_IdLigne = ligne_Mtht = ligne_Mttva = ligne_Txtva = "";
			ligne_nodeId = atts.getValue("ano:node-id");
			ligne_Mtht_nodeid = ligne_Mttva_nodeid = ligne_Txtva_nodeid = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			ligne_IdLigne = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTHT)) {
			ligne_Mtht = atts.getValue("V");
			ligne_Mtht_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_MTTVA)) {
			ligne_Mttva = atts.getValue("V");
			ligne_Mttva_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_TXTVA)) {
			ligne_Txtva = atts.getValue("V");
			ligne_Txtva_nodeid = atts.getValue("ano:node-id");
		}
	}
	

	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if (xpath.endsWith(FIN_LIGNEPIECE)){
			String[] les_taux = (String[])hParams.get("tauxTVA");
			double mtHT = -1, mtTVA = -1, txTVA = -1;
			if (ligne_Mtht!=null && !"".equals(ligne_Mtht)) {
				try {mtHT = Double.parseDouble(ligne_Mtht);} catch (Exception e) {mtHT = -1;}
			}
			if (ligne_Mttva!=null && !"".equals(ligne_Mttva)) {
				try {mtTVA = Double.parseDouble(ligne_Mttva);} catch (Exception e) {mtTVA = -1;}
			}
			if (ligne_Txtva!=null && !"".equals(ligne_Txtva)) {
				try {txTVA = Double.parseDouble(ligne_Txtva)/100.0;} catch (Exception e) {txTVA = -1;}
			}
			
			if (txTVA != -1) {
				if (!contains(les_taux, ligne_Txtva)) {
					anonodes.add(new Node(ligne_Txtva_nodeid));
					buff.append("&lt;li&gt;ligne n").append(ligne_IdLigne).append(" - MtHT=").append(ligne_Mtht).append(" - MtTVA=").append(ligne_Mttva).append(" - TxTVA=").append(ligne_Txtva).append("&lt;/li&gt;");
					if (mtTVA!=0 && txTVA!=0) bloquant = true;
				}
				else if (mtHT != -1 && mtTVA != -1) {
					//double mtTTC = mtHT+mtTVA;
					//double taux = (Math.round(10000*mtTVA/mtTTC)/100.0);
					double taux = mtTVA / mtHT;
					//double taux = mtTVA / mtHT;
					//if (taux != txTVA) {
					if (taux < txMinor(txTVA) || taux > txMajor(txTVA)) {
						anonodes.add (new Node(ligne_Mtht_nodeid));
						anonodes.add (new Node(ligne_Mttva_nodeid));
						anonodes.add (new Node(ligne_Txtva_nodeid));
                        buff.append("&lt;li&gt;ligne n").append(ligne_IdLigne).append(" - MtHT=").append(ligne_Mtht).append(" - MtTVA=").append(ligne_Mttva).append(" - TxTVA=").append(ligne_Txtva).append("&lt;/li&gt;");
            			if (mtTVA!=0 && txTVA!=0) bloquant = true;
					}
				}
			} else {
				if (mtHT != -1 && mtTVA != -1) {
					//double mtTTC = mtHT+mtTVA;
					//double taux = (Math.round(10000*mtTVA/mtTTC)/100.0);
					//double taux = mtTVA / mtHT;
					double taux = mtTVA / mtHT;
                    String strTx = Double.toString(taux);
					if (!containsMajoMino(les_taux, strTx)) {
						anonodes.add (new Node(ligne_Mtht_nodeid));
						anonodes.add (new Node(ligne_Mttva_nodeid));
                        buff.append("&lt;li&gt;ligne n").append(ligne_IdLigne).append(" - MtHT=").append(ligne_Mtht).append(" - MtTVA=").append(ligne_Mttva).append(" - TxTVA=").append(ligne_Txtva).append("&lt;/li&gt;");
            			if (mtTVA!=0 && txTVA!=0) bloquant = true;
					}
				}
			}
			return null;
		} else if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
			if (anonodes.size()>0) {
				String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_Exer);
				msg = msg.replaceAll(MSG_BORD_TYPBORD, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_IDPCE, piece_IdPce);
//				msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, ligne_IdLigne);
//				msg = msg.replaceAll(MSG_LIGNE_MTHT, ligne_Mtht);
//				msg = msg.replaceAll(MSG_LIGNE_MTTVA, ligne_Mttva);
//				msg = msg.replaceAll(MSG_LIGNE_TXTVA, ligne_Txtva);
                msg = msg.replaceAll(MSG_PIECE_DETAIL,buff.toString());
				
				String path="@added:primary-key='"+bord_Exer+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId", "");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
                                                            getDocumentModel().getControlById(CTRL_ID).getId(),
                                                            getDocumentModel().getControlById(CTRL_ID).getLibelle(),
                                                            getDocumentModel().getDocumentId(),
                                                            xpath.split("/")[1],
                                                            BORDEREAU_RECETTE, // lment importable
                                                            bord_IdBord, // id lment importable
                                                            localName,
                                                            libelleLien,
                                                            msg,
                                                            getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
                                                            (bloquant?"BLOQUANT":"NON BLOQUANT"),
                                                            path, // xpath vers le bordereau sous lequel se trouve l'anomalie
                                                            xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
//				ano.addNode(new Node(ligne_Mtht_nodeid));
//				ano.addNode(new Node(ligne_Mttva_nodeid));
				ano.addAll(anonodes);
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}
	
	private boolean contains (String[] tab, String val) {
		if(val==null || val.length()==0) return true;
		if(tab==null || tab.length==0) return false;
		double dVal = Double.parseDouble(val); 
		for (String el:tab) {
			/**
			 * Il faut que si l'on compare 19.6 et 19.60, l'galit soit vraie.
			 */
			// la comparaison de chaines n'est pas adapte
			//if(el.equals(val)) return true;
			double dEl = Double.parseDouble(el);
			if (dEl == dVal) return true;
		}
		return false;
	}

	private boolean containsMajoMino (String[] tab, String val) {
		if(val==null || val.length()==0) return true;
		if(tab==null || tab.length==0) return false;
		double dVal = Double.valueOf(val);
		for (String el:tab) {
			try {
				double tx = Double.valueOf(el)/100.0;
				double marge_erreur = tx/100.0; // divis par 100 pour l'avoir en pourcentage et par 100 pour ne prendre qu'1 % de marge
				if ((dVal >= (tx-marge_erreur)) && (dVal <= (tx+marge_erreur))) return true;
			} catch (Exception e) {
				
			}
		}
		return false;
	}

	private double txMinor (double tx) {
		double marge_erreur = tx/100.0; // divis par 100 pour ne prendre qu'1 % de marge
		return (tx-marge_erreur);
	}
	private double txMajor (double tx) {
		double marge_erreur = tx/100.0; // divis par 100 pour ne prendre qu'1 % de marge
		return (tx+marge_erreur);
	}

	public void endDocument() throws SAXException {}
	
	public void characters(char[] ch, int start, int length, String xpath) {}
	
	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}
	
	public void startPrefixMapping(String prefix, String uri, String xpath) {}
	
	public void endPrefixMapping(String prefix, String xpath) {}
	
	public void processingInstruction(String target, String data, String xpath) {}
	
	public void skippedEntity(String name, String xpath) {}
	
	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}
	
	public void setDocumentLocator(Locator locator) {}
}
