/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC16
 * 
 * Contrle sur l'existence du code produit
 * 
 * Les produits sont paramtrs aussi bien au niveau national qu'au niveau local et peuvent tre fournis par l'ordonnateur. 
 * Il existe une table de correspondance entre les codes produits locaux et les codes produits nationaux.
 * 
 * Pour toutes les lignes, vrifier que le BlocLignePiece/ InfoLignePiece/ CodProdLoc[@V] appartienne  PAR1.
 * Pour la M21, la Balise piece/ CodProd[@V] doit avoir une valeur comprise entre 0 et 9 inclu. (Comme pour Htitre).
 * 
 */
public class REC16 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC16.class);
	public static final transient String CTRL_ID = "REC16";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;
	

	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String FIN_INFOLIGNEPCE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;


	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_CodProd = "";
	private String lignepiece_id = "";
	private String piece_IdPce_NodeId = "";
	private String piece_CodProd_NodeId = "";
	private String lignepiece_CodProdLoc = "";
	private String lignepiece_NodeIdCodProdLoc = "";
	private String lignepiece_id_NodeId = "";

	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_NUM = "#LIGNE_NUM#";
	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	private static final String CHEMIN_BLOCPIECE_CODPROD = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/CodProd/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String CHEMIN_BLOCLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_BLOCLIGNEPIECE_CODPRODLOC = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CodProdLoc/";


	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {

		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_PIECE)) {
			piece_IdPce = lignepiece_CodProdLoc = piece_CodProd = piece_CodProd_NodeId = "";
			lignepiece_NodeIdCodProdLoc = piece_IdPce_NodeId = "";
			anos = new Vector<Anomalie>();
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_CODPROD)){
			piece_CodProd = atts.getValue("V");
			piece_CodProd_NodeId = atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)){
			piece_IdPce=atts.getValue("V");
			piece_IdPce_NodeId = atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE)){
			lignepiece_id = lignepiece_CodProdLoc = "";
			lignepiece_NodeIdCodProdLoc = lignepiece_id_NodeId = "";
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_CODPRODLOC)){
			lignepiece_CodProdLoc=atts.getValue("V");
			lignepiece_NodeIdCodProdLoc=atts.getValue("ano:node-id");
		}
		if(xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_IDLIGNE)){
			lignepiece_id=atts.getValue("V");
			lignepiece_id_NodeId = atts.getValue("ano:node-id");
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		if(xpath.endsWith(FIN_INFOLIGNEPCE)){
			boolean err = false;
			String[] par1 = (String[])hParams.get("codProd");
			try {
				err = true;
				if (par1!=null && par1.length>0) {
					for (String s:par1) {
						if (s.equals(lignepiece_CodProdLoc)) err = false;
					}
				}
			} catch (Exception e) {
				err = true;
			}
			if (err){
			
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken(); msg = st.nextToken();
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_NUM, lignepiece_id);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId",piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				
				if (lignepiece_CodProdLoc.equals(""))
					ano.addNode(new Node (lignepiece_id_NodeId));
				else ano.addNode(new Node (lignepiece_NodeIdCodProdLoc));
				anos.add(ano);
			
			} return null;
			
			
		} else if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
			boolean err = false;
			
			if ( ("M21".equals((String)hParams.get("nomencl"))) && piece_CodProd.equals("") )
				err = true;
			
			else if ( ("M21".equals((String)hParams.get("nomencl"))) && ((Integer.parseInt(piece_CodProd)<0) || (Integer.parseInt(piece_CodProd)>9)) )
				err = true;
			
			if (err){
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();						
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Mandat "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId",piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				
				if (piece_CodProd.equals(""))
					ano.addNode(new Node (piece_IdPce_NodeId));
				else ano.addNode(new Node (piece_CodProd_NodeId));
				anos.add(ano);
			}
			return anos;
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
