/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;


import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC13
 * 
 * Contrle de l'unicit du compte de tiers pour les titres se rattachant au mme code produit
 * 
 * Pour les nomenclatures autres que la M21,
 * pour les titres typs  Titre rcapitulatif avec rle  (TypPce=06), 
 * toutes les lignes ayant le mme code produit BlocLignePiece/ InfoLignePiece/ CodProdLoc[@V] (sauf 0000) 
 * doivent avoir le mme compte de tiers (BlocLignePiece/ InfoLignePiece/ CpteTiers[@V])
 * 
 * Pour la M21,
 * toutes les lignes doivent avoir le mme compte de tiers (BlocLignePiece/ InfoLignePiece/ CpteTiers[@V])
 * 
 */

public class REC13 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC13.class);
	public static final transient String CTRL_ID = "REC13";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;

	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String nodeId = null;

	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String FIN_INFO_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;


	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";

	private String piece_IdPce = "";
	private String piece_TypPce = "";
	private String line_Id = "";
	
	private String ligne_CodProdLoc = "";
	private String ligne_CpteTiers = "";
	private String ligne_NodeIdCodProdLoc = "";
	private String ligne_NodeIdCpteTiers = "";
	
	private Hashtable<String, Hashtable<String,Vector<String>>> codProdCpteTiers = new Hashtable<String, Hashtable<String,Vector<String>>>();
	private Hashtable<String,Vector<String>> cpteTiers = new Hashtable<String,Vector<String>>();
	Vector<Node> anonodes = new Vector<Node>();
	
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_DETAIL = "#DETAIL_MSG#";

	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Dpenses uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";

	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	
	private static final String CHEMIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
	private static final String CHEMIN_LIGNE_CODPRODLOC = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CodProdLoc/";
	private static final String CHEMIN_LIGNE_CPTETIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CpteTiers/";

	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		if (xpath.endsWith(CHEMIN_PIECE)) {
			anos.clear();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
			piece_IdPce = piece_TypPce = "";
			if (!codProdCpteTiers.isEmpty())
				codProdCpteTiers = new Hashtable<String, Hashtable<String,Vector<String>>>();
			if(!cpteTiers.isEmpty())
				cpteTiers = new Hashtable<String,Vector<String>>();
			if (!anonodes.isEmpty())
				anonodes = new Vector<Node>();
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
			piece_IdPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
			piece_TypPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_LIGNE)) {
			ligne_CodProdLoc = ligne_CpteTiers = "";
			ligne_NodeIdCodProdLoc = ligne_NodeIdCpteTiers = "";
		}
		if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
			line_Id = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_LIGNE_CODPRODLOC)) {
			ligne_CodProdLoc = atts.getValue("V");
			ligne_NodeIdCodProdLoc = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_LIGNE_CPTETIERS)) {
			ligne_CpteTiers = atts.getValue("V");
			ligne_NodeIdCpteTiers = atts.getValue("ano:node-id");
		}
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		boolean param = "M21".equals((String)hParams.get("nomencl"));
		
		if (xpath.endsWith(FIN_INFO_LIGNEPIECE)) {	
			
			//L'lment CpteTiers n'tant pas obligatoire, il faut tester sa valeur
			if (ligne_CpteTiers.equals("") || ligne_CpteTiers == null)
				ligne_CpteTiers = "manquant";
			
			
			if (!param){
				
				if ("06".equals(piece_TypPce) && !"0000".equals(ligne_CodProdLoc)) {
					Hashtable<String,Vector<String>> h = codProdCpteTiers.get(ligne_CodProdLoc);
					if (h==null) {
						h = new Hashtable<String,Vector<String>>();
						codProdCpteTiers.put(ligne_CodProdLoc, h);
					}
					
					Vector<String> v = h.get(ligne_CpteTiers);
					if (v==null) {
						v = new Vector<String>();
						h.put(ligne_CpteTiers, v);
					}
						//L'lment CpteTiers n'tant pas obligatoire, il faut tester la valeur de ligne_NodeIdCpteTiers
						if (ligne_NodeIdCpteTiers.equals("")) ligne_NodeIdCpteTiers = " ";
					v.add(ligne_NodeIdCodProdLoc+"|"+ligne_NodeIdCpteTiers+"|"+line_Id);
				}
			}
			
			else {
					Vector<String> v2 = cpteTiers.get(ligne_CpteTiers);
					if (v2==null) {
						v2 = new Vector<String>();
						cpteTiers.put(ligne_CpteTiers,v2);
					}
						//L'lment CpteTiers n'tant pas obligatoire, il faut tester la valeur de ligne_NodeIdCpteTiers
						if (ligne_NodeIdCpteTiers.equals("")) ligne_NodeIdCpteTiers = " ";
					v2.add(ligne_NodeIdCpteTiers+"|"+line_Id);
			}
			
			return null;
		}
		
		else if(xpath.endsWith(ON_RETURN_ANOMALIES)){
			if (!param){
				
				for (Enumeration<String> e=codProdCpteTiers.keys(); e.hasMoreElements();) {
					String keyCodProdLoc = e.nextElement();
					Hashtable<String,Vector<String>> h = codProdCpteTiers.get(keyCodProdLoc);
					if (h.keySet().size()>1) {
						StringBuffer msgListe = new StringBuffer();
						Vector<Node> anonodes = new Vector<Node>();
						for (Enumeration<String> e1=h.keys(); e1.hasMoreElements();) {
							String keyCpteTiers = e1.nextElement();
							for (String s:h.get(keyCpteTiers)) {
								String _ligne_CodProdLoc = keyCodProdLoc;
								String _ligne_CpteTiers = keyCpteTiers;
								StringTokenizer st = new StringTokenizer(s, "|");
								String _ligne_NodeIdCodProdLoc = st.nextToken();
								String _ligne_NodeIdCpteTiers = st.nextToken();
								String _line_Id = st.nextToken();
								
								msgListe.append("&lt;li&gt;Ligne N ").append (_line_Id).append (" Code Produit Loc N ").append(_ligne_CodProdLoc).append(" Compte de Tiers N ").append(_ligne_CpteTiers).append("&lt;/li&gt;");
								anonodes.add (new Node(_ligne_NodeIdCodProdLoc));
							}
						}		
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
						msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
						msg = msg.replaceAll(MSG_DETAIL, msgListe.toString());
						String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId","");
						xslParams.put("mandatId",piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_RECETTE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								getDocumentModel().getControlById(CTRL_ID).getSeverity(),
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(anonodes);
						anos.add(ano);
					}
				}
			}
			
			else {
					if (cpteTiers.keySet().size()>1) {
						StringBuffer msgListe = new StringBuffer();
						Vector<Node> anonodes = new Vector<Node>();
						for (Enumeration<String> e=cpteTiers.keys(); e.hasMoreElements();) {
							String keyCpteTiers = e.nextElement();
							for (String s:cpteTiers.get(keyCpteTiers)) {
								String _ligne_CpteTiers = keyCpteTiers;
								StringTokenizer st = new StringTokenizer(s, "|");
								String _ligne_NodeIdCpteTiers = st.nextToken();
								String _line_Id = st.nextToken();

								
								msgListe.append("&lt;li&gt;Ligne N ").append (_line_Id).append(" Compte de Tiers N ").append(_ligne_CpteTiers).append("&lt;/li&gt;");
								anonodes.add (new Node(_ligne_NodeIdCpteTiers));
							}
						}		
						String msg = getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
						msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
						msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
						msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
						msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
						msg = msg.replaceAll(MSG_DETAIL, msgListe.toString());
						String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
						String anoId = IdGenerator.nextId();
						String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
						Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
						xslParams.put("elementId","");
						xslParams.put("mandatId",piece_IdPce);
						xslParams.put("browser-destination", "internal");
						xslParams.put("anoId", anoId);
						Anomalie ano = new Anomalie(anoId,
								getDocumentModel().getControlById(CTRL_ID).getId(),
								getDocumentModel().getControlById(CTRL_ID).getLibelle(),
								getDocumentModel().getDocumentId(),
								xpath.split("/")[1],
								BORDEREAU_RECETTE, // lment importable
								bord_IdBord, // id lment importable
								localName,
								libelleLien,
								msg,
								getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
								getDocumentModel().getControlById(CTRL_ID).getSeverity(),
								path, // xpath vers le bordereau sous lequel se trouve l'anomalie
								xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
						ano.addAll(anonodes);
						anos.add(ano);
					}							
			
			} return anos;
		}	
			else {
				return null;
			}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
