/*
 * Copyright 
 *   2005 axYus - www.axyus.com
 *   2005 N LE CORRE - nicolas.lecorre@axyus.com
 *   2008 C ESCOBAR - christel.escobar@axyus.com
 * 
 * This file is part of XEMELIOS.
 * 
 * XEMELIOS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * XEMELIOS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XEMELIOS; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;

/**
 * Implmente le contrle N REC10
 * 
 * Rgle de valorisation de la Nature de la pice
 * 
 * Pour chaque titre et chaque ligne :
 * 	1) Si typPce=02 alors le bloc RattachPiece est valoris
 *	2) Si PAR1 parmi (M4 -M14 -M21 -M52 -M61 - M31 - M71) et TypPce=04 alors CpteTiers valoris et IdRegie, IdMarche, IdEncaissement et IdRol  vide
 *	3) Si typPce=05 alors le bloc RattachPiece est valoris
 *	4) Si typPce=06 alors Piece/ BlocPiece/ IdRol est valoris
 *	5) Si typPce=11 alors le bloc RattachPiece est valoris
 *	6) Si NatPce=05 alors Piece/ LigneDePiece/ BlocLignePiece/ LiensIdent/ IdRegie est valoris
 *	7) Si NatPce=11 alors Piece/ LigneDePiece/ BlocLignePiece/ LiensIdent/ IdMarche est valoris
 *	8) Si NatPce=07 alors Piece/ LigneDePiece/ BlocLignePiece/ RattachPiece est valoris et ExerRat=Exer.
 * 
 */

public class REC10 extends AbstractUnitControl implements ConstantsControlsPESv2 {
	private final static Logger logger = Logger.getLogger(REC10.class);
    public static final transient String CTRL_ID="REC10";
	private Vector<Anomalie> anos = new Vector<Anomalie>();
	private Hashtable<String,Object> hParams;
	
	private static final String nomenclatureAutorisee = "-M4-M14-M21-M52-M61-M31-M71";
	/**
	 * La balise du document gnral
	 */
	private String docId = null;
	private String piece_NodeIdPce = null;

	/**
	 * La chaine cible
	 */
	private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String ON_RETURN_ANOMALIES = FIN_PIECE;
	

	/**
	 * Variables contenant les valeurs ncessaires  ce contrle
	 */

	private String bord_IdBord = "";
	private String bord_ExerBord = "";
	private String bord_TypBord = "";
	private String piece_IdPce = "";
	private String piece_typPce = "";
	private String piece_natPce = "";
	private String piece_idRol = "";
	private String lignepiece_idLigne = "";

	private String piece_idRol_nodeid = "";
	private String lignepiece_nodeid = "";
	private String piece_IdPce_nodeId = "";
		
//	private boolean premiere_ligne = true;	
	private boolean rattachpiece_exists = false;
	
	private String lienident_idRegie = "";
	private String lienident_idRegie_nodeid = "";
	private String lienident_idMarche = "";
	private String lienident_idMarche_nodeid = "";
	private String lienident_idEncaissement = "";
	private String lienident_idEncaissement_nodeid = "";
		
	private String rattachpiece_exerRat = "";
	private String rattachpiece_exerRat_nodeid = "";
        
    private String infolignepiece_cpteTiers = "";
	


    
    
	/**
	 * Variables devant tre remplaces dans le message
	 */
	private static final String MSG_BORD_NUM = "#BORD_NUM#";
	private static final String MSG_BORD_EXER = "#BORD_EXER#";
	private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
	private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
	private static final String MSG_LIGNE_ID = "#PIECE_IDLIGNE#";
	private static final String MSG_ERREUR = "#ERREUR#";

	/**
	 * Chemins incomplet vers les divers lments que l'on veux lire. Ils sont incomplets dans la mesure 
	 * o on n'a pas le dbut du chemin, vu que ce contrle est utilis pour les Recettes uniquement
	 */
	private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
	private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
	private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
	private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
	
	private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
	private static final String CHEMIN_BLOCPIECE_TYPPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
	private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
	private static final String CHEMIN_BLOCPIECE_NATPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
	private static final String CHEMIN_BLOCPIECE_IDROL = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdRol/";
	               
	private static final String CHEMIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
	private static final String CHEMIN_LIGNE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    
	private static final String CHEMIN_LIENIDENT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/LiensIdent/";
	private static final String CHEMIN_LIENIDENT_IDREGIE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/LiensIdent/IdRegie/";
	private static final String CHEMIN_LIENIDENT_IDMARCHE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/LiensIdent/IdMarche/";
	private static final String CHEMIN_LIENIDENT_IDENCAISSEMENT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/LiensIdent/IdEncaissement/";
		
	private static final String CHEMIN_RATTACHPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/RattachPiece/";
	private static final String CHEMIN_RATTACHPIECE_EXERRAT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/RattachPiece/ExerRat/";

    private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String CHEMIN_INFOLIGNEPIECE_CPTETIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CpteTiers/";


	public void startDocument() throws SAXException {
		logger.info("In "+CTRL_ID);
	}

	public void setDocId(String docID) {
		this.docId = docID;		
	}

	public void startElement(String uri, String localName, String qName,Attributes atts, String xpath) {
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
			bord_ExerBord = bord_IdBord = bord_TypBord = "";
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
			bord_ExerBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
			bord_IdBord = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
			bord_TypBord = atts.getValue("V");
		}
		
		if (xpath.endsWith(CHEMIN_PIECE)) {
			anos = new Vector<Anomalie>();
			piece_IdPce = piece_natPce = piece_idRol = piece_typPce = "";
			piece_idRol_nodeid = "";
			piece_NodeIdPce = atts.getValue("ano:node-id");
//			premiere_ligne = true;
			rattachpiece_exists = false;
			lienident_idEncaissement = lienident_idMarche = lienident_idRegie = "";
			lienident_idEncaissement_nodeid = lienident_idMarche_nodeid = lienident_idRegie_nodeid = "";
			rattachpiece_exerRat = "";
			rattachpiece_exerRat_nodeid = "";
		}
		if (xpath.endsWith(CHEMIN_LIGNE_IDLIGNE)) {
			lignepiece_idLigne = atts.getValue("V");
			lignepiece_nodeid = atts.getValue("ano:node-id");				
			rattachpiece_exerRat = "";
			rattachpiece_exerRat_nodeid = "";
			rattachpiece_exists = false;
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPCE)) {
			piece_typPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
			piece_IdPce = atts.getValue("V");
			piece_IdPce_nodeId = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPCE)) {			
			piece_natPce = atts.getValue("V");
		}
		if (xpath.endsWith(CHEMIN_BLOCPIECE_IDROL)) {
			piece_idRol = atts.getValue("V");
			piece_idRol_nodeid = atts.getValue("ano:node-id");			
		}
		if (xpath.endsWith(CHEMIN_LIENIDENT)) {
			lienident_idEncaissement = lienident_idMarche = lienident_idRegie = "";
			lienident_idEncaissement_nodeid = lienident_idMarche_nodeid = lienident_idRegie_nodeid = "";
		}
		if (xpath.endsWith(CHEMIN_LIENIDENT_IDENCAISSEMENT)) {
			lienident_idEncaissement = atts.getValue("V");
			lienident_idEncaissement_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_LIENIDENT_IDMARCHE)) {
			lienident_idMarche = atts.getValue("V");
			lienident_idMarche_nodeid = atts.getValue("ano:node-id");
		}
		if (xpath.endsWith(CHEMIN_LIENIDENT_IDREGIE)) {
			lienident_idRegie = atts.getValue("V");
			lienident_idRegie_nodeid = atts.getValue("ano:node-id");
		}			
		if (xpath.endsWith(CHEMIN_RATTACHPIECE)) {
			rattachpiece_exists = true;
			rattachpiece_exerRat = "";
			rattachpiece_exerRat_nodeid = "";
		}
		if (xpath.endsWith(CHEMIN_RATTACHPIECE_EXERRAT)) {
			rattachpiece_exerRat = atts.getValue("V");
			rattachpiece_exerRat_nodeid = atts.getValue("ano:node-id");
		}
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)){
            infolignepiece_cpteTiers = "";
        }
    	if(xpath.endsWith(CHEMIN_INFOLIGNEPIECE_CPTETIERS)){
            infolignepiece_cpteTiers = atts.getValue("V");
        }                       		
	}


	public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
		String severite = getDocumentModel().getControlById(CTRL_ID).getSeverity(); //BLOQUANT
		Vector<Node> anonodes = new Vector<Node>();
		
		if (xpath.endsWith(CHEMIN_LIGNE)) {
//			premiere_ligne = false;
			
			boolean err = false;
			boolean err2 = false;
			String erreur = "";
			String nomencl = (String)hParams.get("nomencl");

			
			// 1) Si typPce=02 alors le bloc RattachPiece est valoris
			if ("02".equals(piece_typPce) && !rattachpiece_exists){
				err = true;
				anonodes.add(new Node(lignepiece_nodeid));
				severite = "NON BLOQUANT";
				erreur = "Pour un titre correctif, on doit indiquer la pice de rattachement";
			}

			// 2) Si PAR1 parmi (M4 -M14 -M21 -M52 -M61 - M31 - M71) et TypPce=04 alors CpteTiers valoris et IdRegie, IdMarche, IdEncaissement et IdRol  vide
			if (nomenclatureAutorisee.indexOf(nomencl)!=-1 && "04".equals(piece_typPce) && 
					(("".equals(infolignepiece_cpteTiers)) || !lienident_idEncaissement.equals("") || !lienident_idMarche.equals("") || !lienident_idRegie.equals("") || !piece_idRol.equals(""))) {
				err = true;
				
				if ("".equals(infolignepiece_cpteTiers))
					anonodes.add(new Node(lignepiece_nodeid));
				
				anonodes.add(new Node(lienident_idEncaissement_nodeid));
				anonodes.add(new Node(lienident_idMarche_nodeid));
				anonodes.add(new Node(lienident_idRegie_nodeid));
				anonodes.add(new Node(piece_idRol_nodeid));
				
				severite = "NON BLOQUANT";
				erreur = "Pour les titres d'ordre mixte, le compte de tiers doit tre valoris. Aucun identifiant rgie, march, encaissement ou rle ne doit tre valoris";
			}
			
			// 3) Si typPce=05 alors le bloc RattachPiece est valoris
			if ("05".equals(piece_typPce) && !rattachpiece_exists) {
				err = true;
				anonodes.add(new Node(lignepiece_nodeid));
				severite = "NON BLOQUANT";
				
				if (!lienident_idEncaissement.equals(""))
					erreur = "Pour les titres mis aprs encaissement, le bloc de rattachement doit tre valoris et non l'IdEncaissement";
				else 
					erreur = "Pour les titres mis aprs encaissement, le bloc de rattachement de pice doit tre valoris";
			}
			
			
			// 5) Si typPce=11 alors le bloc RattachPiece est valoris
			if ("11".equals(piece_typPce) && !rattachpiece_exists){
				err = true;
				anonodes.add(new Node(lignepiece_nodeid));		
				erreur = "Lorsqu'il s'agit d'un titre de rattachement alors le bloc RattachPiece doit tre valoris";				
			}

			if (err) {
				
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();

				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_ID, lignepiece_idLigne);
				msg = msg.replaceAll(MSG_ERREUR, erreur);
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						severite,
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addAll(anonodes);
				anos.add(ano);
				anonodes.clear();
			}
			
			
			// 6) Si NatPce=05 alors Piece/ LigneDePiece/ BlocLignePiece/ LiensIdent/ IdRegie est valoris
			if ("05".equals(piece_natPce) && ("".equals(lienident_idRegie))) {	
				err2 = true;
				anonodes.add(new Node(lignepiece_nodeid));
				erreur = "Si la nature de pice est rgie alors la balise IdRegie doit tre valorise";
			}

				
			// 7) Si NatPce=11 alors Piece/ LigneDePiece/ BlocLignePiece/ LiensIdent/ IdMarche est valoris
			if ("11".equals(piece_natPce) && ("".equals(lienident_idMarche))) {	
				err2 = true;
				anonodes.add(new Node(lignepiece_nodeid));
				erreur = "Pour les titres sur march, l'identifiant march doit tre valoris";
			}
			
								
			// 8) Si NatPce=07 alors Piece/ LigneDePiece/ BlocLignePiece/ RattachPiece est valoris et ExerRat=Exer
			if ("07".equals(piece_natPce) && (!rattachpiece_exists || !bord_ExerBord.equals(rattachpiece_exerRat))) {				
				err2 = true;
				
				if (!rattachpiece_exists)
					anonodes.add(new Node(lignepiece_nodeid));
				else
					anonodes.add(new Node(rattachpiece_exerRat_nodeid));
				
				erreur = "Pour les titres complmentaires, le bloc RattachPiece doit tre valoris et l'exercice de rattachement doit tre gal  celui du bordereau";
			}
				
			if (err2){
				
				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();msg = st.nextToken();
				
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_LIGNE_ID, lignepiece_idLigne);
				msg = msg.replaceAll(MSG_ERREUR, erreur);

				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addAll(anonodes);
				anos.add(ano);	
			}
			
			
			return null;
		}
		else if(xpath.endsWith(ON_RETURN_ANOMALIES)){

			
			// 4) Si typPce=06 alors Piece/ BlocPiece/ IdRol est valoris
			if ("06".equals(piece_typPce) && ("".equals(piece_idRol))) {

				StringTokenizer st = new StringTokenizer (getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent(), "|");
				String msg = st.nextToken();
							
				msg = msg.replaceAll(MSG_BORD_NUM, bord_IdBord);
				msg = msg.replaceAll(MSG_BORD_EXER, bord_ExerBord);
				msg = msg.replaceAll(MSG_BORD_TYPE, bord_TypBord);
				msg = msg.replaceAll(MSG_PIECE_ID, piece_IdPce);
				msg = msg.replaceAll(MSG_ERREUR, "Si le titre est un titre rcapitulatif avec rle alors le numro de rle doit tre renseign");
				
				String path="@added:primary-key='"+bord_ExerBord+"-"+bord_TypBord+"-"+bord_IdBord+"'";
				String anoId = IdGenerator.nextId();
				String libelleLien = "Bordereau "+bord_IdBord+" Titre "+piece_IdPce;
				Hashtable<String, Object> xslParams = new Hashtable<String, Object>();
				xslParams.put("elementId","");
				xslParams.put("mandatId", piece_IdPce);
				xslParams.put("browser-destination", "internal");
				xslParams.put("anoId", anoId);
				Anomalie ano = new Anomalie(anoId,
						getDocumentModel().getControlById(CTRL_ID).getId(),
						getDocumentModel().getControlById(CTRL_ID).getLibelle(),
						getDocumentModel().getDocumentId(),
						xpath.split("/")[1],
						BORDEREAU_RECETTE, // lment importable
						bord_IdBord, // id lment importable
						localName,
						libelleLien,
						msg,
						getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(),
						getDocumentModel().getControlById(CTRL_ID).getSeverity(),
						path, // xpath vers le bordereau sous lequel se trouve l'anomalie
						xslParams); // paramtres supplmentaires pour accder  l'lment en anomalie
				ano.addNode(new Node(piece_IdPce_nodeId));
				anos.add(ano);
				
			}
			
			return anos;
			
		} else {
			return null;
		}
	}

	public void endDocument() throws SAXException {}

	public void characters(char[] ch, int start, int length, String xpath) {}

	public void ignorableWhitespace(char[] ch, int start, int length,String xpath) {}

	public void startPrefixMapping(String prefix, String uri, String xpath) {}

	public void endPrefixMapping(String prefix, String xpath) {}

	public void processingInstruction(String target, String data, String xpath) {}

	public void skippedEntity(String name, String xpath) {}

	public void setParameters(Hashtable<String,Object> params) {
		this.hParams=params;
	}

	public void setDocumentLocator(Locator locator) {}
}
