/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.MYSQL_FIELD;
import com.mysql.embedded.api.api;
import com.mysql.embedded.jdbc.MySqlTypes;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MyResultSetMetaData
implements ResultSetMetaData {
    protected long resHandle;
    protected MYSQL_FIELD[] fields;
    protected boolean deallocHandle;

    protected MyResultSetMetaData(long resHandle, int columnCount, boolean deallocHandle) {
        this.resHandle = resHandle;
        this.deallocHandle = deallocHandle;
        this.fields = MYSQL_FIELD.newArray(api.mysql_fetch_fields(resHandle), columnCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        try {
            if (this.resHandle != 0L && this.deallocHandle) {
                api.mysql_free_result(this.resHandle);
            }
        }
        finally {
            this.resHandle = 0L;
        }
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.fields[column - 1].getMaxLength();
    }

    public int getMySqlColumnType(int column) {
        return this.fields[column - 1].getType();
    }

    public int getColumnType(int column) throws SQLException {
        int mysql_type = this.fields[column - 1].getType();
        return MySqlTypes.asJavaType(mysql_type);
    }

    public int getLength(int column) {
        return this.fields[column - 1].getLength();
    }

    public int getPrecision(int column) {
        return this.fields[column - 1].getDecimals();
    }

    public int getScale(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int isNullable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSigned(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCatalogName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnClassName(int column) throws SQLException {
        return MySqlTypes.getJavaClassName(this.getColumnType(column));
    }

    public String getColumnLabel(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnName(int column) throws SQLException {
        return this.fields[column - 1].getName();
    }

    public String getColumnTypeName(int column) throws SQLException {
        int mysql_type = this.fields[column - 1].getType();
        return MySqlTypes.getMysqlTypeName(mysql_type);
    }

    public String getSchemaName(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getTableName(int column) throws SQLException {
        return this.fields[column - 1].getTable();
    }

    protected int findColumn(String columnName) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        return -1;
    }
}

