/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.MYSQL_TIME;
import com.mysql.embedded.api.api;
import com.mysql.embedded.jdbc.MyCallableStatement;
import com.mysql.embedded.jdbc.MyDatabaseMetaData;
import com.mysql.embedded.jdbc.MyPreparedStatement;
import com.mysql.embedded.jdbc.MySqlEmbeddedDriver;
import com.mysql.embedded.jdbc.MySqlTypes;
import com.mysql.embedded.jdbc.MyStatement;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MyConnection
implements Connection {
    public long connectionHandle;
    protected boolean autoCommit;
    protected SQLWarning warning;
    protected MyStatement currentStatement;
    protected HashSet preparedStatements;
    protected int maxRows = 0;
    protected Calendar utcCalendar;
    protected SimpleDateFormat timeFormat;
    protected SimpleDateFormat dateFormat;
    protected SimpleDateFormat timestampFormat;
    protected SimpleDateFormat yearFormat;
    protected Charset charset;
    protected CharsetEncoder charEncoder;
    protected CharsetDecoder charDecoder;
    protected CharBuffer charBuffer;
    protected Charset isoCharset;
    protected CharsetDecoder isoDecoder;
    protected ByteBuffer bbuffer;
    protected ShortBuffer sbuffer;
    protected MYSQL_TIME mysqlTime;
    protected static Set threads = new HashSet();
    protected int databaseMajorVersion = -1;

    public MyConnection(Properties info) throws SQLException {
        MyConnection.initThread();
        String database = info.getProperty("database");
        String user = info.getProperty("user");
        String password = info.getProperty("password");
        this.connectionHandle = api.mysql_init(0L);
        api.mysql_options(this.connectionHandle, 15, null);
        api.mysql_real_connect(this.connectionHandle, null, user, password, database, 0, null, 196736);
        this.utcCalendar = (Calendar)MySqlTypes.UTC_CALENDAR.clone();
        this.timeFormat = (SimpleDateFormat)MySqlTypes.TIME_FORMAT.clone();
        this.dateFormat = (SimpleDateFormat)MySqlTypes.DATE_FORMAT.clone();
        this.timestampFormat = (SimpleDateFormat)MySqlTypes.TIMESTAMP_FORMAT.clone();
        this.yearFormat = (SimpleDateFormat)MySqlTypes.YEAR_FORMAT.clone();
        this.mysqlTime = new MYSQL_TIME();
        this.charset = Charset.forName("UTF-8");
        this.charEncoder = this.charset.newEncoder();
        this.charDecoder = this.charset.newDecoder();
        this.isoCharset = Charset.forName("ISO-8859-1");
        this.isoDecoder = this.isoCharset.newDecoder();
        this.bbuffer = ByteBuffer.allocateDirect(64);
        this.bbuffer.order(ByteOrder.nativeOrder());
        this.sbuffer = this.bbuffer.asShortBuffer();
        this.preparedStatements = new HashSet();
    }

    public static void initThread() throws SQLException {
        Thread thr = Thread.currentThread();
        if (!threads.contains(thr)) {
            api.my_thread_init();
            threads.add(thr);
        }
    }

    public static void endThread() {
        Thread thr = Thread.currentThread();
        if (threads.contains(thr)) {
            api.my_thread_end();
            threads.remove(thr);
        }
    }

    public int getDatabaseMajorVersion() {
        if (this.databaseMajorVersion < 0) {
            this.databaseMajorVersion = api.mysql_get_server_version(this.connectionHandle);
        }
        return this.databaseMajorVersion;
    }

    public Statement createStatement() throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        MyStatement stm = new MyStatement(this, 1003, 1007, 2);
        return stm;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        MyPreparedStatement pstm = new MyPreparedStatement(this, sql, 1003, 1007, 2);
        return pstm;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007, 2);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyStatement(this, resultSetType, resultSetConcurrency, 2);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyPreparedStatement(this, sql, resultSetType, resultSetConcurrency, 2);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 2);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String nativeSQL(String sql) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        String result = api.mysql_odbc_escape_string(this.connectionHandle, sql, 0L);
        result = api.mysql_real_escape_string(this.connectionHandle, result);
        return result;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        if (autoCommit != this.autoCommit) {
            this.autoCommit = autoCommit;
            api.mysql_autocommit(this.connectionHandle, autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (!this.autoCommit) {
            this.useStatement(null);
            api.mysql_commit(this.connectionHandle);
        }
    }

    public void rollback() throws SQLException {
        if (!this.autoCommit) {
            this.useStatement(null);
            api.mysql_rollback(this.connectionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.killQuery();
        try {
            this.useStatement(null);
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        Iterator i = this.preparedStatements.iterator();
        while (i.hasNext()) {
            MyPreparedStatement pstm = (MyPreparedStatement)i.next();
            i.remove();
            pstm.close();
        }
        try {
            api.mysql_close(this.connectionHandle);
        }
        finally {
            this.connectionHandle = 0L;
            MySqlEmbeddedDriver.notifyClosed(this);
        }
    }

    public void killQuery() {
        if (this.connectionHandle != 0L) {
            boolean version5;
            boolean bl = version5 = this.getDatabaseMajorVersion() >= 50000;
            if (version5) {
                api.kill_query(this.connectionHandle);
            }
        }
    }

    public void killConnection() {
        if (this.connectionHandle != 0L) {
            boolean version5;
            boolean bl = version5 = this.getDatabaseMajorVersion() >= 50000;
            if (version5) {
                api.kill_connection(this.connectionHandle);
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return this.connectionHandle == 0L;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        return new MyDatabaseMetaData(this);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (MySqlEmbeddedDriver.unix) {
            MyConnection.initThread();
        }
        api.mysql_select_db(this.connectionHandle, catalog);
    }

    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    public void clearWarnings() throws SQLException {
        this.warning = null;
    }

    public Map getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected boolean useStatement(MyStatement nextStatement) throws SQLException {
        if (this.currentStatement == nextStatement) {
            return true;
        }
        if (this.currentStatement != null && this.currentStatement.result != null && !this.currentStatement.result.stored) {
            this.currentStatement.cancel();
        }
        this.currentStatement = nextStatement;
        return false;
    }

    protected void setMaxRows(int rows) throws SQLException {
        if ((rows = Math.max(0, rows)) != this.maxRows) {
            this.maxRows = rows;
            if (this.maxRows > 0) {
                api.mysql_real_query(this.connectionHandle, "SET SQL_SELECT_LIMIT=" + this.maxRows);
            } else {
                api.mysql_real_query(this.connectionHandle, "SET SQL_SELECT_LIMIT=DEFAULT");
            }
        }
    }

    public CharBuffer getCharBuffer(int capacity) {
        if (this.charBuffer == null || this.charBuffer.capacity() < capacity) {
            this.charBuffer = CharBuffer.allocate(Math.max(capacity, 256));
        }
        this.charBuffer.position(0);
        this.charBuffer.limit(this.charBuffer.capacity());
        return this.charBuffer;
    }

    public String decodeString(ByteBuffer input, int len) {
        if (len == 0) {
            return "";
        }
        CharsetDecoder dec = this.charDecoder;
        CharBuffer output = this.getCharBuffer(len);
        input.position(0);
        input.limit(len);
        dec.reset();
        CoderResult result = dec.decode(input, output, true);
        if (result.isError() || result.isMalformed() || result.isUnmappable()) {
            dec = this.isoDecoder;
            output = this.getCharBuffer(len);
            input.position(0);
            input.limit(len);
            dec.reset();
            dec.decode(input, output, true);
        }
        dec.flush(output);
        output.limit(output.position());
        output.position(0);
        return output.toString();
    }

    protected void register(MyPreparedStatement pstm) {
        this.preparedStatements.add(pstm);
    }

    protected void unregister(MyPreparedStatement pstm) {
        this.preparedStatements.remove(pstm);
    }
}

