/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.data.ui.PatchProgress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RsaPatch40014 {
    public static final String MARKER = "rsa.patch.4.0.0.15.applied";
    private static final String NS_URI = "fr:gouv:finances:xemelios:internal";
    private static final Logger logger = Logger.getLogger(RsaPatch40014.class);
    private DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    XPathFactory xpf = null;
    private MySqlDataLayer impl = null;
    private TDocument tDoc = null;
    private DocumentModel documentModel = null;
    private EtatModel etatModel = null;
    private Connection updateCon = null;
    private Transformer identityTransformer = null;

    public RsaPatch40014(MySqlDataLayer impl) {
        this.domFactory.setNamespaceAware(true);
        this.impl = impl;
        try {
            this.identityTransformer = new TransformerFactoryImpl().newTransformer();
            this.identityTransformer.setOutputProperty("encoding", "ISO-8859-1");
            this.identityTransformer.setOutputProperty("indent", "yes");
        }
        catch (Exception ex) {
            logger.error((Object)"while creating identityTransformer: ", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        PatchProgress pp;
        Connection con;
        block18: {
            block16: {
                block17: {
                    String pMarker = this.impl.getParameterValue(MARKER);
                    if (pMarker != null) {
                        if ("true".equals(pMarker)) return;
                    }
                    con = null;
                    pp = null;
                    try {
                        try {
                            con = PoolManager.getInstance().getConnection();
                            this.updateCon = PoolManager.getInstance().getConnection();
                            this.documentModel = Loader.getDocumentsInfos(null).getDocumentById("rsa");
                            if (this.documentModel == null) {
                                Object var13_4 = null;
                                if (con == null) break block16;
                                break block17;
                            }
                            this.etatModel = this.documentModel.getEtatById("InfosFinancieresFoyerRSA");
                            LocalUser user = new LocalUser();
                            this.tDoc = this.impl.getPersistenceConfig(this.documentModel, user).getLayer("mysql").getDocument(this.documentModel.getId());
                            Statement st = con.createStatement();
                            ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM " + this.tDoc.getEtat("InfosFinancieresFoyerRSA").getDocumentTable().getBaseName());
                            long nbRecords = 0L;
                            while (rs.next()) {
                                nbRecords = rs.getLong(1);
                            }
                            pp = this.impl.getPatchProgress();
                            pp.setMaxProgress(nbRecords);
                            this.xpf = new XPathFactoryImpl();
                            rs = st.executeQuery("SELECT " + this.tDoc.getCollectiviteCodeColname() + ", " + this.tDoc.getBudgetCodeColname() + ", DOC_ID FROM " + this.tDoc.getEtat("InfosFinancieresFoyerRSA").getDocumentTable().getBaseName());
                            pp.startProgress("Recalcul des totalisations du RSA");
                            while (rs.next()) {
                                String collectivite = rs.getString(1);
                                String budget = rs.getString(2);
                                String docId = rs.getString(3);
                                this.patchDocument(collectivite, budget, docId, user, pp);
                            }
                            this.impl.setParameterValue(MARKER, "true");
                            break block18;
                        }
                        catch (Exception ex) {
                            logger.info((Object)"in run()", (Throwable)ex);
                            Object var13_6 = null;
                            if (con != null) {
                                PoolManager.getInstance().releaseConnection(con);
                            }
                            if (this.updateCon != null) {
                                PoolManager.getInstance().releaseConnection(this.updateCon);
                            }
                            if (pp == null) return;
                            pp.endProgress();
                            this.impl.killPatchProgress();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_7 = null;
                        if (con != null) {
                            PoolManager.getInstance().releaseConnection(con);
                        }
                        if (this.updateCon != null) {
                            PoolManager.getInstance().releaseConnection(this.updateCon);
                        }
                        if (pp == null) throw throwable;
                        pp.endProgress();
                        this.impl.killPatchProgress();
                        throw throwable;
                    }
                }
                PoolManager.getInstance().releaseConnection(con);
            }
            if (this.updateCon != null) {
                PoolManager.getInstance().releaseConnection(this.updateCon);
            }
            if (pp == null) return;
            pp.endProgress();
            this.impl.killPatchProgress();
            return;
        }
        Object var13_5 = null;
        if (con != null) {
            PoolManager.getInstance().releaseConnection(con);
        }
        if (this.updateCon != null) {
            PoolManager.getInstance().releaseConnection(this.updateCon);
        }
        if (pp == null) return;
        pp.endProgress();
        this.impl.killPatchProgress();
    }

    private void patchDocument(String collectivite, String budget, String docId, XemeliosUser user, PatchProgress pp) throws Exception {
        Pair pColl = new Pair(collectivite, collectivite);
        Pair pBudg = new Pair(budget, budget);
        Document dom = this.impl.getDocumentAsDom(this.etatModel, pColl, pBudg, docId, user);
        XPath xp = this.xpf.newXPath();
        xp.setNamespaceContext((NamespaceContext)this.documentModel.getNamespaces());
        BigDecimal totalAmount = new BigDecimal("0.00");
        Element detailAcompte = (Element)xp.evaluate("/n:Racine/n:DemandesRSA/n:InfosFinancieresFoyerRSA/n:AcompteRSA/n:DetailAcompteRSA", dom, XPathConstants.NODE);
        if (detailAcompte == null) {
            throw new RuntimeException("Impossible de trouver le DetailAcompteRSA");
        }
        Object o = xp.evaluate("./*", detailAcompte, XPathConstants.NODESET);
        if (o instanceof List) {
            List list = (List)o;
            for (Element total : list) {
                BigDecimal typeAmount = new BigDecimal("0.00");
                List lignes = (List)xp.evaluate("./*", total, XPathConstants.NODESET);
                for (Element ligne : lignes) {
                    String sMt = ligne.getElementsByTagNameNS(NS_URI, "MTMOUCOMPTA").item(0).getTextContent().trim();
                    String sSens = ligne.getElementsByTagNameNS(NS_URI, "SENSOPECOMPTA").item(0).getTextContent().trim();
                    String nodeId = ligne.getAttributeNS("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "generated-id");
                    BigDecimal mt = new BigDecimal(sMt);
                    if ("DE".equals(sSens)) {
                        mt = mt.multiply(new BigDecimal(-1));
                    }
                    ligne.setAttributeNS("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "added:mt", mt.toPlainString());
                    this.updateIndexRow(collectivite, budget, docId, nodeId, mt);
                    typeAmount = typeAmount.add(mt);
                }
                total.setAttributeNS("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "added:somme", typeAmount.toPlainString());
                totalAmount = totalAmount.add(typeAmount);
            }
            detailAcompte.setAttributeNS("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "added:somme", totalAmount.toPlainString());
            StringBuilder sb = new StringBuilder();
            TEtat sec = this.tDoc.getEtat("InfosFinancieresFoyerRSA");
            sb.append("UPDATE ").append(sec.getDocumentTable().getBaseName()).append(" SET DOC=?, ENCODING=? WHERE " + this.tDoc.getBudgetCodeColname() + "=? AND " + this.tDoc.getCollectiviteCodeColname() + "=? AND DOC_ID=?");
            PreparedStatement ps = this.updateCon.prepareStatement(sb.toString());
            ps.setString(3, budget);
            ps.setString(4, collectivite);
            ps.setString(5, docId);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.identityTransformer.transform(new DOMSource(dom), new StreamResult(baos));
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            ps.setBinaryStream(1, (InputStream)is, baos.toByteArray().length);
            ps.setString(2, "ISO-8859-1");
            ps.executeUpdate();
            ps.close();
        }
        pp.pushProgress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIndexRow(String collectivite, String budget, String docId, String rowId, BigDecimal mt) throws Exception {
        Connection con = null;
        try {
            con = PoolManager.getInstance().getConnection();
            String sql = "UPDATE RSA_DEMANDES_DETAILALLIGNE_IX SET MTMOUCOMPTA=? WHERE COLLECTIVITE=? AND BUDGET=? AND DOC_ID=? AND NODE_ID=?";
            PreparedStatement ps = con.prepareStatement(sql);
            ps.setBigDecimal(1, mt);
            ps.setString(2, collectivite);
            ps.setString(3, budget);
            ps.setString(4, docId);
            ps.setString(5, rowId);
            int ret = ps.executeUpdate();
            if (ret != 1) {
                throw new RuntimeException("while patching row (" + collectivite + "," + budget + "," + docId + "," + rowId + ": " + ret + " rows updated !");
            }
            ps.close();
            Object var11_11 = null;
            if (con == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (con == null) throw throwable;
            PoolManager.getInstance().releaseConnection(con);
            throw throwable;
        }
        PoolManager.getInstance().releaseConnection(con);
    }

    private class LocalUser
    implements XemeliosUser {
        private LocalUser() {
        }

        public String getId() {
            return "admin";
        }

        public String getDisplayName() {
            return "rsa.patcher";
        }

        public boolean hasRole(String role) {
            return true;
        }

        public boolean hasDocument(String document) {
            return "rsa".equals(document);
        }

        public boolean hasCollectivite(String collectivite, DocumentModel dm) {
            return true;
        }
    }
}

