/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.MysqlDrsParser;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.UserModel;
import fr.gouv.finances.dgfip.utils.Amount;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.XWay;
import fr.gouv.finances.dgfip.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.XPathModel;
import fr.gouv.finances.dgfip.xemelios.data.CachedData;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.data.DocumentInfos;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TElement;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TSqlIndex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MySqlDataResultSet
implements DataResultSet,
XmlMarshallable {
    public static final QName QN = new QName("mysql-drs");
    private static Logger logger = Logger.getLogger(MySqlDataResultSet.class);
    private static final int CACHE_SIZE = 1;
    private EtatModel etatModel = null;
    private ElementModel elementModel = null;
    private Pair collectivite = null;
    private Pair budget = null;
    private String xPath = null;
    private String sql = null;
    private String whereClause = "";
    private String fromClause = "";
    private String selectClause = "";
    private MySqlDataLayer implementation = null;
    private int pageSize = 0;
    private int currentPage = 0;
    private ResultSet rs = null;
    private boolean hasNextPage = false;
    private boolean hasPreviousPage = false;
    private int estimatedSize = 0;
    private int estimatedPageCount = -1;
    private int estimatedMainElementSize = 0;
    private ListeResultatModel lrm = null;
    private CachedData cache = null;
    private DocumentCache documentCache = new DocumentCache(1);
    private ArrayList<String> docIds = null;
    private int currentDocIndex = -1;
    private Object currentList = null;
    private int currentItemInList = -1;
    private boolean hasNextItem = false;
    private String currentDocId = null;
    private XemeliosUser user;
    private XPathFactory xpf = null;
    private String documentId = null;
    private String etatId = null;
    private String elementId = null;

    public MySqlDataResultSet(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, String sql, ListeResultatModel lrm, MySqlDataLayer impl, XemeliosUser user) throws SQLException, DataConfigurationException {
        this();
        this.elementModel = elementModel;
        this.etatModel = elementModel.getParent();
        this.collectivite = collectivite;
        this.budget = budget;
        this.xPath = xPath;
        this.sql = sql;
        this.lrm = lrm;
        this.implementation = impl;
        this.pageSize = elementModel.getMaxDisplay();
        if (lrm == null) {
            logger.debug((Object)"lrm is null");
        } else if (lrm.getTriDefaut() == null) {
            logger.debug((Object)"lrm.getTriDefaut() id null");
        }
        this.loadIds();
    }

    public MySqlDataResultSet() {
        try {
            this.xpf = new XPathFactoryImpl();
        }
        catch (Throwable t) {
            logger.error((Object)"instanciating xpf:", t);
            this.xpf = XPathFactory.newInstance();
        }
        this.xpf.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
    }

    public MySqlDataResultSet(QName qn) {
        this();
    }

    public int getCount() {
        return this.docIds.size();
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    protected void loadIds() throws SQLException, DataConfigurationException {
        this.cleanAllCaches();
        StringBuilder currentRequest = new StringBuilder(this.sql);
        this.selectClause = this.sql.substring(0, this.sql.indexOf("FROM"));
        this.fromClause = this.sql.substring(this.sql.indexOf("FROM"), this.sql.indexOf("WHERE"));
        this.whereClause = this.sql.substring(this.sql.indexOf("WHERE"));
        TDocument spc = this.implementation.getPersistenceConfig(this.etatModel.getParent(), this.user).getLayer(this.implementation.getLayerName()).getDocument(this.etatModel.getParent().getId());
        TEtat sEtatc = spc.getEtat(this.etatModel.getId());
        TElement sec = sEtatc.getElement(this.elementModel.getId());
        if (sec != null && sec.getSpecialCond() != null) {
            String sCond = sec.getSpecialCond().trim();
            String tableName = sCond.substring(0, sCond.indexOf(46));
            if (this.fromClause.indexOf(tableName) < 0) {
                String sTmp = this.fromClause.substring("FROM".length()).trim();
                String mainTableName = null;
                mainTableName = sTmp.indexOf(32) >= 0 ? sTmp.substring(0, sTmp.indexOf(32)).trim() : sTmp;
                StringBuffer sb = new StringBuffer(this.fromClause);
                sb.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                this.fromClause = sb.toString();
                currentRequest = new StringBuilder();
                currentRequest.append(this.selectClause).append(this.fromClause).append(" ").append(this.whereClause);
            }
            currentRequest.append(" AND ").append(sCond);
        }
        if (this.lrm != null && this.lrm.getTriDefaut() != null) {
            String tris = this.lrm.getTriDefaut();
            String ordres = this.lrm.getOrdre();
            StringTokenizer trisTokenizer = new StringTokenizer(tris, ",");
            StringTokenizer ordresTokenizer = new StringTokenizer(ordres, ",");
            if (currentRequest.indexOf("ORDER BY") < 0) {
                currentRequest.append(" ORDER BY ");
            } else {
                currentRequest.append(", ");
            }
            while (trisTokenizer.hasMoreElements()) {
                ChampModel cm;
                String ordre;
                String tri = trisTokenizer.nextToken();
                String string = ordre = ordresTokenizer.hasMoreTokens() ? ordresTokenizer.nextToken() : "ASC";
                if (ordre == null || ordre.length() == 0) {
                    ordre = "ASC";
                }
                if ((cm = (ChampModel)this.lrm.getChamps().get(tri)) != null) {
                    String path = this.elementModel.getPath().getPath() + "/" + cm.getPath().getPath();
                    path = XWay.compactXPath((String)path);
                    try {
                        TSqlIndex si = sEtatc.getSqlIndexByPath(path);
                        if (si == null) {
                            logger.error((Object)("index not found for path " + path + "\n won't sort !"));
                            continue;
                        }
                        currentRequest.append(sEtatc.getIndexTable(si.getTableId()).getBaseName()).append(".").append(si.getColumn()).append(" ").append(ordre).append(",");
                        String tableName = sEtatc.getIndexTable(si.getTableId()).getBaseName();
                        if (this.fromClause.indexOf(tableName) >= 0) continue;
                        String sTmp = this.fromClause.substring("FROM".length()).trim();
                        String mainTableName = null;
                        mainTableName = sTmp.indexOf(32) >= 0 ? sTmp.substring(0, sTmp.indexOf(32)).trim() : sTmp;
                        StringBuffer sb = new StringBuffer(this.fromClause);
                        sb.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                        this.fromClause = sb.toString();
                        String saveOrderBy = currentRequest.toString();
                        saveOrderBy = saveOrderBy.substring(saveOrderBy.indexOf(" ORDER BY"));
                        currentRequest = new StringBuilder();
                        currentRequest.append(this.selectClause).append(this.fromClause).append(" ").append(this.whereClause).append(saveOrderBy);
                    }
                    catch (Throwable t) {}
                    continue;
                }
                throw new DataConfigurationException("order by clause of " + this.elementModel.getId() + " references an unknown champ :" + tri);
            }
            if (currentRequest.substring(currentRequest.length() - 1).equals(",")) {
                currentRequest.deleteCharAt(currentRequest.length() - 1);
            }
            if (currentRequest.substring(currentRequest.length() - 9).equals("ORDER BY ")) {
                currentRequest.delete(currentRequest.length() - 10, currentRequest.length());
            }
        }
        currentRequest.append(" LIMIT ").append(this.currentPage * this.pageSize).append(", ").append(this.pageSize);
        logger.debug((Object)currentRequest);
        Connection conToRelease = null;
        try {
            ResultSet rs2;
            String sTmp;
            this.rs = this.implementation.execute(currentRequest.toString());
            conToRelease = this.rs.getStatement().getConnection();
            this.docIds = new ArrayList();
            while (this.rs.next()) {
                this.docIds.add(this.rs.getString(1));
            }
            Statement st = this.rs.getStatement().getConnection().createStatement();
            String sqlCount = null;
            if (sec != null && (sTmp = sec.getSqlCount()) != null) {
                String tmp = currentRequest.toString();
                tmp = tmp.substring(tmp.indexOf("FROM"));
                String limitedFromClause = tmp.substring(0, tmp.indexOf("LIMIT"));
                sqlCount = "SELECT " + sTmp + " " + limitedFromClause;
            }
            if ((rs2 = st.executeQuery("SELECT FOUND_ROWS()")).next()) {
                this.estimatedMainElementSize = rs2.getInt(1);
            }
            if (sqlCount != null) {
                logger.debug((Object)("sqlCount=" + sqlCount));
                rs2 = st.executeQuery(sqlCount);
                this.estimatedSize = rs2.next() ? rs2.getInt(1) : this.estimatedMainElementSize;
            } else {
                this.estimatedSize = this.estimatedMainElementSize;
            }
            st.close();
            this.hasNextPage = this.docIds.size() == this.pageSize;
            this.hasPreviousPage = this.currentPage > 0;
            this.hasNextItem = this.docIds.size() > 0;
            this.currentDocIndex = -1;
            this.rs.getStatement().close();
            Object var20_21 = null;
            if (conToRelease != null) {
                this.implementation.releaseConnection(conToRelease);
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            if (conToRelease != null) {
                this.implementation.releaseConnection(conToRelease);
            }
            throw throwable;
        }
        if (this.cache != null && logger.isDebugEnabled()) {
            logger.debug((Object)("cache contains " + this.cache.getSize() + " entries"));
        }
        this.cleanAllCaches();
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPreviousPage() {
        return this.hasPreviousPage;
    }

    public boolean hasNext() {
        return this.hasNextItem;
    }

    public DataHandler next() {
        if (!this.hasNextItem) {
            throw new NoSuchElementException("iterating has ended");
        }
        if (this.currentList == null) {
            this.currentDocId = this.docIds.get(++this.currentDocIndex);
            try {
                Document document = this.getDocument(this.currentDocId);
                XPath xp = this.xpf.newXPath();
                xp.setNamespaceContext((NamespaceContext)this.etatModel.getParent().getNamespaces());
                this.currentList = xp.evaluate(this.xPath, document, XPathConstants.NODESET);
                this.currentItemInList = -1;
            }
            catch (Exception ex) {
                logger.error((Object)"in next():", (Throwable)ex);
                throw new NoSuchElementException("an error occurs. See logs for details.");
            }
        }
        Element el = null;
        try {
            if (this.currentList instanceof NodeList) {
                NodeList nl = (NodeList)this.currentList;
                el = (Element)nl.item(++this.currentItemInList);
            } else {
                ArrayList lst = (ArrayList)this.currentList;
                el = (Element)lst.get(++this.currentItemInList);
            }
        }
        catch (IndexOutOfBoundsException iEx) {
            // empty catch block
        }
        if (this.currentList instanceof NodeList) {
            if (this.currentItemInList == ((NodeList)this.currentList).getLength() - 1) {
                this.currentList = null;
                this.hasNextItem = this.currentDocIndex + 1 < this.docIds.size();
            }
        } else if (this.currentItemInList == ((List)this.currentList).size() - 1) {
            this.currentList = null;
            boolean bl = this.hasNextItem = this.currentDocIndex + 1 < this.docIds.size();
        }
        if (el != null) {
            return new DataHandler(this.lrm, el, (DataResultSet)this, this.currentDocId, this.cache);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Charset cs = Charset.forName("UTF-8");
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, cs);
        XmlOutputter output = new XmlOutputter(osw, cs.name());
        this.marshall(output);
        try {
            osw.flush();
            osw.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        logger.fatal((Object)("SQL REQUEST RETURNS MORE THAN XPATH DOES\n" + baos.toString() + "\ncurrentDocId=" + this.currentDocId));
        this.hasNextItem = false;
        return null;
    }

    public Document getDocument(String docId) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        Document ret = this.documentCache.getDocument(docId);
        if (ret == null) {
            DocumentInfos di = this.implementation.getDocumentInfos(this.etatModel, this.collectivite, this.budget, docId, this.user);
            this.addDocumentToCache(docId, di);
            ret = di.getDoc();
        }
        return ret;
    }

    public String getDocumentEncoding(String docId) throws DataConfigurationException, DataAccessException {
        return this.documentCache.getEncoding(docId);
    }

    public void setEnvironment(ListeResultatModel lrm, CachedData cache) {
        this.lrm = lrm;
        this.cache = cache;
    }

    public void remove() {
        throw new UnsupportedOperationException("this operation is not allowed on MySqlDataResultSet");
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setBudget(Pair budget) {
        this.budget = budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setCollectivite(Pair collectivite) {
        this.collectivite = collectivite;
    }

    public EtatModel getEtatModel() {
        return this.etatModel;
    }

    public void setEtatModel(EtatModel etatModel) {
        this.etatModel = etatModel;
    }

    public void nextPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            ++this.currentPage;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void previousPage() throws DataAccessException, DataConfigurationException {
        if (this.hasPreviousPage()) {
            --this.currentPage;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void firstPage() throws DataAccessException, DataConfigurationException {
        this.currentPage = 0;
        try {
            this.loadIds();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public void lastPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            this.currentPage = this.getEstimatedPageCount() - 1;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void setPage(int page) throws DataAccessException, DataConfigurationException {
        this.currentPage = page;
        try {
            this.loadIds();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public int getEstimatedPageCount() {
        if (this.estimatedPageCount == -1) {
            if (this.pageSize == 0 || this.estimatedSize == 0) {
                this.estimatedPageCount = 0;
            } else {
                this.estimatedPageCount = this.estimatedMainElementSize / this.pageSize;
                if (this.estimatedSize % this.pageSize > 0) {
                    ++this.estimatedPageCount;
                }
            }
        }
        return this.estimatedPageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public ListeResultatModel getListeResultatModel() {
        return this.lrm;
    }

    public void setListeResultatModel(ListeResultatModel l) {
        this.lrm = l;
    }

    public void clear() {
        this.cleanAllCaches();
    }

    protected void cleanAllCaches() {
        if (this.cache != null) {
            this.cache.flush();
        }
        if (this.documentCache != null) {
            this.documentCache.clear();
        }
    }

    protected void addDocumentToCache(String docId, DocumentInfos doc) {
        this.documentCache.putDocument(docId, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String calculateAggregate(String columnName, String tableName, String operator, ChampModel cm) {
        String result;
        block31: {
            result = "";
            ResultSet rset = null;
            StringBuffer sb = new StringBuffer();
            if (this.elementModel.equals(this.elementModel.getParent().getImportableElement())) {
                sb.append("SELECT ").append(operator).append("(").append(columnName).append(")");
                if (cm.getDatatype().equals("date")) {
                    sb.append("))");
                }
                sb.append(" FROM ").append(tableName).append(" WHERE ").append(tableName).append(".COLLECTIVITE='");
                sb.append(this.collectivite.key).append("' AND ").append(tableName).append(".BUDGET='").append(this.budget.key).append("' AND DOC_ID IN (\n");
                sb.append(this.selectClause.replaceAll("SQL_CALC_FOUND_ROWS ", "")).append(" ").append(this.fromClause).append(" ").append(this.whereClause).append("\n)");
            } else {
                int whereLoc;
                String where;
                String sTmp;
                int loc;
                sb.append("SELECT ").append(operator).append("(").append(columnName).append(")");
                if (cm.getDatatype().equals("date")) {
                    sb.append("))");
                }
                if ((loc = (sTmp = this.sql.substring(this.sql.indexOf("FROM "))).indexOf("LIMIT ")) > 0) {
                    sTmp = sTmp.substring(0, loc);
                }
                String string = where = (whereLoc = sTmp.indexOf("WHERE ")) > 0 ? sTmp.substring(whereLoc) : "";
                if (whereLoc > 0) {
                    sTmp = sTmp.substring(0, whereLoc);
                }
                if (sTmp.indexOf(tableName) < 0) {
                    String sTmp2 = sTmp.substring("FROM".length()).trim();
                    String mainTableName = null;
                    mainTableName = sTmp2.indexOf(32) >= 0 ? sTmp2.substring(0, sTmp2.indexOf(32)).trim() : sTmp2;
                    StringBuffer sb2 = new StringBuffer(sTmp);
                    sb2.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                    sTmp = sb2.toString();
                }
                sb.append(" ").append(sTmp).append(" ").append(where);
            }
            logger.debug((Object)sb.toString());
            Connection conn = null;
            try {
                try {
                    rset = this.implementation.execute(sb.toString());
                    if (rset.getStatement() != null) {
                        conn = rset.getStatement().getConnection();
                    }
                    if (rset.next()) {
                        result = rset.getString(1);
                        Class classToReturn = cm.getDataClass();
                        if (classToReturn.equals(Float.class)) {
                            try {
                                Float computed = new Float(Float.parseFloat(result));
                            }
                            catch (Exception nfEx) {}
                        } else if (classToReturn.equals(Integer.class)) {
                            try {
                                Integer computed = new Integer(Integer.parseInt(result));
                            }
                            catch (Exception nfEx) {}
                        } else if (classToReturn.equals(Amount.class)) {
                            try {
                                Amount computed = new Amount(result);
                                result = computed.stringRepresentation();
                            }
                            catch (Exception nfEx) {}
                        } else if (classToReturn.equals(Date.class) && result != null) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            Date computed = sdf.parse(result);
                            sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
                            result = sdf.format(computed);
                        }
                    }
                    rset.close();
                    logger.debug((Object)("resultat : " + result));
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    Object var16_26 = null;
                    if (conn != null) {
                        this.implementation.releaseConnection(conn);
                    }
                    break block31;
                }
                catch (ParseException pEx) {
                    pEx.printStackTrace();
                    Object var16_27 = null;
                    if (conn != null) {
                        this.implementation.releaseConnection(conn);
                    }
                }
                Object var16_25 = null;
                if (conn != null) {
                    this.implementation.releaseConnection(conn);
                }
            }
            catch (Throwable throwable) {
                Object var16_28 = null;
                if (conn != null) {
                    this.implementation.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        return result;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tag) throws SAXException {
        if (tag.equals(MysqlDrsParser.XPATH)) {
            XPathModel xp = (XPathModel)child;
            this.xPath = xp.getPath();
        } else if (tag.equals(MysqlDrsParser.FROM_CLAUSE)) {
            XPathModel xp = (XPathModel)child;
            this.fromClause = xp.getPath();
        } else if (tag.equals(MysqlDrsParser.SELECT_CLAUSE)) {
            XPathModel xp = (XPathModel)child;
            this.selectClause = xp.getPath();
        } else if (tag.equals(MysqlDrsParser.SQL)) {
            XPathModel xp = (XPathModel)child;
            this.sql = xp.getPath();
        } else if (tag.equals(MysqlDrsParser.WHERE_CLAUSE)) {
            XPathModel xp = (XPathModel)child;
            this.whereClause = xp.getPath();
        } else if (ListeResultatModel.QN.equals(tag)) {
            this.lrm = (ListeResultatModel)child;
        } else if (tag.equals(UserModel.QN)) {
            UserModel um = (UserModel)child;
            this.user = new LocalUser(um);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.documentId = attributes.getValue("doc-id");
        this.etatId = attributes.getValue("etat-id");
        this.elementId = attributes.getValue("element-id");
        this.pageSize = attributes.getIntValue("page-size");
        this.currentPage = attributes.getIntValue("current-page");
        this.estimatedSize = attributes.getIntValue("estimated-size");
        this.estimatedPageCount = attributes.getIntValue("estimated-page-count");
        this.estimatedMainElementSize = attributes.getIntValue("estimated-main-element-size");
        String sTmp = attributes.getValue("collectivite");
        if (sTmp != null) {
            this.collectivite = new Pair(sTmp, sTmp);
            sTmp = null;
        }
        if ((sTmp = attributes.getValue("budget")) != null) {
            this.budget = new Pair(sTmp, sTmp);
            sTmp = null;
        }
        return this;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(QN);
        output.addAttribute("doc-id", this.etatModel.getParent().getId());
        output.addAttribute("etat-id", this.etatModel.getId());
        output.addAttribute("element-id", this.elementModel.getId());
        output.addAttribute("page-size", this.pageSize);
        output.addAttribute("current-page", this.currentPage);
        output.addAttribute("estimated-size", this.estimatedSize);
        output.addAttribute("estimated-page-count", this.estimatedPageCount);
        output.addAttribute("estimated-main-element-size", this.estimatedMainElementSize);
        output.addAttribute("collectivite", this.collectivite.key);
        output.addAttribute("budget", this.budget.key);
        output.startTag(MysqlDrsParser.XPATH);
        output.addCharacterData(this.xPath);
        output.endTag(MysqlDrsParser.XPATH);
        output.startTag(MysqlDrsParser.FROM_CLAUSE);
        output.addCharacterData(this.fromClause);
        output.endTag(MysqlDrsParser.FROM_CLAUSE);
        output.startTag(MysqlDrsParser.SELECT_CLAUSE);
        output.addCharacterData(this.selectClause);
        output.endTag(MysqlDrsParser.SELECT_CLAUSE);
        output.startTag(MysqlDrsParser.SQL);
        output.addCharacterData(this.sql);
        output.endTag(MysqlDrsParser.SQL);
        output.startTag(MysqlDrsParser.WHERE_CLAUSE);
        output.addCharacterData(this.whereClause);
        output.endTag(MysqlDrsParser.WHERE_CLAUSE);
        this.lrm.marshall(output);
        if (this.user != null) {
            UserModel um = new UserModel(UserModel.QN);
            um.setId(this.user.getId());
            um.setLibelle(this.user.getDisplayName());
            um.setCollectivite(this.collectivite.key);
            um.setDocument(this.etatModel.getParent().getId());
            if (this.user.hasRole("BROWSE")) {
                um.getRoles().add("BROWSE");
            }
            if (this.user.hasRole("CLEAN")) {
                um.getRoles().add("CLEAN");
            }
            if (this.user.hasRole("CONNECT")) {
                um.getRoles().add("CONNECT");
            }
            if (this.user.hasRole("EXPORT")) {
                um.getRoles().add("EXPORT");
            }
            if (this.user.hasRole("IMPORT")) {
                um.getRoles().add("IMPORT");
            }
            if (this.user.hasRole("SEARCH")) {
                um.getRoles().add("SEARCH");
            }
            um.marshall(output);
        }
        output.endTag(QN);
    }

    public void validate() throws InvalidXmlDefinition {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QName getQName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ElementModel getElementModel() {
        return this.elementModel;
    }

    public MySqlDataLayer getImplementation() {
        return this.implementation;
    }

    public ListeResultatModel getLrm() {
        return this.lrm;
    }

    public String getSql() {
        return this.sql;
    }

    public String getXPath() {
        return this.xPath;
    }

    public String getCurrentDocId() {
        return this.currentDocId;
    }

    public MySqlDataResultSet clone() {
        return this;
    }

    public void finishInit(DocumentsModel docs) {
        DocumentModel dm = docs.getDocumentById(this.documentId);
        this.etatModel = dm.getEtatById(this.etatId);
        this.elementModel = this.etatModel.getElementById(this.elementId);
        if (this.lrm.getParent() == null) {
            this.lrm.setParent(this.elementModel);
        }
        if (this.implementation == null) {
            try {
                this.implementation = (MySqlDataLayer)DataLayerManager.getImplementation();
            }
            catch (Throwable t) {
                logger.error((Object)"finishInit(DocumentsModel)", t);
            }
        }
    }

    private class LocalUser
    implements XemeliosUser {
        private UserModel user;

        public LocalUser(UserModel user) {
            this.user = user;
        }

        public String getId() {
            return this.user.getId();
        }

        public String getDisplayName() {
            return this.user.getLibelle();
        }

        public boolean hasRole(String role) {
            return this.user.getRoles().contains(role);
        }

        public boolean hasDocument(String document) {
            return document.equals(this.user.getDocument());
        }

        public boolean hasCollectivite(String collectivite, DocumentModel dm) {
            return dm.getId().equals(this.user.getDocument()) && collectivite.equals(this.user.getCollectivite());
        }
    }

    protected class DocumentCache {
        private int maxCacheSize;
        private int actualCacheSize = 0;
        private Hashtable<String, Document> cache;
        private Hashtable<String, String> encodings;
        private LinkedList<String> chain;
        private final Object locker = new Object();

        public DocumentCache(int cacheSize) {
            this.maxCacheSize = cacheSize;
            this.cache = new Hashtable();
            this.chain = new LinkedList();
            this.encodings = new Hashtable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.locker;
            synchronized (object) {
                this.cache.clear();
                this.chain.clear();
                this.actualCacheSize = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document getDocument(String docId) {
            Document ret = this.cache.get(docId);
            if (ret != null) {
                Object object = this.locker;
                synchronized (object) {
                    this.chain.remove(docId);
                    this.chain.addFirst(docId);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putDocument(String docId, DocumentInfos doc) {
            Object object;
            if (this.cache.contains(docId)) {
                object = this.locker;
                synchronized (object) {
                    this.cache.remove(docId);
                    this.chain.remove(docId);
                    --this.actualCacheSize;
                }
            }
            object = this.locker;
            synchronized (object) {
                while (this.actualCacheSize >= this.maxCacheSize) {
                    String docToRemove = this.chain.removeLast();
                    this.cache.remove(docToRemove);
                    --this.actualCacheSize;
                }
            }
            object = this.locker;
            synchronized (object) {
                this.cache.put(docId, doc.getDoc());
                this.chain.addFirst(docId);
                this.encodings.put(docId, doc.getEncoding());
                ++this.actualCacheSize;
            }
        }

        public String getEncoding(String docId) {
            String encoding = this.encodings.get(docId);
            if (encoding == null) {
                this.getDocument(docId);
                encoding = this.encodings.get(docId);
            }
            return encoding;
        }
    }
}

