/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.dgfip.utils.xml.NamespaceContextImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class CgCollocPatch40 {
    private static final Logger logger = Logger.getLogger(CgCollocPatch40.class);
    private MySqlDataLayer impl = null;

    public CgCollocPatch40(MySqlDataLayer impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection con = null;
        try {
            try {
                con = this.impl.getConnection();
                boolean isDocumentTableExists = false;
                try {
                    con.createStatement().execute("SELECT COLLECTIVITE FROM CG_LIST_BUDG_COLL LIMIT 1");
                    isDocumentTableExists = true;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (!isDocumentTableExists) {
                    Object var25_6 = null;
                    if (con == null) return;
                    this.impl.releaseConnection(con);
                    return;
                }
                ResultSet rs = con.createStatement().executeQuery("SELECT COLLECTIVITE, BUDGET, INITIAL_DOC_NAME FROM CG_LIST_BUDG_COLL WHERE PARENT_COLL1 IS NULL");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xp = xpf.newXPath();
                NamespaceContextImpl nsCtx = new NamespaceContextImpl();
                nsCtx.addMapping("n", "http://www.xemelios.org/namespaces#cg-1.0");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                while (rs.next()) {
                    String collectivite = rs.getString(1);
                    String budget = rs.getString(2);
                    String initialDocName = rs.getString(3);
                    PreparedStatement ps = con.prepareStatement("SELECT DOC,DOC_ID,ENCODING FROM CG_BALANCEGENERALE_DOCUMENTS WHERE COLLECTIVITE=? AND BUDGET=? AND INITIAL_DOC_NAME=? LIMIT 1");
                    ps.setString(1, collectivite);
                    ps.setString(2, budget);
                    ps.setString(3, initialDocName);
                    ResultSet rs2 = ps.executeQuery();
                    if (rs2.next()) {
                        logger.debug((Object)("DOC_ID=" + rs2.getString(2)));
                        byte[] buff = new byte[512];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        InputStream is = rs2.getAsciiStream(1);
                        int length = is.read(buff);
                        while (length > 0) {
                            baos.write(buff, 0, length);
                            length = is.read(buff);
                        }
                        DocumentBuilder builder = dbf.newDocumentBuilder();
                        byte[] byteArray = baos.toByteArray();
                        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                        Document doc = builder.parse(bis);
                        String parentColl1 = xp.evaluate("/n:CompteGestion/n:Entete/n:Infos/n:Tresorerie/@Codique", doc);
                        String parentColl1Lib = xp.evaluate("/n:CompteGestion/n:Entete/n:Infos/n:Tresorerie/@LibelleCodique", doc);
                        String parentColl2 = xp.evaluate("/n:CompteGestion/n:Entete/n:Infos/n:Tresorerie/@Dpt", doc);
                        ps = con.prepareStatement("UPDATE CG_LIST_BUDG_COLL SET PARENT_COLL1=?, PARENT_COLL1_LIB=?, PARENT_COLL2=?, PARENT_COLL2_LIB=? WHERE COLLECTIVITE=? AND BUDGET=? AND INITIAL_DOC_NAME=?");
                        ps.setString(1, parentColl1);
                        ps.setString(2, parentColl1Lib);
                        ps.setString(3, parentColl2);
                        ps.setString(4, parentColl2);
                        ps.setString(5, collectivite);
                        ps.setString(6, budget);
                        ps.setString(7, initialDocName);
                        ps.executeUpdate();
                    }
                    rs2.close();
                }
                rs.close();
            }
            catch (Throwable t) {
                logger.error((Object)"in run()", t);
                Object var25_8 = null;
                if (con == null) return;
                this.impl.releaseConnection(con);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var25_9 = null;
            if (con == null) throw throwable;
            this.impl.releaseConnection(con);
            throw throwable;
        }
        Object var25_7 = null;
        if (con == null) return;
        this.impl.releaseConnection(con);
    }
}

