/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl;

import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;
import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.CgCollocPatch40;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.InputStreamLogger;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.PayePatch32;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.PayePatch40;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.PesAllerPatch33;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.RapportPatch33;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.RepositoryPatch;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.RsaPatch40014;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.SavedRequestsPatch;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.VersementPatch32;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.DataResultSetWrapperModel;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.DrswParser;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.serialization.ExportJobImpl;
import fr.gouv.finances.cp.xemelios.data.ui.DlgPatchProgress;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.dgfip.utils.xml.PathNotFoundException;
import fr.gouv.finances.dgfip.utils.xml.dompath.DomPath;
import fr.gouv.finances.dgfip.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.config.ChampModel;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.EtatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigParser;
import fr.gouv.finances.dgfip.xemelios.common.config.RechercheModel;
import fr.gouv.finances.dgfip.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.dgfip.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.dgfip.xemelios.data.AbstractDataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.data.DocumentInfos;
import fr.gouv.finances.dgfip.xemelios.data.ExportableData;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TCriteria;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TLayer;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TPersistenceConfig;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TSql;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TSqlIndex;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TTable;
import fr.gouv.finances.dgfip.xemelios.data.ui.PatchProgress;
import fr.gouv.finances.dgfip.xemelios.export.ConfigModel;
import fr.gouv.finances.dgfip.xemelios.export.ExportJob;
import fr.gouv.finances.dgfip.xemelios.utils.LongueurMax;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDataLayer
extends AbstractDataImpl {
    static final transient String PARAM_TABLE_NAME = "PARAMETERS";
    public static final transient String PROP_CONFIG_FILE_NAME = "xemelios.mysql.config.filename";
    public static final transient String PROP_MIN_POOL_SIZE = "pool-size-mini";
    private static Logger logger = Logger.getLogger(MySqlDataLayer.class);
    private static final SimpleDateFormat mySqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final transient String LAYER_NAME = "mysql";
    private ArrayList<TDocument> checkedConfigs = null;
    private ArrayList<Connection> availableConnections = null;
    private ArrayList<Connection> usedConnections = null;
    private PropertiesExpansion props = null;
    private TreeSet<String> createdTables;
    private SAXParserFactory saxFactory = null;
    private XPathFactory xPathFactory = null;
    private DocumentBuilderFactory domFactory = null;
    private int minPoolSize = 1;
    private Object poolLocker = new Object();
    private Hashtable<Thread, StringBuilder> warnings;
    private PatchProgress progress;

    public MySqlDataLayer() throws DataConfigurationException {
        logger.info((Object)"instancing");
        this.createdTables = new TreeSet();
        this.warnings = new Hashtable();
        this.initConnections();
        this.checkParamTable();
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        try {
            this.xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        this.xPathFactory.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.applyPatches();
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    public void reset() {
        super.reset();
        this.checkedConfigs.clear();
        this.createdTables.clear();
    }

    public PatchProgress getPatchProgress() {
        if (this.progress == null) {
            this.progress = new DlgPatchProgress();
            this.progress.setVisible(true);
        }
        return this.progress;
    }

    public void killPatchProgress() {
        if (this.progress != null) {
            this.progress.setVisible(false);
            this.progress.dispose();
            this.progress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importElement(DocumentModel dm, EtatModel em, Pair codeBudget, Pair collectivite, String sourceFileName, String elementName, byte[] data, String encoding, XemeliosUser user) throws DataAccessException, DataConfigurationException, UnauthorizedException {
        StringBuilder sb;
        if (!user.hasRole("IMPORT")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des fichiers");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        TEtat sec = pc.getEtat(em.getId());
        Connection con = null;
        PreparedStatement ps = null;
        IndexerHandler ih = null;
        String strWarnings = null;
        try {
            con = this.getConnection();
            this.ensureTablesExists(pc, sec, codeBudget, collectivite, con);
            sb = new StringBuilder();
            sb.append("INSERT INTO ").append(sec.getDocumentTable().getBaseName()).append(" (" + pc.getBudgetCodeColname() + "," + pc.getCollectiviteCodeColname() + ", INITIAL_DOC_NAME, DOC_ID, DOC, ENCODING) VALUES (?,?,?,?,?,?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, codeBudget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, sourceFileName);
            ps.setString(4, elementName);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            ps.setBinaryStream(5, (InputStream)is, data.length);
            ps.setString(6, encoding);
            ps.executeUpdate();
            ps.close();
            ih = new IndexerHandler(sec, codeBudget.key, collectivite.key, elementName, con, (NamespaceContext)dm.getNamespaces());
            ih.reset();
            SAXParser parser = this.saxFactory.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)ih);
            ih.reset();
            strWarnings = ih.getWarnings();
            ih = null;
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace();
            throw new DataAccessException((Throwable)(ih.getException() != null ? ih.getException() : saxEx));
        }
        catch (ParserConfigurationException pcEx) {
            pcEx.printStackTrace();
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new DataAccessException((Throwable)(ih.getException() != null ? ih.getException() : ioEx));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        if (strWarnings != null) {
            sb = this.warnings.get(Thread.currentThread());
            if (sb == null) {
                sb = new StringBuilder();
                this.warnings.put(Thread.currentThread(), sb);
            }
            sb.append(strWarnings);
        }
        return strWarnings == null;
    }

    public boolean saveRepository(DocumentModel dm, Pair collectivite, Document repository, Pair nomenclatureReference, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("IMPORT")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des fichiers");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        if (pc.getRepositoryTable() == null) {
            return false;
        }
        Connection con = null;
        Statement ps = null;
        boolean bRet = false;
        try {
            UPDATES_MODES updateMode;
            con = this.getConnection();
            String repositoryEncoding = repository.getXmlEncoding();
            Transformer trans = TransformerFactoryImpl.newInstance().newTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(baos);
            trans.transform(new DOMSource(repository), sr);
            StringBuilder sb = new StringBuilder();
            if (!this.doesRepositoryExist(pc, collectivite.key, con, nomenclatureReference != null ? nomenclatureReference.key : null)) {
                sb.append("INSERT INTO ").append(pc.getRepositoryTable().getBaseName()).append(" (LIBELLE,REPOSITORY,ENCODING," + pc.getCollectiviteCodeColname() + ",ID) VALUES (?,?,?,?,?)");
                updateMode = UPDATES_MODES.INSERT;
            } else {
                sb.append("UPDATE ").append(pc.getRepositoryTable().getBaseName()).append(" SET LIBELLE=?, REPOSITORY=?, ENCODING=? WHERE " + pc.getCollectiviteCodeColname() + "=? AND ID");
                updateMode = UPDATES_MODES.UPDATE;
                if (nomenclatureReference == null || nomenclatureReference.key == null) {
                    sb.append(" IS NULL");
                } else {
                    sb.append("=?");
                }
            }
            ps = con.prepareStatement(sb.toString());
            byte[] buffer = baos.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            if (nomenclatureReference != null && nomenclatureReference.libelle != null) {
                ps.setString(1, nomenclatureReference.libelle);
            } else {
                ps.setNull(1, 12);
            }
            ps.setBinaryStream(2, is, buffer.length);
            ps.setString(3, repositoryEncoding);
            ps.setString(4, collectivite.key);
            if (nomenclatureReference != null && nomenclatureReference.key != null) {
                ps.setString(5, nomenclatureReference.key);
            } else if (updateMode == UPDATES_MODES.INSERT) {
                ps.setNull(5, 12);
            }
            int modifiedRows = ps.executeUpdate();
            bRet = modifiedRows == 1;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (TransformerException tEx) {
            throw new DataConfigurationException((Throwable)tEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return bRet;
    }

    public void registerBudgetCollectivite(DocumentModel dm, Pair codeBudget, Pair collectivite, Pair[] parentCollectivites, String docName, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("IMPORT")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des fichiers");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, codeBudget, collectivite, con);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT 1 FROM ").append(pc.getListBcTable().getBaseName()).append(" WHERE " + pc.getBudgetCodeColname() + "=? AND " + pc.getCollectiviteCodeColname() + "=? AND INITIAL_DOC_NAME=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, codeBudget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                int i;
                sb = new StringBuilder();
                StringBuffer binds = new StringBuffer();
                sb.append("INSERT INTO ").append(pc.getListBcTable().getBaseName()).append(" (" + pc.getBudgetCodeColname() + "," + pc.getCollectiviteCodeColname() + ",INITIAL_DOC_NAME," + pc.getBudgetLibColname() + "," + pc.getCollectiviteLibColname());
                binds.append(" VALUES (?,?,?,?,?");
                for (i = 0; i < parentCollectivites.length; ++i) {
                    Pair p = parentCollectivites[i];
                    if (p == null || p.key == null || p.libelle == null) continue;
                    sb.append(",PARENT_COLL").append(i + 1).append(",PARENT_COLL").append(i + 1).append("_LIB");
                    binds.append(",?,?");
                }
                binds.append(")");
                sb.append(")").append(binds.toString());
                ps = con.prepareStatement(sb.toString());
                ps.setString(1, codeBudget.key);
                ps.setString(2, collectivite.key);
                ps.setString(3, docName);
                ps.setString(4, codeBudget.libelle);
                ps.setString(5, collectivite.libelle);
                i = 6;
                for (Pair p : parentCollectivites) {
                    if (p == null || p.key == null || p.libelle == null) continue;
                    ps.setString(i++, p.key);
                    ps.setString(i++, p.libelle);
                }
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public void saveSpecialKeys(DocumentModel dm, Pair budget, Pair collectivite, String docName, Pair sk1, Pair sk2, Pair sk3, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("IMPORT")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des fichiers");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        if (sk1 == null && sk2 == null && sk3 == null) {
            return;
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(pc.getSpecialKeyTable().getBaseName()).append(" (" + pc.getBudgetCodeColname() + "," + pc.getCollectiviteCodeColname() + ",INITIAL_DOC_NAME,KEY1,LIB1,KEY2,LIB2,KEY3,LIB3) VALUES(?,?,?,?,?,?,?,?,?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docName);
            if (sk1 != null) {
                ps.setString(4, sk1.key);
                ps.setString(5, sk1.libelle);
            } else {
                ps.setNull(4, 12);
                ps.setNull(5, 12);
            }
            if (sk2 != null) {
                ps.setString(6, sk2.key);
                ps.setString(7, sk2.libelle);
            } else {
                ps.setNull(6, 12);
                ps.setNull(7, 12);
            }
            if (sk3 != null) {
                ps.setString(8, sk3.key);
                ps.setString(9, sk3.libelle);
            } else {
                ps.setNull(8, 12);
                ps.setNull(9, 12);
            }
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public boolean canSearch(DocumentModel dm, EtatModel em, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre());
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        TEtat sec = pc.getEtat(em.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            ResultSet rs = null;
            try {
                rs = con.createStatement().executeQuery("SELECT 1 FROM " + sec.getDocumentTable().getBaseName() + " LIMIT 1");
            }
            catch (SQLException sqlEx) {
                boolean bl = false;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                return bl;
            }
            if (rs != null) {
                boolean bl = rs.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public Vector<Pair> getBudgets(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        if (dm == null || collectivite == null) {
            return vRet;
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT " + pc.getBudgetCodeColname() + ", " + pc.getBudgetLibColname() + " FROM ").append(pc.getListBcTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? ORDER BY " + pc.getBudgetLibColname());
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getParentCollectivites(DocumentModel dm, int level, Pair[] otherParents, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        TreeSet<Pair> vRet = new TreeSet<Pair>(new Comparator<Pair>(){

            @Override
            public int compare(Pair o1, Pair o2) {
                int ret = o1.libelle.compareTo(o2.libelle);
                if (ret == 0) {
                    ret = o1.key.compareTo(o2.key);
                }
                return ret;
            }
        });
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT PARENT_COLL").append(level).append(", PARENT_COLL").append(level).append("_LIB, " + pc.getCollectiviteCodeColname() + " FROM ").append(pc.getListBcTable().getBaseName());
            sb.append(" WHERE PARENT_COLL").append(level).append(" IS NOT NULL AND ");
            if (otherParents != null && otherParents.length > 0) {
                for (int i = 0; i < otherParents.length; ++i) {
                    Pair p = otherParents[i];
                    if (p == null) continue;
                    sb.append("PARENT_COLL").append(level + 1 + i).append("=? ");
                    sb.append("AND ");
                }
            }
            if (sb.toString().endsWith("AND ")) {
                sb.delete(sb.length() - 4, sb.length());
            }
            if (sb.toString().endsWith(" WHERE ")) {
                sb.delete(sb.length() - 7, sb.length());
            }
            sb.append(" ORDER BY PARENT_COLL").append(level).append("_LIB ASC");
            logger.debug((Object)sb.toString());
            ps = con.prepareStatement(sb.toString());
            if (otherParents != null && otherParents.length > 0) {
                int j = 1;
                for (int i = 0; i < otherParents.length; ++i) {
                    if (otherParents[i] == null) continue;
                    ps.setString(j++, otherParents[i].key);
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Pair parentColl = new Pair(rs.getString(1), rs.getString(2));
                if (!user.hasCollectivite(rs.getString(3), dm)) continue;
                vRet.add(parentColl);
            }
            rs.close();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ex) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        Vector<Pair> v = new Vector<Pair>();
        v.addAll(vRet);
        return v;
    }

    public int getCollectivitesCount(DocumentModel dm, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        int ret = 0;
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT distinct(" + pc.getCollectiviteCodeColname() + ") FROM ").append(pc.getListBcTable().getBaseName());
            ResultSet rs = con.createStatement().executeQuery(sb.toString());
            while (rs.next()) {
                String collectivite = rs.getString(1);
                if (!user.hasCollectivite(collectivite, dm)) continue;
                ++ret;
            }
            rs.close();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Vector<Pair> getCollectivites(DocumentModel dm, Pair[] parents, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            int i;
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT " + pc.getCollectiviteCodeColname() + ", " + pc.getCollectiviteLibColname() + " FROM ").append(pc.getListBcTable().getBaseName());
            if (parents != null && parents.length > 0 && parents[0] != null) {
                sb.append(" WHERE ");
                for (i = 0; i < parents.length; ++i) {
                    if (parents[i] == null) continue;
                    sb.append("PARENT_COLL").append(i + 1).append("=? AND ");
                }
            }
            if (sb.toString().endsWith("AND ")) {
                sb.delete(sb.length() - 4, sb.length());
            }
            if (sb.toString().endsWith(" WHERE ")) {
                sb.delete(sb.length() - 7, sb.length());
            }
            sb.append(" ORDER BY " + pc.getCollectiviteLibColname());
            ps = con.prepareStatement(sb.toString());
            if (parents != null && parents.length > 0 && parents[0] != null) {
                for (i = 0; i < parents.length; ++i) {
                    if (parents[i] == null) continue;
                    ps.setString(i + 1, parents[i].key);
                }
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Pair collectivite = new Pair(rs.getString(1), rs.getString(2));
                if (!user.hasCollectivite(collectivite.key, dm)) continue;
                vRet.add(collectivite);
            }
            rs.close();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys1(DocumentModel dm, Pair collectivite, Pair budget, boolean distinct, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY1,LIB1 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys2(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, boolean distinct, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY2,LIB2 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE KEY1=? AND " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND KEY2 is not null");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, key1.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys3(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2, boolean distinct, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY3,LIB3 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE KEY1=? AND KEY2=? AND " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, key1.key);
            ps.setString(2, key2.key);
            ps.setString(3, collectivite.key);
            ps.setString(4, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Collection<Pair> queryRepository(DocumentModel dm, Pair collectivite, RecherchePaireModel rpm, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                Document repository = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
                XPath xp = this.xPathFactory.newXPath();
                xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
                DomPath dpCode = rpm.getCodePath().getDomPath((NamespaceContext)dm.getNamespaces());
                DomPath dpLibelle = rpm.getLibellePath().getDomPath((NamespaceContext)dm.getNamespaces());
                Object o = xp.evaluate(rpm.getPath().getPath(), repository, XPathConstants.NODESET);
                if (o instanceof NodeList) {
                    NodeList nl = (NodeList)o;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node node = nl.item(i);
                        String code = (String)dpCode.getValue(node, false);
                        String libelle = (String)dpLibelle.getValue(node, true);
                        vRet.add(new Pair(code, libelle));
                    }
                } else {
                    for (Node node : (List)o) {
                        String code = (String)dpCode.getValue(node, false);
                        String libelle = (String)dpLibelle.getValue(node, true);
                        vRet.add(new Pair(code, libelle));
                    }
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        catch (XPathExpressionException xpEx) {
            throw new DataConfigurationException((Throwable)xpEx);
        }
        catch (InvalidPathExpressionException ipeEx) {
            throw new DataConfigurationException((Throwable)ipeEx);
        }
        catch (PathNotFoundException pnfEx) {
            throw new DataConfigurationException((Throwable)pnfEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Collection<Pair> queryRepository(DocumentModel dm, Pair collectivite, RecherchePaireModel rpm, Pair refNomenclature, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND ID=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            if (refNomenclature != null && refNomenclature.key != null) {
                ps.setString(2, refNomenclature.key);
            } else {
                ps.setNull(2, 12);
            }
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                Document repository = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
                XPath xp = this.xPathFactory.newXPath();
                xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
                Object resp = xp.evaluate(rpm.getPath().getPath(), repository, XPathConstants.NODESET);
                DomPath dpCode = rpm.getCodePath().getDomPath((NamespaceContext)dm.getNamespaces());
                DomPath dpLibelle = rpm.getLibellePath().getDomPath((NamespaceContext)dm.getNamespaces());
                if (resp instanceof NodeList) {
                    NodeList nl = (NodeList)resp;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node node = nl.item(i);
                        String code = (String)dpCode.getValue(node, false);
                        String libelle = (String)dpLibelle.getValue(node, true);
                        vRet.add(new Pair(code, libelle));
                    }
                } else {
                    ArrayList nodes = (ArrayList)resp;
                    for (Node node : nodes) {
                        String code = (String)dpCode.getValue(node, false);
                        String libelle = (String)dpLibelle.getValue(node, true);
                        vRet.add(new Pair(code, libelle));
                    }
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        catch (XPathExpressionException xpEx) {
            throw new DataConfigurationException((Throwable)xpEx);
        }
        catch (InvalidPathExpressionException ipeEx) {
            throw new DataConfigurationException((Throwable)ipeEx);
        }
        catch (PathNotFoundException pnfEx) {
            throw new DataConfigurationException((Throwable)pnfEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public boolean isDocumentExists(DocumentModel dm, Pair budget, Pair collectivite, String docName, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("IMPORT") && !user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des fichiers");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        boolean ret = false;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
                if (!(ret |= this.documentExists(pc, budget, collectivite, docName, con))) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public void removeDocument(DocumentModel dm, Pair budget, Pair collectivite, String docName, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
                StringBuilder sql = null;
                sql = new StringBuilder();
                sql.append("delete from ");
                for (TTable sti : sec.getIndexTables()) {
                    sql.append("\n").append(sti.getBaseName()).append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                String docTableName = sec.getDocumentTable().getBaseName();
                sql.append("\nusing ").append(docTableName);
                for (TTable sti : sec.getIndexTables()) {
                    String baseName = sti.getBaseName();
                    sql.append("\nLEFT OUTER JOIN ").append(baseName).append(" ON (").append(baseName).append("." + pc.getCollectiviteCodeColname() + "=").append(docTableName).append("." + pc.getCollectiviteCodeColname() + " AND ").append(baseName).append("." + pc.getBudgetCodeColname() + "=").append(docTableName).append("." + pc.getBudgetCodeColname() + " AND ").append(baseName).append(".DOC_ID=").append(docTableName).append(".DOC_ID )");
                }
                sql.append("\nwhere ");
                sql.append(docTableName).append("." + pc.getCollectiviteCodeColname() + "=? AND ").append(docTableName).append("." + pc.getBudgetCodeColname() + "=? AND ").append(docTableName).append(".INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
                if (pc.getSpecialKeyTable() != null) {
                    sql = new StringBuilder();
                    sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND INITIAL_DOC_NAME=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, budget.key);
                    ps.setString(3, docName);
                    ps.executeUpdate();
                }
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public String getRepository(DocumentModel dm, Pair collectivite, Pair budget, String idNomenclature, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        String ret = null;
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            ResultSet rs;
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY, ENCODING FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND ");
            if (idNomenclature != null) {
                sb.append("ID=?");
            } else {
                sb.append("ID IS NULL");
            }
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            if (idNomenclature != null) {
                ps.setString(2, idNomenclature);
            }
            if ((rs = ps.executeQuery()).next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret = new String(baos.toByteArray(), encoding);
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    logger.debug((Object)ret);
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Vector<String> getRepositorys(DocumentModel dm, Pair collectivite, Pair budget, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<String> ret = new Vector<String>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY, ENCODING FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret.add(new String(baos.toByteArray(), encoding));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Vector<String> getListeRepository(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<String> ret = new Vector<String>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY, ENCODING FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret.add(new String(baos.toByteArray(), encoding));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Vector<Pair> getListeCodeLibelleRepository(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Pair> ret = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ID, LIBELLE FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String code = rs.getString(1);
                if (rs.wasNull()) {
                    code = "";
                }
                String libelle = rs.getString(2);
                if (rs.wasNull()) {
                    libelle = "Nomenclature par d\u00e9faut";
                }
                ret.add(new Pair(code, libelle));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Document getRepositoryAsDom(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        return this.getRepositoryAsDom(dm, collectivite, null, user);
    }

    public Document getRepositoryAsDom(DocumentModel dm, Pair collectivite, String idNomenclature, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector vRet = new Vector();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        if (pc.getRepositoryTable() == null) {
            return null;
        }
        Connection con = null;
        Statement ps = null;
        Document repository = null;
        try {
            ResultSet rs;
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND ");
            if (idNomenclature != null) {
                sb.append("ID=?");
            } else {
                sb.append("ID IS NULL");
            }
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            if (idNomenclature != null) {
                ps.setString(2, idNomenclature);
            }
            if ((rs = ps.executeQuery()).next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                repository = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    TransformerFactory tf = TransformerFactoryImpl.newInstance();
                    Transformer t = tf.newTransformer();
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    t.transform(new DOMSource(repository), new StreamResult(baos2));
                    logger.debug((Object)new String(baos2.toByteArray()));
                }
            }
        }
        catch (Throwable t) {
            throw new DataConfigurationException("invalid code !", t);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return repository;
    }

    public Vector<Document> getRepositorysAsDom(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        Vector<Document> vRet = new Vector<Document>();
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                Document doc = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
                vRet.add(doc);
                if (!"true".equals(System.getProperty("xemelios.log.dom.doc"))) continue;
                TransformerFactory tf = TransformerFactoryImpl.newInstance();
                Transformer t = tf.newTransformer();
                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                t.transform(new DOMSource(doc), new StreamResult(baos2));
                logger.debug((Object)new String(baos2.toByteArray()));
            }
        }
        catch (Throwable t) {
            throw new DataConfigurationException("invalid code !", t);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Collection<String> getDistinctValues(ElementModel em, Pair collectivite, Pair budget, String path, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(em.getParent().getParent().getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, em.getParent().getParent())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(em.getParent().getParent(), user).getLayer(LAYER_NAME).getDocument(em.getParent().getParent().getId());
        TEtat sec = pc.getEtat(em.getParent().getId());
        TSqlIndex si = sec.getSqlIndexByPath(path);
        TTable sti = sec.getIndexTable(si.getTableId());
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT(").append(si.getColumn()).append(") FROM ").append(sti.getBaseName()).append(" ");
        sb.append("WHERE " + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)collectivite.key)).append("' AND " + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budget.key)).append("' AND ").append(si.getColumn()).append(" IS NOT NULL ORDER BY 1");
        Vector<String> vRet = new Vector<String>();
        Connection con = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sb.toString());
            while (rs.next()) {
                vRet.add(rs.getString(1));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataConfigurationException("invalid code !", (Throwable)sqlEx);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"st closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public boolean removeFichier(DocumentModel dm, String fichier, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where DOC_ID in (select DOC_ID from ").append(sec.getDocumentTable().getBaseName()).append(" where INITIAL_DOC_NAME=?)");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, fichier);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"st closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeBudget(DocumentModel dm, Pair collectivite, Pair budget, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, budget.key);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"st closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeCollectivite(DocumentModel dm, Pair collectivite, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getSpecialKeyTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getListBcTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            if (pc.getRepositoryTable() != null && existingTables.contains(pc.getRepositoryTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getRepositoryTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getRepositoryTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    logger.debug((Object)("delete from " + sti.getBaseName()));
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                logger.debug((Object)("delete from " + sec.getDocumentTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where " + pc.getCollectiviteCodeColname() + "=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            sql.append("delete from ATTACHMENTS where " + pc.getCollectiviteCodeColname() + "=?");
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, collectivite.key);
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"st closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeDocumentModel(DocumentModel dm, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement st = null;
        try {
            con = this.getConnection();
            StringBuilder sql = null;
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, null, null, con);
                for (TTable sti : sec.getIndexTables()) {
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName());
                    logger.debug((Object)sql);
                    st = con.createStatement();
                    st.executeUpdate(sql.toString());
                    sql = new StringBuilder();
                    st.close();
                }
                st = con.createStatement();
                if (pc.getSpecialKeyTable() != null) {
                    sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName());
                    logger.debug((Object)sql);
                    st.executeUpdate(sql.toString());
                }
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName());
                logger.debug((Object)sql);
                st.executeUpdate(sql.toString());
            }
            sql = new StringBuilder();
            sql.append("delete from ").append(pc.getListBcTable().getBaseName());
            logger.debug((Object)sql);
            st.executeUpdate(sql.toString());
            if (pc.getRepositoryTable() != null) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getRepositoryTable().getBaseName());
                logger.debug((Object)sql);
                st.executeUpdate(sql.toString());
                st.close();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"st closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeSpecialKey1(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND KEY1=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ps.setString(3, key1.key);
            ResultSet rs = ps.executeQuery();
            TreeSet<String> al = new TreeSet<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            for (String docName : al) {
                this.removeDocument(dm, budget, collectivite, docName, user);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeSpecialKey2(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        Connection con;
        block15: {
            if (!user.hasRole("CLEAN")) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
            }
            if (!user.hasDocument(dm.getId())) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
            }
            if (!user.hasCollectivite(collectivite.key, dm)) {
                String string;
                if ("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null) {
                    string = "(" + collectivite.libelle + ")";
                    throw new UnauthorizedException(string);
                }
                string = "";
                throw new UnauthorizedException(string);
            }
            TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
            con = null;
            Statement ps = null;
            try {
                logger.debug((Object)("deleting " + dm.getId() + "/" + collectivite.libelle + "/" + budget.libelle + "/" + key1.key + "/" + key2.key));
                con = this.getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND KEY1=? AND KEY2=?");
                ps = con.prepareStatement(sb.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, key1.key);
                ps.setString(4, key2.key);
                ResultSet rs = ps.executeQuery();
                TreeSet<String> al = new TreeSet<String>();
                while (rs.next()) {
                    al.add(rs.getString(1));
                }
                for (String docName : al) {
                    this.removeDocument(dm, budget, collectivite, docName, user);
                }
                if (ps == null) break block15;
            }
            catch (SQLException sqlEx) {
                try {
                    throw new DataAccessException((Throwable)sqlEx);
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con == null) throw throwable;
                    this.releaseConnection(con);
                    throw throwable;
                }
            }
            try {
                ps.close();
            }
            catch (Throwable t) {
                logger.info((Object)"ps closed !", t);
            }
        }
        if (con == null) return true;
        this.releaseConnection(con);
        return true;
    }

    public boolean removeSpecialKey3(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2, Pair key3, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("CLEAN")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des donn\u00e9es");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 supprimer des " + dm.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? AND KEY1=? AND KEY2=? AND KEY3=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ps.setString(3, key1.key);
            ps.setString(4, key2.key);
            ps.setString(5, key3.key);
            ResultSet rs = ps.executeQuery();
            TreeSet<String> al = new TreeSet<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            for (String docName : al) {
                this.removeDocument(dm, budget, collectivite, docName, user);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public DataResultSet getEmptyDataResultSet() {
        return new MySqlDataResultSet();
    }

    public DataResultSet search(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, ListeResultatModel lrm, Vector<CritereModel> models, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(elementModel.getParent().getParent().getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + elementModel.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, elementModel.getParent().getParent())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + elementModel.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        String sql = this.transformXPathToSql(elementModel, collectivite, budget, xPath, models, user);
        logger.debug((Object)sql);
        MySqlDataResultSet rs = null;
        try {
            rs = new MySqlDataResultSet(elementModel, collectivite, budget, xPath, sql, lrm, this, user);
        }
        catch (SQLException sqlEx) {
            throw new DataConfigurationException((Throwable)sqlEx);
        }
        return rs;
    }

    public Pair[] getOperators(String datatype) {
        if ("string".equals(datatype)) {
            return new Pair[]{new Pair("starts-with", "commence par"), new Pair("contains", "contient"), new Pair("xem:does-not-contain", "ne contient pas"), new Pair("xem:ends-with", "fini par"), new Pair("xem:StringEquals", "\u00e9gal \u00e0\u00a0"), new Pair("xem:StringDiffers", "diff\u00e8re de"), new Pair("xem:StringIsNull", "est nul"), new Pair("xem:StringIsNotNull", "n'est pas nul")};
        }
        if ("numeric".equals(datatype)) {
            return new Pair[]{new Pair("=", "="), new Pair(">=", ">="), new Pair(">", ">"), new Pair("<", "<"), new Pair("<=", "<="), new Pair("!=", "!=")};
        }
        if ("date".equals(datatype)) {
            return new Pair[]{new Pair("xem:DateBefore", "avant le (inclus)"), new Pair("xem:DateEquals", "le"), new Pair("xem:DateAfter", "apr\u00e8s le (inclus)")};
        }
        return null;
    }

    public String getDocumentAsString(EtatModel etatModel, Pair collectivite, Pair budget, String docId, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(etatModel.getParent().getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, etatModel.getParent())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        DocumentModel dm = etatModel.getParent();
        String ret = null;
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC, ENCODING FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE " + pc.getBudgetCodeColname() + "=? AND " + pc.getCollectiviteCodeColname() + "=? AND DOC_ID=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret = new String(baos.toByteArray(), encoding);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Document getDocumentAsDom(EtatModel etatModel, Pair collectivite, Pair budget, String docId, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(etatModel.getParent().getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre());
        }
        if (!user.hasCollectivite(collectivite.key, etatModel.getParent())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
        }
        DocumentModel dm = etatModel.getParent();
        Document ret = null;
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE " + pc.getBudgetCodeColname() + "=? AND " + pc.getCollectiviteCodeColname() + "=? AND DOC_ID=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                byte[] byteArray = baos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                ret = builder.parse(bis);
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    logger.debug((Object)new String(byteArray));
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public DocumentInfos getDocumentInfos(EtatModel etatModel, Pair collectivite, Pair budget, String docId, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (user != null) {
            if (!user.hasRole("SEARCH")) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
            }
            if (!user.hasDocument(etatModel.getParent().getId())) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre());
            }
            if (!user.hasCollectivite(collectivite.key, etatModel.getParent())) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + etatModel.getTitre() + " pour cette collectivit\u00e9 " + collectivite.libelle != null ? "(" + collectivite.libelle + ")" : "");
            }
        }
        DocumentModel dm = etatModel.getParent();
        Document ret = null;
        String encoding = null;
        TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC, ENCODING FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE " + pc.getBudgetCodeColname() + "=? AND " + pc.getCollectiviteCodeColname() + "=? AND DOC_ID=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                byte[] byteArray = baos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                ret = builder.parse(bis);
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    logger.debug((Object)new String(byteArray));
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        if (ret == null) {
            logger.info((Object)"ret is null !");
        }
        return new DocumentInfos(docId, ret, encoding);
    }

    @Deprecated
    private Connection createNewConnection() throws SQLException {
        return null;
    }

    public void releaseConnection(Connection con) {
        PoolManager.getInstance().releaseConnection(con);
    }

    public Connection getConnection() throws SQLException {
        Connection con = PoolManager.getInstance().getConnection();
        ResultSet rs = con.createStatement().executeQuery("SELECT @@sql_mode");
        if (rs.next()) {
            String[] modes;
            String sqlMode = rs.getString(1);
            StringBuilder sb = new StringBuilder();
            for (String mode : modes = sqlMode.split(",")) {
                if ("STRICT_TRANS_TABLES".equals(mode) || "STRICT_ALL_TABLES".equals(mode)) continue;
                sb.append(mode).append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            con.createStatement().executeUpdate("SET sql_mode='".concat(sb.toString()).concat("'"));
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean documentExists(TDocument pc, Pair codeBudget, Pair collectivite, String docName, Connection con) throws SQLException {
        Statement ps = null;
        boolean bRet = false;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select 1 from ").append(pc.getListBcTable().getBaseName()).append(" where INITIAL_DOC_NAME=? AND " + pc.getBudgetCodeColname() + "=? AND " + pc.getCollectiviteCodeColname() + "=? LIMIT 1");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, docName);
            ps.setString(2, codeBudget.key);
            ps.setString(3, collectivite.key);
            ResultSet rs = ps.executeQuery();
            bRet = rs.next();
            rs.close();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesRepositoryExist(TDocument pc, String collectivite, Connection con, String idNomenclature) throws SQLException {
        boolean bRet = false;
        if (pc.getRepositoryTable() == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT 1 FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND ID");
        if (idNomenclature != null) {
            sb.append("=?");
        } else {
            sb.append(" IS NULL");
        }
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite);
            if (idNomenclature != null) {
                ps.setString(2, idNomenclature);
            }
            ResultSet rs = ps.executeQuery();
            bRet = rs.next();
            rs.close();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
        }
        return bRet;
    }

    protected void ensureTablesExists(TDocument pc, TEtat sec, Pair codeBudget, Pair collectivite, Connection con) throws SQLException {
        Statement st = con.createStatement();
        this.createTable(pc.getListBcTable(), st);
        this.createTable(pc.getRepositoryTable(), st);
        this.createTable(pc.getSpecialKeyTable(), st);
        this.createTable(sec.getDocumentTable(), st);
        for (TTable table : sec.getIndexTables()) {
            this.createTable(table, st);
        }
        st.close();
    }

    private void createTable(TTable sti, Statement st) throws SQLException {
        if (sti == null) {
            return;
        }
        if (!this.createdTables.contains(sti.getBaseName())) {
            st.executeUpdate(sti.getScript());
            if (st.executeQuery("SELECT 1 FROM TABLES_VERSIONS WHERE TABLE_NAME='" + sti.getBaseName() + "'").next()) {
                st.executeUpdate("UPDATE TABLES_VERSIONS SET VERSION=" + sti.getVersion() + " WHERE TABLE_NAME='" + sti.getBaseName() + "'");
            } else {
                st.executeUpdate("INSERT INTO TABLES_VERSIONS (TABLE_NAME,VERSION) VALUES ('" + sti.getBaseName() + "'," + sti.getVersion() + ")");
            }
            this.createdTables.add(sti.getBaseName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateTableVersion(TTable table, Connection con) throws SQLException {
        block31: {
            block26: {
                block24: {
                    sql = "SELECT VERSION FROM TABLES_VERSIONS WHERE TABLE_NAME=?";
                    ps = null;
                    st = null;
                    rs = null;
                    ps = con.prepareStatement(sql);
                    ps.setString(1, table.getBaseName());
                    rs = ps.executeQuery();
                    if (!rs.next()) break block29;
                    existingVersion = rs.getInt(1);
                    if (existingVersion < table.getVersion()) break block30;
                    var14_8 = null;
                    if (rs == null) break block24;
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        MySqlDataLayer.logger.info((Object)"rs closed !", t);
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t) {
                        MySqlDataLayer.logger.info((Object)"st closed !", t);
                    }
                }
                if (ps == null) ** GOTO lbl-1000
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    MySqlDataLayer.logger.info((Object)"ps closed !", t);
                }
lbl-1000:
                // 3 sources

                {
                    block29: {
                        block30: {
                            return;
                        }
                        MySqlDataLayer.logger.info((Object)("patching " + table.getBaseName() + " from version " + existingVersion));
                        patch = table.getPatchFromVersion(existingVersion);
                        st = con.createStatement();
                        for (TSql order : patch.getOrders()) {
                            sqlEx = null;
                            try {
                                st.execute(order.getSql());
                            }
                            catch (SQLException ex) {
                                MySqlDataLayer.logger.error((Object)"updateTableVersion(TTable,Connection)", (Throwable)ex);
                                sqlEx = ex;
                            }
                            if (sqlEx == null || !order.isFailOnError()) continue;
                            throw sqlEx;
                        }
                        rs.close();
                        sql = "UPDATE TABLES_VERSIONS SET VERSION=? WHERE TABLE_NAME=?";
                        ps = con.prepareStatement(sql);
                        ps.setInt(1, table.getVersion());
                        ps.setString(2, table.getBaseName());
                        ps.executeUpdate();
                        break block26;
                    }
                    st = con.createStatement();
                    this.createTable(table, st);
                }
            }
            var14_9 = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {
                    MySqlDataLayer.logger.info((Object)"rs closed !", t);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {
                    MySqlDataLayer.logger.info((Object)"st closed !", t);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    MySqlDataLayer.logger.info((Object)"ps closed !", t);
                }
            }
            break block31;
            catch (Throwable var13_19) {
                var14_10 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        MySqlDataLayer.logger.info((Object)"rs closed !", t);
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t) {
                        MySqlDataLayer.logger.info((Object)"st closed !", t);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        MySqlDataLayer.logger.info((Object)"ps closed !", t);
                    }
                }
                throw var13_19;
            }
        }
    }

    protected String transformXPathToSql(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, Vector<CritereModel> models, XemeliosUser user) throws DataConfigurationException {
        EtatModel etatModel = elementModel.getParent();
        DocumentModel documentModel = etatModel.getParent();
        TDocument pc = this.getPersistenceConfig(documentModel, user).getLayer(LAYER_NAME).getDocument(documentModel.getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        if (!xPath.substring(0, elementModel.getPath().getPath().length()).equals(elementModel.getPath().getPath())) {
            throw new DataConfigurationException("XPath: " + xPath + " does not start with element[" + elementModel.getId() + "] path");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CritereModel> part = new ArrayList<CritereModel>();
        boolean firstPart = true;
        if (models != null) {
            for (CritereModel cm : models) {
                TCriteria ci = sec.getCriteria(cm.getId());
                if (ci == null) {
                    throw new DataConfigurationException("no criteria persistence info found for " + cm.getId());
                }
                cm.setAdditionnalData((Object)ci);
                part.add(cm);
            }
        }
        this.appendRequest(pc, part, sb, sec, collectivite, budget, firstPart);
        return sb.toString();
    }

    protected void appendRequest(TDocument pc, ArrayList<CritereModel> criterias, StringBuilder sb, TEtat sec, Pair collectivite, Pair budget, boolean firstPart) throws DataConfigurationException {
        TTable mainTable = sec.getMaintable();
        TreeSet<TTable> criteriasUsedTables = new TreeSet<TTable>();
        StringBuilder fromClause = new StringBuilder();
        StringBuilder whereClause = new StringBuilder();
        sb.append("SELECT SQL_CALC_FOUND_ROWS DISTINCT(").append(mainTable.getBaseName()).append(".DOC_ID) FROM ");
        sb.append(sec.getMaintable().getBaseName());
        whereClause.append(" WHERE ");
        whereClause.append(mainTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)collectivite.key)).append("' AND ").append(mainTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budget.key)).append("' AND ( (");
        for (CritereModel cm : criterias) {
            TCriteria sci = (TCriteria)cm.getAdditionnalData();
            if (sci.getSqlIndexId() == null) {
                logger.warn((Object)("try to use a mis-defined criteria : " + sci.getId()));
                continue;
            }
            TSqlIndex si = sec.getSqlIndexById(sci.getSqlIndexId());
            TTable sti = sec.getIndexTable(si.getTableId());
            if (cm.getProperty("AND_OR") != null) {
                String andOr = cm.getProperty("AND_OR");
                if ("||".equals(andOr)) {
                    whereClause.append(") OR (");
                } else {
                    whereClause.append(" AND ");
                }
            }
            String s = sci.getSubstitutedWhereClause(cm);
            s = s.replaceAll("\\$\\{table\\}", sti.getBaseName());
            s = s.replaceAll("\\$\\{column\\}", si.getColumn());
            whereClause.append(s);
            criteriasUsedTables.add(sti);
        }
        if (whereClause.substring(sb.length() - 6).equals(" AND ")) {
            for (int i = 0; i < 4; ++i) {
                whereClause.deleteCharAt(whereClause.length() - 1);
            }
        }
        if (whereClause.substring(sb.length() - 5).equals(" OR ")) {
            for (int i = 0; i < 3; ++i) {
                whereClause.deleteCharAt(whereClause.length() - 1);
            }
        }
        whereClause.append(") )");
        for (TTable sti : sec.getIndexTables()) {
            if (sti.isMainTable() || !criteriasUsedTables.contains(sti)) continue;
            fromClause.append(" LEFT OUTER JOIN ").append(sti.getBaseName()).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(sti.getBaseName()).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(sti.getBaseName()).append("." + pc.getCollectiviteCodeColname() + " AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(sti.getBaseName()).append("." + pc.getBudgetCodeColname() + "");
        }
        sb.append(fromClause.toString()).append(whereClause.toString());
    }

    @Deprecated
    protected String[] evaluateCondition(String cond) {
        String[] ret = new String[3];
        return ret;
    }

    public ResultSet execute(String sql) throws SQLException {
        Connection con = null;
        ResultSet rs = null;
        con = this.getConnection();
        Statement st = con.createStatement();
        rs = st.executeQuery(sql);
        return rs;
    }

    private void initConnections() throws DataConfigurationException {
        String configFileName = System.getProperty(PROP_CONFIG_FILE_NAME);
        this.props = new PropertiesExpansion();
        Connection pCon = null;
        try {
            try {
                ResultSet rs;
                try {
                    this.props.load((InputStream)new FileInputStream(configFileName));
                }
                catch (NullPointerException npEx) {
                    // empty catch block
                }
                PoolManager.getInstance().init((Properties)this.props);
                this.checkedConfigs = new ArrayList();
                pCon = this.getConnection();
                Statement st = pCon.createStatement();
                st.executeUpdate("CREATE TABLE IF NOT EXISTS TABLES_VERSIONS (TABLE_NAME VARCHAR(64) NOT NULL, VERSION INT NOT NULL)");
                st.executeUpdate("CREATE TABLE IF NOT EXISTS ATTACHMENTS (COLLECTIVITE VARCHAR(15) NOT NULL, PJ_NAME VARCHAR(270) NOT NULL, FILE_NAME VARCHAR(280) NOT NULL, DATA LONGBLOB, INDEX IX_PJ (COLLECTIVITE,PJ_NAME) ) ENGINE MYISAM");
                st.executeUpdate("CREATE TABLE IF NOT EXISTS CONFIGS_EXPORT (ID int unsigned NOT NULL auto_increment, DOC_ID varchar(100) NOT NULL, ETAT_ID varchar(100) NOT NULL, OWNER varchar(25) NOT NULL, DATE_CREA datetime NOT NULL, CODE varchar(250) NOT NULL, LIBELLE VARCHAR(200) NOT NULL, CONFIG longblob NOT NULL, PRIMARY KEY (ID, DOC_ID, ETAT_ID))");
                try {
                    st.executeQuery("SELECT 1 FROM LAST_INPUT_VALUES").close();
                }
                catch (Exception ex) {
                    st.executeUpdate("CREATE TABLE IF NOT EXISTS LAST_INPUT_VALUES(USER_ID VARCHAR(50) NOT NULL, INPUT_ID VARCHAR(250) NOT NULL, VALUE VARCHAR(250), INDEX IX_LAST_INPUT (USER_ID, INPUT_ID) ) ENGINE MYISAM");
                }
                try {
                    st.executeQuery("SELECT 1 FROM SAVED_REQUESTS").close();
                }
                catch (Exception ex) {
                    st.executeUpdate("CREATE TABLE IF NOT EXISTS SAVED_REQUESTS (ID VARCHAR(250) NOT NULL, REQUEST LONGBLOB, KEY_EM VARCHAR(250) NOT NULL, USER_ID VARCHAR(50) NOT NULL, PUBLIC INTEGER, TITLE VARCHAR(250) NOT NULL, INDEX IX_SR (KEY_EM,USER_ID) ) ENGINE MYISAM");
                }
                try {
                    st.executeQuery("SELECT 1 FROM XEM_IMPORTS").close();
                }
                catch (Exception ex) {
                    st.executeUpdate("CREATE TABLE IF NOT EXISTS XEM_IMPORTS (UTI_LOGIN VARCHAR(50) not null,IMPORT_ID VARCHAR(200) not null,FILE_NAME VARCHAR(200) not null,FILE_TYPE VARCHAR(200) not null,SUBMIT_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,END_DATE TIMESTAMP,STATUS integer not null,COLLECTIVITE VARCHAR(15),BUDGET VARCHAR(24),COLLECTIVITE_LIB VARCHAR(250),BUDGET_LIB VARCHAR(250),ERROR_MESSAGE LONGTEXT,CLEANED integer,INDEX IX_IMPORTS(UTI_LOGIN,IMPORT_ID))");
                }
                try {
                    st.executeQuery("SELECT 1 FROM XEM_IMPORTS_FILES").close();
                }
                catch (Exception ex) {
                    st.executeUpdate("CREATE TABLE IF NOT EXISTS XEM_IMPORTS_FILES (IMPORT_ID VARCHAR(200) not null,SUB_FILE_NAME LONGTEXT not null,FILE_TYPE VARCHAR(200) not null,STATUS INTEGER,COLLECTIVITE VARCHAR(15),BUDGET VARCHAR(24),COLLECTIVITE_LIB VARCHAR(250),BUDGET_LIB VARCHAR(250),ERROR_MESSAGE LONGTEXT,INDEX IX_IMPORTS_FILES(IMPORT_ID))");
                }
                try {
                    st.executeQuery("SELECT 1 FROM EXPORT_JOBS").close();
                    rs = st.executeQuery("SHOW COLUMNS FROM EXPORT_JOBS WHERE FIELD='GENERATED_FILE_NAME'");
                    if (!rs.next()) {
                        st.executeUpdate("ALTER TABLE EXPORT_JOBS ADD GENERATED_FILE_NAME VARCHAR(150)");
                    }
                    if (!(rs = st.executeQuery("SHOW COLUMNS FROM EXPORT_JOBS WHERE FIELD='ELEMENT_ID'")).next()) {
                        st.executeUpdate("ALTER TABLE EXPORT_JOBS ADD ELEMENT_ID VARCHAR(150)");
                    }
                }
                catch (Exception ex) {
                    st.executeUpdate("CREATE TABLE IF NOT EXISTS EXPORT_JOBS (UTI_LOGIN VARCHAR(50) not null,EXPORT_ID int unsigned NOT NULL auto_increment,FILE_NAME VARCHAR(80) not null,EXPORT_NAME VARCHAR(80) not null,DOC_ID VARCHAR(150) not null,ETAT_ID VARCHAR(150) not null,CONFIG_ID int unsigned not null,SIZE int,PRIORITY int,STATUS int not null,SUBMIT_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,RUN_DATE TIMESTAMP,DOWNLOAD_DATE TIMESTAMP,ERROR_MESSAGE LONGTEXT,DRS longblob not null,CLEANED integer,GENERATED_FILE_NAME VARCHAR(150),ELEMENT_ID VARCHAR(150),INDEX IX_IMPORTS(UTI_LOGIN,EXPORT_ID)) ENGINE MYISAM");
                }
                try {
                    rs = st.executeQuery("SELECT MAX(EXPORT_ID) FROM EXPORT_JOBS");
                    if (rs.next()) {
                        st.execute("ALTER TABLE EXPORT_JOBS AUTO_INCREMENT=" + (rs.getInt(1) + 1));
                    }
                }
                catch (SQLException sqlEx) {
                    logger.error((Object)"while setting auto_increment", (Throwable)sqlEx);
                }
                st.close();
                DatabaseMetaData dmd = pCon.getMetaData();
                logger.info((Object)("driver = " + dmd.getDriverName() + " - " + dmd.getDriverVersion()));
                logger.info((Object)("database = " + dmd.getDatabaseProductName() + " - " + dmd.getDatabaseProductVersion()));
            }
            catch (Throwable t) {
                logger.error((Object)"in initConnections()", t);
                StringBuilder sb = new StringBuilder();
                sb.append("Impossible de se connecter au serveur Xemelios :\npool=").append(this.props.getProperty("jndi.poolname") != null ? this.props.getProperty("jndi.poolname") : this.props.getProperty("database.url"));
                throw new DataConfigurationException(sb.toString(), t);
            }
            Object var6_14 = null;
            if (pCon != null) {
                this.releaseConnection(pCon);
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            if (pCon != null) {
                this.releaseConnection(pCon);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getLastInputValue(String inputId, XemeliosUser user) {
        String ret;
        block16: {
            PreparedStatement ps;
            Connection con;
            block14: {
                con = null;
                ps = null;
                ret = null;
                con = this.getConnection();
                ps = con.prepareStatement("SELECT VALUE FROM LAST_INPUT_VALUES WHERE USER_ID=? AND INPUT_ID=?");
                ps.setString(1, user.getId());
                ps.setString(2, inputId);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    ret = rs.getString(1);
                }
                rs.close();
                Object var8_8 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (SQLException sqlEx2) {
                    logger.info((Object)"getLastInputValue(String,XemeliosUser)", (Throwable)sqlEx2);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block16;
            {
                catch (SQLException sqlEx) {
                    logger.error((Object)"getLastInputValue(String,XemeliosUser)", (Throwable)sqlEx);
                    Object var8_9 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getLastInputValue(String,XemeliosUser)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqlEx2) {
                        logger.info((Object)"getLastInputValue(String,XemeliosUser)", (Throwable)sqlEx2);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setLastInputValue(String inputId, String value, XemeliosUser user) {
        block16: {
            PreparedStatement ps;
            Connection con;
            block14: {
                block13: {
                    con = null;
                    ps = null;
                    con = this.getConnection();
                    ps = con.prepareStatement("UPDATE LAST_INPUT_VALUES SET VALUE=? WHERE USER_ID=? AND INPUT_ID=?");
                    ps.setString(1, value);
                    ps.setString(2, user.getId());
                    ps.setString(3, inputId);
                    int ret = ps.executeUpdate();
                    if (ret != 0) break block13;
                    ps.close();
                    ps = con.prepareStatement("INSERT INTO LAST_INPUT_VALUES (INPUT_ID,USER_ID,VALUE) VALUES (?,?,?)");
                    ps.setString(1, inputId);
                    ps.setString(2, user.getId());
                    ps.setString(3, value);
                    ps.executeUpdate();
                }
                Object var8_8 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (SQLException sqlEx2) {
                    logger.info((Object)"setLastInputValue(String,String,XemeliosUser)", (Throwable)sqlEx2);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block16;
            {
                catch (SQLException sqlEx) {
                    logger.error((Object)"setLastInputValue(String,String,XemeliosUser)", (Throwable)sqlEx);
                    Object var8_9 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"setLastInputValue(String,String,XemeliosUser)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqlEx2) {
                        logger.info((Object)"setLastInputValue(String,String,XemeliosUser)", (Throwable)sqlEx2);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    public void shutdown() {
        this.reset();
        PoolManager.getInstance().shutdown();
    }

    public byte[] serializeDataResultSet(DataResultSet drs) {
        if (drs instanceof MySqlDataResultSet) {
            try {
                DataResultSetWrapperModel drsw = new DataResultSetWrapperModel(DataResultSetWrapperModel.QN);
                drsw.setDataResultSet(drs);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Charset cs = Charset.forName("UTF-8");
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, cs);
                XmlOutputter output = new XmlOutputter(osw, cs.name());
                drsw.marshall(output);
                osw.flush();
                return baos.toByteArray();
            }
            catch (IOException ex) {
                logger.error((Object)"serializeDataResultSet(DataResultSet)", (Throwable)ex);
                return null;
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DataResultSet deserializeDataResultSet(byte[] buffer) {
        try {
            DrswParser parser = new DrswParser();
            parser.parse(new ByteArrayInputStream(buffer));
            DataResultSetWrapperModel drsw = (DataResultSetWrapperModel)parser.getMarshallable();
            return drsw.getDataResultSet();
        }
        catch (Exception ex) {
            logger.error((Object)"deserializeDataResultSet(byte[])", (Throwable)ex);
            return null;
        }
    }

    public String getWarnings() {
        StringBuilder sb = this.warnings.remove(Thread.currentThread());
        return sb.toString();
    }

    public TPersistenceConfig getPersistenceConfig(DocumentModel dm, XemeliosUser user) throws DataConfigurationException {
        TPersistenceConfig pc = super.getPersistenceConfig(dm, user);
        TDocument spc = pc.getLayer(LAYER_NAME).getDocument(dm.getId());
        if (!this.checkedConfigs.contains(spc)) {
            logger.info((Object)("Chargement de la configuration " + dm.getTitre()));
            boolean allOk = true;
            boolean newer = false;
            boolean older = false;
            Connection con = null;
            ArrayList<TTable> tables = new ArrayList<TTable>();
            try {
                try {
                    con = this.getConnection();
                    int ret = 0;
                    if (spc.getListBcTable() != null) {
                        ret = MySqlDataLayer.checkTableVersion(spc.getListBcTable(), con);
                        allOk &= ret == 0;
                        if (ret < 0) {
                            older = true;
                        }
                        if (ret > 0) {
                            newer = true;
                        }
                        tables.add(spc.getListBcTable());
                    }
                    if (spc.getRepositoryTable() != null) {
                        ret = MySqlDataLayer.checkTableVersion(spc.getRepositoryTable(), con);
                        allOk &= ret == 0;
                        if (ret < 0) {
                            older = true;
                        }
                        if (ret > 0) {
                            newer = true;
                        }
                        tables.add(spc.getRepositoryTable());
                    }
                    if (spc.getSpecialKeyTable() != null) {
                        ret = MySqlDataLayer.checkTableVersion(spc.getSpecialKeyTable(), con);
                        allOk &= ret == 0;
                        if (ret < 0) {
                            older = true;
                        }
                        if (ret > 0) {
                            newer = true;
                        }
                        tables.add(spc.getSpecialKeyTable());
                    }
                    for (TEtat sec : spc.getEtats()) {
                        ret = MySqlDataLayer.checkTableVersion(sec.getDocumentTable(), con);
                        allOk &= ret == 0;
                        if (ret < 0) {
                            older = true;
                        }
                        if (ret > 0) {
                            newer = true;
                        }
                        tables.add(sec.getDocumentTable());
                        for (TTable table : sec.getIndexTables()) {
                            ret = MySqlDataLayer.checkTableVersion(table, con);
                            allOk &= ret == 0;
                            if (ret < 0) {
                                older = true;
                            }
                            if (ret > 0) {
                                newer = true;
                            }
                            tables.add(table);
                        }
                    }
                    if (!allOk) {
                        if (older) {
                            StringBuilder msg = new StringBuilder();
                            msg.append("Votre base de donn\u00e9e contient des tables dont la version est plus r\u00e9cente\nque votre version de Xemelios.\n");
                            msg.append("Il vous faut mettre \u00e0 jour votre version de Xemelios avant de pouvoir l'utiliser.");
                            throw new DataConfigurationException("Version de Xemelios trop ancienne");
                        }
                        if (newer) {
                            for (TTable table : tables) {
                                this.updateTableVersion(table, con);
                            }
                            this.checkedConfigs.add(spc);
                        }
                    }
                    this.checkedConfigs.add(spc);
                }
                catch (SQLException sqlEx) {
                    throw new DataConfigurationException((Throwable)sqlEx);
                }
                Object var16_16 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int checkTableVersion(TTable sti, Connection con) {
        int ret;
        PreparedStatement ps;
        block9: {
            if (sti == null) {
                return 0;
            }
            ps = null;
            ret = 0;
            ps = con.prepareStatement("SELECT VERSION FROM TABLES_VERSIONS WHERE TABLE_NAME=?");
            ps.setString(1, sti.getBaseName());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block9;
            ret = sti.getVersion() - rs.getInt(1);
        }
        Object var6_6 = null;
        if (ps == null) return ret;
        try {
            ps.close();
            return ret;
        }
        catch (Throwable t) {}
        return ret;
        {
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                Object var6_7 = null;
                if (ps == null) return ret;
                try {
                    ps.close();
                    return ret;
                }
                catch (Throwable t) {}
                return ret;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getLastWarnings() {
        return this.warnings.get(Thread.currentThread()).toString();
    }

    /*
     * Loose catch block
     */
    public void importPj(PJRef pj, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        block20: {
            Throwable t22;
            Connection con;
            ResultSet rs;
            PreparedStatement ps;
            block18: {
                if (!user.hasRole("IMPORT")) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 importer des donn\u00e9es");
                }
                ps = null;
                rs = null;
                con = null;
                con = this.getConnection();
                String s = "SELECT 1 FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?";
                ps = con.prepareStatement(s);
                ps.setString(1, pj.getCollectivite());
                ps.setString(2, pj.getPjName());
                rs = ps.executeQuery();
                if (rs.next()) {
                    ps.close();
                    ps = con.prepareStatement("DELETE FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?");
                    ps.setString(1, pj.getCollectivite());
                    ps.setString(2, pj.getPjName());
                    ps.executeUpdate();
                }
                ps.close();
                ps = con.prepareStatement("INSERT INTO ATTACHMENTS (COLLECTIVITE,PJ_NAME,FILE_NAME,DATA) VALUES (?,?,?,?)");
                ps.setString(1, pj.getCollectivite());
                ps.setString(2, pj.getPjName());
                ps.setString(3, pj.getFileName());
                ps.setBinaryStream(4, pj.getDataInputStream(), (int)pj.getUncompressedSize());
                ps.executeUpdate();
                Object var8_9 = null;
                if (rs == null) break block18;
                try {
                    rs.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"rs closed !", t22);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"ps closed !", t22);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block20;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
                catch (Exception ex) {
                    throw new DataConfigurationException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Throwable t22;
                Object var8_10 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t22) {
                        logger.info((Object)"rs closed !", t22);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t22) {
                        logger.info((Object)"ps closed !", t22);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public PJRef getPj(Pair collectivite, String pjName, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        PJRef pj;
        block15: {
            Statement ps;
            Connection con;
            block14: {
                block13: {
                    if (!user.hasRole("SEARCH")) {
                        throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
                    }
                    con = null;
                    ps = null;
                    pj = null;
                    logger.debug((Object)("getting " + pjName + " in " + collectivite.key));
                    con = this.getConnection();
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT FILE_NAME, DATA FROM ATTACHMENTS WHERE COLLECTIVITE=? AND FILE_NAME=?");
                    ps = con.prepareStatement(sb.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, pjName);
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block13;
                    pj = new PJRef();
                    byte[] buff = new byte[512];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = rs.getAsciiStream(2);
                    int length = is.read(buff);
                    while (length > 0) {
                        baos.write(buff, 0, length);
                        length = is.read(buff);
                    }
                    pj.setData(baos.toByteArray());
                    pj.setFileName(rs.getString(1));
                }
                Object var14_15 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
                catch (IOException ioEx) {
                    throw new DataAccessException((Throwable)ioEx);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return pj;
    }

    /*
     * Loose catch block
     */
    public PJRef getPjByUniqueId(Pair collectivite, String id, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        PJRef pj;
        block15: {
            Statement ps;
            Connection con;
            block14: {
                block13: {
                    if (!user.hasRole("SEARCH")) {
                        throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
                    }
                    con = null;
                    ps = null;
                    pj = null;
                    logger.debug((Object)("getting " + id + " in " + collectivite.key));
                    con = this.getConnection();
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT FILE_NAME, DATA FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?");
                    ps = con.prepareStatement(sb.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, id);
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block13;
                    pj = new PJRef();
                    byte[] buff = new byte[512];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = rs.getAsciiStream(2);
                    int length = is.read(buff);
                    while (length > 0) {
                        baos.write(buff, 0, length);
                        length = is.read(buff);
                    }
                    pj.setData(baos.toByteArray());
                    pj.setFileName(rs.getString(1));
                }
                Object var14_15 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
                catch (IOException ioEx) {
                    throw new DataAccessException((Throwable)ioEx);
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return pj;
    }

    /*
     * Loose catch block
     */
    public boolean isPjAvailable(Pair collectivite, String id, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        boolean ret;
        block13: {
            Statement ps;
            Connection con;
            block12: {
                if (!user.hasRole("SEARCH")) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
                }
                con = null;
                ret = false;
                ps = null;
                con = this.getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT 1 FROM ATTACHMENTS WHERE COLLECTIVITE=? AND FILE_NAME=?");
                ps = con.prepareStatement(sb.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    ret = true;
                }
                rs.close();
                Object var10_10 = null;
                if (ps == null) break block12;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block13;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<String> getDocumentListFromSpecialKeys(ElementModel em, String collectivite, String budget, String sp1, String sp2, String sp3, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        Throwable t22;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        ArrayList<String> ret;
        block26: {
            TSqlIndex si;
            String path;
            SpecialKeyModel skm;
            if (!user.hasRole("SEARCH")) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
            }
            if (!user.hasDocument(em.getParent().getParent().getId())) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre());
            }
            if (!user.hasCollectivite(collectivite, em.getParent().getParent())) {
                throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des donn\u00e9es pour cette collectivit\u00e9");
            }
            ret = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            EtatModel etatModel = em.getParent();
            TDocument pc = this.getPersistenceConfig(etatModel.getParent(), user).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
            TEtat sec = pc.getEtat(etatModel.getId());
            sb.append("SELECT DOC_ID FROM ").append(sec.getMaintable().getBaseName()).append(" WHERE " + pc.getCollectiviteCodeColname() + "=? AND " + pc.getBudgetCodeColname() + "=? ");
            DocumentModel dm = etatModel.getParent();
            Vector specialKeys = dm.getSpecialKeys();
            if (sp1 != null) {
                skm = null;
                for (SpecialKeyModel sk : specialKeys) {
                    if (sk.getPos() != 1) continue;
                    skm = sk;
                }
                if (skm == null) throw new DataConfigurationException("no special key in pos 1 defined for " + dm.getId());
                path = skm.getPath();
                si = sec.getSqlIndexByPath(path);
                if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
                sb.append("AND ").append(si.getColumn()).append("=? ");
            }
            if (sp2 != null) {
                skm = null;
                for (SpecialKeyModel sk : specialKeys) {
                    if (sk.getPos() != 2) continue;
                    skm = sk;
                }
                if (skm == null) throw new DataConfigurationException("no special key in pos 2 defined for " + dm.getId());
                path = skm.getPath();
                si = sec.getSqlIndexByPath(path);
                if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
                sb.append("AND ").append(si.getColumn()).append("=? ");
            }
            if (sp3 != null) {
                skm = null;
                for (SpecialKeyModel sk : specialKeys) {
                    if (sk.getPos() != 3) continue;
                    skm = sk;
                }
                if (skm == null) throw new DataConfigurationException("no special key in pos 3 defined for " + dm.getId());
                path = skm.getPath();
                si = sec.getSqlIndexByPath(path);
                if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
                sb.append("AND ").append(si.getColumn()).append("=? ");
            }
            logger.debug((Object)sb.toString());
            con = null;
            ps = null;
            rs = null;
            con = this.getConnection();
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite);
            logger.debug((Object)("1->" + collectivite));
            ps.setString(2, budget);
            logger.debug((Object)("2->" + budget));
            if (sp1 != null) {
                ps.setString(3, sp1);
                logger.debug((Object)("3->" + sp1));
            }
            if (sp2 != null) {
                ps.setString(4, sp2);
            }
            if (sp3 != null) {
                ps.setString(5, sp3);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            Object var20_18 = null;
            if (rs == null) break block26;
            try {
                rs.close();
            }
            catch (Throwable t22) {
                logger.info((Object)"rs closed !", t22);
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable t22) {
                logger.info((Object)"ps closed !", t22);
            }
        }
        if (con == null) return ret;
        this.releaseConnection(con);
        {
            return ret;
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
        catch (Throwable throwable) {
            Throwable t22;
            Object var20_19 = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"rs closed !", t22);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"ps closed !", t22);
                }
            }
            if (con == null) throw throwable;
            this.releaseConnection(con);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public ArrayList<String> getDocumentListFromXPath(ElementModel em, String collectivite, String budget, String sp1, String sp2, String sp3, String xpath, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        ArrayList<String> ret;
        block57: {
            Throwable t22;
            ResultSet rs;
            PreparedStatement ps;
            Connection con;
            block55: {
                String tName;
                TSqlIndex si;
                String path;
                SpecialKeyModel skm;
                if (!user.hasRole("SEARCH")) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
                }
                if (!user.hasDocument(em.getParent().getParent().getId())) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre());
                }
                if (!user.hasCollectivite(collectivite, em.getParent().getParent())) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des donn\u00e9es pour cette collectivit\u00e9");
                }
                ret = new ArrayList<String>();
                StringBuffer selectClause = new StringBuffer();
                StringBuffer fromClause = new StringBuffer();
                StringBuffer whereClause = new StringBuffer();
                ArrayList<String> addedTableNames = new ArrayList<String>();
                EtatModel etatModel = em.getParent();
                TDocument pc = this.getPersistenceConfig(etatModel.getParent(), user).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
                TEtat sec = pc.getEtat(etatModel.getId());
                selectClause.append("SELECT ").append(sec.getMaintable().getBaseName()).append(".DOC_ID ");
                fromClause.append("FROM ").append(sec.getMaintable().getBaseName()).append(" ");
                addedTableNames.add(sec.getMaintable().getId());
                whereClause.append(" WHERE ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=? AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=? ");
                DocumentModel dm = etatModel.getParent();
                Vector specialKeys = dm.getSpecialKeys();
                if (sp1 != null) {
                    skm = null;
                    for (SpecialKeyModel sk : specialKeys) {
                        if (sk.getPos() != 1) continue;
                        skm = sk;
                    }
                    if (skm != null) {
                        path = skm.getPath();
                        si = sec.getSqlIndexByPath(path);
                        tName = sec.getIndexTable(si.getTableId()).getBaseName();
                        whereClause.append("AND ").append(tName).append(".").append(si.getColumn()).append("=? ");
                        if (!addedTableNames.contains(si.getTableId())) {
                            fromClause.append(" LEFT OUTER JOIN ").append(tName).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(tName).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(tName).append("." + pc.getCollectiviteCodeColname() + " AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(tName).append("." + pc.getBudgetCodeColname() + "");
                            addedTableNames.add(si.getTableId());
                        }
                    } else {
                        throw new DataConfigurationException("no special key in pos 1 defined for " + dm.getId());
                    }
                }
                if (sp2 != null) {
                    skm = null;
                    for (SpecialKeyModel sk : specialKeys) {
                        if (sk.getPos() != 2) continue;
                        skm = sk;
                    }
                    if (skm != null) {
                        path = skm.getPath();
                        si = sec.getSqlIndexByPath(path);
                        tName = sec.getIndexTable(si.getTableId()).getBaseName();
                        whereClause.append("AND ").append(tName).append(".").append(si.getColumn()).append("=? ");
                        if (!addedTableNames.contains(si.getTableId())) {
                            fromClause.append(" LEFT OUTER JOIN ").append(tName).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(tName).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(tName).append("." + pc.getCollectiviteCodeColname() + " AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(tName).append("." + pc.getBudgetCodeColname() + "");
                            addedTableNames.add(si.getTableId());
                        }
                    } else {
                        throw new DataConfigurationException("no special key in pos 2 defined for " + dm.getId());
                    }
                }
                if (sp3 != null) {
                    skm = null;
                    for (SpecialKeyModel sk : specialKeys) {
                        if (sk.getPos() != 3) continue;
                        skm = sk;
                    }
                    if (skm != null) {
                        path = skm.getPath();
                        si = sec.getSqlIndexByPath(path);
                        tName = sec.getIndexTable(si.getTableId()).getBaseName();
                        whereClause.append("AND ").append(tName).append(".").append(si.getColumn()).append("=? ");
                        if (!addedTableNames.contains(si.getTableId())) {
                            fromClause.append(" LEFT OUTER JOIN ").append(tName).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(tName).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(tName).append("." + pc.getCollectiviteCodeColname() + " AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(tName).append("." + pc.getBudgetCodeColname() + "");
                            addedTableNames.add(si.getTableId());
                        }
                    } else {
                        throw new DataConfigurationException("no special key in pos 3 defined for " + dm.getId());
                    }
                }
                if (xpath != null) {
                    logger.debug((Object)("xpath is " + xpath));
                    if (xpath.startsWith(em.getPath().getPath())) {
                        String[] conds;
                        String shortPath = xpath.substring(em.getPath().getPath().length());
                        if (!shortPath.startsWith("[")) {
                            throw new DataConfigurationException("XPath too complicated. This implementation can only deal with XPath formed by <path-to-element>[cond on sub-element][cond on sub element]...");
                        }
                        for (String s : conds = MySqlDataLayer.splitConditions(shortPath)) {
                            logger.debug((Object)s);
                            s = s.substring(1, s.length() - 1);
                            String op = null;
                            int pos = -1;
                            pos = s.indexOf("<=");
                            if (pos >= 0) {
                                op = "<=";
                            } else {
                                pos = s.indexOf(">=");
                                if (pos >= 0) {
                                    op = ">=";
                                } else {
                                    pos = s.indexOf(61);
                                    if (pos >= 0) {
                                        op = "=";
                                    } else {
                                        pos = s.indexOf(60);
                                        if (pos >= 0) {
                                            op = "<";
                                        } else {
                                            pos = s.indexOf(62);
                                            if (pos >= 0) {
                                                op = ">";
                                            }
                                        }
                                    }
                                }
                            }
                            String left = s.substring(0, pos);
                            String right = s.substring(pos + op.length());
                            String indexedPath = em.getPath().getPath() + "/" + left;
                            logger.debug((Object)(indexedPath + " " + op + " " + right));
                            TSqlIndex si2 = sec.getSqlIndexByPath(indexedPath);
                            if (si2 != null) {
                                String tName2 = sec.getIndexTable(si2.getTableId()).getBaseName();
                                String value = null;
                                if ("string".equals(si2.getDatatype())) {
                                    value = MySqlDataLayer.sqlEscapeString(si2.getFormattedStringValue(right));
                                    if (!value.startsWith("'") && !value.endsWith("'")) {
                                        value = "'".concat(value).concat("'");
                                    }
                                } else {
                                    value = MySqlDataLayer.sqlEscapeString(right);
                                }
                                whereClause.append("AND ").append(tName2).append(".").append(si2.getColumn()).append(op).append(value).append(" ");
                                if (addedTableNames.contains(si2.getTableId())) continue;
                                fromClause.append(" LEFT OUTER JOIN ").append(tName2).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(tName2).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(tName2).append("." + pc.getCollectiviteCodeColname() + " AND ").append(sec.getMaintable().getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(tName2).append("." + pc.getBudgetCodeColname() + "");
                                addedTableNames.add(si2.getTableId());
                                continue;
                            }
                            throw new DataConfigurationException("path not indexed: " + indexedPath);
                        }
                    } else {
                        throw new DataConfigurationException("XPath too complicated. only XPath starting with element path are allowed. Here, XPath should start with " + em.getPath().getPath());
                    }
                }
                String sql = selectClause.append(fromClause.toString()).append(whereClause.toString()).toString();
                logger.debug((Object)sql);
                con = null;
                ps = null;
                rs = null;
                con = this.getConnection();
                ps = con.prepareStatement(sql);
                ps.setString(1, collectivite);
                logger.debug((Object)("1(coll)->" + collectivite));
                ps.setString(2, budget);
                logger.debug((Object)("2(budg)->" + budget));
                if (sp1 != null) {
                    ps.setString(3, sp1);
                    logger.debug((Object)("3(sp1 )->" + sp1));
                }
                if (sp2 != null) {
                    ps.setString(4, sp2);
                    logger.debug((Object)("4(sp2 )->" + sp2));
                }
                if (sp3 != null) {
                    ps.setString(5, sp3);
                    logger.debug((Object)("5(sp3 )->" + sp3));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    ret.add(rs.getString(1));
                }
                Object var34_36 = null;
                if (rs == null) break block55;
                try {
                    rs.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"rs closed !", t22);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t22) {
                    logger.info((Object)"ps closed !", t22);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block57;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
            }
            catch (Throwable throwable) {
                Throwable t22;
                Object var34_37 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t22) {
                        logger.info((Object)"rs closed !", t22);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t22) {
                        logger.info((Object)"ps closed !", t22);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    private static String[] splitConditions(String cond) throws DataConfigurationException {
        ArrayList<String> ret = new ArrayList<String>();
        String s = cond;
        while (s.length() > 0 && s.charAt(0) == '[') {
            int end = MySqlDataLayer.findClosingParenthesis(s, 0, "[]");
            ret.add(s.substring(0, end + 1));
            s = s.substring(end + 1);
        }
        String[] aRet = new String[ret.size()];
        ret.toArray(aRet);
        return aRet;
    }

    private static int findClosingParenthesis(String expr, int first, String delimitors) throws DataConfigurationException {
        char OPENNING_DELIM = delimitors.charAt(0);
        char CLOSING_DELIM = delimitors.charAt(1);
        int len = expr.length();
        int close = -1;
        int pCount = 1;
        for (int i = first + 1; i < len; ++i) {
            char c = expr.charAt(i);
            if (c == OPENNING_DELIM) {
                ++pCount;
            } else if (c == CLOSING_DELIM) {
                --pCount;
            }
            if (pCount != 0) continue;
            close = i;
            break;
        }
        if (close == -1) {
            throw new DataConfigurationException("unbalanced delimitor");
        }
        return close;
    }

    public SimpleDateFormat getDateFormatter() {
        return mySqlDateFormat;
    }

    public Pair[] getAggregateOperators(String datatype) {
        ArrayList<Pair> result = new ArrayList<Pair>();
        logger.debug((Object)("Requested aggregate operators for data type " + datatype));
        if (datatype.equals("integer") || datatype.equals("decimal") || datatype.equals("amount")) {
            result.add(new Pair("AVG", "Moyenne"));
            result.add(new Pair("SUM", "Somme"));
            result.add(new Pair("MIN", "Minimum"));
            result.add(new Pair("MAX", "Maximum"));
            result.add(new Pair("STDDEV_POP", "Ecart type"));
            result.add(new Pair("VAR_POP", "Variance"));
        } else if (datatype.equals("date")) {
            result.add(new Pair("SEC_TO_TIME(SUM(TIME_TO_SEC", "Somme"));
            result.add(new Pair("SEC_TO_TIME(AVG(TIME_TO_SEC", "Moyenne"));
        }
        Pair[] aRet = new Pair[result.size()];
        result.toArray(aRet);
        return aRet;
    }

    public String calculateAggregate(DocumentModel dm, EtatModel em, String columnXPath, String operator, ChampModel cm, DataResultSet rs, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("SEARCH")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des recherches");
        }
        if (!user.hasDocument(dm.getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre());
        }
        if (!user.hasCollectivite(rs.getCollectivite().key, dm)) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre() + " pour cette collectivit\u00e9 " + rs.getCollectivite().libelle != null ? "(" + rs.getCollectivite().libelle + ")" : "");
        }
        TPersistenceConfig pers = this.getPersistenceConfig(dm, user);
        TLayer layer = pers.getLayer(this.getLayerName());
        TDocument tdoc = layer.getDocument(dm.getId());
        TEtat tet = tdoc.getEtat(em.getId());
        columnXPath = columnXPath.replaceAll("\\[[0-9]\\]", "");
        logger.debug((Object)columnXPath);
        TSqlIndex tsqlIndex = tet.getSqlIndexByPath(columnXPath);
        if (tsqlIndex == null) {
            throw new DataConfigurationException("Pas d'index sur " + columnXPath);
        }
        String columnName = tsqlIndex.getColumn();
        String tableName = tet.getIndexTable(tsqlIndex.getTableId()).getBaseName();
        if (rs != null) {
            MySqlDataResultSet myRs = (MySqlDataResultSet)rs;
            return myRs.calculateAggregate(tableName + "." + columnName, tableName, operator, cm);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkParamTable() {
        block18: {
            Statement st;
            Connection con;
            block16: {
                con = null;
                st = null;
                ResultSet rs = null;
                con = this.getConnection();
                st = con.createStatement();
                rs = st.executeQuery("SELECT 1 FROM PARAMETERS");
                rs.close();
                Object var7_4 = null;
                if (st == null) break block16;
                try {
                    st.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block18;
            {
                catch (SQLException sqlEx) {
                    if (sqlEx.getErrorCode() == 1146) {
                        try {
                            st.executeUpdate("CREATE TABLE PARAMETERS (PARAM_NAME VARCHAR(100) NOT NULL, PARAM_VALUE VARCHAR(100), UNIQUE INDEX PARAM_IX (PARAM_NAME)) ENGINE MYISAM");
                        }
                        catch (Throwable t) {
                            logger.error((Object)"while creating PARAMETERS", t);
                        }
                    }
                    Object var7_5 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getParameterValue(String paramName) {
        String ret;
        block25: {
            Throwable t222;
            ResultSet rs;
            PreparedStatement ps;
            Connection con;
            block21: {
                block20: {
                    con = null;
                    ps = null;
                    rs = null;
                    ret = null;
                    con = this.getConnection();
                    ps = con.prepareStatement("SELECT PARAM_VALUE FROM PARAMETERS WHERE PARAM_NAME=?");
                    ps.setString(1, paramName);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block20;
                    ret = rs.getString(1);
                }
                Object var8_6 = null;
                if (rs == null) break block21;
                try {
                    rs.close();
                }
                catch (Throwable t222) {
                    logger.info((Object)"rs closed !", t222);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t222) {
                    logger.info((Object)"ps closed !", t222);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block25;
            {
                catch (SQLException sqlEx) {
                    Throwable t222;
                    logger.error((Object)"in getParameterValue", (Throwable)sqlEx);
                    Object var8_7 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t222) {
                            logger.info((Object)"rs closed !", t222);
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t222) {
                            logger.info((Object)"ps closed !", t222);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable t222;
                Object var8_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t222) {
                        logger.info((Object)"rs closed !", t222);
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t222) {
                        logger.info((Object)"ps closed !", t222);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setParameterValue(String paramName, String paramValue) {
        block15: {
            Statement ps;
            Connection con;
            block13: {
                con = null;
                ps = null;
                con = this.getConnection();
                String ret = this.getParameterValue(paramName);
                ps = ret == null ? con.prepareStatement("INSERT INTO PARAMETERS (PARAM_VALUE, PARAM_NAME) VALUES (?, ?)") : con.prepareStatement("UPDATE PARAMETERS SET PARAM_VALUE=? WHERE PARAM_NAME=?");
                ps.setString(1, paramValue);
                ps.setString(2, paramName);
                ps.executeUpdate();
                Object var7_7 = null;
                if (ps == null) break block13;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (SQLException sqlEx) {
                    logger.error((Object)"in getParameterValue", (Throwable)sqlEx);
                    Object var7_8 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    private void applyPatches() {
        Object patcher;
        new RsaPatch40014(this).run();
        new SavedRequestsPatch().run();
        new CgCollocPatch40(this).run();
        if (this.getParameterValue("repository.patch.applied") == null) {
            patcher = new RepositoryPatch(this);
            ((RepositoryPatch)patcher).run();
        }
        if (this.getParameterValue("paye.patch.3.2.applied") == null) {
            patcher = new PayePatch32(this);
            ((PayePatch32)patcher).run();
        }
        if (this.getParameterValue("versement.patch.3.2.applied") == null) {
            patcher = new VersementPatch32(this);
            ((VersementPatch32)patcher).run();
        }
        if (this.getParameterValue("pesv2.patch.3.3.applied") == null) {
            patcher = new PesAllerPatch33(this);
            ((PesAllerPatch33)patcher).run();
        }
        if (this.getParameterValue("rapport.patch.3.3.applied") == null) {
            patcher = new RapportPatch33(this);
            ((RapportPatch33)patcher).run();
        }
        if (this.getParameterValue("paye.patch.4.0.applied") == null) {
            patcher = new PayePatch40(this);
            ((PayePatch40)patcher).run();
        }
        this.killPatchProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void insertConfigExport(ConfigModel cm, XemeliosUser user) {
        block15: {
            PreparedStatement ps;
            Connection con;
            block13: {
                con = null;
                ps = null;
                con = this.getConnection();
                ps = con.prepareStatement("INSERT INTO CONFIGS_EXPORT (DOC_ID,ETAT_ID,OWNER,DATE_CREA,CODE,LIBELLE,CONFIG) VALUES (?,?,?,CURRENT_DATE(),?,?,?)");
                int i = 1;
                ps.setString(i++, cm.getDocID());
                ps.setString(i++, cm.getEtatID());
                ps.setString(i++, user.getId());
                ps.setString(i++, cm.getCode());
                ps.setString(i++, cm.getLibelle());
                byte[] buffer = cm.getConfigLines();
                ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                ps.setBinaryStream(i++, (InputStream)is, buffer.length);
                ps.executeUpdate();
                Object var9_9 = null;
                if (ps == null) break block13;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (Exception e) {
                    logger.error((Object)"in insertConfigExport ", (Throwable)e);
                    Object var9_10 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateConfigExport(ConfigModel cm, XemeliosUser user) {
        block15: {
            PreparedStatement ps;
            Connection con;
            block13: {
                con = null;
                ps = null;
                con = this.getConnection();
                ps = con.prepareStatement("UPDATE CONFIGS_EXPORT set CODE=?, LIBELLE=?, CONFIG=? WHERE ID=? AND DOC_ID=? AND ETAT_ID=?");
                int i = 1;
                ps.setString(i++, cm.getCode());
                ps.setString(i++, cm.getLibelle());
                byte[] buffer = cm.getConfigLines();
                ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                ps.setBinaryStream(i++, (InputStream)is, buffer.length);
                ps.setString(i++, cm.getId());
                ps.setString(i++, cm.getDocID());
                ps.setString(i++, cm.getEtatID());
                ps.executeUpdate();
                Object var9_9 = null;
                if (ps == null) break block13;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (Exception e) {
                    logger.error((Object)"in updateConfigExport ", (Throwable)e);
                    Object var9_10 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Vector<ConfigModel> getListeConfigsExport(String docID, String etatID, XemeliosUser user) {
        Vector<ConfigModel> ret;
        block16: {
            PreparedStatement ps;
            Connection con;
            block14: {
                con = null;
                ps = null;
                ret = new Vector<ConfigModel>();
                con = this.getConnection();
                ps = con.prepareStatement("SELECT ID,DOC_ID,ETAT_ID,OWNER,DATE_CREA,CODE,LIBELLE,CONFIG FROM CONFIGS_EXPORT WHERE DOC_ID=? AND ETAT_ID=? ORDER BY CODE");
                int i = 1;
                ps.setString(i++, docID);
                ps.setString(i++, etatID);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ret.add(new ConfigModel(rs));
                }
                Object var10_10 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block16;
            {
                catch (Exception e) {
                    logger.error((Object)"in getListeConfigsExport ", (Throwable)e);
                    Object var10_11 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ConfigModel getConfigExport(String docId, String etatId, String configId, XemeliosUser user) {
        ConfigModel ret;
        block16: {
            PreparedStatement ps;
            Connection con;
            block14: {
                block13: {
                    con = null;
                    ps = null;
                    ret = null;
                    con = this.getConnection();
                    ps = con.prepareStatement("SELECT ID,DOC_ID,ETAT_ID,OWNER,DATE_CREA,CODE,LIBELLE,CONFIG FROM CONFIGS_EXPORT WHERE DOC_ID=? AND ETAT_ID=? ANd ID=? ORDER BY CODE");
                    int i = 1;
                    ps.setString(i++, docId);
                    ps.setString(i++, etatId);
                    ps.setString(i++, configId);
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block13;
                    ret = new ConfigModel(rs);
                }
                Object var11_11 = null;
                if (ps == null) break block14;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block16;
            {
                catch (Exception e) {
                    logger.error((Object)"in getConfigExport ", (Throwable)e);
                    Object var11_12 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deleteConfigExport(ConfigModel cm, XemeliosUser user) {
        block15: {
            PreparedStatement ps;
            Connection con;
            block13: {
                con = null;
                ps = null;
                con = this.getConnection();
                ps = con.prepareStatement("DELETE FROM CONFIGS_EXPORT WHERE ID=? AND DOC_ID=? AND ETAT_ID=?");
                int i = 1;
                ps.setString(i++, cm.getId());
                ps.setString(i++, cm.getDocID());
                ps.setString(i++, cm.getEtatID());
                ps.executeUpdate();
                Object var7_7 = null;
                if (ps == null) break block13;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block15;
            {
                catch (Exception e) {
                    logger.error((Object)"in deleteConfigExport ", (Throwable)e);
                    Object var7_8 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public ExportableData searchFichiers(DocumentModel dm, String coll, String budg, XemeliosUser user) throws DataAccessException, DataConfigurationException, UnauthorizedException {
        boolean found;
        ExportableData dD;
        block26: {
            Statement ps;
            Connection con;
            block25: {
                if (!user.hasRole("EXPORT")) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des exports");
                }
                if (!user.hasDocument(dm.getId())) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 exporter des " + dm.getTitre());
                }
                if (!user.hasCollectivite(coll, dm)) {
                    throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 exporter des " + dm.getTitre() + " pour cette collectivit\u00e9");
                }
                dD = null;
                TDocument pc = this.getPersistenceConfig(dm, user).getLayer(LAYER_NAME).getDocument(dm.getId());
                con = null;
                ps = null;
                found = false;
                con = this.getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT " + pc.getCollectiviteCodeColname() + ", " + pc.getCollectiviteLibColname() + ", " + pc.getBudgetCodeColname() + ", " + pc.getBudgetLibColname() + ", INITIAL_DOC_NAME FROM ").append(pc.getListBcTable().getBaseName());
                if (coll != null) {
                    sb.append(" WHERE " + pc.getCollectiviteCodeColname() + "=? ");
                }
                if (budg != null) {
                    if (coll == null) {
                        sb.append(" WHERE ");
                    } else {
                        sb.append(" AND ");
                    }
                    sb.append(" " + pc.getBudgetCodeColname() + " = ? ");
                }
                sb.append(" ORDER BY " + pc.getCollectiviteLibColname() + ", " + pc.getBudgetLibColname() + ", INITIAL_DOC_NAME");
                ps = con.prepareStatement(sb.toString());
                int i = 1;
                if (coll != null) {
                    ps.setString(i++, coll);
                }
                if (budg != null) {
                    ps.setString(i++, budg);
                }
                ResultSet rs = ps.executeQuery();
                String lastColl = "";
                String lastBudg = "";
                while (rs.next()) {
                    if (!found) {
                        dD = new ExportableData();
                        dD.setKey(dm.getId());
                        dD.setLevel(1);
                        dD.setLibelle(dm.getTitre());
                        dD.setSelected(false);
                    }
                    found = true;
                    String curColl = rs.getString(1);
                    String curBudg = rs.getString(3);
                    ExportableData dF = new ExportableData();
                    dF.setKey(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3) + "|" + rs.getString(5));
                    dF.setLevel(6);
                    dF.setLibelle(rs.getString(5));
                    dF.setSelected(false);
                    ExportableData dC = null;
                    if (!curColl.equals(lastColl)) {
                        dC = new ExportableData();
                        dC.setKey(dm.getId() + "|" + rs.getString(1));
                        dC.setLevel(2);
                        dC.setLibelle(rs.getString(1) + " - " + rs.getString(2));
                        dC.setSelected(false);
                        dD.addChild(dC);
                        lastBudg = "";
                    } else {
                        dC = dD.getChild(dm.getId() + "|" + rs.getString(1));
                    }
                    ExportableData dB = null;
                    if (!curBudg.equals(lastBudg)) {
                        dB = new ExportableData();
                        dB.setKey(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3));
                        dB.setLevel(3);
                        dB.setLibelle(rs.getString(3) + " - " + rs.getString(4));
                        dB.setSelected(false);
                        dC.addChild(dB);
                    } else {
                        dB = dC.getChild(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3));
                    }
                    dB.addChild(dF);
                    lastBudg = curBudg;
                    lastColl = curColl;
                }
                Object var21_21 = null;
                if (ps == null) break block25;
                try {
                    ps.close();
                }
                catch (Throwable t) {
                    logger.info((Object)"ps closed !", t);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block26;
            {
                catch (SQLException sqlEx) {
                    throw new DataAccessException((Throwable)sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return found ? dD : null;
    }

    public Vector<ExportableData> searchFichiers(DocumentsModel dms, String coll, String budg, XemeliosUser user) throws DataAccessException, DataConfigurationException, UnauthorizedException {
        Vector<ExportableData> ret = new Vector<ExportableData>();
        for (DocumentModel doc : dms.getDocuments()) {
            try {
                ExportableData tmp = this.searchFichiers(doc, coll, budg, user);
                if (tmp == null) continue;
                ret.add(tmp);
            }
            catch (DataAccessException dae) {
                if (dae.getMessage().endsWith("doesn't exist")) continue;
                throw dae;
            }
        }
        return ret;
    }

    protected String buildSelectToExport(int whatToExport, ElementModel elementModel, Pair coll, Pair budg, String fic, Pair sk1, Pair sk2, XemeliosUser user) throws DataConfigurationException {
        EtatModel etatModel = elementModel.getParent();
        DocumentModel documentModel = etatModel.getParent();
        TDocument pc = this.getPersistenceConfig(documentModel, user).getLayer(LAYER_NAME).getDocument(documentModel.getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        TTable mainTable = sec.getMaintable();
        TTable docTable = sec.getDocumentTable();
        StringBuffer sb = new StringBuffer();
        switch (whatToExport) {
            case 3: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" WHERE ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" ");
                break;
            }
            case 4: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" LEFT OUTER JOIN ").append(pc.getSpecialKeyTable().getBaseName()).append(" ON ");
                sb.append(docTable.getBaseName()).append(".INITIAL_DOC_NAME=").append(pc.getSpecialKeyTable().getBaseName()).append(".INITIAL_DOC_NAME ");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(pc.getSpecialKeyTable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + " ");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(pc.getSpecialKeyTable().getBaseName()).append("." + pc.getBudgetCodeColname() + " ");
                sb.append(" WHERE ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY1='").append(StringEscapeUtils.escapeSql((String)sk1.key)).append("'");
                sb.append(" ");
                break;
            }
            case 5: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" LEFT OUTER JOIN ").append(pc.getSpecialKeyTable().getBaseName()).append(" ON ");
                sb.append(docTable.getBaseName()).append(".INITIAL_DOC_NAME=").append(pc.getSpecialKeyTable().getBaseName()).append(".INITIAL_DOC_NAME ");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "=").append(pc.getSpecialKeyTable().getBaseName()).append("." + pc.getCollectiviteCodeColname() + " ");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "=").append(pc.getSpecialKeyTable().getBaseName()).append("." + pc.getBudgetCodeColname() + " ");
                sb.append(" WHERE ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY1='").append(StringEscapeUtils.escapeSql((String)sk1.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY2='").append(StringEscapeUtils.escapeSql((String)sk2.key)).append("'");
                sb.append(" ");
                break;
            }
            case 6: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" WHERE ").append(docTable.getBaseName()).append("." + pc.getCollectiviteCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append("." + pc.getBudgetCodeColname() + "='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".INITIAL_DOC_NAME='").append(StringEscapeUtils.escapeSql((String)fic)).append("'");
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public DataResultSet getDataResultSetForExport(int whatToExport, ElementModel em, Pair coll, Pair budg, String fic, Pair SK1, Pair SK2, XemeliosUser user) throws DataConfigurationException, SQLException, UnauthorizedException {
        if (!user.hasRole("EXPORT")) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 faire des exports");
        }
        if (!user.hasDocument(em.getParent().getParent().getId())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 exporter des " + em.getTitre());
        }
        if (!user.hasCollectivite(coll.key, em.getParent().getParent())) {
            throw new UnauthorizedException("Vous n'\u00eates pas autoris\u00e9 \u00e0 rechercher des " + em.getTitre() + " pour cette collectivit\u00e9 " + coll.libelle != null ? "(" + coll.libelle + ")" : "");
        }
        String sql = this.buildSelectToExport(whatToExport, em, coll, budg, fic, SK1, SK2, user);
        ListeResultatModel lrm = em.getListeResultat();
        MySqlDataResultSet drs = new MySqlDataResultSet(em, coll, budg, em.getPath().getPath(), sql, lrm, (MySqlDataLayer)DataLayerManager.getImplementation(), user);
        return drs;
    }

    public Object HSWinitTempStorage(String storageId, String keyId, int maxKeyLength, Vector<Field> fieldList) {
        Class[] classes = null;
        int[] sizes = null;
        String[] names = null;
        if (fieldList != null) {
            classes = new Class[fieldList.size()];
            sizes = new int[fieldList.size()];
            names = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                LongueurMax anno;
                Integer longueurMax;
                Field fld = fieldList.get(i);
                String typeName = fld.getType().toString();
                if (typeName.equals("class java.lang.String")) {
                    longueurMax = 255;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno == null) {
                        throw new RuntimeException("The field " + fld.getName() + " has no annotation @LongueurMax(value = xxx)");
                    }
                    longueurMax = anno.value();
                    classes[i] = String.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Integer.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Float.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Float.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("class java.util.Date")) {
                    classes[i] = Date.class;
                    sizes[i] = 999;
                }
                names[i] = fld.getName();
            }
        }
        return this.HSWinitTempStorage(storageId, keyId, maxKeyLength, classes, sizes, names);
    }

    public Object HSWinitTempStorage(String storageId, String keyId, int maxKeyLength, Class[] classes, int[] sizes, String[] names) {
        Connection HSWcon = null;
        Hashtable<String, PreparedStatement> reqs = new Hashtable<String, PreparedStatement>();
        StringBuffer sqlCreateBuffer = new StringBuffer();
        StringBuffer sqlInsertBuffer = new StringBuffer();
        StringBuffer sqlInsertValuesBuffer = new StringBuffer();
        StringBuffer sqlSelectBuffer = new StringBuffer();
        StringBuffer sqlExistsBuffer = new StringBuffer();
        StringBuffer sqlCountBuffer = new StringBuffer();
        StringBuffer sqlDeleteBuffer = new StringBuffer();
        StringBuffer sqlDropBuffer = new StringBuffer();
        String virgule = ",";
        sqlCreateBuffer.append("CREATE TEMPORARY TABLE " + storageId + "(\n");
        sqlInsertBuffer.append("INSERT INTO " + storageId + "(\n");
        sqlInsertValuesBuffer.append("VALUES(\n");
        sqlExistsBuffer.append("SELECT COUNT(*) FROM " + storageId + "\n");
        sqlSelectBuffer.append("SELECT \n");
        sqlDeleteBuffer.append("DELETE FROM " + storageId + "\n");
        sqlDropBuffer.append("DROP TABLE " + storageId + "\n");
        sqlCountBuffer.append("SELECT COUNT(*) FROM " + storageId + "\n");
        if (classes != null) {
            sqlCreateBuffer.append(keyId + " VARCHAR(" + maxKeyLength + ") UNIQUE");
            sqlInsertBuffer.append(keyId);
            sqlInsertValuesBuffer.append("?");
            sqlSelectBuffer.append(keyId);
            sqlExistsBuffer.append("WHERE " + keyId + " = ? ");
            sqlDeleteBuffer.append("WHERE " + keyId + " = ? ");
            for (int i = 0; i < classes.length; ++i) {
                Class cls = classes[i];
                Integer longueurMax = sizes[i];
                sqlCreateBuffer.append(virgule);
                sqlCreateBuffer.append("\n");
                sqlCreateBuffer.append(names[i] + " ");
                sqlInsertBuffer.append(virgule);
                sqlInsertBuffer.append("\n");
                sqlInsertBuffer.append(names[i] + " ");
                sqlInsertValuesBuffer.append(virgule);
                sqlInsertValuesBuffer.append("\n");
                sqlInsertValuesBuffer.append("?");
                sqlSelectBuffer.append(virgule);
                sqlSelectBuffer.append("\n");
                sqlSelectBuffer.append(names[i] + " ");
                String typeName = cls.toString();
                if (typeName.equals("class java.lang.String")) {
                    sqlCreateBuffer.append("VARCHAR(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                    sqlCreateBuffer.append("INTEGER(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                    sqlCreateBuffer.append("FLOAT(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                    sqlCreateBuffer.append("DOUBLE(" + longueurMax.toString() + ")");
                    continue;
                }
                if (!typeName.equals("class java.util.Date")) continue;
                sqlCreateBuffer.append("DATE");
            }
            sqlCreateBuffer.append("\n)\n");
            sqlInsertBuffer.append("\n)\n");
            sqlInsertValuesBuffer.append("\n)\n");
            sqlSelectBuffer.append(" FROM " + storageId + " WHERE  " + keyId + " = ? ");
            try {
                HSWcon = this.getConnection();
                reqs.put("Create", HSWcon.prepareStatement(sqlCreateBuffer.toString()));
                reqs.put("Insert", HSWcon.prepareStatement(sqlInsertBuffer.toString() + sqlInsertValuesBuffer.toString()));
                reqs.put("Exists", HSWcon.prepareStatement(sqlExistsBuffer.toString()));
                reqs.put("Select", HSWcon.prepareStatement(sqlSelectBuffer.toString()));
                reqs.put("Delete", HSWcon.prepareStatement(sqlDeleteBuffer.toString()));
                reqs.put("Drop", HSWcon.prepareStatement(sqlDropBuffer.toString()));
                reqs.put("Count", HSWcon.prepareStatement(sqlCountBuffer.toString()));
            }
            catch (SQLException se) {
                logger.error((Object)"init : SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)"init: other exception", (Throwable)e);
            }
        }
        return new HSWStorageHandle(reqs, classes, HSWcon);
    }

    public void HSWdoCreateStorage(Object pStorageHandle) {
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
            try {
                PreparedStatement ps = ht.get("Create");
                ps.executeUpdate();
            }
            catch (SQLException se) {
                logger.error((Object)"Create SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public void HSWdoInsert(Object pStorageHandle, String key, Object[] values) {
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
            try {
                PreparedStatement ps = ht.get("Insert");
                ps.setString(1, key);
                for (int i = 0; i < values.length; ++i) {
                    int j = i + 2;
                    if (values[i] instanceof String) {
                        ps.setString(j, (String)values[i]);
                        continue;
                    }
                    if (values[i] instanceof Integer) {
                        ps.setInt(j, (Integer)values[i]);
                        continue;
                    }
                    if (values[i] instanceof Float) {
                        ps.setFloat(j, ((Float)values[i]).floatValue());
                        continue;
                    }
                    if (!(values[i] instanceof Date)) continue;
                    java.sql.Date sqlDate = new java.sql.Date(((Date)values[i]).getTime());
                    ps.setDate(j, sqlDate);
                }
                ps.executeUpdate();
            }
            catch (SQLException se) {
                logger.error((Object)"doInsert SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public boolean HSWdoExists(Object pStorageHandle, String key) {
        boolean ret = false;
        PreparedStatement ps = null;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            try {
                int count;
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                ps = ht.get("Exists");
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (count = rs.getInt(1)) > 0) {
                    ret = true;
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doExists SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public Object[] HSWdoSelect(Object pStorageHandle, String key, Object[] inoutObj) {
        Object[] ret = null;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            PreparedStatement ps = null;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                Class[] classes = storageHandle.classes;
                ps = ht.get("Select");
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    for (int i = 0; i < classes.length; ++i) {
                        int j = i + 2;
                        Class cls = classes[i];
                        String typeName = cls.toString();
                        if (typeName.equals("class java.lang.String")) {
                            inoutObj[i] = rs.getString(j);
                            continue;
                        }
                        if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                            inoutObj[i] = rs.getInt(j);
                            continue;
                        }
                        if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                            inoutObj[i] = Float.valueOf(rs.getFloat(j));
                            continue;
                        }
                        if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                            inoutObj[i] = rs.getDouble(j);
                            continue;
                        }
                        if (!typeName.equals("class java.util.Date")) continue;
                        java.sql.Date sqlDate = rs.getDate(j);
                        inoutObj[i] = sqlDate;
                    }
                    ret = inoutObj;
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doSelect SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public boolean HSWdoDelete(Object pStorageHandle, String key) {
        boolean ret = false;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            PreparedStatement ps = null;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                ps = ht.get("Delete");
                ps.setString(1, key);
                ps.executeUpdate();
                ret = true;
            }
            catch (SQLException se) {
                logger.error((Object)"doDelete SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public int HSWdoCount(Object pStorageHandle) {
        int ret = -1;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            PreparedStatement ps = null;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                ps = ht.get("Count");
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    ret = rs.getInt(1);
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doCount SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean HSWdoDrop(Object pStorageHandle) {
        boolean ret;
        block20: {
            ret = false;
            if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
                PreparedStatement ps;
                Connection HSWcon;
                block18: {
                    HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
                    HSWcon = null;
                    ps = null;
                    Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                    ps = ht.get("Drop");
                    HSWcon = storageHandle.con;
                    ps.executeUpdate();
                    Object var8_9 = null;
                    if (ps == null) break block18;
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        logger.info((Object)"ps closed !", t);
                    }
                }
                if (HSWcon != null) {
                    this.releaseConnection(HSWcon);
                    storageHandle.con = null;
                }
                break block20;
                {
                    catch (SQLException se) {
                        logger.error((Object)"doDrop : SQL Exception:", (Throwable)se);
                        Object var8_10 = null;
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable t) {
                                logger.info((Object)"ps closed !", t);
                            }
                        }
                        if (HSWcon != null) {
                            this.releaseConnection(HSWcon);
                            storageHandle.con = null;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        Object var8_11 = null;
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable t) {
                                logger.info((Object)"ps closed !", t);
                            }
                        }
                        if (HSWcon != null) {
                            this.releaseConnection(HSWcon);
                            storageHandle.con = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                    if (HSWcon != null) {
                        this.releaseConnection(HSWcon);
                        storageHandle.con = null;
                    }
                    throw throwable;
                }
            }
        }
        return ret;
    }

    public boolean isLocalComputerServer() {
        String driver = this.props.getProperty("driver.class");
        if ("com.mysql.embedded.jdbc.MySqlEmbeddedDriver".equals(driver)) {
            return true;
        }
        if ("com.mysql.jdbc.Driver".equals(driver)) {
            int pos;
            String url = this.props.getProperty("database.url");
            url = url.substring(13);
            int pipePos = url.indexOf(58);
            int slashPos = url.indexOf(47);
            if (pipePos < 0) {
                pipePos = 10000;
            }
            if (slashPos < 0) {
                slashPos = 10000;
            }
            if ((pos = Math.min(pipePos, slashPos)) > url.length()) {
                pos = url.length();
            }
            String server = url.substring(0, pos);
            try {
                InetAddress serverAddress = InetAddress.getByName(server);
                InetAddress localAddress = InetAddress.getLocalHost();
                return localAddress.equals(serverAddress);
            }
            catch (UnknownHostException uhEx) {
                logger.error(null, (Throwable)uhEx);
            }
        } else {
            throw new RuntimeException("no support is provided for this driver. Please see MySqlDataLayer.isLocalComputerServer() and provide adapted code.");
        }
        return false;
    }

    public static String sqlEscapeString(String data) {
        StringBuilder ret = new StringBuilder();
        if (data.startsWith("'") && data.endsWith("'")) {
            ret.append("'");
            ret.append(MySqlDataLayer.sqlEscapeString(data.substring(1, data.length() - 1)));
            ret.append("'");
        } else {
            ret.append(data.replaceAll("'", "''"));
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<RechercheModel> getSavedRequests(ElementModel em, XemeliosUser user, boolean includePublics) {
        ArrayList<RechercheModel> ret;
        block30: {
            PreparedStatement ps;
            Connection con;
            block28: {
                ret = new ArrayList<RechercheModel>();
                String key = em.getKey();
                StringBuffer sql = new StringBuffer("SELECT REQUEST FROM SAVED_REQUESTS WHERE KEY_EM=? AND ");
                if (includePublics) {
                    sql.append("(USER_ID=? OR PUBLIC=1)");
                } else {
                    sql.append("USER_ID=?");
                }
                con = null;
                ps = null;
                con = this.getConnection();
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, key);
                ps.setString(2, user.getId());
                ResultSet rs = ps.executeQuery();
                PersonnalConfigParser pcp = new PersonnalConfigParser();
                while (rs.next()) {
                    InputStream is = rs.getBinaryStream(1);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStreamLogger wrapper = new InputStreamLogger(is, baos);
                    pcp.parse((InputStream)wrapper);
                    RechercheModel rm = (RechercheModel)pcp.getMarshallable();
                    ret.add(rm);
                    logger.debug((Object)baos.toString("ISO-8859-1"));
                }
                Object var16_19 = null;
                if (ps == null) break block28;
                try {
                    ps.close();
                }
                catch (SQLException sqlEx2) {
                    logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block30;
            {
                catch (SQLException sqlEx) {
                    logger.error((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx);
                    Object var16_20 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block30;
                }
                catch (SAXException saxEx) {
                    logger.error((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)saxEx);
                    Object var16_21 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block30;
                }
                catch (ParserConfigurationException pcEx) {
                    logger.error((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)pcEx);
                    Object var16_22 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block30;
                }
                catch (IOException ioEx) {
                    logger.error((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)ioEx);
                    Object var16_23 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_24 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqlEx2) {
                        logger.info((Object)"getSavedRequests(ElementModel,XemeliosUser,boolean)", (Throwable)sqlEx2);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveRequest(ElementModel em, RechercheModel recherche, XemeliosUser user) {
        block19: {
            Statement ps;
            Connection con;
            block17: {
                String key = em.getKey();
                con = null;
                ps = null;
                con = this.getConnection();
                UPDATES_MODES updateMode = UPDATES_MODES.INSERT;
                if (recherche.getId() != null) {
                    updateMode = UPDATES_MODES.UPDATE;
                } else {
                    String title = recherche.getDisplayName().replaceAll(" ", "");
                    if (title.length() > 200) {
                        title = title.substring(0, 199);
                    }
                    recherche.setId(title.concat(Long.toHexString(System.currentTimeMillis())));
                }
                String sql = updateMode == UPDATES_MODES.INSERT ? "INSERT INTO SAVED_REQUESTS (REQUEST, KEY_EM, USER_ID, TITLE, PUBLIC, ID) VALUES (?,?,?,?,0,?)" : "UPDATE SAVED_REQUESTS SET REQUEST=? WHERE KEY_EM=? AND USER_ID=? AND TITLE=? AND ID=?";
                ps = con.prepareStatement(sql);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Charset cs = Charset.forName("ISO-8859-1");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, cs);
                XmlOutputter outputter = new XmlOutputter(out, cs.name());
                recherche.marshall(outputter);
                out.flush();
                out.close();
                ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                ps.setBinaryStream(1, is, baos.size());
                ps.setString(2, key);
                ps.setString(3, user.getId());
                ps.setString(4, recherche.getDisplayName());
                ps.setString(5, recherche.getId());
                int ret = ps.executeUpdate();
                if (ret != 1) {
                    throw new SQLException("unexpected update result: " + ret + " row(s) updated, only 1 expected");
                }
                Object var16_16 = null;
                if (ps == null) break block17;
                try {
                    ps.close();
                }
                catch (SQLException sqlEx) {
                    logger.info((Object)"saveRequest(ElementModel,RechercheModel,XemeliosUser)", (Throwable)sqlEx);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block19;
            {
                catch (Exception ex) {
                    logger.error((Object)"saveRequest(ElementModel,RechercheModel,XemeliosUser)", (Throwable)ex);
                    Object var16_17 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx) {
                            logger.info((Object)"saveRequest(ElementModel,RechercheModel,XemeliosUser)", (Throwable)sqlEx);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqlEx) {
                        logger.info((Object)"saveRequest(ElementModel,RechercheModel,XemeliosUser)", (Throwable)sqlEx);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public RechercheModel getSavedRequest(ElementModel em, XemeliosUser user, String searchId) {
        RechercheModel ret;
        block28: {
            PreparedStatement ps;
            Connection con;
            block26: {
                block25: {
                    ret = null;
                    String key = em.getKey();
                    StringBuffer sql = new StringBuffer("SELECT REQUEST FROM SAVED_REQUESTS WHERE KEY_EM=? AND ID=?");
                    con = null;
                    ps = null;
                    con = this.getConnection();
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, key);
                    ps.setString(2, searchId);
                    ResultSet rs = ps.executeQuery();
                    PersonnalConfigParser pcp = new PersonnalConfigParser();
                    if (!rs.next()) break block25;
                    InputStream is = rs.getBinaryStream(1);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStreamLogger wrapper = new InputStreamLogger(is, baos);
                    pcp.parse((InputStream)wrapper);
                    ret = (RechercheModel)pcp.getMarshallable();
                    logger.debug((Object)baos.toString("ISO-8859-1"));
                }
                Object var15_18 = null;
                if (ps == null) break block26;
                try {
                    ps.close();
                }
                catch (SQLException sqlEx2) {
                    logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                }
            }
            if (con != null) {
                this.releaseConnection(con);
            }
            break block28;
            {
                catch (SQLException sqlEx) {
                    logger.error((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx);
                    Object var15_19 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block28;
                }
                catch (SAXException saxEx) {
                    logger.error((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)saxEx);
                    Object var15_20 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block28;
                }
                catch (ParserConfigurationException pcEx) {
                    logger.error((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)pcEx);
                    Object var15_21 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                    break block28;
                }
                catch (IOException ioEx) {
                    logger.error((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)ioEx);
                    Object var15_22 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqlEx2) {
                            logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                        }
                    }
                    if (con != null) {
                        this.releaseConnection(con);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqlEx2) {
                        logger.info((Object)"getSavedRequest(ElementModel,XemeliosUser,String)", (Throwable)sqlEx2);
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return ret;
    }

    public void createExportJob(ExportJob job, XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        if (!user.hasRole("EXPORT")) {
            throw new UnauthorizedException("Vous n'avez pas les droits pour r\u00e9aliser des exports.");
        }
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                String sql = "INSERT INTO EXPORT_JOBS (UTI_LOGIN,FILE_NAME,EXPORT_NAME,DOC_ID,ETAT_ID,ELEMENT_ID,CONFIG_ID,SIZE,STATUS,SUBMIT_DATE,DRS) VALUES (?,?,?,?,?,?,?,?,?,NOW(),?)";
                PreparedStatement ps = con.prepareStatement(sql);
                int i = 1;
                ps.setString(i++, user.getId());
                ps.setString(i++, job.getFileName());
                ps.setString(i++, job.getExportName());
                ps.setString(i++, job.getDocumentId());
                ps.setString(i++, job.getEtatId());
                ps.setString(i++, job.getElementId());
                ps.setLong(i++, job.getExportConfigId());
                ps.setInt(i++, job.getSize());
                ps.setInt(i++, 0);
                byte[] buffer = job.getDrs();
                ps.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(buffer), buffer.length);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                logger.error((Object)"createExportJob(ExportJob,XemeliosUser)", (Throwable)ex);
                throw new DataAccessException((Throwable)ex);
            }
            Object var9_9 = null;
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (con != null) {
                this.releaseConnection(con);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportJob> getExportJobList(XemeliosUser user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        ArrayList<ExportJob> ret = new ArrayList<ExportJob>();
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                String sql = "SELECT EXPORT_ID, FILE_NAME, EXPORT_NAME, DOC_ID, ETAT_ID, ELEMENT_ID, CONFIG_ID, SIZE, PRIORITY, STATUS, SUBMIT_DATE, RUN_DATE, DOWNLOAD_DATE, ERROR_MESSAGE, GENERATED_FILE_NAME, CLEANED, UTI_LOGIN FROM EXPORT_JOBS WHERE UTI_LOGIN=? AND (DOWNLOAD_DATE IS NULL OR DOWNLOAD_DATE<DATE_ADD(CURDATE(),INTERVAL '7' DAY)) AND CLEANED IS NULL";
                PreparedStatement ps = con.prepareStatement(sql);
                ps.setString(1, user.getId());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ret.add(new ExportJobImpl(rs, false));
                }
                Object var8_8 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
            catch (SQLException sqlEx) {
                logger.error((Object)"getExportJobs(XemeliosUser)", (Throwable)sqlEx);
                Object var8_9 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (con != null) {
                this.releaseConnection(con);
            }
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportJob getExportJob(long exportId, String user) throws DataConfigurationException, DataAccessException, UnauthorizedException {
        ExportJobImpl ret = null;
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                String sql = "SELECT EXPORT_ID, FILE_NAME, EXPORT_NAME, DOC_ID, ETAT_ID, ELEMENT_ID, CONFIG_ID, SIZE, PRIORITY, STATUS, SUBMIT_DATE, RUN_DATE, DOWNLOAD_DATE, ERROR_MESSAGE, GENERATED_FILE_NAME, CLEANED, DRS, UTI_LOGIN FROM EXPORT_JOBS WHERE EXPORT_ID=? AND UTI_LOGIN=?";
                PreparedStatement ps = con.prepareStatement(sql);
                ps.setLong(1, exportId);
                ps.setString(2, user);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    ret = new ExportJobImpl(rs, true);
                }
                Object var10_9 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
            catch (SQLException sqlEx) {
                logger.error((Object)"getExportJob(exportId,user)", (Throwable)sqlEx);
                Object var10_10 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (con != null) {
                this.releaseConnection(con);
            }
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatalayerConfiguration() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataLayer: ").append(this.getLayerName()).append("\n");
        sb.append("-------------------------------------------------------------------------------\n");
        Connection con = null;
        try {
            try {
                con = this.getConnection();
                DatabaseMetaData dmd = con.getMetaData();
                sb.append("Database: ").append(dmd.getDatabaseProductName()).append(" - ").append(dmd.getDatabaseProductVersion()).append("\n");
                sb.append("Driver: ").append(dmd.getDriverName()).append(" - ").append(dmd.getDriverVersion()).append("\n");
                ResultSet rs = con.createStatement().executeQuery("SELECT @@sql_mode");
                rs.next();
                String sqlMode = rs.getString(1);
                sb.append("SQL_MODE=").append(sqlMode).append("\n");
                rs = con.createStatement().executeQuery("SHOW TABLES");
                while (rs.next()) {
                    String tbName = rs.getString(1);
                    int rowCount = 0;
                    ResultSet rsCount = con.createStatement().executeQuery("SELECT COUNT(*) FROM ".concat(tbName));
                    if (rsCount.next()) {
                        rowCount = rsCount.getInt(1);
                    }
                    sb.append("\n").append(tbName).append(" (").append(rowCount).append(" rows)\n");
                    ResultSet rsCols = con.createStatement().executeQuery("DESCRIBE ".concat(tbName));
                    int colCount = rsCols.getMetaData().getColumnCount();
                    while (rsCols.next()) {
                        for (int i = 1; i <= colCount; ++i) {
                            sb.append(rsCols.getString(i)).append("\t");
                        }
                        sb.append("\n");
                    }
                }
                rs = con.createStatement().executeQuery("SELECT * FROM PARAMETERS");
                sb.append("\nPARAMETERS\n-----------------\n");
                while (rs.next()) {
                    sb.append(rs.getString(1)).append("=").append(rs.getString(2)).append("\n");
                }
                Object var13_13 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
            catch (SQLException sQLException) {
                Object var13_14 = null;
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (con != null) {
                this.releaseConnection(con);
            }
            throw throwable;
        }
        return sb.toString();
    }

    static {
        DataLayerManager.regiterDataImpl((String)LAYER_NAME, MySqlDataLayer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UPDATES_MODES {
        UPDATE,
        INSERT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HSWStorageHandle {
        Class[] classes;
        Hashtable<String, PreparedStatement> requetes;
        Connection con;

        HSWStorageHandle(Hashtable<String, PreparedStatement> preqs, Class[] pclasses, Connection con) {
            this.classes = pclasses;
            this.requetes = preqs;
            this.con = con;
        }
    }

    private class IndexerHandler
    extends DefaultHandler {
        private TEtat sec = null;
        private TDocument pc = null;
        private Stack<QName> stack = null;
        private String key1 = null;
        private String key2 = null;
        private String key3 = null;
        private String key4 = null;
        private String key5 = null;
        private String key6 = null;
        private String key7 = null;
        private String key8 = null;
        private String key9 = null;
        private String key10 = null;
        private String pathToResetKey1 = null;
        private String pathToResetKey2 = null;
        private String pathToResetKey3 = null;
        private String pathToResetKey4 = null;
        private String pathToResetKey5 = null;
        private String pathToResetKey6 = null;
        private String pathToResetKey7 = null;
        private String pathToResetKey8 = null;
        private String pathToResetKey9 = null;
        private String pathToResetKey10 = null;
        private String collectivite = null;
        private String budget = null;
        private String docId = null;
        private SQLException sqlEx = null;
        private long indexDuration = 0L;
        private Hashtable<TSqlIndex, Object> cachedData = null;
        private Connection con = null;
        private StringBuffer warnings;
        private Stack<StringBuffer> datas = null;
        private NamespaceContext nsCtx = null;

        public long getIndexDuration() {
            return this.indexDuration;
        }

        public void reset() {
            this.indexDuration = 0L;
            if (this.cachedData != null) {
                this.cachedData.clear();
            }
            if (this.stack != null) {
                this.stack.clear();
            }
            this.key1 = null;
            this.key2 = null;
            this.key3 = null;
            this.key4 = null;
            this.key5 = null;
            this.key6 = null;
            this.key7 = null;
            this.key8 = null;
            this.key9 = null;
            this.key10 = null;
            this.pathToResetKey1 = null;
            this.pathToResetKey2 = null;
            this.pathToResetKey3 = null;
            this.pathToResetKey4 = null;
            this.pathToResetKey5 = null;
            this.pathToResetKey6 = null;
            this.pathToResetKey7 = null;
            this.pathToResetKey8 = null;
            this.pathToResetKey9 = null;
            this.pathToResetKey10 = null;
        }

        public IndexerHandler(TEtat sec, String codeBudget, String codeCollectivite, String elementName, Connection con, NamespaceContext nsCtx) throws SQLException {
            this.sec = sec;
            this.pc = sec.getParent();
            this.stack = new Stack();
            this.collectivite = codeCollectivite;
            this.budget = codeBudget;
            this.docId = elementName;
            this.cachedData = new Hashtable();
            this.con = con;
            this.warnings = new StringBuffer();
            this.datas = new Stack();
            this.nsCtx = nsCtx;
            if (nsCtx == null) {
                throw new IllegalArgumentException("nsCtx can not be null)");
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            QName qname = XmlUtils.getQName((String)uri, (String)localName, (String)qName);
            this.stack.push(qname);
            this.datas.push(new StringBuffer());
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            for (int i = 0; i < attributes.getLength(); ++i) {
                ArrayList indexList;
                String prefix = this.nsCtx.getPrefix(attributes.getURI(i));
                StringBuffer sb = new StringBuffer();
                sb.append(pathTag).append("/@");
                if (prefix != null && prefix.length() > 0) {
                    sb.append(prefix).append(":");
                }
                sb.append(attributes.getLocalName(i));
                String fullPath = sb.toString();
                if (this.sec.getKey1() != null && this.sec.getKey1().getPathes().contains(fullPath)) {
                    this.key1 = attributes.getValue(i);
                    this.pathToResetKey1 = pathTag;
                }
                if (this.sec.getKey2() != null && this.sec.getKey2().getPathes().contains(fullPath)) {
                    this.key2 = attributes.getValue(i);
                    this.pathToResetKey2 = pathTag;
                }
                if (this.sec.getKey3() != null && this.sec.getKey3().getPathes().contains(fullPath)) {
                    this.key3 = attributes.getValue(i);
                    this.pathToResetKey3 = pathTag;
                }
                if (this.sec.getKey4() != null && this.sec.getKey4().getPathes().contains(fullPath)) {
                    this.key4 = attributes.getValue(i);
                    this.pathToResetKey4 = pathTag;
                }
                if (this.sec.getKey5() != null && this.sec.getKey5().getPathes().contains(fullPath)) {
                    this.key5 = attributes.getValue(i);
                    this.pathToResetKey5 = pathTag;
                }
                if (this.sec.getKey6() != null && this.sec.getKey6().getPathes().contains(fullPath)) {
                    this.key6 = attributes.getValue(i);
                    this.pathToResetKey6 = pathTag;
                }
                if (this.sec.getKey7() != null && this.sec.getKey7().getPathes().contains(fullPath)) {
                    this.key7 = attributes.getValue(i);
                    this.pathToResetKey7 = pathTag;
                }
                if (this.sec.getKey8() != null && this.sec.getKey8().getPathes().contains(fullPath)) {
                    this.key8 = attributes.getValue(i);
                    this.pathToResetKey8 = pathTag;
                }
                if (this.sec.getKey9() != null && this.sec.getKey9().getPathes().contains(fullPath)) {
                    this.key9 = attributes.getValue(i);
                    this.pathToResetKey9 = pathTag;
                }
                if (this.sec.getKey10() != null && this.sec.getKey10().getPathes().contains(fullPath)) {
                    this.key10 = attributes.getValue(i);
                    this.pathToResetKey10 = pathTag;
                }
                if ((indexList = this.sec.getAllIndexesByPath(fullPath)) == null) continue;
                for (TSqlIndex si : indexList) {
                    if (!si.isGenerate()) continue;
                    String sValue = attributes.getValue(i);
                    Object value = null;
                    if ("integer".equals(si.getDatatype())) {
                        try {
                            value = new Integer(Integer.parseInt(sValue.trim()));
                        }
                        catch (NumberFormatException ex) {
                            if (sValue != null) {
                                logger.warn((Object)(sValue + " is not an integer - " + si.getTableId() + "." + si.getColumn()));
                            }
                        }
                    } else if ("decimal".equals(si.getDatatype())) {
                        try {
                            value = new BigDecimal(sValue.trim());
                        }
                        catch (NumberFormatException ex) {
                            if (sValue != null) {
                                logger.warn((Object)(sValue + " is not a decimal - " + si.getTableId() + "." + si.getColumn()));
                            }
                        }
                    } else if ("float".equals(si.getDatatype())) {
                        try {
                            value = new Float(Float.parseFloat(sValue.trim()));
                        }
                        catch (NumberFormatException ex) {
                            if (sValue != null) {
                                logger.warn((Object)(sValue + " is not a float - " + si.getTableId() + "." + si.getColumn()));
                            }
                        }
                    } else if ("date".equals(si.getDatatype())) {
                        try {
                            value = si.getDateValue(sValue.trim());
                        }
                        catch (ParseException ex) {
                            logger.warn((Object)ex.getMessage());
                        }
                    } else if ("string".equals(si.getDatatype())) {
                        value = si.getFormattedStringValue(sValue);
                    } else if ("boolean".equals(si.getDatatype())) {
                        value = si.getBooleanValue(sValue.trim());
                    } else {
                        value = sValue;
                        logger.error((Object)("unknown datatype for index " + si.getId() + ": " + si.getDatatype()));
                    }
                    if (value == null) continue;
                    this.cachedData.put(si, value);
                }
            }
            String fullPath = pathTag + "/name()";
            ArrayList indexList = this.sec.getAllIndexesByPath(fullPath);
            for (TSqlIndex si : indexList) {
                if (si == null || !si.isGenerate()) continue;
                String sValue = localName;
                Object value = null;
                if ("integer".equals(si.getDatatype())) {
                    try {
                        value = new Integer(Integer.parseInt(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        if (sValue != null) {
                            logger.warn((Object)(sValue + " is not an integer - " + si.getTableId() + "." + si.getColumn()));
                        }
                    }
                } else if ("decimal".equals(si.getDatatype())) {
                    try {
                        value = new BigDecimal(sValue.trim());
                    }
                    catch (NumberFormatException ex) {
                        if (sValue != null) {
                            logger.warn((Object)(sValue + " is not a decimal - " + si.getTableId() + "." + si.getColumn()));
                        }
                    }
                } else if ("float".equals(si.getDatatype())) {
                    try {
                        value = new Float(Float.parseFloat(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        if (sValue != null) {
                            logger.warn((Object)(sValue + " is not a float - " + si.getTableId() + "." + si.getColumn()));
                        }
                    }
                } else if ("date".equals(si.getDatatype())) {
                    try {
                        value = si.getDateValue(sValue.trim());
                    }
                    catch (ParseException ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                } else if ("string".equals(si.getDatatype())) {
                    value = si.getFormattedStringValue(sValue);
                } else if ("boolean".equals(si.getDatatype())) {
                    String sTmp = sValue.toString();
                    value = "1".equals(si.getBooleanValue(sValue)) ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    value = sValue;
                    logger.error((Object)("unknown datatype for index " + si.getId() + ": " + si.getDatatype()));
                }
                if (value == null) continue;
                this.cachedData.put(si, value);
            }
        }

        protected void closePathToReset(String pathTag) throws SAXException {
            if (pathTag.equals(this.pathToResetKey10)) {
                this.pathToResetKey10 = null;
                try {
                    this.writeIndexesOnKey10();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    ex.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", ex);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key10 = null;
            } else if (pathTag.equals(this.pathToResetKey9)) {
                this.pathToResetKey9 = null;
                try {
                    this.writeIndexesOnKey9();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    ex.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", ex);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key9 = null;
            } else if (pathTag.equals(this.pathToResetKey8)) {
                this.pathToResetKey8 = null;
                try {
                    this.writeIndexesOnKey8();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    ex.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", ex);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key8 = null;
            } else if (pathTag.equals(this.pathToResetKey7)) {
                this.pathToResetKey7 = null;
                try {
                    this.writeIndexesOnKey7();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key7 = null;
            } else if (pathTag.equals(this.pathToResetKey6)) {
                this.pathToResetKey6 = null;
                try {
                    this.writeIndexesOnKey6();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key6 = null;
            } else if (pathTag.equals(this.pathToResetKey5)) {
                this.pathToResetKey5 = null;
                try {
                    this.writeIndexesOnKey5();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key5 = null;
            } else if (pathTag.equals(this.pathToResetKey4)) {
                this.pathToResetKey4 = null;
                try {
                    this.writeIndexesOnKey4();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key4 = null;
            } else if (pathTag.equals(this.pathToResetKey3)) {
                this.pathToResetKey3 = null;
                try {
                    this.writeIndexesOnKey3();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key3 = null;
            } else if (pathTag.equals(this.pathToResetKey2)) {
                this.pathToResetKey2 = null;
                try {
                    this.writeIndexesOnKey2();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key2 = null;
            } else if (pathTag.equals(this.pathToResetKey1)) {
                this.pathToResetKey1 = null;
                try {
                    this.writeIndexesOnKey1();
                }
                catch (SQLException ex) {
                    this.sqlEx = ex;
                    this.sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", this.sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key1 = null;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            this.closePathToReset(pathTag);
            String fullPath = pathTag + "/text()";
            ArrayList indexList = this.sec.getAllIndexesByPath(fullPath);
            for (TSqlIndex si : indexList) {
                if (si == null || !si.isGenerate()) continue;
                String sValue = this.datas.peek().toString();
                Object value = null;
                if ("integer".equals(si.getDatatype())) {
                    try {
                        value = new Integer(Integer.parseInt(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not an integer - " + si.getTableId() + "." + si.getColumn()));
                    }
                } else if ("decimal".equals(si.getDatatype())) {
                    try {
                        value = new BigDecimal(sValue.trim());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not a decimal - " + si.getTableId() + "." + si.getColumn()));
                    }
                } else if ("float".equals(si.getDatatype())) {
                    try {
                        value = new Float(Float.parseFloat(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not a float - " + si.getTableId() + "." + si.getColumn()));
                    }
                } else if ("date".equals(si.getDatatype())) {
                    try {
                        value = si.getDateValue(sValue.trim());
                    }
                    catch (ParseException ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                } else if ("string".equals(si.getDatatype())) {
                    value = si.getFormattedStringValue(sValue);
                } else if ("boolean".equals(si.getDatatype())) {
                    String sTmp = sValue.toString();
                    value = "1".equals(si.getBooleanValue(sValue)) ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    value = sValue;
                    logger.error((Object)("unknown datatype for index " + si.getId() + ": " + si.getDatatype()));
                }
                if (value == null) continue;
                this.cachedData.put(si, value);
            }
            this.closePathToReset(fullPath);
            this.datas.pop();
            this.stack.pop();
        }

        public void endDocument() throws SAXException {
            try {
                this.writeElementBasedIndexes();
                this.cachedData.clear();
            }
            catch (SQLException sqlEx2) {
                sqlEx2.printStackTrace();
                this.sqlEx = sqlEx2;
                throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx2);
            }
            catch (DataConfigurationException dcEx) {
                dcEx.printStackTrace();
                throw new SAXException("DataConfiguration occurs. See nested exception for details", (Exception)((Object)dcEx));
            }
        }

        protected void writeIndexesOnKey1() throws SQLException, DataConfigurationException {
            try {
                this.writeIndexesOnKey("key1");
            }
            catch (SQLException sqlEx2) {
                logger.error((Object)sqlEx2);
                throw sqlEx2;
            }
            catch (DataConfigurationException dcEx) {
                logger.error((Object)dcEx);
                throw dcEx;
            }
        }

        protected void writeIndexesOnKey2() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key2");
        }

        protected void writeIndexesOnKey3() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key3");
        }

        protected void writeIndexesOnKey4() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key4");
        }

        protected void writeIndexesOnKey5() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key5");
        }

        protected void writeIndexesOnKey6() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key6");
        }

        protected void writeIndexesOnKey7() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key7");
        }

        protected void writeIndexesOnKey8() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key8");
        }

        protected void writeIndexesOnKey9() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key9");
        }

        protected void writeIndexesOnKey10() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key10");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeIndexesOnKey(String keyName) throws SQLException, DataConfigurationException {
            TSqlIndex index;
            TTable elementTable = null;
            for (TTable ti : this.sec.getIndexTables()) {
                if (!keyName.equals(ti.getBasedOn())) continue;
                elementTable = ti;
                break;
            }
            if (elementTable == null) {
                throw new DataConfigurationException("No table to store " + keyName + "indexes was found !");
            }
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(elementTable.getBaseName()).append(" (" + this.pc.getCollectiviteCodeColname() + "," + this.pc.getBudgetCodeColname() + ",DOC_ID,");
            Vector<Object> valuesToWrite = new Vector<Object>();
            Vector<TSqlIndex> indexesToWrite = new Vector<TSqlIndex>();
            Enumeration<TSqlIndex> enumer = this.cachedData.keys();
            while (enumer.hasMoreElements()) {
                index = enumer.nextElement();
                String tableId = index.getTableId();
                TTable sti = this.sec.getIndexTable(tableId);
                if (sti != elementTable) continue;
                sql.append(index.getColumn()).append(",");
                indexesToWrite.add(index);
                valuesToWrite.add(this.cachedData.get(index));
                if (!keyName.equals(index.getResetOn()) && index.getResetOn() != null) continue;
                this.cachedData.remove(index);
            }
            if (valuesToWrite.size() > 0) {
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") VALUES (?,?,?,");
                for (int i = 0; i < valuesToWrite.size(); ++i) {
                    sql.append("?,");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                PreparedStatement ps = null;
                try {
                    ps = this.con.prepareStatement(sql.toString());
                    ps.setString(1, this.collectivite);
                    ps.setString(2, this.budget);
                    ps.setString(3, this.docId);
                    for (int i = 0; i < valuesToWrite.size(); ++i) {
                        TSqlIndex index2 = (TSqlIndex)indexesToWrite.elementAt(i);
                        Object value = valuesToWrite.elementAt(i);
                        if ("decimal".equals(index2.getDatatype())) {
                            ps.setBigDecimal(i + 4, (BigDecimal)value);
                        } else if ("date".equals(index2.getDatatype())) {
                            ps.setDate(i + 4, (java.sql.Date)value);
                        } else if ("float".equals(index2.getDatatype())) {
                            ps.setFloat(i + 4, ((Float)value).floatValue());
                        } else if ("integer".equals(index2.getDatatype())) {
                            ps.setInt(i + 4, (Integer)value);
                        } else if ("boolean".equals(index2.getDatatype())) {
                            ps.setInt(i + 4, "true".equals(value) || "1".equals(value) ? 1 : 0);
                        } else {
                            ps.setString(i + 4, value.toString());
                        }
                        if (!keyName.equals(index2.getResetOn()) && index2.getResetOn() != null) continue;
                        this.cachedData.remove(index2);
                    }
                    ps.executeUpdate();
                    for (SQLWarning warn = ps.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        this.warnings.append(warn.getMessage()).append("\n");
                    }
                }
                catch (SQLException sqlEx2) {
                    sqlEx2.printStackTrace();
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                }
            }
            valuesToWrite.clear();
            indexesToWrite.clear();
            enumer = this.cachedData.keys();
            while (enumer.hasMoreElements()) {
                index = enumer.nextElement();
                if (!keyName.equals(index.getResetOn())) continue;
                this.cachedData.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeElementBasedIndexes() throws SQLException, DataConfigurationException {
            TTable elementTable = null;
            for (TTable ti : this.sec.getIndexTables()) {
                if (!ti.isMainTable()) continue;
                elementTable = ti;
                break;
            }
            if (elementTable == null) {
                throw new DataConfigurationException("No table to store element indexes was found !");
            }
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(elementTable.getBaseName()).append(" (" + this.pc.getCollectiviteCodeColname() + "," + this.pc.getBudgetCodeColname() + ",DOC_ID,");
            Vector<Object> valuesToWrite = new Vector<Object>();
            Vector<TSqlIndex> indexesToWrite = new Vector<TSqlIndex>();
            Enumeration<TSqlIndex> enumer = this.cachedData.keys();
            while (enumer.hasMoreElements()) {
                TSqlIndex index = enumer.nextElement();
                String tableId = index.getTableId();
                TTable sti = this.sec.getIndexTable(tableId);
                if (sti != elementTable) continue;
                sql.append(index.getColumn()).append(",");
                indexesToWrite.add(index);
                valuesToWrite.add(this.cachedData.get(index));
                this.cachedData.remove(index);
            }
            if (valuesToWrite.size() > 0) {
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") VALUES (?,?,?,");
                for (int i = 0; i < valuesToWrite.size(); ++i) {
                    sql.append("?,");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                PreparedStatement ps = null;
                try {
                    block25: {
                        ps = this.con.prepareStatement(sql.toString());
                        ps.setString(1, this.collectivite);
                        ps.setString(2, this.budget);
                        ps.setString(3, this.docId);
                        for (int i = 0; i < valuesToWrite.size(); ++i) {
                            TSqlIndex index = (TSqlIndex)indexesToWrite.elementAt(i);
                            Object value = valuesToWrite.elementAt(i);
                            if ("decimal".equals(index.getDatatype())) {
                                ps.setBigDecimal(i + 4, (BigDecimal)value);
                                continue;
                            }
                            if ("date".equals(index.getDatatype())) {
                                ps.setDate(i + 4, (java.sql.Date)value);
                                continue;
                            }
                            if ("float".equals(index.getDatatype())) {
                                ps.setFloat(i + 4, ((Float)value).floatValue());
                                continue;
                            }
                            if ("integer".equals(index.getDatatype())) {
                                ps.setInt(i + 4, (Integer)value);
                                continue;
                            }
                            ps.setString(i + 4, value.toString());
                        }
                        try {
                            ps.executeUpdate();
                        }
                        catch (MySQLIntegrityConstraintViolationException icEx) {
                            if (elementTable.isIgnoreConstraintError()) break block25;
                            logger.error((Object)"writeElementBasedIndexes()", (Throwable)icEx);
                            logger.error((Object)("SQL=" + sql));
                            logger.error((Object)("values=" + valuesToWrite));
                        }
                    }
                    for (SQLWarning warn = ps.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        this.warnings.append(warn.getMessage()).append("\n");
                    }
                }
                catch (SQLException sqlEx2) {
                    logger.error((Object)"writeElementBasedIndexes()", (Throwable)sqlEx2);
                    logger.error((Object)("SQL=" + sql));
                    logger.error((Object)("values=" + valuesToWrite));
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {
                            logger.info((Object)"ps closed !", t);
                        }
                    }
                }
            }
            valuesToWrite.clear();
            indexesToWrite.clear();
        }

        public Exception getException() {
            return this.sqlEx;
        }

        public String getWarnings() {
            if (this.warnings.length() > 0) {
                return this.warnings.toString();
            }
            return null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            StringBuffer sb = this.datas.peek();
            sb.append(ch, start, length);
        }
    }
}

