/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.api;
import com.mysql.embedded.jdbc.MyConnection;
import com.mysql.embedded.jdbc.MyResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MyStatement
implements Statement {
    protected MyConnection connection;
    protected MyResultSet result;
    protected int updateCount;
    protected boolean stored;
    protected int maxRows;

    protected MyStatement(MyConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = connection;
        this.maxRows = -1;
        switch (resultSetType) {
            case 1003: {
                this.stored = false;
                break;
            }
            case 1004: {
                this.stored = true;
                break;
            }
            case 1005: {
                throw new UnsupportedOperationException("scroll sensitive result sets are not supported");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            case 1008: {
                throw new UnsupportedOperationException("not yet implemented");
            }
        }
        switch (resultSetHoldability) {
            case 1: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.execute(sql)) {
            return this.result;
        }
        throw new SQLException("Select query expected");
    }

    public int executeUpdate(String sql) throws SQLException {
        if (!this.execute(sql)) {
            return this.updateCount;
        }
        throw new SQLException("Insert or Update query expected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            this.cancel();
        }
        finally {
            this.updateCount = -1;
            this.connection = null;
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.maxRows = Math.max(0, max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        try {
            if (this.result != null && !this.result.isClosed()) {
                this.result.close();
            }
        }
        finally {
            this.result = null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql) throws SQLException {
        this.connection.useStatement(this);
        this.cancel();
        this.connection.setMaxRows(this.maxRows);
        api.mysql_real_query(this.connection.connectionHandle, sql);
        return this.retrieveResult();
    }

    protected boolean retrieveResult() throws SQLException {
        int columnCount = api.mysql_field_count(this.connection.connectionHandle);
        if (columnCount > 0) {
            this.result = new MyResultSet(this, columnCount, this.stored, this.maxRows);
            this.updateCount = -1;
            return true;
        }
        this.result = null;
        this.updateCount = (int)api.mysql_affected_rows(this.connection.connectionHandle);
        return false;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.result;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        switch (rows) {
            case -2147483648: {
                this.stored = false;
                break;
            }
            case -1: {
                this.stored = true;
            }
        }
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (this.stored) {
            return 1004;
        }
        return 1003;
    }

    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: 
            case 3: {
                this.cancel();
                break;
            }
            case 2: {
                if (this.result == null || this.result.stored) break;
                throw new SQLException("can't keep previous ResultSet open");
            }
        }
        this.connection.useStatement(this);
        boolean more = api.mysql_more_results(this.connection.connectionHandle);
        if (more) {
            api.mysql_next_result(this.connection.connectionHandle);
            return this.retrieveResult();
        }
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }
}

