/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.enum_field_types;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class MySqlTypes
implements enum_field_types {
    public static final int UNKNOWN = Integer.MIN_VALUE;
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final Calendar UTC_CALENDAR = new GregorianCalendar(UTC_TIMEZONE);
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("hh:mm:ss.SSS");
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    public static final SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy");

    public static int asMysqlType(int java_Type, boolean version5) {
        switch (java_Type) {
            case 2003: {
                return Integer.MIN_VALUE;
            }
            case -5: {
                return 8;
            }
            case -2: {
                return 252;
            }
            case -7: {
                return version5 ? 16 : 1;
            }
            case 2004: {
                return 252;
            }
            case 16: {
                return 1;
            }
            case 1: {
                return 254;
            }
            case 2005: {
                return 252;
            }
            case 70: {
                return Integer.MIN_VALUE;
            }
            case 91: {
                return 10;
            }
            case 3: {
                return 0;
            }
            case 2001: {
                return Integer.MIN_VALUE;
            }
            case 8: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 2000: {
                return Integer.MIN_VALUE;
            }
            case -4: {
                return 251;
            }
            case -1: {
                return 251;
            }
            case 0: {
                return 6;
            }
            case 2: {
                return 0;
            }
            case 1111: {
                return Integer.MIN_VALUE;
            }
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 2002: {
                return Integer.MIN_VALUE;
            }
            case 92: {
                return 11;
            }
            case 93: {
                return 7;
            }
            case -6: {
                return 1;
            }
            case -3: {
                return 250;
            }
            case 12: {
                return version5 ? 15 : 253;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int asJavaType(int mysql_type) {
        switch (mysql_type) {
            case 0: {
                return 3;
            }
            case 1: {
                return -6;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 93;
            }
            case 8: {
                return -5;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
            case 13: {
                return 91;
            }
            case 14: {
                return 93;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return -7;
            }
            case 246: {
                return 3;
            }
            case 247: {
                return Integer.MIN_VALUE;
            }
            case 248: {
                return Integer.MIN_VALUE;
            }
            case 249: {
                return 2004;
            }
            case 250: {
                return 2004;
            }
            case 251: {
                return 2004;
            }
            case 252: {
                return 2004;
            }
            case 253: {
                return 12;
            }
            case 254: {
                return 1;
            }
            case 255: {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int guessJavaType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof String) {
            return 12;
        }
        if (object instanceof Blob) {
            return 2004;
        }
        if (object instanceof Clob) {
            return 2005;
        }
        if (object instanceof byte[]) {
            return -3;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof java.util.Date) {
            return 93;
        }
        return 2000;
    }

    public static String getJavaClassName(int java_type) {
        switch (java_type) {
            case 2003: {
                return null;
            }
            case -5: {
                return Long.class.getName();
            }
            case -2: {
                return Blob.class.getName();
            }
            case -7: {
                return Boolean.class.getName();
            }
            case 2004: {
                return Blob.class.getName();
            }
            case 16: {
                return Boolean.class.getName();
            }
            case 1: {
                return String.class.getName();
            }
            case 2005: {
                return Clob.class.getName();
            }
            case 70: {
                return null;
            }
            case 91: {
                return Date.class.getName();
            }
            case 3: {
                return BigDecimal.class.getName();
            }
            case 2001: {
                return null;
            }
            case 8: {
                return Double.class.getName();
            }
            case 6: {
                return Float.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 2000: {
                return Object.class.getName();
            }
            case -4: {
                return Blob.class.getName();
            }
            case -1: {
                return Clob.class.getName();
            }
            case 0: {
                return null;
            }
            case 2: {
                return BigDecimal.class.getName();
            }
            case 1111: {
                return null;
            }
            case 7: {
                return Float.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 2002: {
                return null;
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case -3: {
                return Blob.class.getName();
            }
            case 12: {
                return String.class.getName();
            }
        }
        return null;
    }

    public static String getMysqlTypeName(int mysql_type) {
        switch (mysql_type) {
            case 0: 
            case 246: {
                return "DECIMAL";
            }
            case 1: {
                return "TINYINT";
            }
            case 2: {
                return "SMALLINT";
            }
            case 3: {
                return "INTEGER";
            }
            case 4: {
                return "FLOAT";
            }
            case 5: {
                return "DOUBLE";
            }
            case 6: {
                return "NULL";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "BIGINT";
            }
            case 9: {
                return "MEDIUMINT";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "TIME";
            }
            case 12: {
                return "DATETIME";
            }
            case 13: {
                return "YEAR";
            }
            case 14: {
                return "DATETIME";
            }
            case 247: {
                return "ENUM";
            }
            case 248: {
                return "SET";
            }
            case 249: {
                return "BLOB";
            }
            case 250: {
                return "BLOB";
            }
            case 251: {
                return "BLOB";
            }
            case 252: {
                return "BLOB";
            }
            case 16: {
                return "BIT";
            }
            case 15: 
            case 253: {
                return "VARCHAR";
            }
            case 254: {
                return "CHAR";
            }
            case 255: {
                return null;
            }
        }
        return null;
    }

    public static String stringValue(Object x) {
        if (x instanceof Date) {
            return DATE_FORMAT.format((Date)x);
        }
        if (x instanceof Time) {
            return TIME_FORMAT.format((Date)x);
        }
        if (x instanceof java.util.Date) {
            return TIMESTAMP_FORMAT.format((java.util.Date)x);
        }
        return x.toString();
    }

    public static long longValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        return Long.parseLong(MySqlTypes.stringValue(x));
    }

    public static byte byteValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).byteValue();
        }
        return Byte.parseByte(MySqlTypes.stringValue(x));
    }

    public static short shortValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).shortValue();
        }
        return Short.parseShort(MySqlTypes.stringValue(x));
    }

    public static int intValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).intValue();
        }
        return Integer.parseInt(MySqlTypes.stringValue(x));
    }

    public static boolean booleanValue(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x instanceof Number) {
            return ((Number)x).byteValue() != 0;
        }
        return MySqlTypes.stringValue(x).equalsIgnoreCase("true");
    }

    public static Date dateValue(Object x) {
        if (x instanceof Date) {
            return (Date)x;
        }
        return new Date(MySqlTypes.dateMillisValue(x));
    }

    public static Time timeValue(Object x) {
        if (x instanceof Time) {
            return (Time)x;
        }
        return new Time(MySqlTypes.dateMillisValue(x));
    }

    public static Timestamp timestampValue(Object x) {
        if (x instanceof Timestamp) {
            return (Timestamp)x;
        }
        return new Timestamp(MySqlTypes.dateMillisValue(x));
    }

    public static long dateMillisValue(Object x) {
        if (x instanceof java.util.Date) {
            return ((java.util.Date)x).getTime();
        }
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        String s = MySqlTypes.stringValue(x);
        try {
            java.util.Date dt = TIMESTAMP_FORMAT.parse(s);
            return dt.getTime();
        }
        catch (ParseException e) {
            try {
                java.util.Date dt = DATE_FORMAT.parse(s);
                return dt.getTime();
            }
            catch (ParseException e2) {
                try {
                    java.util.Date dt = TIME_FORMAT.parse(s);
                    return dt.getTime();
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(x.toString());
                }
            }
        }
    }

    public static BigDecimal bigDecimalValue(Object x) {
        if (x instanceof BigDecimal) {
            return (BigDecimal)x;
        }
        if (x instanceof Number) {
            return new BigDecimal(((Number)x).doubleValue());
        }
        return new BigDecimal(MySqlTypes.stringValue(x));
    }

    public static float floatValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).floatValue();
        }
        return Float.parseFloat(MySqlTypes.stringValue(x));
    }

    public static double doubleValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        return Double.parseDouble(MySqlTypes.stringValue(x));
    }

    static {
        DATE_FORMAT.setTimeZone(UTC_TIMEZONE);
        TIME_FORMAT.setTimeZone(UTC_TIMEZONE);
        TIMESTAMP_FORMAT.setTimeZone(UTC_TIMEZONE);
        TIMESTAMP_FORMAT.setTimeZone(UTC_TIMEZONE);
        YEAR_FORMAT.setTimeZone(UTC_TIMEZONE);
    }
}

