/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.api.api;
import com.mysql.embedded.api.stmt;
import com.mysql.embedded.jdbc.BindArray;
import com.mysql.embedded.jdbc.MyBlob;
import com.mysql.embedded.jdbc.MyClob;
import com.mysql.embedded.jdbc.MyConnection;
import com.mysql.embedded.jdbc.MyParameterMetaData;
import com.mysql.embedded.jdbc.MyPreparedResultSet;
import com.mysql.embedded.jdbc.MyResultSetMetaData;
import com.mysql.embedded.jdbc.MySqlEmbeddedDriver;
import com.mysql.embedded.jdbc.MySqlTypes;
import com.mysql.embedded.jdbc.MyStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class MyPreparedStatement
extends MyStatement
implements PreparedStatement {
    protected long statementHandle;
    protected BindArray parameters;
    protected MyResultSetMetaData resultMetaData;
    protected MyParameterMetaData paramMetaData;
    protected int columnCount;
    protected BindArray resultColumns;
    protected int fetchSize = 0;

    protected MyPreparedStatement(MyConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.prepare(sql);
    }

    public int executeUpdate() throws SQLException {
        if (this.statementHandle == 0L) {
            throw new SQLException("illegal state");
        }
        if (this.columnCount > 0) {
            throw new SQLException("Update statement expected");
        }
        this.execute();
        return this.updateCount;
    }

    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearParameters() throws SQLException {
        if (this.parameters != null) {
            this.parameters.clear();
        }
        stmt.mysql_stmt_reset(this.statementHandle);
    }

    public synchronized boolean execute() throws SQLException {
        this.connection.useStatement(this);
        this.cancel();
        if (this.parameters != null) {
            stmt.mysql_stmt_bind_param(this.statementHandle, this.parameters.nativeAddress);
        }
        this.connection.setMaxRows(this.maxRows);
        stmt.mysql_stmt_execute(this.statementHandle);
        return this.retrieveResult();
    }

    public void setFetchSize(int rows) throws SQLException {
        super.setFetchSize(rows);
        if (rows < 0) {
            rows = 0;
        }
        if (this.statementHandle != 0L && this.fetchSize != rows) {
            this.fetchSize = rows;
            stmt.mysql_stmt_attr_set(this.statementHandle, 2, this.fetchSize);
        }
        this.fetchSize = rows;
    }

    public boolean getMoreResults(int current) throws SQLException {
        switch (current) {
            case 1: 
            case 3: {
                this.cancel();
                break;
            }
            case 2: {
                if (this.result == null || this.result.stored) break;
                throw new SQLException("can't keep previous ResultSet open");
            }
        }
        this.connection.useStatement(this);
        boolean more = api.mysql_more_results(this.connection.connectionHandle);
        if (more) {
            api.mysql_next_result(this.connection.connectionHandle);
            this.columnCount = stmt.mysql_stmt_field_count(this.statementHandle);
            return this.retrieveResult();
        }
        return false;
    }

    protected boolean retrieveResult() throws SQLException {
        if (this.columnCount > 0) {
            if (this.resultColumns == null) {
                this.resultColumns = new BindArray(this, this.columnCount);
                this.getMetaData();
                this.resultColumns.initialize(this.resultMetaData);
            }
            if (this.result == null) {
                this.result = new MyPreparedResultSet(this, false);
            } else {
                ((MyPreparedResultSet)this.result).reset(false);
            }
            this.updateCount = -1;
            return true;
        }
        this.result = null;
        this.updateCount = (int)stmt.mysql_stmt_affected_rows(this.statementHandle);
        return false;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.setByte(parameterIndex - 1, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.setDouble(parameterIndex - 1, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.setFloat(parameterIndex - 1, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.setInt(parameterIndex - 1, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        boolean version5 = this.connection.getDatabaseMajorVersion() >= 50000;
        this.parameters.setNull(parameterIndex - 1, MySqlTypes.asMysqlType(sqlType, version5));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.setLong(parameterIndex - 1, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.setShort(parameterIndex - 1, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.setByte(parameterIndex - 1, (byte)(x ? 1 : 0));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setBytes(parameterIndex, x, x.length);
    }

    public void setBytes(int parameterIndex, byte[] x, int length) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else if (MySqlEmbeddedDriver.SEND_LONG_DATA) {
            ByteBuffer buffer = this.parameters.allocateBuffer(parameterIndex - 1, 252, length);
            buffer.position(0);
            buffer.put(x, 0, length);
            stmt.mysql_stmt_send_long_data(this.statementHandle, parameterIndex - 1, buffer, length);
        } else {
            this.parameters.setBytes(parameterIndex - 1, 252, x, length);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else {
            this.parameters.setInputStream(parameterIndex - 1, 252, x, length);
        }
    }

    public void setDirectByteBuffer(int parameterIndex, ByteBuffer x) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else if (MySqlEmbeddedDriver.SEND_LONG_DATA) {
            stmt.mysql_stmt_send_long_data(this.statementHandle, parameterIndex - 1, x, x.limit());
        } else {
            this.parameters.setDirectByteBuffer(parameterIndex - 1, 252, x);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else {
            this.parameters.setInputStream(parameterIndex - 1, 252, x, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else {
            this.parameters.setInputStream(parameterIndex - 1, 252, x, length);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.parameters.setNull(parameterIndex - 1, 252);
        } else {
            this.parameters.setReader(parameterIndex - 1, 252, reader, length);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObject(parameterIndex, x, MySqlTypes.guessJavaType(x), 0);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 2003: {
                throw new SQLException("unsuported object type");
            }
            case -5: {
                this.setLong(parameterIndex, MySqlTypes.longValue(x));
                break;
            }
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, MySqlTypes.booleanValue(x));
                break;
            }
            case 70: {
                throw new SQLException("unsuported object type");
            }
            case 91: {
                this.setDate(parameterIndex, MySqlTypes.dateValue(x));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, MySqlTypes.bigDecimalValue(x));
                break;
            }
            case 2001: {
                throw new SQLException("unsuported object type");
            }
            case 7: 
            case 8: {
                this.setDouble(parameterIndex, MySqlTypes.doubleValue(x));
                break;
            }
            case 6: {
                this.setFloat(parameterIndex, MySqlTypes.floatValue(x));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, MySqlTypes.intValue(x));
                break;
            }
            case 2000: {
                throw new SQLException("unsuported object type");
            }
            case -1: 
            case 2005: {
                if (x instanceof ByteBuffer && ((ByteBuffer)x).isDirect()) {
                    this.setDirectByteBuffer(parameterIndex, (ByteBuffer)x);
                    break;
                }
                if (x instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)x);
                    break;
                }
                if (x instanceof String) {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                if (x instanceof Reader) {
                    this.setCharacterStream(parameterIndex, (Reader)x, -1);
                    break;
                }
                throw new SQLException("unsuported object type");
            }
            case 0: {
                this.setNull(parameterIndex, targetSqlType);
                break;
            }
            case 1111: {
                throw new SQLException("unsuported object type");
            }
            case 5: {
                this.setShort(parameterIndex, MySqlTypes.shortValue(x));
                break;
            }
            case 2002: {
                throw new SQLException("unsuported object type");
            }
            case 92: {
                this.setTime(parameterIndex, MySqlTypes.timeValue(x));
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, MySqlTypes.timestampValue(x));
                break;
            }
            case -6: {
                this.setByte(parameterIndex, MySqlTypes.byteValue(x));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (x instanceof ByteBuffer && ((ByteBuffer)x).isDirect()) {
                    this.setDirectByteBuffer(parameterIndex, (ByteBuffer)x);
                    break;
                }
                if (x instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                if (x instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)x);
                    break;
                }
                if (x instanceof InputStream) {
                    this.setBinaryStream(parameterIndex, (InputStream)x, -1);
                    break;
                }
                throw new SQLException("unsuported object type");
            }
            case 1: 
            case 12: {
                this.setString(parameterIndex, MySqlTypes.stringValue(x));
                break;
            }
            default: {
                throw new SQLException("unsuported object type");
            }
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex, 254);
        } else {
            this.parameters.setString(parameterIndex - 1, 254, x);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 0);
        } else {
            this.parameters.setString(parameterIndex - 1, 0, x.toString());
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, x.toExternalForm());
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (x == null) {
            this.parameters.setNull(i, 252);
        } else {
            ByteBuffer buffer = ((MyBlob)x).buffer;
            if (MySqlEmbeddedDriver.SEND_LONG_DATA) {
                stmt.mysql_stmt_send_long_data(this.statementHandle, i - 1, buffer, (int)x.length());
            } else {
                this.parameters.setDirectByteBuffer(i - 1, 252, buffer);
            }
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (x == null) {
            this.parameters.setNull(i, 252);
        } else {
            ByteBuffer buffer = ((MyClob)x).buffer;
            if (MySqlEmbeddedDriver.SEND_LONG_DATA) {
                stmt.mysql_stmt_send_long_data(this.statementHandle, i - 1, buffer, (int)x.length());
            } else {
                this.parameters.setDirectByteBuffer(i - 1, 252, buffer);
            }
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, this.connection.utcCalendar);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.paramMetaData == null) {
            long resHandle = stmt.mysql_stmt_param_metadata(this.statementHandle);
            if (resHandle == 0L) {
                throw new NullPointerException("param_metadata");
            }
            int paramCount = this.parameters != null ? this.parameters.size() : 0;
            this.paramMetaData = new MyParameterMetaData(resHandle, paramCount, true);
        }
        return this.paramMetaData;
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.statementHandle == 0L) {
            throw new SQLException("illegal state");
        }
        if (this.columnCount <= 0) {
            throw new SQLException("Select statement expected");
        }
        this.execute();
        return this.result;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultMetaData == null) {
            long resHandle = stmt.mysql_stmt_result_metadata(this.statementHandle);
            this.resultMetaData = new MyResultSetMetaData(resHandle, this.columnCount, true);
        }
        return this.resultMetaData;
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.connection.utcCalendar);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, this.connection.utcCalendar);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex - 1, 10);
        } else {
            cal.setTime(x);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.parameters.setDate(parameterIndex - 1, 10, cal);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex, 11);
        } else {
            cal.setTime(x);
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            this.parameters.setDate(parameterIndex - 1, 11, cal);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.parameters.setNull(parameterIndex, 7);
        } else {
            cal.setTime(x);
            this.parameters.setDate(parameterIndex - 1, 7, cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            this.connection.unregister(this);
            this.cancel();
            if (this.resultColumns != null) {
                this.resultColumns.close();
            }
            if (this.resultMetaData != null) {
                this.resultMetaData.close();
            }
            if (this.paramMetaData != null) {
                this.paramMetaData.close();
            }
            if (this.statementHandle != 0L) {
                stmt.mysql_stmt_close(this.statementHandle);
            }
            if (this.parameters != null) {
                this.parameters.close();
            }
        }
        finally {
            this.result = null;
            this.resultColumns = null;
            this.resultMetaData = null;
            this.paramMetaData = null;
            this.statementHandle = 0L;
            this.parameters = null;
            this.resultMetaData = null;
            this.paramMetaData = null;
        }
    }

    public void cancel() throws SQLException {
        if (this.result != null && !this.result.isClosed()) {
            this.result.close();
        }
    }

    public boolean isClosed() {
        return this.statementHandle == 0L;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.close();
        this.prepare(sql);
        return this.executeUpdate();
    }

    public boolean execute(String sql) throws SQLException {
        this.close();
        this.prepare(sql);
        return this.execute();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.close();
        this.prepare(sql);
        return this.executeQuery();
    }

    private MyPreparedResultSet preparedResult() {
        return (MyPreparedResultSet)this.result;
    }

    protected static void assertPrepared(long statementHandle) throws SQLException {
        if (statementHandle == 0L) {
            throw new SQLException("illegal state");
        }
    }

    protected void prepare(String sql) throws SQLException {
        this.connection.register(this);
        this.connection.useStatement(this);
        this.statementHandle = stmt.mysql_stmt_init(this.connection.connectionHandle);
        stmt.mysql_stmt_prepare(this.statementHandle, sql);
        stmt.mysql_stmt_attr_set(this.statementHandle, 0, false);
        if (this.fetchSize > 0) {
            stmt.mysql_stmt_attr_set(this.statementHandle, 2, this.fetchSize);
        }
        int paramCount = stmt.mysql_stmt_param_count(this.statementHandle);
        this.columnCount = stmt.mysql_stmt_field_count(this.statementHandle);
        this.parameters = paramCount > 0 ? new BindArray(this, paramCount) : null;
    }
}

