/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.embedded.jdbc;

import com.mysql.embedded.util.ByteBufferInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.sql.Clob;
import java.sql.SQLException;

public class MyClob
implements Clob {
    protected ByteBuffer buffer;

    protected MyClob(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public long length() throws SQLException {
        return this.buffer.limit();
    }

    public void truncate(long len) throws SQLException {
        this.buffer.limit((int)len);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ByteBufferInputStream(this.buffer);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new InputStreamReader(this.getAsciiStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("unsupported encoding: " + e.getLocalizedMessage());
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSubString(long pos, int length) throws SQLException {
        try {
            byte[] bytes = new byte[length];
            this.buffer.position((int)pos);
            this.buffer.get(bytes);
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException("unsupported encoding: " + e.getLocalizedMessage());
        }
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        byte[] bytes = str.substring(offset, offset + len).getBytes();
        this.buffer.position((int)pos);
        this.buffer.put(bytes);
        return len;
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

