/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TPersistenceConfig;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TTable;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class PesAllerPatch33 {
    public static final transient String PARAM_PESV2_PATCH_33 = "pesv2.patch.3.3.applied";
    private MySqlDataLayer impl;

    public PesAllerPatch33(MySqlDataLayer impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DocumentModel dm = MainWindow.instance.getDocModels().getDocumentById("PES_Aller");
        if (dm == null) {
            return;
        }
        Connection con = null;
        try {
            con = this.impl.getConnection();
            TPersistenceConfig cfg = this.impl.getPersistenceConfig(dm);
            TDocument td = cfg.getLayer("mysql").getDocument("PES_Aller");
            TTable tt = td.getListBcTable();
            if (tt != null) {
                this.deleteFrom(tt.getBaseName(), con);
            }
            if ((tt = td.getRepositoryTable()) != null) {
                this.deleteFrom(tt.getBaseName(), con);
            }
            if ((tt = td.getSpecialKeyTable()) != null) {
                this.deleteFrom(tt.getBaseName(), con);
            }
            for (TEtat te : td.getEtats()) {
                tt = te.getDocumentTable();
                if (tt != null) {
                    this.deleteFrom(tt.getBaseName(), con);
                }
                if ((tt = te.getMaintable()) != null) {
                    this.deleteFrom(tt.getBaseName(), con);
                }
                for (TTable tti : te.getIndexTables()) {
                    this.deleteFrom(tti.getBaseName(), con);
                }
            }
            this.impl.setParameterValue(PARAM_PESV2_PATCH_33, "applied");
        }
        catch (DataConfigurationException dcEx) {
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (con != null) {
                this.impl.releaseConnection(con);
            }
        }
    }

    private void deleteFrom(String table, Connection con) {
        try {
            Statement st = con.createStatement();
            st.execute("DELETE FROM " + table);
            st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

