/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.mysql;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.data.DocumentInfos;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TElement;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TSqlIndex;
import fr.gouv.finances.cp.xemelios.ui.resulttable.CachedData;
import fr.gouv.finances.cp.xemelios.ui.resulttable.DataHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MySqlDataResultSet
implements DataResultSet {
    private static Logger logger = Logger.getLogger(MySqlDataResultSet.class);
    private static final int CACHE_SIZE = 1;
    private EtatModel etatModel = null;
    private ElementModel elementModel = null;
    private Pair collectivite = null;
    private Pair budget = null;
    private String xPath = null;
    private String sql = null;
    private String whereClause = "";
    private String fromClause = "";
    private String selectClause = "";
    private MySqlDataLayer implementation = null;
    private int pageSize = 0;
    private int currentPage = 0;
    private ResultSet rs = null;
    private boolean hasNextPage = false;
    private boolean hasPreviousPage = false;
    private int estimatedSize = 0;
    private int estimatedPageCount = -1;
    private int estimatedMainElementSize = 0;
    private ListeResultatModel lrm = null;
    private CachedData cache = null;
    private DocumentCache documentCache = new DocumentCache(1);
    private ArrayList<String> docIds = null;
    private int currentDocIndex = -1;
    private NodeList currentList = null;
    private int currentItemInList = -1;
    private boolean hasNextItem = false;
    private String currentDocId = null;
    private XPathFactory xpf = null;

    public MySqlDataResultSet(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, String sql, ListeResultatModel lrm, MySqlDataLayer impl) throws SQLException, DataConfigurationException {
        this();
        this.elementModel = elementModel;
        this.etatModel = elementModel.getParent();
        this.collectivite = collectivite;
        this.budget = budget;
        this.xPath = xPath;
        this.sql = sql;
        this.lrm = lrm;
        this.implementation = impl;
        this.pageSize = elementModel.getMaxDisplay();
        try {
            this.xpf = new XPathFactoryImpl();
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
        }
        this.xpf.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
        if (lrm == null) {
            logger.debug((Object)"lrm is null");
        } else if (lrm.getTriDefaut() == null) {
            logger.debug((Object)"lrm.getTriDefaut() id null");
        }
        this.loadIds();
    }

    public int getCount() {
        return this.docIds.size();
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public MySqlDataResultSet() {
    }

    protected void loadIds() throws SQLException, DataConfigurationException {
        this.cleanAllCaches();
        StringBuilder currentRequest = new StringBuilder(this.sql);
        this.selectClause = this.sql.substring(0, this.sql.indexOf("FROM"));
        this.fromClause = this.sql.substring(this.sql.indexOf("FROM"), this.sql.indexOf("WHERE"));
        this.whereClause = this.sql.substring(this.sql.indexOf("WHERE"));
        TDocument spc = this.implementation.getPersistenceConfig(this.etatModel.getParent()).getLayer(this.implementation.getLayerName()).getDocument(this.etatModel.getParent().getId());
        TEtat sEtatc = spc.getEtat(this.etatModel.getId());
        TElement sec = sEtatc.getElement(this.elementModel.getId());
        if (sec != null && sec.getSpecialCond() != null) {
            String sCond = sec.getSpecialCond().trim();
            String tableName = sCond.substring(0, sCond.indexOf(46));
            if (this.fromClause.indexOf(tableName) < 0) {
                String sTmp = this.fromClause.substring("FROM".length()).trim();
                String mainTableName = null;
                mainTableName = sTmp.indexOf(32) >= 0 ? sTmp.substring(0, sTmp.indexOf(32)).trim() : sTmp;
                StringBuffer sb = new StringBuffer(this.fromClause);
                sb.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                this.fromClause = sb.toString();
                currentRequest = new StringBuilder();
                currentRequest.append(this.selectClause).append(this.fromClause).append(" ").append(this.whereClause);
            }
            currentRequest.append(" AND ").append(sCond);
        }
        if (this.lrm != null && this.lrm.getTriDefaut() != null) {
            String tris = this.lrm.getTriDefaut();
            String ordres = this.lrm.getOrdre();
            StringTokenizer trisTokenizer = new StringTokenizer(tris, ",");
            StringTokenizer ordresTokenizer = new StringTokenizer(ordres, ",");
            if (currentRequest.indexOf("ORDER BY") < 0) {
                currentRequest.append(" ORDER BY ");
            } else {
                currentRequest.append(", ");
            }
            while (trisTokenizer.hasMoreElements()) {
                ChampModel cm;
                String ordre;
                String tri = trisTokenizer.nextToken();
                String string = ordre = ordresTokenizer.hasMoreTokens() ? ordresTokenizer.nextToken() : "ASC";
                if (ordre == null || ordre.length() == 0) {
                    ordre = "ASC";
                }
                if ((cm = (ChampModel)this.lrm.getChamps().get(tri)) != null) {
                    String path = this.elementModel.getPath().getPath() + "/" + cm.getPath().getPath();
                    path = path.replaceAll("[a-zA-Z0-9]:", "");
                    try {
                        TSqlIndex si = sEtatc.getSqlIndexByPath(path);
                        if (si == null) {
                            logger.error((Object)("index not found for path " + path + "\n won't sort !"));
                            continue;
                        }
                        currentRequest.append(sEtatc.getIndexTable(si.getTableId()).getBaseName()).append(".").append(si.getColumn()).append(" ").append(ordre).append(",");
                        String tableName = sEtatc.getIndexTable(si.getTableId()).getBaseName();
                        if (this.fromClause.indexOf(tableName) >= 0) continue;
                        String sTmp = this.fromClause.substring("FROM".length()).trim();
                        String mainTableName = null;
                        mainTableName = sTmp.indexOf(32) >= 0 ? sTmp.substring(0, sTmp.indexOf(32)).trim() : sTmp;
                        StringBuffer sb = new StringBuffer(this.fromClause);
                        sb.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                        this.fromClause = sb.toString();
                        String saveOrderBy = currentRequest.toString();
                        saveOrderBy = saveOrderBy.substring(saveOrderBy.indexOf(" ORDER BY"));
                        currentRequest = new StringBuilder();
                        currentRequest.append(this.selectClause).append(this.fromClause).append(" ").append(this.whereClause).append(saveOrderBy);
                    }
                    catch (Throwable t) {}
                    continue;
                }
                throw new DataConfigurationException("order by clause of " + this.elementModel.getId() + " references an unknown champ :" + tri);
            }
            if (currentRequest.substring(currentRequest.length() - 1).equals(",")) {
                currentRequest.deleteCharAt(currentRequest.length() - 1);
            }
            if (currentRequest.substring(currentRequest.length() - 9).equals("ORDER BY ")) {
                currentRequest.delete(currentRequest.length() - 10, currentRequest.length());
            }
        }
        currentRequest.append(" LIMIT ").append(this.currentPage * this.pageSize).append(", ").append(this.pageSize);
        logger.debug((Object)currentRequest);
        Connection conToRelease = null;
        try {
            ResultSet rs2;
            String sTmp;
            this.rs = this.implementation.execute(currentRequest.toString());
            conToRelease = this.rs.getStatement().getConnection();
            this.docIds = new ArrayList();
            while (this.rs.next()) {
                this.docIds.add(this.rs.getString(1));
            }
            Statement st = this.rs.getStatement().getConnection().createStatement();
            String sqlCount = null;
            if (sec != null && (sTmp = sec.getSqlCount()) != null) {
                String tmp = currentRequest.toString();
                tmp = tmp.substring(tmp.indexOf("FROM"));
                String fromClause = tmp.substring(0, tmp.indexOf("LIMIT"));
                sqlCount = "SELECT " + sTmp + " " + fromClause;
            }
            if ((rs2 = st.executeQuery("SELECT FOUND_ROWS()")).next()) {
                this.estimatedMainElementSize = rs2.getInt(1);
            }
            if (sqlCount != null) {
                logger.debug((Object)("sqlCount=" + sqlCount));
                rs2 = st.executeQuery(sqlCount);
                this.estimatedSize = rs2.next() ? rs2.getInt(1) : this.estimatedMainElementSize;
            } else {
                this.estimatedSize = this.estimatedMainElementSize;
            }
            st.close();
            this.hasNextPage = this.docIds.size() == this.pageSize;
            this.hasPreviousPage = this.currentPage > 0;
            this.hasNextItem = this.docIds.size() > 0;
            this.currentDocIndex = -1;
            this.rs.getStatement().close();
            if (conToRelease != null) {
                this.implementation.releaseConnection(conToRelease);
            }
        }
        catch (SQLException sqlEx) {
            try {
                throw sqlEx;
            }
            catch (Throwable throwable) {
                if (conToRelease != null) {
                    this.implementation.releaseConnection(conToRelease);
                }
                throw throwable;
            }
        }
        if (this.cache != null && logger.isDebugEnabled()) {
            logger.debug((Object)("cache contains " + this.cache.getSize() + " entries"));
        }
        this.cleanAllCaches();
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPreviousPage() {
        return this.hasPreviousPage;
    }

    public boolean hasNext() {
        return this.hasNextItem;
    }

    public DataHandler next() {
        if (!this.hasNextItem) {
            throw new NoSuchElementException("iterating has ended");
        }
        if (this.currentList == null) {
            this.currentDocId = this.docIds.get(++this.currentDocIndex);
            try {
                Document document = this.getDocument(this.currentDocId);
                XPath xp = this.xpf.newXPath();
                xp.setNamespaceContext((NamespaceContext)this.etatModel.getParent().getNamespaces());
                this.currentList = (NodeList)xp.evaluate(this.xPath, document, XPathConstants.NODESET);
                this.currentItemInList = -1;
            }
            catch (Exception ex) {
                logger.error((Object)"in next():", (Throwable)ex);
                throw new NoSuchElementException("an error occurs. See logs for details.");
            }
        }
        Element el = null;
        try {
            el = (Element)this.currentList.item(++this.currentItemInList);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (this.currentItemInList == this.currentList.getLength() - 1) {
            this.currentList = null;
            boolean bl = this.hasNextItem = this.currentDocIndex + 1 < this.docIds.size();
        }
        if (el != null) {
            return new DataHandler(this.lrm, el, (DataResultSet)this, this.currentDocId, this.cache);
        }
        logger.fatal((Object)"SQL REQUEST RETURNS MORE THAN XPATH DOES");
        this.hasNextItem = false;
        return null;
    }

    public Document getDocument(String docId) throws DataConfigurationException, DataAccessException {
        Document ret = this.documentCache.getDocument(docId);
        if (ret == null) {
            DocumentInfos di = this.implementation.getDocumentInfos(this.etatModel, this.collectivite, this.budget, docId);
            this.addDocumentToCache(docId, di);
            ret = di.getDoc();
        }
        return ret;
    }

    public String getDocumentEncoding(String docId) throws DataConfigurationException, DataAccessException {
        return this.documentCache.getEncoding(docId);
    }

    public void setEnvironment(ListeResultatModel lrm, CachedData cache) {
        this.lrm = lrm;
        this.cache = cache;
    }

    public void remove() {
        throw new UnsupportedOperationException("this operation is not allowed on MySqlDataResultSet");
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setBudget(Pair budget) {
        this.budget = budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setCollectivite(Pair collectivite) {
        this.collectivite = collectivite;
    }

    public EtatModel getEtatModel() {
        return this.etatModel;
    }

    public void setEtatModel(EtatModel etatModel) {
        this.etatModel = etatModel;
    }

    public void nextPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            ++this.currentPage;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void previousPage() throws DataAccessException, DataConfigurationException {
        if (this.hasPreviousPage()) {
            --this.currentPage;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void firstPage() throws DataAccessException, DataConfigurationException {
        this.currentPage = 0;
        try {
            this.loadIds();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public void lastPage() throws DataAccessException, DataConfigurationException {
        if (this.hasNextPage()) {
            this.currentPage = this.getEstimatedPageCount() - 1;
            try {
                this.loadIds();
            }
            catch (SQLException sqlEx) {
                throw new DataAccessException((Throwable)sqlEx);
            }
        }
    }

    public void setPage(int page) throws DataAccessException, DataConfigurationException {
        this.currentPage = page;
        try {
            this.loadIds();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
    }

    public int getEstimatedPageCount() {
        if (this.estimatedPageCount == -1) {
            if (this.pageSize == 0 || this.estimatedSize == 0) {
                this.estimatedPageCount = 0;
            } else {
                this.estimatedPageCount = this.estimatedMainElementSize / this.pageSize;
                if (this.estimatedSize % this.pageSize > 0) {
                    ++this.estimatedPageCount;
                }
            }
        }
        return this.estimatedPageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public ListeResultatModel getListeResultatModel() {
        return this.lrm;
    }

    public void setListeResultatModel(ListeResultatModel l) {
        this.lrm = l;
    }

    public void clear() {
        this.cleanAllCaches();
    }

    protected void cleanAllCaches() {
        if (this.cache != null) {
            this.cache.flush();
        }
        if (this.documentCache != null) {
            this.documentCache.clear();
        }
    }

    protected void addDocumentToCache(String docId, DocumentInfos doc) {
        this.documentCache.putDocument(docId, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String calculateAggregate(String columnName, String tableName, String operator, ChampModel cm) {
        String result;
        block31: {
            result = "";
            ResultSet rset = null;
            StringBuffer sb = new StringBuffer();
            if (this.elementModel.equals(this.elementModel.getParent().getImportableElement())) {
                sb.append("SELECT ").append(operator).append("(").append(columnName).append(")");
                if (cm.getDatatype().equals("date")) {
                    sb.append("))");
                }
                sb.append(" FROM ").append(tableName).append(" WHERE ").append(tableName).append(".COLLECTIVITE='");
                sb.append(this.collectivite.key).append("' AND ").append(tableName).append(".BUDGET='").append(this.budget.key).append("' AND DOC_ID IN (\n");
                sb.append(this.selectClause.replaceAll("SQL_CALC_FOUND_ROWS ", "")).append(" ").append(this.fromClause).append(" ").append(this.whereClause).append("\n)");
            } else {
                int whereLoc;
                String where;
                String sTmp;
                int loc;
                sb.append("SELECT ").append(operator).append("(").append(columnName).append(")");
                if (cm.getDatatype().equals("date")) {
                    sb.append("))");
                }
                if ((loc = (sTmp = this.sql.substring(this.sql.indexOf("FROM "))).indexOf("LIMIT ")) > 0) {
                    sTmp = sTmp.substring(0, loc);
                }
                String string = where = (whereLoc = sTmp.indexOf("WHERE ")) > 0 ? sTmp.substring(whereLoc) : "";
                if (whereLoc > 0) {
                    sTmp = sTmp.substring(0, whereLoc);
                }
                if (sTmp.indexOf(tableName) < 0) {
                    String sTmp2 = sTmp.substring("FROM".length()).trim();
                    String mainTableName = null;
                    mainTableName = sTmp2.indexOf(32) >= 0 ? sTmp2.substring(0, sTmp2.indexOf(32)).trim() : sTmp2;
                    StringBuffer sb2 = new StringBuffer(sTmp);
                    sb2.append(" LEFT OUTER JOIN ").append(tableName).append(" ON ").append(mainTableName).append(".DOC_ID=").append(tableName).append(".DOC_ID AND ").append(mainTableName).append(".COLLECTIVITE=").append(tableName).append(".COLLECTIVITE AND ").append(mainTableName).append(".BUDGET=").append(tableName).append(".BUDGET");
                    sTmp = sb2.toString();
                }
                sb.append(" ").append(sTmp).append(" ").append(where);
            }
            logger.debug((Object)sb.toString());
            Connection conn = null;
            try {
                rset = this.implementation.execute(sb.toString());
                if (rset.getStatement() != null) {
                    conn = rset.getStatement().getConnection();
                }
                if (rset.next()) {
                    result = rset.getString(1);
                    Class classToReturn = cm.getDataClass();
                    if (classToReturn.equals(Float.class)) {
                        try {
                            Float computed = new Float(Float.parseFloat(result));
                        }
                        catch (NumberFormatException nfEx) {}
                    } else if (classToReturn.equals(Integer.class)) {
                        try {
                            Integer computed = new Integer(Integer.parseInt(result));
                        }
                        catch (NumberFormatException nfEx) {}
                    } else if (classToReturn.equals(Amount.class)) {
                        try {
                            Amount computed = new Amount(result);
                            result = computed.stringRepresentation();
                        }
                        catch (NumberFormatException nfEx) {}
                    } else if (classToReturn.equals(Date.class)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Date computed = sdf.parse(result);
                        sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
                        result = sdf.format(computed);
                    }
                }
                rset.close();
                logger.debug((Object)("resultat : " + result));
                if (conn != null) {
                    this.implementation.releaseConnection(conn);
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            catch (ParseException pEx) {
                pEx.printStackTrace();
                break block31;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (conn != null) {
                    this.implementation.releaseConnection(conn);
                }
            }
        }
        return result;
    }

    public ElementModel getElementModel() {
        return this.elementModel;
    }

    public MySqlDataLayer getImplementation() {
        return this.implementation;
    }

    public ListeResultatModel getLrm() {
        return this.lrm;
    }

    public String getSql() {
        return this.sql;
    }

    public String getXPath() {
        return this.xPath;
    }

    public String getCurrentDocId() {
        return this.currentDocId;
    }

    private class DocumentCache {
        private int maxCacheSize;
        private int actualCacheSize = 0;
        private Hashtable<String, Document> cache;
        private Hashtable<String, String> encodings;
        private LinkedList<String> chain;
        private Object locker = new Object();

        public DocumentCache(int cacheSize) {
            this.maxCacheSize = cacheSize;
            this.cache = new Hashtable();
            this.chain = new LinkedList();
            this.encodings = new Hashtable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.locker;
            synchronized (object) {
                this.cache.clear();
                this.chain.clear();
                this.actualCacheSize = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document getDocument(String docId) {
            Document ret = this.cache.get(docId);
            if (ret != null) {
                Object object = this.locker;
                synchronized (object) {
                    this.chain.remove(docId);
                    this.chain.addFirst(docId);
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putDocument(String docId, DocumentInfos doc) {
            Object object;
            if (this.cache.contains(docId)) {
                object = this.locker;
                synchronized (object) {
                    this.cache.remove(docId);
                    this.chain.remove(docId);
                    --this.actualCacheSize;
                }
            }
            object = this.locker;
            synchronized (object) {
                while (this.actualCacheSize >= this.maxCacheSize) {
                    String docToRemove = this.chain.removeLast();
                    this.cache.remove(docToRemove);
                    --this.actualCacheSize;
                }
            }
            object = this.locker;
            synchronized (object) {
                this.cache.put(docId, doc.getDoc());
                this.chain.addFirst(docId);
                this.encodings.put(docId, doc.getEncoding());
                ++this.actualCacheSize;
            }
        }

        public String getEncoding(String docId) {
            String encoding = this.encodings.get(docId);
            if (encoding == null) {
                this.getDocument(docId);
                encoding = this.encodings.get(docId);
            }
            return encoding;
        }
    }
}

