/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.cp.utils.xml.PathNotFoundException;
import fr.gouv.finances.cp.utils.xml.dompath.DomPath;
import fr.gouv.finances.cp.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.common.Scramble;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.data.AbstractDataImpl;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.data.DocumentInfos;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSet;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.PayePatch32;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.PesAllerPatch33;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.RapportPatch33;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.VersementPatch32;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TCriteria;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TLayer;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TPatch;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TPersistenceConfig;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TSql;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TSqlIndex;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TTable;
import fr.gouv.finances.cp.xemelios.data.ui.DlgPatchProgress;
import fr.gouv.finances.cp.xemelios.data.ui.PatchProgress;
import fr.gouv.finances.cp.xemelios.export.ConfigModel;
import fr.gouv.finances.cp.xemelios.ui.DatabaseTreeDataFichier;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.utils.LongueurMax;
import fr.gouv.finances.cp.xemelios.utils.TextWriter;
import fr.gouv.finances.cp.xemelios.utils.XmlUtils;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDataLayer
extends AbstractDataImpl {
    static final transient String PARAM_TABLE_NAME = "PARAMETERS";
    public static final transient String PROP_CONFIG_FILE_NAME = "xemelios.mysql.config.filename";
    public static final transient String PROP_MIN_POOL_SIZE = "pool-size-mini";
    private static Logger logger = Logger.getLogger(MySqlDataLayer.class);
    private static final SimpleDateFormat mySqlDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final transient String LAYER_NAME = "mysql";
    private ArrayList<TPersistenceConfig> checkedConfigs = null;
    private ArrayList<Connection> availableConnections = null;
    private ArrayList<Connection> usedConnections = null;
    private PropertiesExpansion props = null;
    private TreeSet<String> createdTables;
    private DocumentBuilderFactory dbf = null;
    private SAXParserFactory saxFactory = null;
    private XPathFactory xPathFactory = null;
    private DocumentBuilderFactory domFactory = null;
    private int minPoolSize = 1;
    private Object poolLocker = new Object();
    private Hashtable<Thread, String> warnings;
    private DlgPatchProgress progress;

    public MySqlDataLayer() throws DataConfigurationException {
        logger.info((Object)"instancing");
        this.createdTables = new TreeSet();
        this.warnings = new Hashtable();
        this.initConnections();
        this.checkParamTable();
        this.dbf = DocumentBuilderFactory.newInstance();
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        try {
            this.xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            this.xPathFactory = XPathFactory.newInstance();
        }
        this.xPathFactory.setXPathFunctionResolver((XPathFunctionResolver)new FunctionResolver());
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.applyPatches();
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    public void reset() {
        super.reset();
        this.checkedConfigs.clear();
        this.createdTables.clear();
    }

    public PatchProgress getPatchProgress() {
        if (this.progress == null) {
            this.progress = new DlgPatchProgress();
            this.progress.setVisible(true);
        }
        return this.progress;
    }

    protected void killPatchProgress() {
        if (this.progress != null) {
            this.progress.setVisible(false);
            this.progress.dispose();
            this.progress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importElement(DocumentModel dm, EtatModel em, Pair codeBudget, Pair collectivite, String sourceFileName, String elementName, String strElement, String encoding) throws DataAccessException, DataConfigurationException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        TEtat sec = pc.getEtat(em.getId());
        Connection con = null;
        PreparedStatement ps = null;
        IndexerHandler ih = null;
        String strWarnings = null;
        try {
            con = this.getConnection();
            this.ensureTablesExists(pc, sec, codeBudget, collectivite, con);
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(sec.getDocumentTable().getBaseName()).append(" (BUDGET,COLLECTIVITE, INITIAL_DOC_NAME, DOC_ID, DOC, ENCODING) VALUES (?,?,?,?,?,?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, codeBudget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, sourceFileName);
            ps.setString(4, elementName);
            String strBuffer = strElement;
            byte[] buffer = strBuffer.getBytes(encoding);
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            ps.setBinaryStream(5, (InputStream)is, buffer.length);
            ps.setString(6, encoding);
            ps.executeUpdate();
            ps.close();
            ih = new IndexerHandler(sec, codeBudget.key, collectivite.key, elementName, con, (NamespaceContext)dm.getNamespaces());
            ih.reset();
            SAXParser parser = this.saxFactory.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(strElement.getBytes(encoding)), (DefaultHandler)ih);
            ih.reset();
            strWarnings = ih.getWarnings();
            ih = null;
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace();
            throw new DataAccessException((Throwable)(ih.getException() != null ? ih.getException() : saxEx));
        }
        catch (ParserConfigurationException pcEx) {
            pcEx.printStackTrace();
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new DataAccessException((Throwable)(ih.getException() != null ? ih.getException() : ioEx));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        if (strWarnings != null) {
            this.warnings.put(Thread.currentThread(), strWarnings);
        } else {
            this.warnings.remove(Thread.currentThread());
        }
        return strWarnings == null;
    }

    public boolean saveRepository(DocumentModel dm, Pair collectivite, Document repository) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        boolean bRet = false;
        try {
            con = this.getConnection();
            String repositoryEncoding = repository.getXmlEncoding();
            String strRepository = TextWriter.toString((Node)repository, (String)repositoryEncoding);
            StringBuilder sb = new StringBuilder();
            if (!this.doesRepositoryExist(pc, collectivite.key, con)) {
                sb.append("INSERT INTO ").append(pc.getRepositoryTable().getBaseName()).append(" (REPOSITORY,ENCODING,COLLECTIVITE) VALUES (?,?,?)");
            } else {
                sb.append("UPDATE ").append(pc.getRepositoryTable().getBaseName()).append(" SET REPOSITORY=?, ENCODING=? WHERE COLLECTIVITE=?");
            }
            ps = con.prepareStatement(sb.toString());
            byte[] buffer = strRepository.getBytes(repositoryEncoding);
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            ps.setBinaryStream(1, is, buffer.length);
            ps.setString(2, repositoryEncoding);
            ps.setString(3, collectivite.key);
            bRet = ps.executeUpdate() == 1;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (UnsupportedEncodingException ueEx) {
            throw new DataConfigurationException("The char encoding of this file is unknown", (Throwable)ueEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return bRet;
    }

    public void registerBudgetCollectivite(DocumentModel dm, Pair codeBudget, Pair collectivite, String docName) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, codeBudget, collectivite, con);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT 1 FROM ").append(pc.getListBcTable().getBaseName()).append(" WHERE BUDGET=? AND COLLECTIVITE=? AND INITIAL_DOC_NAME=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, codeBudget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docName);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                sb = new StringBuilder();
                sb.append("INSERT INTO ").append(pc.getListBcTable().getBaseName()).append(" (BUDGET,COLLECTIVITE,INITIAL_DOC_NAME,BUDGET_LIB,COLLECTIVITE_LIB) VALUES (?,?,?,?,?)");
                ps = con.prepareStatement(sb.toString());
                ps.setString(1, codeBudget.key);
                ps.setString(2, collectivite.key);
                ps.setString(3, docName);
                ps.setString(4, codeBudget.libelle);
                ps.setString(5, collectivite.libelle);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public void saveSpecialKeys(DocumentModel dm, Pair budget, Pair collectivite, String docName, Pair sk1, Pair sk2, Pair sk3) throws DataConfigurationException, DataAccessException {
        if (sk1 == null && sk2 == null && sk3 == null) {
            return;
        }
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(pc.getSpecialKeyTable().getBaseName()).append(" (BUDGET,COLLECTIVITE,INITIAL_DOC_NAME,KEY1,LIB1,KEY2,LIB2,KEY3,LIB3) VALUES(?,?,?,?,?,?,?,?,?)");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docName);
            if (sk1 != null) {
                ps.setString(4, sk1.key);
                ps.setString(5, sk1.libelle);
            } else {
                ps.setNull(4, 12);
                ps.setNull(5, 12);
            }
            if (sk2 != null) {
                ps.setString(6, sk2.key);
                ps.setString(7, sk2.libelle);
            } else {
                ps.setNull(6, 12);
                ps.setNull(7, 12);
            }
            if (sk3 != null) {
                ps.setString(8, sk3.key);
                ps.setString(9, sk3.libelle);
            } else {
                ps.setNull(8, 12);
                ps.setNull(9, 12);
            }
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public boolean canSearch(DocumentModel dm, EtatModel em) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        TEtat sec = pc.getEtat(em.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            ResultSet rs = null;
            try {
                rs = con.createStatement().executeQuery("SELECT 1 FROM " + sec.getDocumentTable().getBaseName() + " LIMIT 1");
            }
            catch (SQLException sqlEx) {
                boolean bl = false;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    this.releaseConnection(con);
                }
                return bl;
            }
            if (rs != null) {
                boolean bl = rs.next();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public Vector<Pair> getBudgets(DocumentModel dm, Pair collectivite) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        if (dm == null || collectivite == null) {
            return vRet;
        }
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT BUDGET, BUDGET_LIB FROM ").append(pc.getListBcTable().getBaseName()).append(" WHERE COLLECTIVITE=? ORDER BY BUDGET_LIB");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getCollectivites(DocumentModel dm) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DISTINCT COLLECTIVITE, COLLECTIVITE_LIB FROM ").append(pc.getListBcTable().getBaseName()).append(" ORDER BY COLLECTIVITE_LIB");
            ResultSet rs = con.createStatement().executeQuery(sb.toString());
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys1(DocumentModel dm, Pair collectivite, Pair budget, boolean distinct) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY1,LIB1 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys2(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, boolean distinct) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY2,LIB2 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE KEY1=? AND COLLECTIVITE=? AND BUDGET=? AND KEY2 is not null");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, key1.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Vector<Pair> getSpecialKeys3(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2, boolean distinct) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(distinct ? "DISTINCT " : " ").append("KEY3,LIB3 FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE KEY1=? AND KEY2=? AND COLLECTIVITE=? AND BUDGET=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, key1.key);
            ps.setString(2, key2.key);
            ps.setString(3, collectivite.key);
            ps.setString(4, budget.key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                vRet.add(new Pair(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public Collection<Pair> queryRepository(DocumentModel dm, Pair collectivite, RecherchePaireModel rpm) throws DataConfigurationException, DataAccessException {
        Vector<Pair> vRet = new Vector<Pair>();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE COLLECTIVITE=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                Document repository = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
                XPath xp = this.xPathFactory.newXPath();
                xp.setNamespaceContext((NamespaceContext)dm.getNamespaces());
                NodeList nl = (NodeList)xp.evaluate(rpm.getPath().getPath(), repository, XPathConstants.NODESET);
                DomPath dpCode = rpm.getCodePath().getDomPath((NamespaceContext)dm.getNamespaces());
                DomPath dpLibelle = rpm.getLibellePath().getDomPath((NamespaceContext)dm.getNamespaces());
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    String code = (String)dpCode.getValue(node, false);
                    String libelle = (String)dpLibelle.getValue(node, true);
                    vRet.add(new Pair(code, libelle));
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        catch (XPathExpressionException xpEx) {
            throw new DataConfigurationException((Throwable)xpEx);
        }
        catch (InvalidPathExpressionException ipeEx) {
            throw new DataConfigurationException((Throwable)ipeEx);
        }
        catch (PathNotFoundException pnfEx) {
            throw new DataConfigurationException((Throwable)pnfEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public boolean isDocumentExists(DocumentModel dm, Pair budget, Pair collectivite, String docName) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        boolean ret = false;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
                if (!(ret |= this.documentExists(pc, budget, collectivite, docName, con))) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public void removeDocument(DocumentModel dm, Pair budget, Pair collectivite, String docName) throws DataConfigurationException, DataAccessException {
        logger.debug((Object)("remove document " + docName + " / " + collectivite.key + " / " + budget.key));
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, budget, collectivite, con);
                StringBuilder sql = null;
                PreparedStatement ps = null;
                sql = new StringBuilder();
                sql.append("delete from ");
                for (TTable sti : sec.getIndexTables()) {
                    sql.append("\n").append(sti.getBaseName()).append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                String docTableName = sec.getDocumentTable().getBaseName();
                sql.append("\nusing ").append(docTableName);
                for (TTable sti : sec.getIndexTables()) {
                    String baseName = sti.getBaseName();
                    sql.append("\nLEFT OUTER JOIN ").append(baseName).append(" ON (").append(baseName).append(".COLLECTIVITE=").append(docTableName).append(".COLLECTIVITE AND ").append(baseName).append(".BUDGET=").append(docTableName).append(".BUDGET AND ").append(baseName).append(".DOC_ID=").append(docTableName).append(".DOC_ID )");
                }
                sql.append("\nwhere ");
                sql.append(docTableName).append(".COLLECTIVITE=? AND ").append(docTableName).append(".BUDGET=? AND ").append(docTableName).append(".INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
                if (pc.getSpecialKeyTable() != null) {
                    sql = new StringBuilder();
                    sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=? AND INITIAL_DOC_NAME=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, budget.key);
                    ps.setString(3, docName);
                    ps.executeUpdate();
                }
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=? AND INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=? AND INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.setString(3, docName);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public String getRepository(DocumentModel dm, Pair collectivite, Pair budget) throws DataConfigurationException, DataAccessException {
        String ret = null;
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY, ENCODING FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE COLLECTIVITE=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret = new String(baos.toByteArray(), encoding);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Document getRepositoryAsDom(DocumentModel dm, Pair collectivite) throws DataConfigurationException, DataAccessException {
        Vector vRet = new Vector();
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        PreparedStatement ps = null;
        Document repository = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT REPOSITORY FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE COLLECTIVITE=?");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getBinaryStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                repository = domBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
            }
        }
        catch (Throwable t) {
            throw new DataConfigurationException("invalid code !", t);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return repository;
    }

    public Collection<String> getDistinctValues(ElementModel em, Pair collectivite, Pair budget, String path) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(em.getParent().getParent()).getLayer(LAYER_NAME).getDocument(em.getParent().getParent().getId());
        TEtat sec = pc.getEtat(em.getParent().getId());
        TSqlIndex si = sec.getSqlIndexByPath(path);
        TTable sti = sec.getIndexTable(si.getTableId());
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT(").append(si.getColumn()).append(") FROM ").append(sti.getBaseName()).append(" ");
        sb.append("WHERE COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)collectivite.key)).append("' AND BUDGET='").append(StringEscapeUtils.escapeSql((String)budget.key)).append("' AND ").append(si.getColumn()).append(" IS NOT NULL ORDER BY 1");
        Vector<String> vRet = new Vector<String>();
        Connection con = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sb.toString());
            while (rs.next()) {
                vRet.add(rs.getString(1));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataConfigurationException("invalid code !", (Throwable)sqlEx);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return vRet;
    }

    public boolean removeFichier(DocumentModel dm, String fichier) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            PreparedStatement ps = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where DOC_ID=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, fichier);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where INITIAL_DOC_NAME=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, fichier);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeBudget(DocumentModel dm, Pair collectivite, Pair budget) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            PreparedStatement ps = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.setString(2, budget.key);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where COLLECTIVITE=? AND BUDGET=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.setString(2, budget.key);
                ps.executeUpdate();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeCollectivite(DocumentModel dm, Pair collectivite) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT TABLE_NAME FROM TABLES_VERSIONS");
            ArrayList<String> existingTables = new ArrayList<String>();
            while (rs.next()) {
                existingTables.add(rs.getString(1));
            }
            StringBuilder sql = null;
            if (pc.getSpecialKeyTable() != null && existingTables.contains(pc.getSpecialKeyTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getSpecialKeyTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName()).append(" where COLLECTIVITE=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            if (existingTables.contains(pc.getListBcTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getListBcTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName()).append(" where COLLECTIVITE=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            if (existingTables.contains(pc.getRepositoryTable().getBaseName())) {
                logger.debug((Object)("delete from " + pc.getRepositoryTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getRepositoryTable().getBaseName()).append(" where COLLECTIVITE=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            for (TEtat sec : pc.getEtats()) {
                for (TTable sti : sec.getIndexTables()) {
                    if (!existingTables.contains(sti.getBaseName())) continue;
                    logger.debug((Object)("delete from " + sti.getBaseName()));
                    sql = new StringBuilder();
                    sql.append("delete from ").append(sti.getBaseName()).append(" where COLLECTIVITE=?");
                    ps = con.prepareStatement(sql.toString());
                    ps.setString(1, collectivite.key);
                    ps.executeUpdate();
                }
                if (!existingTables.contains(sec.getDocumentTable().getBaseName())) continue;
                logger.debug((Object)("delete from " + sec.getDocumentTable().getBaseName()));
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName()).append(" where COLLECTIVITE=?");
                ps = con.prepareStatement(sql.toString());
                ps.setString(1, collectivite.key);
                ps.executeUpdate();
            }
            sql = new StringBuilder();
            sql.append("delete from ATTACHMENTS where COLLECTIVITE=?");
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, collectivite.key);
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeDocumentModel(DocumentModel dm) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            for (TEtat sec : pc.getEtats()) {
                this.ensureTablesExists(pc, sec, null, null, con);
                StringBuilder sql = new StringBuilder();
                Statement st = null;
                for (TTable sti : sec.getIndexTables()) {
                    sql.append("delete from ").append(sti.getBaseName());
                    st = con.createStatement();
                    st.executeUpdate(sql.toString());
                    sql = new StringBuilder();
                    st.close();
                }
                st = con.createStatement();
                if (pc.getSpecialKeyTable() != null) {
                    sql.append("delete from ").append(pc.getSpecialKeyTable().getBaseName());
                    st.executeUpdate(sql.toString());
                }
                sql = new StringBuilder();
                sql.append("delete from ").append(sec.getDocumentTable().getBaseName());
                st.executeUpdate(sql.toString());
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getListBcTable().getBaseName());
                st.executeUpdate(sql.toString());
                sql = new StringBuilder();
                sql.append("delete from ").append(pc.getRepositoryTable().getBaseName());
                st.executeUpdate(sql.toString());
                st.close();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeSpecialKey1(DocumentModel dm, Pair collectivite, Pair budget, Pair key1) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=? AND KEY1=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ps.setString(3, key1.key);
            ResultSet rs = ps.executeQuery();
            TreeSet<String> al = new TreeSet<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            for (String docName : al) {
                this.removeDocument(dm, budget, collectivite, docName);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public boolean removeSpecialKey2(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            logger.debug((Object)("deleting " + dm.getId() + "/" + collectivite.libelle + "/" + budget.libelle + "/" + key1.key + "/" + key2.key));
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=? AND KEY1=? AND KEY2=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ps.setString(3, key1.key);
            ps.setString(4, key2.key);
            ResultSet rs = ps.executeQuery();
            TreeSet<String> al = new TreeSet<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            for (String docName : al) {
                this.removeDocument(dm, budget, collectivite, docName);
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        catch (SQLException sqlEx) {
            try {
                throw new DataAccessException((Throwable)sqlEx);
            }
            catch (Throwable throwable) {
                if (con != null) {
                    this.releaseConnection(con);
                }
                throw throwable;
            }
        }
        return true;
    }

    public boolean removeSpecialKey3(DocumentModel dm, Pair collectivite, Pair budget, Pair key1, Pair key2, Pair key3) throws DataConfigurationException, DataAccessException {
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT INITIAL_DOC_NAME FROM ").append(pc.getSpecialKeyTable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=? AND KEY1=? AND KEY2=? AND KEY3=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, budget.key);
            ps.setString(3, key1.key);
            ps.setString(4, key2.key);
            ps.setString(5, key3.key);
            ResultSet rs = ps.executeQuery();
            TreeSet<String> al = new TreeSet<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            for (String docName : al) {
                this.removeDocument(dm, budget, collectivite, docName);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return true;
    }

    public DataResultSet getEmptyDataResultSet() {
        return new MySqlDataResultSet();
    }

    public DataResultSet search(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, ListeResultatModel lrm, Vector<CritereModel> models) throws DataConfigurationException, DataAccessException {
        String sql = this.transformXPathToSql(elementModel, collectivite, budget, xPath, models);
        logger.debug((Object)sql);
        MySqlDataResultSet rs = null;
        try {
            rs = new MySqlDataResultSet(elementModel, collectivite, budget, xPath, sql, lrm, this);
        }
        catch (SQLException sqlEx) {
            throw new DataConfigurationException((Throwable)sqlEx);
        }
        return rs;
    }

    public Pair[] getOperators(String datatype) {
        if ("string".equals(datatype)) {
            return new Pair[]{new Pair("starts-with", "commence par"), new Pair("contains", "contient"), new Pair("xem:ends-with", "fini par"), new Pair("xem:StringEquals", "\u00e9gal \u00e0\u00a0"), new Pair("xem:StringDiffers", "diff\u00e8re de"), new Pair("xem:StringIsNull", "est nul"), new Pair("xem:StringIsNotNull", "n'est pas nul")};
        }
        if ("numeric".equals(datatype)) {
            return new Pair[]{new Pair("=", "="), new Pair(">=", ">="), new Pair(">", ">"), new Pair("<", "<"), new Pair("<=", "<="), new Pair("!=", "!=")};
        }
        if ("date".equals(datatype)) {
            return new Pair[]{new Pair("xem:DateBefore", "avant le"), new Pair("xem:DateEquals", "le"), new Pair("xem:DateAfter", "apr\u00e8s le")};
        }
        return null;
    }

    public String getDocumentAsString(EtatModel etatModel, Pair collectivite, Pair budget, String docId) throws DataConfigurationException, DataAccessException {
        DocumentModel dm = etatModel.getParent();
        String ret = null;
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC, ENCODING FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE BUDGET=? AND COLLECTIVITE=? AND DOC_ID=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                ret = new String(baos.toByteArray(), encoding);
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public Document getDocumentAsDom(EtatModel etatModel, Pair collectivite, Pair budget, String docId) throws DataConfigurationException, DataAccessException {
        DocumentModel dm = etatModel.getParent();
        Document ret = null;
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE BUDGET=? AND COLLECTIVITE=? AND DOC_ID=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                byte[] byteArray = baos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                ret = builder.parse(bis);
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    logger.debug((Object)new String(byteArray));
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    public DocumentInfos getDocumentInfos(EtatModel etatModel, Pair collectivite, Pair budget, String docId) throws DataConfigurationException, DataAccessException {
        DocumentModel dm = etatModel.getParent();
        Document ret = null;
        String encoding = null;
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        Connection con = null;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT DOC, ENCODING FROM ").append(sec.getDocumentTable().getBaseName()).append(" WHERE BUDGET=? AND COLLECTIVITE=? AND DOC_ID=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, budget.key);
            ps.setString(2, collectivite.key);
            ps.setString(3, docId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                encoding = rs.getString(2);
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(1);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                byte[] byteArray = baos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                ret = builder.parse(bis);
                if ("true".equals(System.getProperty("xemelios.log.dom.doc"))) {
                    logger.debug((Object)new String(byteArray));
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        catch (ParserConfigurationException pcEx) {
            throw new DataConfigurationException((Throwable)pcEx);
        }
        catch (SAXException saxEx) {
            throw new DataAccessException((Throwable)saxEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return new DocumentInfos(docId, ret, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createNewConnection() throws SQLException {
        logger.info((Object)"create new connection");
        Connection con = DriverManager.getConnection(this.props.getProperty("database.url"), (Properties)this.props);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            st.execute("SET sql_mode=''");
            st.close();
            st = null;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection con) {
        Object object = this.poolLocker;
        synchronized (object) {
            if (this.usedConnections.contains(con)) {
                this.usedConnections.remove(con);
            } else {
                Exception ex = new Exception();
                logger.warn((Object)"unknown connection to release !!!", (Throwable)ex);
            }
            if (this.usedConnections.size() + this.availableConnections.size() > this.minPoolSize) {
                logger.info((Object)"closing connection");
                try {
                    con.close();
                }
                catch (SQLException sqlEx) {
                    logger.warn((Object)"while closing connection", (Throwable)sqlEx);
                }
            } else {
                this.availableConnections.add(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Object object = this.poolLocker;
        synchronized (object) {
            Connection con = null;
            con = this.availableConnections.size() > 0 ? this.availableConnections.remove(0) : this.createNewConnection();
            this.usedConnections.add(con);
            return con;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean documentExists(TDocument pc, Pair codeBudget, Pair collectivite, String docName, Connection con) throws SQLException {
        Statement ps = null;
        boolean bRet = false;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select 1 from ").append(pc.getListBcTable().getBaseName()).append(" where INITIAL_DOC_NAME=? AND BUDGET=? AND COLLECTIVITE=? LIMIT 1");
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, docName);
            ps.setString(2, codeBudget.key);
            ps.setString(3, collectivite.key);
            ResultSet rs = ps.executeQuery();
            bRet = rs.next();
            rs.close();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesRepositoryExist(TDocument pc, String collectivite, Connection con) throws SQLException {
        boolean bRet = false;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT 1 FROM ").append(pc.getRepositoryTable().getBaseName()).append(" WHERE COLLECTIVITE=?");
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite);
            ResultSet rs = ps.executeQuery();
            bRet = rs.next();
            rs.close();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return bRet;
    }

    protected void ensureTablesExists(TDocument pc, TEtat sec, Pair codeBudget, Pair collectivite, Connection con) throws SQLException {
        Statement st = con.createStatement();
        this.createTable(pc.getListBcTable(), st);
        this.createTable(pc.getRepositoryTable(), st);
        this.createTable(pc.getSpecialKeyTable(), st);
        this.createTable(sec.getDocumentTable(), st);
        for (TTable table : sec.getIndexTables()) {
            this.createTable(table, st);
        }
        st.close();
    }

    private void createTable(TTable sti, Statement st) throws SQLException {
        if (sti == null) {
            return;
        }
        if (!this.createdTables.contains(sti.getBaseName())) {
            st.executeUpdate(sti.getScript());
            if (st.executeQuery("SELECT 1 FROM TABLES_VERSIONS WHERE TABLE_NAME='" + sti.getBaseName() + "'").next()) {
                st.executeUpdate("UPDATE TABLES_VERSIONS SET VERSION=" + sti.getVersion() + " WHERE TABLE_NAME='" + sti.getBaseName() + "'");
            } else {
                st.executeUpdate("INSERT INTO TABLES_VERSIONS (TABLE_NAME,VERSION) VALUES ('" + sti.getBaseName() + "'," + sti.getVersion() + ")");
            }
            this.createdTables.add(sti.getBaseName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableVersion(TTable table, Connection con) throws SQLException {
        block30: {
            String sql = "SELECT VERSION FROM TABLES_VERSIONS WHERE TABLE_NAME=?";
            PreparedStatement ps = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                ps = con.prepareStatement(sql);
                ps.setString(1, table.getBaseName());
                rs = ps.executeQuery();
                if (rs.next()) {
                    int existingVersion = rs.getInt(1);
                    if (existingVersion >= table.getVersion()) {
                        return;
                    }
                    TPatch patch = table.getPatchFromVersion(existingVersion);
                    st = con.createStatement();
                    for (TSql order : patch.getOrders()) {
                        SQLException sqlEx = null;
                        try {
                            st.execute(order.getSql());
                        }
                        catch (SQLException ex) {
                            sqlEx = ex;
                        }
                        if (sqlEx == null || !order.isFailOnError()) continue;
                        throw sqlEx;
                    }
                    rs.close();
                    sql = "UPDATE TABLES_VERSIONS SET VERSION=? WHERE TABLE_NAME=?";
                    ps = con.prepareStatement(sql);
                    ps.setInt(1, table.getVersion());
                    ps.setString(2, table.getBaseName());
                    ps.executeUpdate();
                    break block30;
                }
                st = con.createStatement();
                this.createTable(table, st);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    protected String transformXPathToSql(ElementModel elementModel, Pair collectivite, Pair budget, String xPath, Vector<CritereModel> models) throws DataConfigurationException {
        EtatModel etatModel = elementModel.getParent();
        DocumentModel documentModel = etatModel.getParent();
        TDocument pc = this.getPersistenceConfig(documentModel).getLayer(LAYER_NAME).getDocument(documentModel.getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        if (!xPath.substring(0, elementModel.getPath().getPath().length()).equals(elementModel.getPath().getPath())) {
            throw new DataConfigurationException("XPath: " + xPath + " does not start with element[" + elementModel.getId() + "] path");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CritereModel> part = new ArrayList<CritereModel>();
        boolean firstPart = true;
        if (models != null) {
            for (CritereModel cm : models) {
                TCriteria ci = sec.getCriteria(cm.getId());
                if (ci == null) {
                    throw new DataConfigurationException("no criteria persistence info found for " + cm.getId());
                }
                cm.setAdditionnalData((Object)ci);
                part.add(cm);
            }
        }
        this.appendRequest(part, sb, sec, collectivite, budget, firstPart);
        return sb.toString();
    }

    protected void appendRequest(ArrayList<CritereModel> criterias, StringBuilder sb, TEtat sec, Pair collectivite, Pair budget, boolean firstPart) throws DataConfigurationException {
        TTable mainTable = sec.getMaintable();
        TreeSet<TTable> criteriasUsedTables = new TreeSet<TTable>();
        StringBuilder fromClause = new StringBuilder();
        StringBuilder whereClause = new StringBuilder();
        sb.append("SELECT SQL_CALC_FOUND_ROWS DISTINCT(").append(mainTable.getBaseName()).append(".DOC_ID) FROM ");
        sb.append(sec.getMaintable().getBaseName());
        whereClause.append(" WHERE ");
        whereClause.append(mainTable.getBaseName()).append(".COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)collectivite.key)).append("' AND ").append(mainTable.getBaseName()).append(".BUDGET='").append(StringEscapeUtils.escapeSql((String)budget.key)).append("' AND ( (");
        for (CritereModel cm : criterias) {
            TCriteria sci = (TCriteria)cm.getAdditionnalData();
            if (sci.getSqlIndexId() == null) {
                logger.warn((Object)("try to use a mis-defined criteria : " + sci.getId()));
                continue;
            }
            TSqlIndex si = sec.getSqlIndexById(sci.getSqlIndexId());
            TTable sti = sec.getIndexTable(si.getTableId());
            if (cm.getProperty("AND_OR") != null) {
                String andOr = cm.getProperty("AND_OR");
                if ("||".equals(andOr)) {
                    whereClause.append(") OR (");
                } else {
                    whereClause.append(" AND ");
                }
            }
            String s = sci.getSubstitutedWhereClause(cm);
            s = s.replaceAll("\\$\\{table\\}", sti.getBaseName());
            s = s.replaceAll("\\$\\{column\\}", si.getColumn());
            whereClause.append(s);
            criteriasUsedTables.add(sti);
        }
        if (whereClause.substring(sb.length() - 6).equals(" AND ")) {
            for (int i = 0; i < 4; ++i) {
                whereClause.deleteCharAt(whereClause.length() - 1);
            }
        }
        if (whereClause.substring(sb.length() - 5).equals(" OR ")) {
            for (int i = 0; i < 3; ++i) {
                whereClause.deleteCharAt(whereClause.length() - 1);
            }
        }
        whereClause.append(") )");
        for (TTable sti : sec.getIndexTables()) {
            if (sti.isMainTable() || !criteriasUsedTables.contains(sti)) continue;
            fromClause.append(" LEFT OUTER JOIN ").append(sti.getBaseName()).append(" ON ").append(sec.getMaintable().getBaseName()).append(".DOC_ID=").append(sti.getBaseName()).append(".DOC_ID AND ").append(sec.getMaintable().getBaseName()).append(".COLLECTIVITE=").append(sti.getBaseName()).append(".COLLECTIVITE AND ").append(sec.getMaintable().getBaseName()).append(".BUDGET=").append(sti.getBaseName()).append(".BUDGET");
        }
        sb.append(fromClause.toString()).append(whereClause.toString());
    }

    protected String[] evaluateCondition(String cond) {
        String[] ret = new String[3];
        return ret;
    }

    public ResultSet execute(String sql) throws SQLException {
        Connection con = null;
        ResultSet rs = null;
        con = this.getConnection();
        Statement st = con.createStatement();
        rs = st.executeQuery(sql);
        return rs;
    }

    private void initConnections() throws DataConfigurationException {
        String configFileName = System.getProperty(PROP_CONFIG_FILE_NAME);
        this.props = new PropertiesExpansion();
        for (Object key : System.getProperties().keySet()) {
            this.props.put(key, (Object)System.getProperty((String)key));
        }
        Connection pCon = null;
        try {
            this.props.load((InputStream)new FileInputStream(configFileName));
            String cipheredPassword = this.props.getProperty("password");
            String clearPassword = Scramble.unScramblePassword((String)cipheredPassword);
            this.props.setProperty("password", clearPassword);
            Class.forName(this.props.getProperty("driver.class"));
            String sTmp = this.props.getProperty(PROP_MIN_POOL_SIZE);
            if (sTmp == null || sTmp.length() == 0) {
                sTmp = "1";
            }
            this.minPoolSize = 1;
            try {
                this.minPoolSize = Integer.parseInt(sTmp);
            }
            catch (NumberFormatException nfEx) {
                logger.error((Object)"property pool-size-mini has an invalid value");
            }
            this.availableConnections = new ArrayList(this.minPoolSize);
            this.usedConnections = new ArrayList();
            this.checkedConfigs = new ArrayList();
            for (int i = 0; i < this.minPoolSize; ++i) {
                this.availableConnections.add(this.createNewConnection());
            }
            this.addShutdownHook(this.availableConnections, this.usedConnections);
            pCon = this.getConnection();
            Statement st = pCon.createStatement();
            st.executeUpdate("CREATE TABLE IF NOT EXISTS TABLES_VERSIONS (TABLE_NAME VARCHAR(64) NOT NULL, VERSION INT NOT NULL)");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS ATTACHMENTS (COLLECTIVITE VARCHAR(15) NOT NULL, PJ_NAME VARCHAR(270) NOT NULL, FILE_NAME VARCHAR(280) NOT NULL, DATA LONGBLOB, INDEX IX_PJ (COLLECTIVITE,PJ_NAME) ) TYPE MYISAM");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS CONFIGS_EXPORT (ID int unsigned NOT NULL auto_increment, DOC_ID varchar(100) NOT NULL, ETAT_ID varchar(100) NOT NULL, OWNER varchar(25) NOT NULL, DATE_CREA datetime NOT NULL, CODE varchar(25) NOT NULL, LIBELLE VARCHAR(200) NOT NULL, CONFIG longblob NOT NULL, PRIMARY KEY (ID, DOC_ID, ETAT_ID))");
            st.close();
            DatabaseMetaData dmd = pCon.getMetaData();
            logger.info((Object)("driver = " + dmd.getDriverName() + " - " + dmd.getDriverVersion()));
            logger.info((Object)("database = " + dmd.getDatabaseProductName() + " - " + dmd.getDatabaseProductVersion()));
            if (logger.isDebugEnabled()) {
                Vector<String> v = new Vector<String>();
                ResultSet rs = pCon.createStatement().executeQuery("SHOW TABLES");
                while (rs.next()) {
                    v.add(rs.getString(1));
                }
                for (String s : v) {
                    ResultSet rs2 = pCon.createStatement().executeQuery("SELECT CONCAT('" + s + "   ',CONV(COUNT(*),10,10)) FROM " + s);
                    if (!rs2.next()) continue;
                    logger.debug((Object)rs2.getString(1));
                }
            }
            if (pCon != null) {
                this.releaseConnection(pCon);
            }
        }
        catch (Throwable t) {
            try {
                logger.error((Object)"in initConnections()", t);
                StringBuilder sb = new StringBuilder();
                sb.append("Impossible de se connecter au serveur Xemelios :\ndatabase.url=").append(this.props.getProperty("database.url"));
                throw new DataConfigurationException(sb.toString(), t);
            }
            catch (Throwable throwable) {
                if (pCon != null) {
                    this.releaseConnection(pCon);
                }
                throw throwable;
            }
        }
    }

    private void addShutdownHook(ArrayList<Connection> available, ArrayList<Connection> used) {
        Runtime.getRuntime().addShutdownHook(new ConnectionFinalizer(available, used));
    }

    public TPersistenceConfig getPersistenceConfig(DocumentModel dm) throws DataConfigurationException {
        TPersistenceConfig pc = super.getPersistenceConfig(dm);
        if (!this.checkedConfigs.contains(pc)) {
            logger.info((Object)("Chargement de la configuration " + dm.getTitre()));
            boolean allOk = true;
            boolean newer = false;
            boolean older = false;
            Connection con = null;
            ArrayList<TTable> tables = new ArrayList<TTable>();
            TDocument spc = pc.getLayer(LAYER_NAME).getDocument(dm.getId());
            try {
                con = this.getConnection();
                int ret = 0;
                ret = MySqlDataLayer.checkTableVersion(spc.getListBcTable(), con);
                allOk &= ret == 0;
                if (ret < 0) {
                    older = true;
                }
                if (ret > 0) {
                    newer = true;
                }
                allOk &= (ret = MySqlDataLayer.checkTableVersion(spc.getRepositoryTable(), con)) == 0;
                if (ret < 0) {
                    older = true;
                }
                if (ret > 0) {
                    newer = true;
                }
                allOk &= (ret = MySqlDataLayer.checkTableVersion(spc.getSpecialKeyTable(), con)) == 0;
                if (ret < 0) {
                    older = true;
                }
                if (ret > 0) {
                    newer = true;
                }
                tables.add(spc.getListBcTable());
                tables.add(spc.getRepositoryTable());
                tables.add(spc.getSpecialKeyTable());
                for (TEtat sec : spc.getEtats()) {
                    ret = MySqlDataLayer.checkTableVersion(sec.getDocumentTable(), con);
                    allOk &= ret == 0;
                    if (ret < 0) {
                        older = true;
                    }
                    if (ret > 0) {
                        newer = true;
                    }
                    tables.add(sec.getDocumentTable());
                    for (TTable table : sec.getIndexTables()) {
                        ret = MySqlDataLayer.checkTableVersion(table, con);
                        allOk &= ret == 0;
                        if (ret < 0) {
                            older = true;
                        }
                        if (ret > 0) {
                            newer = true;
                        }
                        tables.add(table);
                    }
                }
                if (!allOk) {
                    XemeliosUser user = MainWindow.getInstance().getConnectedUser();
                    if (older) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Votre base de donn\u00c3\u00a9e contient des tables dont la version est plus r\u00c3\u00a9cente\nque votre version de Xemelios.\n");
                        msg.append("Il vous faut mettre \u00c3\u00a0 jour votre version de Xemelios avant de pouvoir l'utiliser.");
                        JOptionPane.showMessageDialog((Component)MainWindow.getInstance(), msg.toString(), "Probl\u00c3\u00a8me de configuration", 0);
                        throw new DataConfigurationException("Version de Xemelios trop ancienne");
                    }
                    if (newer) {
                        Statement st = con.createStatement();
                        for (TTable table : tables) {
                            this.updateTableVersion(table, con);
                        }
                        st.close();
                        this.checkedConfigs.add(pc);
                    }
                }
                this.checkedConfigs.add(pc);
            }
            catch (SQLException sqlEx) {
                throw new DataConfigurationException((Throwable)sqlEx);
            }
            finally {
                if (con != null) {
                    this.releaseConnection(con);
                }
            }
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int checkTableVersion(TTable sti, Connection con) {
        if (sti == null) {
            return 0;
        }
        PreparedStatement ps = null;
        int ret = 0;
        try {
            ps = con.prepareStatement("SELECT VERSION FROM TABLES_VERSIONS WHERE TABLE_NAME=?");
            ps.setString(1, sti.getBaseName());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = sti.getVersion() - rs.getInt(1);
            }
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    public String getLastWarnings() {
        return this.warnings.get(Thread.currentThread());
    }

    public void importPj(PJRef pj) throws DataConfigurationException, DataAccessException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection();
            String s = "SELECT 1 FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?";
            ps = con.prepareStatement(s);
            ps.setString(1, pj.getCollectivite());
            ps.setString(2, pj.getPjName());
            rs = ps.executeQuery();
            if (rs.next()) {
                ps.close();
                ps = con.prepareStatement("DELETE FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?");
                ps.setString(1, pj.getCollectivite());
                ps.setString(2, pj.getPjName());
                ps.executeUpdate();
            }
            ps.close();
            ps = con.prepareStatement("INSERT INTO ATTACHMENTS (COLLECTIVITE,PJ_NAME,FILE_NAME,DATA) VALUES (?,?,?,?)");
            ps.setString(1, pj.getCollectivite());
            ps.setString(2, pj.getPjName());
            ps.setString(3, pj.getFileName());
            ps.setBinaryStream(4, pj.getDataInputStream(), (int)pj.getUncompressedSize());
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (Exception ex) {
            throw new DataConfigurationException((Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public PJRef getPj(Pair collectivite, String pjName) throws DataConfigurationException, DataAccessException {
        Connection con = null;
        PJRef pj = null;
        logger.debug((Object)("getting " + pjName + " in " + collectivite.key));
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT FILE_NAME, DATA FROM ATTACHMENTS WHERE COLLECTIVITE=? AND FILE_NAME=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, pjName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pj = new PJRef();
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(2);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                pj.setData(baos.toByteArray());
                pj.setFileName(rs.getString(1));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return pj;
    }

    public PJRef getPjByUniqueId(Pair collectivite, String id) throws DataConfigurationException, DataAccessException {
        Connection con = null;
        PJRef pj = null;
        logger.debug((Object)("getting " + id + " in " + collectivite.key));
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT FILE_NAME, DATA FROM ATTACHMENTS WHERE COLLECTIVITE=? AND PJ_NAME=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pj = new PJRef();
                byte[] buff = new byte[512];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = rs.getAsciiStream(2);
                int length = is.read(buff);
                while (length > 0) {
                    baos.write(buff, 0, length);
                    length = is.read(buff);
                }
                pj.setData(baos.toByteArray());
                pj.setFileName(rs.getString(1));
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        catch (IOException ioEx) {
            throw new DataAccessException((Throwable)ioEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return pj;
    }

    public boolean isPjAvailable(Pair collectivite, String id) throws DataConfigurationException, DataAccessException {
        Connection con = null;
        boolean ret = false;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT 1 FROM ATTACHMENTS WHERE COLLECTIVITE=? AND FILE_NAME=?");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite.key);
            ps.setString(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = true;
            }
            rs.close();
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<String> getDocumentListFromSpecialKeys(ElementModel em, String collectivite, String budget, String sp1, String sp2, String sp3) throws DataConfigurationException, DataAccessException {
        TSqlIndex si;
        String path;
        SpecialKeyModel skm;
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        EtatModel etatModel = em.getParent();
        TDocument pc = this.getPersistenceConfig(etatModel.getParent()).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        sb.append("SELECT DOC_ID FROM ").append(sec.getMaintable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=? ");
        DocumentModel dm = etatModel.getParent();
        Vector specialKeys = dm.getSpecialKeys();
        if (sp1 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 1) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 1 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        if (sp2 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 2) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 2 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        if (sp3 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 3) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 3 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        logger.debug((Object)sb.toString());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite);
            logger.debug((Object)("1->" + collectivite));
            ps.setString(2, budget);
            logger.debug((Object)("2->" + budget));
            if (sp1 != null) {
                ps.setString(3, sp1);
                logger.debug((Object)("3->" + sp1));
            }
            if (sp2 != null) {
                ps.setString(4, sp2);
            }
            if (sp3 != null) {
                ps.setString(5, sp3);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            return ret;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<String> getDocumentListFromXPath(ElementModel em, String collectivite, String budget, String sp1, String sp2, String sp3, String xpath) throws DataConfigurationException, DataAccessException {
        TSqlIndex si;
        String path;
        SpecialKeyModel skm;
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        EtatModel etatModel = em.getParent();
        TDocument pc = this.getPersistenceConfig(etatModel.getParent()).getLayer(LAYER_NAME).getDocument(etatModel.getParent().getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        sb.append("SELECT DOC_ID FROM ").append(sec.getMaintable().getBaseName()).append(" WHERE COLLECTIVITE=? AND BUDGET=? ");
        DocumentModel dm = etatModel.getParent();
        Vector specialKeys = dm.getSpecialKeys();
        if (sp1 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 1) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 1 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        if (sp2 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 2) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 2 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        if (sp3 != null) {
            skm = null;
            for (SpecialKeyModel sk : specialKeys) {
                if (sk.getPos() != 3) continue;
                skm = sk;
            }
            if (skm == null) throw new DataConfigurationException("no special key in pos 3 defined for " + dm.getId());
            path = skm.getPath();
            si = sec.getSqlIndexByPath(path);
            if (!si.getTableId().equals(sec.getMaintable().getId())) throw new DataConfigurationException(path + " is not indexed in " + sec.getMaintable().getBaseName());
            sb.append("AND ").append(si.getColumn()).append("=? ");
        }
        if (xpath != null) {
            String[] conds;
            logger.debug((Object)("xpath is " + xpath));
            if (!xpath.startsWith(em.getPath().getPath())) throw new DataConfigurationException("XPath too complicated. only XPath starting with element path are allowed. Here, XPath should start with " + em.getPath().getPath());
            String shortPath = xpath.substring(em.getPath().getPath().length());
            if (!shortPath.startsWith("[")) {
                throw new DataConfigurationException("XPath too complicated. This implementation can only deal with XPath formed by <path-to-element>[cond on sub-element][cond on sub element]...");
            }
            for (String s : conds = MySqlDataLayer.splitConditions(shortPath)) {
                logger.debug((Object)s);
                s = s.substring(1, s.length() - 1);
                String op = null;
                int pos = -1;
                pos = s.indexOf("<=");
                if (pos >= 0) {
                    op = "<=";
                } else {
                    pos = s.indexOf(">=");
                    if (pos >= 0) {
                        op = ">=";
                    } else {
                        pos = s.indexOf(61);
                        if (pos >= 0) {
                            op = "=";
                        } else {
                            pos = s.indexOf(60);
                            if (pos >= 0) {
                                op = "<";
                            } else {
                                pos = s.indexOf(62);
                                if (pos >= 0) {
                                    op = ">";
                                }
                            }
                        }
                    }
                }
                String left = s.substring(0, pos);
                String right = s.substring(pos + op.length());
                String indexedPath = em.getPath().getPath() + "/" + left;
                logger.debug((Object)(indexedPath + " " + op + " " + right));
                TSqlIndex si2 = sec.getSqlIndexByPath(indexedPath);
                if (si2 == null) throw new DataConfigurationException("path not indexed: " + indexedPath);
                if (!si2.getTableId().equals(sec.getMaintable().getId())) {
                    throw new DataConfigurationException("index " + si2.getId() + " is not on main table of " + sec.getId());
                }
                sb.append("AND ").append(si2.getColumn()).append(op).append(MySqlDataLayer.sqlEscapeString(right)).append(" ");
            }
        }
        logger.debug((Object)sb.toString());
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement(sb.toString());
            ps.setString(1, collectivite);
            logger.debug((Object)("1->" + collectivite));
            ps.setString(2, budget);
            logger.debug((Object)("2->" + budget));
            if (sp1 != null) {
                ps.setString(3, sp1);
                logger.debug((Object)("3->" + sp1));
            }
            if (sp2 != null) {
                ps.setString(4, sp2);
            }
            if (sp3 != null) {
                ps.setString(5, sp3);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            return ret;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    private static String[] splitConditions(String cond) throws DataConfigurationException {
        ArrayList<String> ret = new ArrayList<String>();
        String s = cond;
        while (s.length() > 0 && s.charAt(0) == '[') {
            int end = MySqlDataLayer.findClosingParenthesis(s, 0, "[]");
            ret.add(s.substring(0, end + 1));
            s = s.substring(end + 1);
        }
        String[] aRet = new String[ret.size()];
        ret.toArray(aRet);
        return aRet;
    }

    private static int findClosingParenthesis(String expr, int first, String delimitors) throws DataConfigurationException {
        char OPENNING_DELIM = delimitors.charAt(0);
        char CLOSING_DELIM = delimitors.charAt(1);
        int len = expr.length();
        int close = -1;
        int pCount = 1;
        for (int i = first + 1; i < len; ++i) {
            char c = expr.charAt(i);
            if (c == OPENNING_DELIM) {
                ++pCount;
            } else if (c == CLOSING_DELIM) {
                --pCount;
            }
            if (pCount != 0) continue;
            close = i;
            break;
        }
        if (close == -1) {
            throw new DataConfigurationException("unbalanced delimitor");
        }
        return close;
    }

    public SimpleDateFormat getDateFromatter() {
        return mySqlDateFormat;
    }

    public Pair[] getAggregateOperators(String datatype) {
        ArrayList<Pair> result = new ArrayList<Pair>();
        logger.debug((Object)("Requested aggregate operators for data type " + datatype));
        if (datatype.equals("integer") || datatype.equals("decimal") || datatype.equals("amount")) {
            result.add(new Pair("AVG", "Moyenne"));
            result.add(new Pair("SUM", "Somme"));
            result.add(new Pair("MIN", "Minimum"));
            result.add(new Pair("MAX", "Maximum"));
            result.add(new Pair("STDDEV_POP", "Ecart type"));
            result.add(new Pair("VAR_POP", "Variance"));
        } else if (datatype.equals("date")) {
            result.add(new Pair("SEC_TO_TIME(SUM(TIME_TO_SEC", "Somme"));
            result.add(new Pair("SEC_TO_TIME(AVG(TIME_TO_SEC", "Moyenne"));
        }
        Pair[] aRet = new Pair[result.size()];
        result.toArray(aRet);
        return aRet;
    }

    public String calculateAggregate(DocumentModel dm, EtatModel em, String columnXPath, String operator, ChampModel cm, DataResultSet rs) throws DataConfigurationException, DataAccessException {
        TPersistenceConfig pers = this.getPersistenceConfig(dm);
        TLayer layer = pers.getLayer(this.getLayerName());
        TDocument tdoc = layer.getDocument(dm.getId());
        TEtat tet = tdoc.getEtat(em.getId());
        columnXPath = columnXPath.replaceAll("\\[[0-9]\\]", "");
        logger.debug((Object)columnXPath);
        TSqlIndex tsqlIndex = tet.getSqlIndexByPath(columnXPath);
        if (tsqlIndex == null) {
            throw new DataConfigurationException("Pas d'index sur " + columnXPath);
        }
        String columnName = tsqlIndex.getColumn();
        String tableName = tet.getIndexTable(tsqlIndex.getTableId()).getBaseName();
        if (rs != null) {
            MySqlDataResultSet myRs = (MySqlDataResultSet)rs;
            return myRs.calculateAggregate(tableName + "." + columnName, tableName, operator, cm);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParamTable() {
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            rs = st.executeQuery("SELECT 1 FROM PARAMETERS");
            rs.close();
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() == 1146) {
                try {
                    st.executeUpdate("CREATE TABLE PARAMETERS (PARAM_NAME VARCHAR(100) NOT NULL, PARAM_VALUE VARCHAR(100), UNIQUE INDEX PARAM_IX (PARAM_NAME)) TYPE MYISAM");
                }
                catch (Throwable t) {
                    logger.error((Object)"while creating PARAMETERS", t);
                }
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(String paramName) {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String ret = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("SELECT PARAM_VALUE FROM PARAMETERS WHERE PARAM_NAME=?");
            ps.setString(1, paramName);
            rs = ps.executeQuery();
            if (rs.next()) {
                ret = rs.getString(1);
            }
        }
        catch (SQLException sqlEx) {
            logger.error((Object)"in getParameterValue", (Throwable)sqlEx);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String paramName, String paramValue) {
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection();
            String ret = this.getParameterValue(paramName);
            ps = ret == null ? con.prepareStatement("INSERT INTO PARAMETERS (PARAM_VALUE, PARAM_NAME) VALUES (?, ?)") : con.prepareStatement("UPDATE PARAMETERS SET PARAM_VALUE=? WHERE PARAM_NAME=?");
            ps.setString(1, paramValue);
            ps.setString(2, paramName);
            ps.executeUpdate();
        }
        catch (SQLException sqlEx) {
            logger.error((Object)"in getParameterValue", (Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    private void applyPatches() {
        Object patcher;
        if (this.getParameterValue("paye.patch.3.2.applied") == null) {
            patcher = new PayePatch32(this);
            ((PayePatch32)patcher).run();
        }
        if (this.getParameterValue("versement.patch.3.2.applied") == null) {
            patcher = new VersementPatch32(this);
            ((VersementPatch32)patcher).run();
        }
        if (this.getParameterValue("pesv2.patch.3.3.applied") == null) {
            patcher = new PesAllerPatch33(this);
            ((PesAllerPatch33)patcher).run();
        }
        if (this.getParameterValue("rapport.patch.3.3.applied") == null) {
            patcher = new RapportPatch33(this);
            ((RapportPatch33)patcher).run();
        }
        this.killPatchProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertConfigExport(ConfigModel cm) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("INSERT INTO CONFIGS_EXPORT (DOC_ID,ETAT_ID,OWNER,DATE_CREA,CODE,LIBELLE,CONFIG) VALUES (?,?,?,CURRENT_DATE(),?,?,?)");
            int i = 1;
            ps.setString(i++, cm.getDocID());
            ps.setString(i++, cm.getEtatID());
            ps.setString(i++, cm.getOwner());
            ps.setString(i++, cm.getCode());
            ps.setString(i++, cm.getLibelle());
            byte[] buffer = cm.getConfigLines();
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            ps.setBinaryStream(i++, (InputStream)is, buffer.length);
            ps.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"in insertConfigExport ", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigExport(ConfigModel cm) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("UPDATE CONFIGS_EXPORT set CODE=?, LIBELLE=?, CONFIG=? WHERE ID=? AND DOC_ID=? AND ETAT_ID=?");
            int i = 1;
            ps.setString(i++, cm.getCode());
            ps.setString(i++, cm.getLibelle());
            byte[] buffer = cm.getConfigLines();
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            ps.setBinaryStream(i++, (InputStream)is, buffer.length);
            ps.setString(i++, cm.getId());
            ps.setString(i++, cm.getDocID());
            ps.setString(i++, cm.getEtatID());
            ps.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"in updateConfigExport ", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ConfigModel> getListeConfigsExport(String docID, String etatID) {
        Connection con = null;
        PreparedStatement ps = null;
        Vector<ConfigModel> ret = new Vector<ConfigModel>();
        try {
            con = this.getConnection();
            ps = con.prepareStatement("SELECT ID,DOC_ID,ETAT_ID,OWNER,DATE_CREA,CODE,LIBELLE,CONFIG FROM CONFIGS_EXPORT WHERE DOC_ID=? AND ETAT_ID=? ORDER BY CODE");
            int i = 1;
            ps.setString(i++, docID);
            ps.setString(i++, etatID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ret.add(new ConfigModel(rs));
            }
        }
        catch (Exception e) {
            logger.error((Object)"in getListeConfigsExport ", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigExport(ConfigModel cm) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("DELETE FROM CONFIGS_EXPORT WHERE ID=? AND DOC_ID=? AND ETAT_ID=?");
            int i = 1;
            ps.setString(i++, cm.getId());
            ps.setString(i++, cm.getDocID());
            ps.setString(i++, cm.getEtatID());
            ps.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)"in deleteConfigExport ", (Throwable)e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    public DatabaseTreeDataFichier.Data searchFichiers(DocumentModel dm, String coll, String budg) throws DataAccessException, DataConfigurationException {
        DatabaseTreeDataFichier.Data dD = null;
        TDocument pc = this.getPersistenceConfig(dm).getLayer(LAYER_NAME).getDocument(dm.getId());
        Connection con = null;
        boolean found = false;
        try {
            con = this.getConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT COLLECTIVITE, COLLECTIVITE_LIB, BUDGET, BUDGET_LIB, INITIAL_DOC_NAME FROM ").append(pc.getListBcTable().getBaseName());
            if (coll != null) {
                sb.append(" WHERE COLLECTIVITE=? ");
            }
            if (budg != null) {
                if (coll == null) {
                    sb.append(" WHERE ");
                } else {
                    sb.append(" AND ");
                }
                sb.append(" BUDGET = ? ");
            }
            sb.append(" ORDER BY COLLECTIVITE_LIB, BUDGET_LIB, INITIAL_DOC_NAME");
            PreparedStatement ps = con.prepareStatement(sb.toString());
            int i = 1;
            if (coll != null) {
                ps.setString(i++, coll);
            }
            if (budg != null) {
                ps.setString(i++, budg);
            }
            ResultSet rs = ps.executeQuery();
            String lastColl = "";
            String lastBudg = "";
            while (rs.next()) {
                if (!found) {
                    dD = new DatabaseTreeDataFichier.Data();
                    dD.setKey(dm.getId());
                    dD.setLevel(1);
                    dD.setLibelle(dm.getTitre());
                    dD.setSelected(false);
                }
                found = true;
                String curColl = rs.getString(1);
                String curBudg = rs.getString(3);
                DatabaseTreeDataFichier.Data dF = new DatabaseTreeDataFichier.Data();
                dF.setKey(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3) + "|" + rs.getString(5));
                dF.setLevel(6);
                dF.setLibelle(rs.getString(5));
                dF.setSelected(false);
                DatabaseTreeDataFichier.Data dC = null;
                if (!curColl.equals(lastColl)) {
                    dC = new DatabaseTreeDataFichier.Data();
                    dC.setKey(dm.getId() + "|" + rs.getString(1));
                    dC.setLevel(2);
                    dC.setLibelle(rs.getString(1) + " - " + rs.getString(2));
                    dC.setSelected(false);
                    dD.addChild(dC);
                    lastBudg = "";
                } else {
                    dC = dD.getChild(dm.getId() + "|" + rs.getString(1));
                }
                DatabaseTreeDataFichier.Data dB = null;
                if (!curBudg.equals(lastBudg)) {
                    dB = new DatabaseTreeDataFichier.Data();
                    dB.setKey(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3));
                    dB.setLevel(3);
                    dB.setLibelle(rs.getString(3) + " - " + rs.getString(4));
                    dB.setSelected(false);
                    dC.addChild(dB);
                } else {
                    dB = dC.getChild(dm.getId() + "|" + rs.getString(1) + "|" + rs.getString(3));
                }
                dB.addChild(dF);
                lastBudg = curBudg;
                lastColl = curColl;
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
        return found ? dD : null;
    }

    public Vector<DatabaseTreeDataFichier.Data> searchFichiers(DocumentsModel dms, String coll, String budg) throws DataAccessException, DataConfigurationException {
        Vector<DatabaseTreeDataFichier.Data> ret = new Vector<DatabaseTreeDataFichier.Data>();
        for (DocumentModel doc : dms.getDocuments()) {
            try {
                DatabaseTreeDataFichier.Data tmp = this.searchFichiers(doc, coll, budg);
                if (tmp == null) continue;
                ret.add(tmp);
            }
            catch (DataAccessException dae) {
                if (dae.getMessage().endsWith("doesn't exist")) continue;
                throw dae;
            }
        }
        return ret;
    }

    protected String buildSelectToExport(int whatToExport, ElementModel elementModel, Pair coll, Pair budg, String fic, Pair sk1, Pair sk2) throws DataConfigurationException {
        EtatModel etatModel = elementModel.getParent();
        DocumentModel documentModel = etatModel.getParent();
        TDocument pc = this.getPersistenceConfig(documentModel).getLayer(LAYER_NAME).getDocument(documentModel.getId());
        TEtat sec = pc.getEtat(etatModel.getId());
        TTable mainTable = sec.getMaintable();
        TTable docTable = sec.getDocumentTable();
        StringBuffer sb = new StringBuffer();
        switch (whatToExport) {
            case 3: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" WHERE ").append(docTable.getBaseName()).append(".COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" ");
                break;
            }
            case 4: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" LEFT OUTER JOIN ").append(pc.getSpecialKeyTable().getBaseName()).append(" ON ");
                sb.append(docTable.getBaseName()).append(".INITIAL_DOC_NAME=").append(pc.getSpecialKeyTable().getBaseName()).append(".INITIAL_DOC_NAME ");
                sb.append(" AND ").append(docTable.getBaseName()).append(".COLLECTIVITE=").append(pc.getSpecialKeyTable().getBaseName()).append(".COLLECTIVITE ");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET=").append(pc.getSpecialKeyTable().getBaseName()).append(".BUDGET ");
                sb.append(" WHERE ").append(docTable.getBaseName()).append(".COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY1='").append(StringEscapeUtils.escapeSql((String)sk1.key)).append("'");
                sb.append(" ");
                break;
            }
            case 5: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" LEFT OUTER JOIN ").append(pc.getSpecialKeyTable().getBaseName()).append(" ON ");
                sb.append(docTable.getBaseName()).append(".INITIAL_DOC_NAME=").append(pc.getSpecialKeyTable().getBaseName()).append(".INITIAL_DOC_NAME ");
                sb.append(" AND ").append(docTable.getBaseName()).append(".COLLECTIVITE=").append(pc.getSpecialKeyTable().getBaseName()).append(".COLLECTIVITE ");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET=").append(pc.getSpecialKeyTable().getBaseName()).append(".BUDGET ");
                sb.append(" WHERE ").append(docTable.getBaseName()).append(".COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY1='").append(StringEscapeUtils.escapeSql((String)sk1.key)).append("'");
                sb.append(" AND ").append(pc.getSpecialKeyTable().getBaseName()).append(".KEY2='").append(StringEscapeUtils.escapeSql((String)sk2.key)).append("'");
                sb.append(" ");
                break;
            }
            case 6: {
                sb.append("SELECT ").append(docTable.getBaseName()).append(".DOC_ID FROM ").append(docTable.getBaseName());
                sb.append(" WHERE ").append(docTable.getBaseName()).append(".COLLECTIVITE='").append(StringEscapeUtils.escapeSql((String)coll.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".BUDGET='").append(StringEscapeUtils.escapeSql((String)budg.key)).append("'");
                sb.append(" AND ").append(docTable.getBaseName()).append(".INITIAL_DOC_NAME='").append(StringEscapeUtils.escapeSql((String)fic)).append("'");
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public DataResultSet getDataResultSetForExport(int whatToExport, ElementModel em, Pair coll, Pair budg, String fic, Pair SK1, Pair SK2) throws DataConfigurationException, SQLException {
        String sql = this.buildSelectToExport(whatToExport, em, coll, budg, fic, SK1, SK2);
        ListeResultatModel lrm = em.getListeResultat();
        MySqlDataResultSet drs = new MySqlDataResultSet(em, coll, budg, em.getPath().getPath(), sql, lrm, (MySqlDataLayer)DataLayerManager.getImplementation());
        return drs;
    }

    public Object HSWinitTempStorage(String storageId, String keyId, int maxKeyLength, Vector<Field> fieldList) {
        Class[] classes = null;
        int[] sizes = null;
        String[] names = null;
        if (fieldList != null) {
            classes = new Class[fieldList.size()];
            sizes = new int[fieldList.size()];
            names = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                LongueurMax anno;
                Integer longueurMax;
                Field fld = fieldList.get(i);
                String typeName = fld.getType().toString();
                if (typeName.equals("class java.lang.String")) {
                    longueurMax = 255;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno == null) {
                        throw new RuntimeException("The field " + fld.getName() + " has no annotation @LongueurMax(value = xxx)");
                    }
                    longueurMax = anno.value();
                    classes[i] = String.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Integer.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Float.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                    longueurMax = 10;
                    anno = fld.getAnnotation(LongueurMax.class);
                    if (anno != null) {
                        longueurMax = anno.value();
                    }
                    classes[i] = Float.class;
                    sizes[i] = longueurMax;
                } else if (typeName.equals("class java.util.Date")) {
                    classes[i] = Date.class;
                    sizes[i] = 999;
                }
                names[i] = fld.getName();
            }
        }
        return this.HSWinitTempStorage(storageId, keyId, maxKeyLength, classes, sizes, names);
    }

    public Object HSWinitTempStorage(String storageId, String keyId, int maxKeyLength, Class[] classes, int[] sizes, String[] names) {
        Connection HSWcon = null;
        Hashtable<String, PreparedStatement> reqs = new Hashtable<String, PreparedStatement>();
        StringBuffer sqlCreateBuffer = new StringBuffer();
        StringBuffer sqlInsertBuffer = new StringBuffer();
        StringBuffer sqlInsertValuesBuffer = new StringBuffer();
        StringBuffer sqlSelectBuffer = new StringBuffer();
        StringBuffer sqlExistsBuffer = new StringBuffer();
        StringBuffer sqlCountBuffer = new StringBuffer();
        StringBuffer sqlDeleteBuffer = new StringBuffer();
        StringBuffer sqlDropBuffer = new StringBuffer();
        String virgule = ",";
        sqlCreateBuffer.append("CREATE TEMPORARY TABLE " + storageId + "(\n");
        sqlInsertBuffer.append("INSERT INTO " + storageId + "(\n");
        sqlInsertValuesBuffer.append("VALUES(\n");
        sqlExistsBuffer.append("SELECT COUNT(*) FROM " + storageId + "\n");
        sqlSelectBuffer.append("SELECT \n");
        sqlDeleteBuffer.append("DELETE FROM " + storageId + "\n");
        sqlDropBuffer.append("DROP TABLE " + storageId + "\n");
        sqlCountBuffer.append("SELECT COUNT(*) FROM " + storageId + "\n");
        if (classes != null) {
            sqlCreateBuffer.append(keyId + " VARCHAR(" + maxKeyLength + ") UNIQUE");
            sqlInsertBuffer.append(keyId);
            sqlInsertValuesBuffer.append("?");
            sqlSelectBuffer.append(keyId);
            sqlExistsBuffer.append("WHERE " + keyId + " = ? ");
            sqlDeleteBuffer.append("WHERE " + keyId + " = ? ");
            for (int i = 0; i < classes.length; ++i) {
                Class cls = classes[i];
                Integer longueurMax = sizes[i];
                sqlCreateBuffer.append(virgule);
                sqlCreateBuffer.append("\n");
                sqlCreateBuffer.append(names[i] + " ");
                sqlInsertBuffer.append(virgule);
                sqlInsertBuffer.append("\n");
                sqlInsertBuffer.append(names[i] + " ");
                sqlInsertValuesBuffer.append(virgule);
                sqlInsertValuesBuffer.append("\n");
                sqlInsertValuesBuffer.append("?");
                sqlSelectBuffer.append(virgule);
                sqlSelectBuffer.append("\n");
                sqlSelectBuffer.append(names[i] + " ");
                String typeName = cls.toString();
                if (typeName.equals("class java.lang.String")) {
                    sqlCreateBuffer.append("VARCHAR(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                    sqlCreateBuffer.append("INTEGER(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                    sqlCreateBuffer.append("FLOAT(" + longueurMax.toString() + ")");
                    continue;
                }
                if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                    sqlCreateBuffer.append("DOUBLE(" + longueurMax.toString() + ")");
                    continue;
                }
                if (!typeName.equals("class java.util.Date")) continue;
                sqlCreateBuffer.append("DATE");
            }
            sqlCreateBuffer.append("\n)\n");
            sqlInsertBuffer.append("\n)\n");
            sqlInsertValuesBuffer.append("\n)\n");
            sqlSelectBuffer.append(" FROM " + storageId + " WHERE  " + keyId + " = ? ");
            try {
                HSWcon = this.getConnection();
                reqs.put("Create", HSWcon.prepareStatement(sqlCreateBuffer.toString()));
                reqs.put("Insert", HSWcon.prepareStatement(sqlInsertBuffer.toString() + sqlInsertValuesBuffer.toString()));
                reqs.put("Exists", HSWcon.prepareStatement(sqlExistsBuffer.toString()));
                reqs.put("Select", HSWcon.prepareStatement(sqlSelectBuffer.toString()));
                reqs.put("Delete", HSWcon.prepareStatement(sqlDeleteBuffer.toString()));
                reqs.put("Drop", HSWcon.prepareStatement(sqlDropBuffer.toString()));
                reqs.put("Count", HSWcon.prepareStatement(sqlCountBuffer.toString()));
            }
            catch (SQLException se) {
                logger.error((Object)"init : SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)"init: other exception", (Throwable)e);
            }
        }
        return new HSWStorageHandle(reqs, classes, HSWcon);
    }

    public void HSWdoCreateStorage(Object pStorageHandle) {
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
            try {
                PreparedStatement ps = ht.get("Create");
                ps.executeUpdate();
            }
            catch (SQLException se) {
                logger.error((Object)"Create SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public void HSWdoInsert(Object pStorageHandle, String key, Object[] values) {
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
            try {
                PreparedStatement ps = ht.get("Insert");
                ps.setString(1, key);
                for (int i = 0; i < values.length; ++i) {
                    int j = i + 2;
                    if (values[i] instanceof String) {
                        ps.setString(j, (String)values[i]);
                        continue;
                    }
                    if (values[i] instanceof Integer) {
                        ps.setInt(j, (Integer)values[i]);
                        continue;
                    }
                    if (values[i] instanceof Float) {
                        ps.setFloat(j, ((Float)values[i]).floatValue());
                        continue;
                    }
                    if (!(values[i] instanceof Date)) continue;
                    java.sql.Date sqlDate = new java.sql.Date(((Date)values[i]).getTime());
                    ps.setDate(j, sqlDate);
                }
                ps.executeUpdate();
            }
            catch (SQLException se) {
                logger.error((Object)"doInsert SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public boolean HSWdoExists(Object pStorageHandle, String key) {
        boolean ret = false;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            try {
                int count;
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                PreparedStatement ps = ht.get("Exists");
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next() && (count = rs.getInt(1)) > 0) {
                    ret = true;
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doExists SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public Object[] HSWdoSelect(Object pStorageHandle, String key, Object[] inoutObj) {
        Object[] ret = null;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                Class[] classes = storageHandle.classes;
                PreparedStatement ps = ht.get("Select");
                ps.setString(1, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    for (int i = 0; i < classes.length; ++i) {
                        int j = i + 2;
                        Class cls = classes[i];
                        String typeName = cls.toString();
                        if (typeName.equals("class java.lang.String")) {
                            inoutObj[i] = rs.getString(j);
                            continue;
                        }
                        if (typeName.equals("int") || typeName.equals("class java.lang.Integer")) {
                            inoutObj[i] = rs.getInt(j);
                            continue;
                        }
                        if (typeName.equals("float") || typeName.equals("class java.lang.Float")) {
                            inoutObj[i] = Float.valueOf(rs.getFloat(j));
                            continue;
                        }
                        if (typeName.equals("double") || typeName.equals("class java.lang.Double")) {
                            inoutObj[i] = rs.getDouble(j);
                            continue;
                        }
                        if (!typeName.equals("class java.util.Date")) continue;
                        java.sql.Date sqlDate = rs.getDate(j);
                        inoutObj[i] = sqlDate;
                    }
                    ret = inoutObj;
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doSelect SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public boolean HSWdoDelete(Object pStorageHandle, String key) {
        boolean ret = false;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                PreparedStatement ps = ht.get("Delete");
                ps.setString(1, key);
                ps.executeUpdate();
                ret = true;
            }
            catch (SQLException se) {
                logger.error((Object)"doDelete SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    public int HSWdoCount(Object pStorageHandle) {
        int ret = -1;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                PreparedStatement ps = ht.get("Count");
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    ret = rs.getInt(1);
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doCount SQL Exception:", (Throwable)se);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean HSWdoDrop(Object pStorageHandle) {
        boolean ret = false;
        if (pStorageHandle != null && pStorageHandle instanceof HSWStorageHandle) {
            HSWStorageHandle storageHandle = (HSWStorageHandle)pStorageHandle;
            Connection HSWcon = null;
            try {
                Hashtable<String, PreparedStatement> ht = storageHandle.requetes;
                PreparedStatement ps = ht.get("Drop");
                HSWcon = storageHandle.con;
                ps.executeUpdate();
                if (HSWcon != null) {
                    this.releaseConnection(HSWcon);
                    storageHandle.con = null;
                }
            }
            catch (SQLException se) {
                logger.error((Object)"doDrop : SQL Exception:", (Throwable)se);
                if (HSWcon != null) {
                    this.releaseConnection(HSWcon);
                    storageHandle.con = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                if (HSWcon != null) {
                    this.releaseConnection(HSWcon);
                    storageHandle.con = null;
                }
                {
                    catch (Throwable throwable) {
                        if (HSWcon != null) {
                            this.releaseConnection(HSWcon);
                            storageHandle.con = null;
                        }
                        throw throwable;
                    }
                }
            }
        }
        return ret;
    }

    public boolean isLocalComputerServer() {
        String driver = this.props.getProperty("driver.class");
        if ("com.mysql.embedded.jdbc.MySqlEmbeddedDriver".equals(driver)) {
            return true;
        }
        if ("com.mysql.jdbc.Driver".equals(driver)) {
            int pos;
            String url = this.props.getProperty("database.url");
            url = url.substring(13);
            int pipePos = url.indexOf(58);
            int slashPos = url.indexOf(47);
            if (pipePos < 0) {
                pipePos = 10000;
            }
            if (slashPos < 0) {
                slashPos = 10000;
            }
            if ((pos = Math.min(pipePos, slashPos)) > url.length()) {
                pos = url.length();
            }
            String server = url.substring(0, pos);
            try {
                InetAddress serverAddress = InetAddress.getByName(server);
                InetAddress localAddress = InetAddress.getLocalHost();
                return localAddress.equals(serverAddress);
            }
            catch (UnknownHostException uhEx) {
                logger.error(null, (Throwable)uhEx);
            }
        } else {
            throw new RuntimeException("no support is provided for this driver. Please see MySqlDataLayer.isLocalComputerServer() and provide adapted code.");
        }
        return false;
    }

    public static String sqlEscapeString(String data) {
        StringBuilder ret = new StringBuilder();
        if (data.startsWith("'") && data.endsWith("'")) {
            ret.append("'");
            ret.append(MySqlDataLayer.sqlEscapeString(data.substring(1, data.length() - 1)));
            ret.append("'");
        } else {
            ret.append(data.replaceAll("'", "''"));
        }
        return ret.toString();
    }

    static {
        DataLayerManager.regiterDataImpl((String)LAYER_NAME, MySqlDataLayer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HSWStorageHandle {
        Class[] classes;
        Hashtable<String, PreparedStatement> requetes;
        Connection con;

        HSWStorageHandle(Hashtable<String, PreparedStatement> preqs, Class[] pclasses, Connection con) {
            this.classes = pclasses;
            this.requetes = preqs;
            this.con = con;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionFinalizer
    extends Thread {
        private ArrayList<Connection> v1;
        private ArrayList<Connection> v2;

        public ConnectionFinalizer(ArrayList<Connection> v1, ArrayList<Connection> v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public void run() {
            for (Connection con : this.v1) {
                this.killConnection(con);
            }
            for (Connection con : this.v2) {
                this.killConnection(con);
            }
        }

        private void killConnection(Connection con) {
            try {
                if (con != null && !con.isClosed()) {
                    System.out.println("closing connection");
                    con.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class IndexerHandler
    extends DefaultHandler {
        private TEtat sec = null;
        private Stack<QName> stack = null;
        private String key1 = null;
        private String key2 = null;
        private String key3 = null;
        private String key4 = null;
        private String key5 = null;
        private String key6 = null;
        private String key7 = null;
        private String key8 = null;
        private String key9 = null;
        private String key10 = null;
        private String pathToResetKey1 = null;
        private String pathToResetKey2 = null;
        private String pathToResetKey3 = null;
        private String pathToResetKey4 = null;
        private String pathToResetKey5 = null;
        private String pathToResetKey6 = null;
        private String pathToResetKey7 = null;
        private String pathToResetKey8 = null;
        private String pathToResetKey9 = null;
        private String pathToResetKey10 = null;
        private String collectivite = null;
        private String budget = null;
        private String docId = null;
        private SQLException sqlEx = null;
        private long indexDuration = 0L;
        private Hashtable<TSqlIndex, Object> cachedData = null;
        private Connection con = null;
        private StringBuffer warnings;
        private Stack<StringBuffer> datas = null;
        private NamespaceContext nsCtx = null;

        public long getIndexDuration() {
            return this.indexDuration;
        }

        public void reset() {
            this.indexDuration = 0L;
            if (this.cachedData != null) {
                this.cachedData.clear();
            }
            if (this.stack != null) {
                this.stack.clear();
            }
            this.key1 = null;
            this.key2 = null;
            this.key3 = null;
            this.key4 = null;
            this.key5 = null;
            this.key6 = null;
            this.key7 = null;
            this.key8 = null;
            this.key9 = null;
            this.key10 = null;
            this.pathToResetKey1 = null;
            this.pathToResetKey2 = null;
            this.pathToResetKey3 = null;
            this.pathToResetKey4 = null;
            this.pathToResetKey5 = null;
            this.pathToResetKey6 = null;
            this.pathToResetKey7 = null;
            this.pathToResetKey8 = null;
            this.pathToResetKey9 = null;
            this.pathToResetKey10 = null;
        }

        public IndexerHandler(TEtat sec, String codeBudget, String codeCollectivite, String elementName, Connection con, NamespaceContext nsCtx) throws SQLException {
            this.sec = sec;
            this.stack = new Stack();
            this.collectivite = codeCollectivite;
            this.budget = codeBudget;
            this.docId = elementName;
            this.cachedData = new Hashtable();
            this.con = con;
            this.warnings = new StringBuffer();
            this.datas = new Stack();
            this.nsCtx = nsCtx;
            if (nsCtx == null) {
                throw new IllegalArgumentException("nsCtx can not be null)");
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            QName qname = XmlUtils.getQName((String)uri, (String)localName, (String)qName);
            this.stack.push(qname);
            this.datas.push(new StringBuffer());
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            for (int i = 0; i < attributes.getLength(); ++i) {
                TSqlIndex si;
                String prefix = this.nsCtx.getPrefix(attributes.getURI(i));
                StringBuffer sb = new StringBuffer();
                sb.append(pathTag).append("/@");
                if (prefix != null && prefix.length() > 0) {
                    sb.append(prefix).append(":");
                }
                sb.append(attributes.getLocalName(i));
                String fullPath = sb.toString();
                if (this.sec.getKey1() != null && this.sec.getKey1().getPathes().contains(fullPath)) {
                    this.key1 = attributes.getValue(i);
                    this.pathToResetKey1 = pathTag;
                }
                if (this.sec.getKey2() != null && this.sec.getKey2().getPathes().contains(fullPath)) {
                    this.key2 = attributes.getValue(i);
                    this.pathToResetKey2 = pathTag;
                }
                if (this.sec.getKey3() != null && this.sec.getKey3().getPathes().contains(fullPath)) {
                    this.key3 = attributes.getValue(i);
                    this.pathToResetKey3 = pathTag;
                }
                if (this.sec.getKey4() != null && this.sec.getKey4().getPathes().contains(fullPath)) {
                    this.key4 = attributes.getValue(i);
                    this.pathToResetKey4 = pathTag;
                }
                if (this.sec.getKey5() != null && this.sec.getKey5().getPathes().contains(fullPath)) {
                    this.key5 = attributes.getValue(i);
                    this.pathToResetKey5 = pathTag;
                }
                if (this.sec.getKey6() != null && this.sec.getKey6().getPathes().contains(fullPath)) {
                    this.key6 = attributes.getValue(i);
                    this.pathToResetKey6 = pathTag;
                }
                if (this.sec.getKey7() != null && this.sec.getKey7().getPathes().contains(fullPath)) {
                    this.key7 = attributes.getValue(i);
                    this.pathToResetKey7 = pathTag;
                }
                if (this.sec.getKey8() != null && this.sec.getKey8().getPathes().contains(fullPath)) {
                    this.key8 = attributes.getValue(i);
                    this.pathToResetKey8 = pathTag;
                }
                if (this.sec.getKey9() != null && this.sec.getKey9().getPathes().contains(fullPath)) {
                    this.key9 = attributes.getValue(i);
                    this.pathToResetKey9 = pathTag;
                }
                if (this.sec.getKey10() != null && this.sec.getKey10().getPathes().contains(fullPath)) {
                    this.key10 = attributes.getValue(i);
                    this.pathToResetKey10 = pathTag;
                }
                if ((si = this.sec.getSqlIndexByPath(fullPath)) == null) continue;
                String sValue = attributes.getValue(i);
                Object value = null;
                if ("integer".equals(si.getDatatype())) {
                    try {
                        value = new Integer(Integer.parseInt(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {}
                } else if ("decimal".equals(si.getDatatype())) {
                    try {
                        value = new BigDecimal(sValue.trim());
                    }
                    catch (NumberFormatException ex) {}
                } else if ("float".equals(si.getDatatype())) {
                    try {
                        value = new Float(Float.parseFloat(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {}
                } else if ("date".equals(si.getDatatype())) {
                    try {
                        value = si.getDateValue(sValue.trim());
                    }
                    catch (ParseException ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                } else if ("string".equals(si.getDatatype())) {
                    value = si.getFormattedStringValue(sValue);
                } else if ("boolean".equals(si.getDatatype())) {
                    value = si.getBooleanValue(sValue.trim());
                } else {
                    value = sValue;
                    logger.error((Object)("unknown datatype for index " + si.getId() + ": " + si.getDatatype()));
                }
                if (value == null) continue;
                this.cachedData.put(si, value);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String fullPath;
            TSqlIndex si;
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            if (pathTag.equals(this.pathToResetKey10)) {
                this.pathToResetKey10 = null;
                try {
                    this.writeIndexesOnKey10();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key10 = null;
            }
            if (pathTag.equals(this.pathToResetKey9)) {
                this.pathToResetKey9 = null;
                try {
                    this.writeIndexesOnKey9();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key9 = null;
            }
            if (pathTag.equals(this.pathToResetKey8)) {
                this.pathToResetKey8 = null;
                try {
                    this.writeIndexesOnKey8();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key8 = null;
            }
            if (pathTag.equals(this.pathToResetKey7)) {
                this.pathToResetKey7 = null;
                try {
                    this.writeIndexesOnKey7();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key7 = null;
            }
            if (pathTag.equals(this.pathToResetKey6)) {
                this.pathToResetKey6 = null;
                try {
                    this.writeIndexesOnKey6();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key6 = null;
            }
            if (pathTag.equals(this.pathToResetKey5)) {
                this.pathToResetKey5 = null;
                try {
                    this.writeIndexesOnKey5();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key5 = null;
            }
            if (pathTag.equals(this.pathToResetKey4)) {
                this.pathToResetKey4 = null;
                try {
                    this.writeIndexesOnKey4();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key4 = null;
            }
            if (pathTag.equals(this.pathToResetKey3)) {
                this.pathToResetKey3 = null;
                try {
                    this.writeIndexesOnKey3();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key3 = null;
            }
            if (pathTag.equals(this.pathToResetKey2)) {
                this.pathToResetKey2 = null;
                try {
                    this.writeIndexesOnKey2();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key2 = null;
            }
            if (pathTag.equals(this.pathToResetKey1)) {
                this.pathToResetKey1 = null;
                try {
                    this.writeIndexesOnKey1();
                }
                catch (SQLException sqlEx) {
                    this.sqlEx = sqlEx;
                    sqlEx.printStackTrace();
                    throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
                }
                catch (DataConfigurationException dcEx) {
                    dcEx.printStackTrace();
                    throw new SAXException("DataConfigurationException occurs. See nested exception for details)", this.sqlEx);
                }
                this.key1 = null;
            }
            if ((si = this.sec.getSqlIndexByPath(fullPath = pathTag + "/text()")) != null) {
                String sValue = this.datas.peek().toString();
                Object value = null;
                if ("integer".equals(si.getDatatype())) {
                    try {
                        value = new Integer(Integer.parseInt(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not an integer"));
                    }
                } else if ("decimal".equals(si.getDatatype())) {
                    try {
                        value = new BigDecimal(sValue.trim());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not a decimal"));
                    }
                } else if ("float".equals(si.getDatatype())) {
                    try {
                        value = new Float(Float.parseFloat(sValue.trim()));
                    }
                    catch (NumberFormatException ex) {
                        logger.warn((Object)(sValue + " is not a float"));
                    }
                } else if ("date".equals(si.getDatatype())) {
                    try {
                        value = si.getDateValue(sValue.trim());
                    }
                    catch (ParseException ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                } else if ("string".equals(si.getDatatype())) {
                    value = si.getFormattedStringValue(sValue);
                } else if ("boolean".equals(si.getDatatype())) {
                    String sTmp = sValue.toString();
                    value = "1".equals(si.getBooleanValue(sValue)) ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    value = sValue;
                    logger.error((Object)("unknown datatype for index " + si.getId() + ": " + si.getDatatype()));
                }
                if (value != null) {
                    this.cachedData.put(si, value);
                }
            }
            this.datas.pop();
            this.stack.pop();
        }

        public void endDocument() throws SAXException {
            try {
                this.writeElementBasedIndexes();
                this.cachedData.clear();
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
                this.sqlEx = sqlEx;
                throw new SAXException("SQLException occurs. See nested exception for details)", sqlEx);
            }
            catch (DataConfigurationException dcEx) {
                dcEx.printStackTrace();
                throw new SAXException("DataConfiguration occurs. See nested exception for details", (Exception)((Object)dcEx));
            }
        }

        protected void writeIndexesOnKey1() throws SQLException, DataConfigurationException {
            try {
                this.writeIndexesOnKey("key1");
            }
            catch (SQLException sqlEx) {
                logger.error((Object)sqlEx);
                throw sqlEx;
            }
            catch (DataConfigurationException dcEx) {
                logger.error((Object)dcEx);
                throw dcEx;
            }
        }

        protected void writeIndexesOnKey2() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key2");
        }

        protected void writeIndexesOnKey3() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key3");
        }

        protected void writeIndexesOnKey4() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key4");
        }

        protected void writeIndexesOnKey5() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key5");
        }

        protected void writeIndexesOnKey6() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key6");
        }

        protected void writeIndexesOnKey7() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key7");
        }

        protected void writeIndexesOnKey8() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key8");
        }

        protected void writeIndexesOnKey9() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key9");
        }

        protected void writeIndexesOnKey10() throws SQLException, DataConfigurationException {
            this.writeIndexesOnKey("key10");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeIndexesOnKey(String keyName) throws SQLException, DataConfigurationException {
            TTable elementTable = null;
            for (TTable ti : this.sec.getIndexTables()) {
                if (!keyName.equals(ti.getBasedOn())) continue;
                elementTable = ti;
                break;
            }
            if (elementTable == null) {
                throw new DataConfigurationException("No table to store " + keyName + "indexes was found !");
            }
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(elementTable.getBaseName()).append(" (COLLECTIVITE,BUDGET,DOC_ID,");
            Vector<Object> valuesToWrite = new Vector<Object>();
            Vector<TSqlIndex> indexesToWrite = new Vector<TSqlIndex>();
            Enumeration<TSqlIndex> enumer = this.cachedData.keys();
            while (enumer.hasMoreElements()) {
                TSqlIndex index = enumer.nextElement();
                String tableId = index.getTableId();
                TTable sti = this.sec.getIndexTable(tableId);
                if (sti != elementTable) continue;
                sql.append(index.getColumn()).append(",");
                indexesToWrite.add(index);
                valuesToWrite.add(this.cachedData.get(index));
                this.cachedData.remove(index);
            }
            if (valuesToWrite.size() > 0) {
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") VALUES (?,?,?,");
                for (int i = 0; i < valuesToWrite.size(); ++i) {
                    sql.append("?,");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                PreparedStatement ps = null;
                try {
                    ps = this.con.prepareStatement(sql.toString());
                    ps.setString(1, this.collectivite);
                    ps.setString(2, this.budget);
                    ps.setString(3, this.docId);
                    for (int i = 0; i < valuesToWrite.size(); ++i) {
                        TSqlIndex index = (TSqlIndex)indexesToWrite.elementAt(i);
                        Object value = valuesToWrite.elementAt(i);
                        if ("decimal".equals(index.getDatatype())) {
                            ps.setBigDecimal(i + 4, (BigDecimal)value);
                        } else if ("date".equals(index.getDatatype())) {
                            ps.setDate(i + 4, (java.sql.Date)value);
                        } else if ("float".equals(index.getDatatype())) {
                            ps.setFloat(i + 4, ((Float)value).floatValue());
                        } else if ("integer".equals(index.getDatatype())) {
                            ps.setInt(i + 4, (Integer)value);
                        } else if ("boolean".equals(index.getDatatype())) {
                            ps.setInt(i + 4, "true".equals(value) || "1".equals(value) ? 1 : 0);
                        } else {
                            ps.setString(i + 4, value.toString());
                        }
                        this.cachedData.remove(index);
                    }
                    ps.executeUpdate();
                    for (SQLWarning warn = ps.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        this.warnings.append(warn.getMessage()).append("\n");
                    }
                }
                catch (SQLException sqlEx) {
                    sqlEx.printStackTrace();
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            valuesToWrite.clear();
            indexesToWrite.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeElementBasedIndexes() throws SQLException, DataConfigurationException {
            TTable elementTable = null;
            for (TTable ti : this.sec.getIndexTables()) {
                if (!ti.isMainTable()) continue;
                elementTable = ti;
                break;
            }
            if (elementTable == null) {
                throw new DataConfigurationException("No table to store element indexes was found !");
            }
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(elementTable.getBaseName()).append(" (COLLECTIVITE,BUDGET,DOC_ID,");
            Vector<Object> valuesToWrite = new Vector<Object>();
            Vector<TSqlIndex> indexesToWrite = new Vector<TSqlIndex>();
            Enumeration<TSqlIndex> enumer = this.cachedData.keys();
            while (enumer.hasMoreElements()) {
                TSqlIndex index = enumer.nextElement();
                String tableId = index.getTableId();
                TTable sti = this.sec.getIndexTable(tableId);
                if (sti != elementTable) continue;
                sql.append(index.getColumn()).append(",");
                indexesToWrite.add(index);
                valuesToWrite.add(this.cachedData.get(index));
                this.cachedData.remove(index);
            }
            if (valuesToWrite.size() > 0) {
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") VALUES (?,?,?,");
                for (int i = 0; i < valuesToWrite.size(); ++i) {
                    sql.append("?,");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                PreparedStatement ps = null;
                try {
                    ps = this.con.prepareStatement(sql.toString());
                    ps.setString(1, this.collectivite);
                    ps.setString(2, this.budget);
                    ps.setString(3, this.docId);
                    for (int i = 0; i < valuesToWrite.size(); ++i) {
                        TSqlIndex index = (TSqlIndex)indexesToWrite.elementAt(i);
                        Object value = valuesToWrite.elementAt(i);
                        if ("decimal".equals(index.getDatatype())) {
                            ps.setBigDecimal(i + 4, (BigDecimal)value);
                            continue;
                        }
                        if ("date".equals(index.getDatatype())) {
                            ps.setDate(i + 4, (java.sql.Date)value);
                            continue;
                        }
                        if ("float".equals(index.getDatatype())) {
                            ps.setFloat(i + 4, ((Float)value).floatValue());
                            continue;
                        }
                        if ("integer".equals(index.getDatatype())) {
                            ps.setInt(i + 4, (Integer)value);
                            continue;
                        }
                        ps.setString(i + 4, value.toString());
                    }
                    ps.executeUpdate();
                    for (SQLWarning warn = ps.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        this.warnings.append(warn.getMessage()).append("\n");
                    }
                }
                catch (SQLException sqlEx) {
                    sqlEx.printStackTrace();
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            valuesToWrite.clear();
            indexesToWrite.clear();
        }

        public Exception getException() {
            return this.sqlEx;
        }

        protected void finalize() throws Throwable {
            this.reset();
            super.finalize();
        }

        public String getWarnings() {
            if (this.warnings.length() > 0) {
                return this.warnings.toString();
            }
            return null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            StringBuffer sb = this.datas.peek();
            sb.append(ch, start, length);
        }
    }
}

