/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.basic.mysql;

import fr.gouv.finances.cp.xemelios.Splash;
import fr.gouv.finances.cp.xemelios.auth.AbstractAuthenticationManager;
import fr.gouv.finances.cp.xemelios.auth.AuthChecker;
import fr.gouv.finances.cp.xemelios.auth.AuthProvider;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationCancelationException;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationConfigurationException;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.auth.basic.AskPassword;
import fr.gouv.finances.cp.xemelios.auth.basic.BasicUser;
import fr.gouv.finances.cp.xemelios.auth.basic.NewPassword;
import fr.gouv.finances.cp.xemelios.common.Crypter;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFrame;

public class Manager
extends AbstractAuthenticationManager
implements AuthChecker {
    private AuthProvider provider;

    public Manager(MainWindow mw) throws AuthenticationConfigurationException, AuthenticationCancelationException {
        block17: {
            this.provider = null;
            this.setMainWindow(mw);
            try {
                if (!(DataLayerManager.getImplementation() instanceof MySqlDataLayer)) {
                    throw new AuthenticationConfigurationException(this.getAuthenticationManagerName() + " can run only with mysql data layer");
                }
                Connection con = null;
                MySqlDataLayer dataLayer = null;
                Statement ps = null;
                try {
                    int size;
                    dataLayer = (MySqlDataLayer)DataLayerManager.getImplementation();
                    con = dataLayer.getConnection();
                    String sql = "CREATE TABLE IF NOT EXISTS BASIC_USERS (LOGIN VARCHAR(24) NOT NULL, PASSWORD VARCHAR(128) NOT NULL, ACCESS INT)";
                    con.createStatement().executeUpdate(sql);
                    ResultSet rs = con.createStatement().executeQuery("SELECT COUNT(*) FROM BASIC_USERS");
                    if (!rs.next() || (size = rs.getInt(1)) != 0) break block17;
                    if (this.getMainWindow().getStartListener() instanceof Splash) {
                        Splash splash = (Splash)this.getMainWindow().getStartListener();
                        splash.setAlwaysOnTop(false);
                        splash.setVisible(false);
                    }
                    NewPassword np = new NewPassword((JFrame)this.getMainWindow());
                    boolean bRet = np.run();
                    if (this.getMainWindow().getStartListener() instanceof Splash) {
                        Splash splash = (Splash)this.getMainWindow().getStartListener();
                        splash.setVisible(true);
                        splash.setAlwaysOnTop(true);
                    }
                    if (bRet) {
                        String[] passwords = np.getNewPassword();
                        sql = "INSERT INTO BASIC_USERS(LOGIN,PASSWORD,ACCESS) VALUES (?,?,?)";
                        ps = con.prepareStatement(sql);
                        ps.setString(1, "anonymous");
                        ps.setString(2, Crypter.cryptPassword((String)passwords[1]));
                        ps.setInt(3, 113);
                        ps.executeUpdate();
                        ps.setString(1, "admin");
                        ps.setString(2, Crypter.cryptPassword((String)passwords[0]));
                        ps.setInt(3, 119);
                        ps.executeUpdate();
                        break block17;
                    }
                    throw new AuthenticationCancelationException("Action interrompue");
                }
                catch (SQLException sqlEx) {
                    throw new AuthenticationConfigurationException((Throwable)sqlEx);
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {}
                    }
                    if (con != null) {
                        dataLayer.releaseConnection(con);
                    }
                }
            }
            catch (DataConfigurationException dataConfigurationException) {
                // empty catch block
            }
        }
    }

    public AuthChecker getChecker() {
        return this;
    }

    public AuthProvider getProvider() {
        if (this.provider == null) {
            this.provider = new AskPassword((JFrame)this.getMainWindow());
        }
        return this.provider;
    }

    public String getAuthenticationManagerName() {
        return "MySql-based basic authenticator";
    }

    public boolean authenticate(XemeliosUser user) throws DataAccessException, AuthenticationConfigurationException {
        BasicUser bu = null;
        if (!(user instanceof BasicUser)) {
            throw new AuthenticationConfigurationException("can only authenticate BasicUser");
        }
        bu = (BasicUser)user;
        Connection con = null;
        MySqlDataLayer dataLayer = null;
        Statement ps = null;
        try {
            dataLayer = (MySqlDataLayer)DataLayerManager.getImplementation();
            con = dataLayer.getConnection();
            String sql = "SELECT LOGIN,ACCESS FROM BASIC_USERS WHERE PASSWORD=?";
            ps = con.prepareStatement(sql);
            ps.setString(1, bu.getCryptedPassword());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                bu.setId(rs.getString(1));
                bu.setAuth(rs.getInt(2));
                rs.close();
            }
        }
        catch (DataConfigurationException dcEx) {
            throw new AuthenticationConfigurationException((Throwable)dcEx);
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                dataLayer.releaseConnection(con);
            }
        }
        return user.isAllowedTo(null, 1);
    }
}

