/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.erar.plugins;

import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.impl.mysql.MySqlDataResultSetDocGenerator;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.PropertyModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig.TEtat;
import fr.gouv.finances.dgfip.xemelios.plugins.SearchPlugin;
import java.io.File;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class TotalisationDebiteur
extends SearchPlugin {
    private static final Logger logger = Logger.getLogger(TotalisationDebiteur.class);
    private TDocument pc = null;
    MySqlDataLayer layer;
    private TEtat ec = null;
    private String CRLF = "\n";
    private String request;
    private DecimalFormat df;

    public TotalisationDebiteur(XemeliosUser user) {
        super(user);
        try {
            this.layer = (MySqlDataLayer)DataLayerManager.getImplementation();
        }
        catch (Exception ex) {
            logger.error((Object)"<init>", (Throwable)ex);
        }
    }

    protected static String unnull(String s) {
        return s != null ? s : "";
    }

    public void computeParameters() throws Exception {
        this.pc = this.layer.getPersistenceConfig(this.getDocumentModel(), this.getUser()).getLayer("mysql").getDocument(this.getDocumentModel().getId());
        this.ec = this.pc.getEtat(this.getEtatModel().getId());
        for (PropertyModel pm : this.getPluginModel().getProperties()) {
            if (!"request".equals(pm.getName())) continue;
            this.request = pm.getValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getParameterizedRequest(String rq) throws DataConfigurationException {
        String data = rq;
        int posParam = data.indexOf("${");
        while (posParam >= 0) {
            int posEnd = data.indexOf(125, posParam);
            if (posEnd < 0) {
                throw new DataConfigurationException("Invalid request: " + rq);
            }
            String paramName = data.substring(posParam + 2, posEnd);
            String paramValue = null;
            if (paramName.startsWith("table-")) {
                String typeTable = paramName.substring(6);
                if (!typeTable.startsWith("index-")) throw new DataConfigurationException("can only deal with index tables: ${" + paramName + "}");
                String indexId = typeTable.substring(6);
                paramValue = this.ec.getIndexTable(indexId).getBaseName();
            } else if (paramName.equals("collectivite")) {
                paramValue = this.getCollectivite().key;
            } else {
                if (!paramName.equals("budget")) throw new DataConfigurationException("can only deal with tables parameters: ${" + paramName + "}");
                paramValue = this.getBudget().key;
            }
            if (paramValue == null) {
                throw new DataConfigurationException("no value found for param ${" + paramName + "}");
            }
            data = data.replaceAll("\\$\\{" + paramName + "\\}", paramValue);
            posParam = data.indexOf("${");
        }
        int pos = data.indexOf("##");
        while (pos >= 0) {
            int endPos = data.indexOf("##", pos + 2);
            if (endPos < 0) {
                throw new DataConfigurationException("invalid expression near " + data.substring(pos));
            }
            String pattern = data.substring(pos, endPos + 2);
            String paramName = pattern.substring(2, pattern.length() - 2);
            String paramValue = (String)this.getParameters().get(paramName);
            data = paramValue != null ? data.replace(pattern, paramValue) : data.replace(pattern, "\"\"");
            pos = data.indexOf("##");
        }
        return data;
    }

    public DataResultSet getResultSet() throws Exception {
        try {
            String rq = this.getParameterizedRequest(this.request);
            String xslFileName = this.getElementModel().getParent().getParent().getParameters().getParameter("xsl.doc.generator").getValue();
            File xslFile = new File(new File(this.getElementModel().getParent().getParent().getBaseDirectory()), xslFileName);
            return new MySqlDataResultSetDocGenerator(this.getElementModel(), this.getCollectivite(), this.getBudget(), this.getElementModel().getPath().getPath(), rq, this.getListeResultat(), this.layer, xslFile);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return this.layer.getEmptyDataResultSet();
        }
    }
}

