/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.utils;

import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.utils.HashSwapAttributesPicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashSwapPersister<T> {
    private HashSwapAttributesPicker<T> picker;
    private String storageId;
    private String keyId;
    private Boolean storageCreated = false;
    DataImpl myDataImpl;
    private Object persistHandle;

    HashSwapPersister(HashSwapAttributesPicker<T> p) {
        this.picker = p;
        this.init();
    }

    void init() {
        int lower = 1;
        int higher = 1000;
        Integer random = (int)(Math.random() * (double)(higher - lower)) + lower;
        Long now = System.currentTimeMillis();
        this.storageId = "hsw_" + now.toString() + "_" + random.toString();
        this.keyId = this.storageId + "_k";
        try {
            this.myDataImpl = DataLayerManager.getImplementation();
        }
        catch (DataConfigurationException e) {
            e.printStackTrace();
            return;
        }
        this.persistHandle = this.myDataImpl.HSWinitTempStorage(this.storageId, this.keyId, 100, this.picker.allFields);
    }

    private void ensureStorageCreated() {
        if (!this.storageCreated.booleanValue()) {
            this.myDataImpl.HSWdoCreateStorage(this.persistHandle);
            this.storageCreated = true;
        }
    }

    void storeAt(String k, T value) {
        Object[] attValues;
        this.ensureStorageCreated();
        try {
            attValues = this.picker.getAttributesValues(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.myDataImpl.HSWdoInsert(this.persistHandle, k, attValues);
    }

    boolean exists(String key) {
        if (!this.storageCreated.booleanValue()) {
            return false;
        }
        return this.myDataImpl.HSWdoExists(this.persistHandle, key);
    }

    boolean delete(String key) {
        if (!this.storageCreated.booleanValue()) {
            return false;
        }
        return this.myDataImpl.HSWdoDelete(this.persistHandle, key);
    }

    Object[] getValues(String key) {
        if (!this.storageCreated.booleanValue()) {
            return null;
        }
        Object[] dummyValues = new Object[this.picker.allFields.size()];
        return this.myDataImpl.HSWdoSelect(this.persistHandle, key, dummyValues);
    }

    T readFromStorage(String key) throws Exception {
        Object[] values = this.getValues(key);
        if (values != null) {
            T result = this.picker.instantiateWithValues(values);
            return result;
        }
        return null;
    }

    T fillFromStorage(String key, T objToFill) throws Exception {
        Object[] values = this.getValues(key);
        if (values != null && objToFill != null) {
            return this.picker.fillFieldsOfObject(objToFill, values);
        }
        return null;
    }

    int size() throws Exception {
        if (!this.storageCreated.booleanValue()) {
            return 0;
        }
        return this.myDataImpl.HSWdoCount(this.persistHandle);
    }

    void destruct() throws Exception {
        if (this.storageCreated.booleanValue()) {
            this.myDataImpl.HSWdoDrop(this.persistHandle);
        }
        this.storageCreated = false;
    }

    protected void finalize() throws Throwable {
        this.destruct();
        super.finalize();
    }
}

