/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;

public class CSVWriter {
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ';';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";
    private static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy");

    public CSVWriter(Writer writer) {
        this(writer, ';');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeNext(String[] nextLine, Integer maxInd) {
        if (nextLine == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i <= maxInd; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            if (this.quotechar != '\u0000') {
                sb.append(this.quotechar);
            }
            for (int j = 0; j < nextElement.length(); ++j) {
                char nextChar = nextElement.charAt(j);
                if (this.escapechar != '\u0000' && nextChar == this.quotechar) {
                    sb.append(this.escapechar).append(nextChar);
                    continue;
                }
                if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                    sb.append(this.escapechar).append(nextChar);
                    continue;
                }
                sb.append(nextChar);
            }
            if (this.quotechar == '\u0000') continue;
            sb.append(this.quotechar);
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    public void close() throws IOException {
        this.pw.flush();
        this.pw.close();
        this.rawWriter.close();
    }
}

