/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.importers;

import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.importers.AbstractImportPatcherImpl;
import fr.gouv.finances.dgfip.xemelios.importers.EtatImporteur;
import fr.gouv.finances.dgfip.xemelios.importers.ImportServiceProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XemeliosArchiveImporter {
    private static final Logger logger = Logger.getLogger(XemeliosArchiveImporter.class);
    public static final transient String MANIFEST_FILENAME = "manifeste_XeMeLios.xml";
    private DocumentsModel documentsModel;
    private File archiveFirstFile;
    private Document manifest;
    Archive arch;
    private XemeliosUser user = null;
    private ImportServiceProvider isp;
    private FileInfo fileInfo = null;
    private ArrayList<File> filesToDrop;
    private ArrayList<File> directoriesToDrop;

    public XemeliosArchiveImporter(DocumentsModel dms, File fToImport, ImportServiceProvider isp) {
        this.documentsModel = dms;
        this.archiveFirstFile = fToImport;
        this.isp = isp;
        this.fileInfo = new FileInfo();
        this.filesToDrop = new ArrayList();
        this.directoriesToDrop = new ArrayList();
    }

    public void setUser(XemeliosUser user) {
        this.user = user;
    }

    public XemeliosUser getUser() {
        if (this.user == null) {
            this.user = new XemeliosUser(){

                public String getId() {
                    return "authorized importer";
                }

                public String getDisplayName() {
                    return this.getId();
                }

                public boolean hasRole(String role) {
                    return true;
                }

                public boolean hasDocument(String document) {
                    return true;
                }

                public boolean hasCollectivite(String collectivite, DocumentModel dm) {
                    return true;
                }
            };
        }
        return this.user;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Errors doImport() {
        Errors errors = this.checkArchive();
        if (errors.containsError()) {
            return errors;
        }
        File directory = this.archiveFirstFile.getParentFile();
        for (Volume volume : this.arch.volumes) {
            File volumeFile = new File(directory, volume.fileName);
            try {
                ZipFile zf = new ZipFile(volumeFile);
                ZipEntry ze = zf.getEntry(MANIFEST_FILENAME);
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                this.manifest = builder.parse(zf.getInputStream(ze));
                XPathFactoryImpl xpf = new XPathFactoryImpl();
                XPath xp = xpf.newXPath();
                Double fCount = (Double)xp.evaluate("count(//document[@volume=" + volume.num + "] | //action)", this.manifest, XPathConstants.NUMBER);
                this.isp.displayProgress(fCount.intValue());
                Object o = xp.evaluate("//document[@volume=" + volume.num + "] | //action", this.manifest, XPathConstants.NODESET);
                if (o instanceof NodeList) {
                    NodeList nl = (NodeList)o;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element document = (Element)nl.item(i);
                        this.doImportDocument(zf, document);
                    }
                    continue;
                }
                if (!(o instanceof List)) continue;
                for (Element document : (List)o) {
                    if (document.getNodeName().equals("action")) {
                        this.doApplyAction(zf, document, (XPathFactory)xpf);
                        continue;
                    }
                    this.doImportDocument(zf, document);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                if (!(ex instanceof ZipException)) continue;
                String msg = "Cette archive a probablement \u00e9t\u00e9 renomm\u00e9e.\nSon nom d'orgine devait \u00eatre \n\t" + volume.fileName + "\nElle ne peut \u00eatre import\u00e9e que si elle porte ce nom.";
                boolean previousValue = this.isp.shouldDisplayFeedback();
                errors.addError(3, msg);
            }
            finally {
                this.cleanTempFiles();
            }
        }
        return errors;
    }

    protected void doImportDocument(ZipFile zf, Element document) throws IOException {
        String filePath = document.getAttribute("path");
        String type = document.getAttribute("type");
        String idColl = document.getAttribute("buIdCol");
        String libColl = document.getAttribute("buLibelle");
        String idBudg = document.getAttribute("buCode");
        String libBudg = "Budget Principal";
        String sTmp = document.getAttribute("libBudget");
        if (sTmp != null && sTmp.length() > 0) {
            libBudg = sTmp;
        }
        String codic = document.getAttribute("buCodic");
        String codColl = document.getAttribute("buCodeCol");
        String nomOrigine = document.getAttribute("nomOrigine");
        String idUnique = document.getAttribute("idUnique");
        Object docId = null;
        docId = "CGE".equals(type) ? "compteGestion" : ("CGETAT".equals(type) ? "compteGestionEtat" : ("PES".equals(type) ? "PES_Aller" : ("PJ".equals(type) ? null : ("ERTN".equals(type) ? "ertn" : ("EDMN".equals(type) ? "edmn" : type)))));
        String skipProperty = null;
        if (document.getAttribute("skip-if-exists") != null && document.getAttribute("skip-if-exists").length() > 0) {
            skipProperty = document.getAttribute("skip-if-exists");
        }
        if (skipProperty != null && "true".equals(System.getProperty(skipProperty))) {
            logger.info((Object)("skipping " + filePath + " because " + skipProperty + " exists."));
            return;
        }
        String overwriteRule = "default";
        if (document.getAttribute("default-overwrite") != null && document.getAttribute("default-overwrite").length() > 0) {
            overwriteRule = document.getAttribute("default-overwrite");
        }
        Pair coll = new Pair(idColl, libColl);
        Pair budg = new Pair(idBudg, libBudg);
        if (docId != null) {
            this.doImportXmlDocument((String)docId, zf, filePath, coll, budg, overwriteRule);
        } else {
            this.doImportPJ(zf, filePath, coll, nomOrigine, idUnique, overwriteRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportXmlDocument(String docId, ZipFile zf, String filePath, Pair collectivite, Pair budget, String overwriteRule) throws IOException {
        File source = this.extractFileFromZip(zf, filePath);
        DocumentModel dm = this.documentsModel.getDocumentById(docId);
        try {
            Class<?> clazz = Class.forName(dm.getImportClass());
            Constructor<?> cc = clazz.getConstructor(XemeliosUser.class);
            Object obj = cc.newInstance(this.getUser());
            if (!(obj instanceof EtatImporteur)) {
                throw new DataConfigurationException("Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.");
            }
            EtatImporteur ei = (EtatImporteur)((Object)obj);
            ei.setImpSvcProvider(this.isp);
            ei.setOverwriteRule(overwriteRule);
            this.isp.setEtatImporter(ei);
            this.isp.setCollectivite(collectivite);
            this.isp.setBudget(budget);
            ei.setDocument(dm);
            File[] fichiers = new File[]{source};
            ei.setFilesToImport(fichiers);
            ei.run();
            this.fileInfo.merge(ei.getFileInfo());
        }
        catch (Exception ex) {
            logger.error((Object)"importer", (Throwable)ex);
        }
        finally {
            if (source.exists()) {
                source.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportPJ(ZipFile zf, String filePath, Pair collectivite, String nomOrigine, String idUnique, String overwriteRule) throws IOException {
        File f = this.extractFileFromZip(zf, filePath);
        try {
            DataImpl impl = DataLayerManager.getImplementation();
            PJRef pj = new PJRef();
            pj.setCollectivite(collectivite.key);
            pj.setFileName(nomOrigine);
            pj.setPjName(idUnique);
            pj.setUncompressedSize(f.length());
            pj.setTmpFileName(f.getAbsolutePath());
            impl.importPj(pj, this.getUser());
        }
        catch (Exception ex) {
            logger.error((Object)"doImportPJ(ZipFile,String,Pair,Pair,String,String)", (Throwable)ex);
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    protected void doApplyAction(ZipFile zf, Element action, XPathFactory xpf) throws XPathExpressionException, IOException, Exception {
        String className = action.getAttribute("class");
        Class<?> clazz = Class.forName(className);
        Object instance = clazz.newInstance();
        if (!(instance instanceof AbstractImportPatcherImpl)) {
            throw new Exception(className + " n'est pas un AbstractImportPatcherImpl");
        }
        AbstractImportPatcherImpl patcher = (AbstractImportPatcherImpl)instance;
        XPath xp = xpf.newXPath();
        Object o = xp.evaluate("parameter", action, XPathConstants.NODESET);
        if (!(o instanceof NodeList) && o instanceof List) {
            for (Element param : (List)o) {
                String value;
                String paramName = param.getAttribute("name");
                String type = param.getAttribute("type");
                if ("java.io.File".equals(type)) {
                    value = (String)xp.evaluate("./text()", param, XPathConstants.STRING);
                    ZipEntry ze = zf.getEntry(value);
                    File f = this.extractFileFromZip(zf, value);
                    if (f == null) continue;
                    this.filesToDrop.add(f);
                    patcher.setParameter(paramName, f);
                    continue;
                }
                if ("java.lang.String".equals(type)) {
                    value = param.getAttribute("value");
                    if (value == null) {
                        value = (String)xp.evaluate("./text()", param, XPathConstants.STRING);
                    }
                    patcher.setParameter(paramName, value);
                    continue;
                }
                if (!"java.lang.Integer".equals(type)) continue;
                value = param.getAttribute("value");
                if (value == null) {
                    value = (String)xp.evaluate("./text()", param, XPathConstants.STRING);
                }
                patcher.setParameter(paramName, Integer.valueOf(value));
            }
            patcher.setImportServiceProvider(this.isp);
            FileInfo info = patcher.run();
            this.fileInfo.merge(info);
        }
    }

    protected File extractFileFromZip(ZipFile zf, String filePath) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        ZipEntry ze = zf.getEntry(filePath);
        File ret = new File(tmpDir, filePath);
        File parent = ret.getParentFile();
        parent.mkdirs();
        InputStream is = zf.getInputStream(ze);
        FileOutputStream fos = new FileOutputStream(ret);
        byte[] buffer = new byte[1024];
        int read = is.read(buffer);
        do {
            if (read <= 0) continue;
            ((OutputStream)fos).write(buffer, 0, read);
        } while ((read = is.read(buffer)) > 0);
        fos.flush();
        ((OutputStream)fos).close();
        this.filesToDrop.add(ret);
        while (!parent.equals(tmpDir)) {
            this.directoriesToDrop.add(parent);
            parent = parent.getParentFile();
        }
        return ret;
    }

    public Errors checkArchive() {
        Errors errors;
        block13: {
            errors = new Errors();
            if (!this.archiveFirstFile.exists()) {
                errors.addError(3, "Le fichier est introuvable");
            } else {
                try {
                    ZipFile zf = new ZipFile(this.archiveFirstFile, 1);
                    ZipEntry ze = zf.getEntry(MANIFEST_FILENAME);
                    if (ze == null) {
                        errors.addError(3, "Manifest (manifeste_XeMeLios.xml) non trouv\u00e9 dans l'archive");
                        break block13;
                    }
                    DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = domFactory.newDocumentBuilder();
                    this.manifest = builder.parse(zf.getInputStream(ze));
                    XPathFactory xpf = XPathFactory.newInstance();
                    XPath xp = xpf.newXPath();
                    Object o = xp.evaluate("//volume", this.manifest, XPathConstants.NODESET);
                    TreeSet<Volume> volumes = new TreeSet<Volume>();
                    if (o instanceof NodeList) {
                        NodeList nl = (NodeList)o;
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Element volume = (Element)nl.item(i);
                            volumes.add(new Volume(volume));
                        }
                    } else if (o instanceof List) {
                        for (Element volume : (List)o) {
                            volumes.add(new Volume(volume));
                        }
                    }
                    int thisArchiveNum = 0;
                    for (Volume v : volumes) {
                        if (!v.fileName.equals(this.archiveFirstFile.getName())) continue;
                        thisArchiveNum = v.num;
                        break;
                    }
                    this.arch = new Archive();
                    this.arch.setVolumes(volumes);
                    File directory = this.archiveFirstFile.getParentFile();
                    for (Volume v : volumes) {
                        File archive;
                        if (v.num == 1 || (archive = new File(directory, v.fileName)).exists()) continue;
                        this.arch.removeVolume(v);
                        if (thisArchiveNum != 1) continue;
                        errors.addError(2, v.fileName + " introuvable");
                    }
                }
                catch (ZipException zEx) {
                    errors.addError(3, this.archiveFirstFile.getName() + " : archive zip corrompue.");
                    logger.info((Object)"archive zip corrompue:", (Throwable)zEx);
                }
                catch (Exception ex) {
                    errors.addError(3, ex.getMessage());
                }
            }
        }
        return errors;
    }

    protected void cleanTempFiles() {
        for (File f : this.filesToDrop) {
            f.delete();
        }
        for (File f : this.directoriesToDrop) {
            f.delete();
        }
        this.filesToDrop = new ArrayList();
        this.directoriesToDrop = new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Archive {
        TreeSet<Volume> volumes = new TreeSet();

        public void setVolumes(Set<Volume> vols) {
            this.volumes.addAll(vols);
        }

        public void removeVolume(Volume vol) {
            this.volumes.remove(vol);
        }
    }

    private class Volume
    implements Comparable {
        String fileName;
        int num = 0;

        public Volume(Element el) {
            this.fileName = el.getAttribute("fichier");
            String str = el.getAttribute("num");
            try {
                this.num = Integer.parseInt(str);
            }
            catch (NumberFormatException nfEx) {
                // empty catch block
            }
        }

        public int compareTo(Object o) {
            if (o instanceof Volume) {
                return this.num - ((Volume)o).num;
            }
            return 1;
        }
    }

    public static class Error {
        private int severity = 0;
        private String message;

        public Error(int severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public String getSeverityMessage() {
            switch (this.severity) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Information";
                }
                case 2: {
                    return "Warning";
                }
                case 3: {
                    return "Erreur";
                }
            }
            return null;
        }

        public int getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Errors {
        public static final int SEVERITY_NONE = 0;
        public static final int SEVERITY_INFO = 1;
        public static final int SEVERITY_WARNING = 2;
        public static final int SEVERITY_ERROR = 3;
        private List<Error> errors = new ArrayList<Error>();
        private int maxSeverity = 0;

        private Errors() {
        }

        public void addError(int severity, String message) {
            if (severity > this.maxSeverity) {
                this.maxSeverity = severity;
            }
            this.errors.add(new Error(severity, message));
        }

        public boolean containsError() {
            return this.maxSeverity == 3;
        }

        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

