/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.export;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.dgfip.utils.Base64;
import fr.gouv.finances.dgfip.xemelios.export.ConfigParser;
import fr.gouv.finances.dgfip.xemelios.export.ExportModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigModel
implements XmlMarshallable {
    public static String TAG = "ConfigModel";
    public static final transient QName QN = new QName(TAG);
    private Logger logger = Logger.getLogger(ConfigModel.class);
    private String id;
    private String docID;
    private String etatID;
    private String owner;
    private String dateCreation;
    private String code;
    private String libelle;
    private byte[] configLines;
    private StringBuffer base64Buffer = new StringBuffer();

    public ConfigModel(QName tagName) {
    }

    public ConfigModel(ResultSet rs) throws SQLException {
        int i = 1;
        this.setId(rs.getString(i++));
        this.setDocID(rs.getString(i++));
        this.setEtatID(rs.getString(i++));
        this.setOwner(rs.getString(i++));
        Date dTmp = rs.getDate(i++);
        SimpleDateFormat sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
        this.setDateCreation(sdf.format(dTmp));
        this.setCode(rs.getString(i++));
        this.setLibelle(rs.getString(i++));
        try {
            byte[] buff = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = rs.getAsciiStream(i++);
            int length = is.read(buff);
            while (length > 0) {
                baos.write(buff, 0, length);
                length = is.read(buff);
            }
            this.setConfigLines(baos.toByteArray());
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Erreur lors de la lecture de la configuration", (Throwable)ioe);
        }
    }

    public void addCharacterData(String cData) throws SAXException {
        this.base64Buffer.append(cData);
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.docID = attributes.getValue("docID") != null ? attributes.getValue("docID") : this.docID;
        this.etatID = attributes.getValue("etatID") != null ? attributes.getValue("etatID") : this.etatID;
        this.owner = attributes.getValue("owner") != null ? attributes.getValue("owner") : this.owner;
        this.dateCreation = attributes.getValue("dateCreation") != null ? attributes.getValue("dateCreation") : this.dateCreation;
        this.code = attributes.getValue("code") != null ? attributes.getValue("code") : this.code;
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("docID", this.docID);
        output.addAttribute("etatID", this.etatID);
        output.addAttribute("owner", this.owner);
        output.addAttribute("dateCreation", this.dateCreation);
        output.addAttribute("code", this.code);
        output.addAttribute("libelle", this.libelle);
        output.addCharacterData(Base64.encodeBytes(this.configLines));
        output.endTag(TAG);
    }

    public Object clone() {
        ConfigModel cm = new ConfigModel(QN);
        cm.setId(this.getId());
        cm.setDocID(this.getDocID());
        cm.setEtatID(this.getEtatID());
        cm.setOwner(this.getOwner());
        cm.setDateCreation(this.getDateCreation());
        cm.setCode(this.getCode());
        cm.setLibelle(this.getLibelle());
        cm.setConfigLines(this.getConfigLines());
        return cm;
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public byte[] getConfigLines() {
        if (this.configLines == null && this.base64Buffer.length() > 0) {
            this.configLines = Base64.decode(this.base64Buffer.toString());
            this.base64Buffer = new StringBuffer();
        }
        return this.configLines;
    }

    public void setConfigLines(byte[] buffer) {
        this.configLines = buffer;
    }

    public String getDateCreation() {
        return this.dateCreation;
    }

    public void setDateCreation(String dateCreation) {
        this.dateCreation = dateCreation;
    }

    public String getDocID() {
        return this.docID;
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }

    public String getEtatID() {
        return this.etatID;
    }

    public void setEtatID(String etatID) {
        this.etatID = etatID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public ExportModel getExportModel() {
        ExportModel ret = null;
        try {
            ConfigParser cp = new ConfigParser();
            cp.parse(new ByteArrayInputStream(this.getConfigLines()));
            ret = (ExportModel)cp.getMarshallable();
        }
        catch (Exception e) {
            this.logger.error((Object)"Erreur lors de la lecture de la configuration \u00e0 modifier", (Throwable)e);
        }
        return ret;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

