/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TSqlIndex
implements XmlMarshallable {
    private static final Logger logger = Logger.getLogger(TSqlIndex.class);
    public static final String TAG = "sql-index";
    public static final transient QName QN = new QName("sql-index");
    private SimpleDateFormat[] sdfs;
    private String id;
    private String tableId;
    private String path;
    private String format;
    private String datatype;
    private String column;
    private boolean useInCriterias = true;
    private String resetOn;

    public TSqlIndex(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.tableId = attributes.getValue("table");
        this.path = attributes.getValue("path");
        this.format = attributes.getValue("format");
        this.datatype = attributes.getValue("datatype");
        this.column = attributes.getValue("column");
        String sTmp = attributes.getValue("use-in-criteria");
        if (sTmp != null && sTmp.length() > 0) {
            this.useInCriterias = "|TRUE|YES|1|".indexOf("|".concat(sTmp.toUpperCase()).concat("|")) >= 0;
        }
        this.resetOn = attributes.getValue("reset-on");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public TSqlIndex clone() {
        TSqlIndex other = new TSqlIndex(QN);
        other.column = this.column;
        other.datatype = this.datatype;
        other.format = this.format;
        other.id = this.id;
        other.path = this.path;
        other.tableId = this.tableId;
        other.useInCriterias = this.useInCriterias;
        other.resetOn = this.resetOn;
        return other;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getFormattedStringValue(String value) {
        if (this.format != null) {
            if ("uppercase".equals(this.format)) {
                return value.toUpperCase();
            }
            if ("lowercase".equals(this.format)) {
                return value.toLowerCase();
            }
            if ("normalize-month".equals(this.format)) {
                return value.length() == 1 ? "0" + value : value;
            }
        }
        return value;
    }

    public Date getDateValue(String value) throws ParseException {
        int count;
        if (!"date".equals(this.datatype)) {
            return null;
        }
        if (this.sdfs == null) {
            if (this.format == null) {
                logger.error((Object)("format is null for sql-index " + this.id));
            }
            StringTokenizer tokenizer = new StringTokenizer(this.format, ";");
            this.sdfs = new SimpleDateFormat[tokenizer.countTokens()];
            for (count = 0; count < this.sdfs.length; ++count) {
                String s = tokenizer.nextToken();
                this.sdfs[count] = new SimpleDateFormat(s);
            }
        }
        Date ret = null;
        count = 0;
        while (ret == null && count < this.sdfs.length) {
            try {
                ret = new Date(this.sdfs[count].parse(value).getTime());
            }
            catch (ParseException pEx) {
                ++count;
            }
        }
        if (ret == null) {
            throw new ParseException(value + " does not match any of following date patterns : " + this.format, 0);
        }
        return ret;
    }

    public String getBooleanValue(String value) {
        if (!"boolean".equals(this.datatype)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equals(value)) {
            return "1";
        }
        return "0";
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }

    public boolean isUseInCriterias() {
        return this.useInCriterias;
    }

    public void setUseInCriterias(boolean useInCriterias) {
        this.useInCriterias = useInCriterias;
    }

    public String getResetOn() {
        return this.resetOn;
    }

    public void setResetOn(String resetOn) {
        this.resetOn = resetOn;
    }
}

